// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
// Portions copyright (C) 2007, Martin Stride <MartinS>
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Cbi;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// 
	/// </summary>
	[Description("A panel for CCI traders.  Reading from the top: \nCurrent bar range forecast High Close + 1 tick\nCurrent bar range forecast Low Close - 1 tick.\nPrevious High (white if close was at high) and Current Bar High\nLast Price\nPrevious Low (white if close was at low) and Current Bar Low.\nCCI stats, High close CCI location and cci differential (green if > previous, red if <)\nprevious CCI differential and current CCI location\nLow close CCI location and differential (green if > previous, red if <).")]
	public class CCI_Panel_V7 : Indicator  //For CCI_Forecaster_V7_DE
	{
		#region Variables
		//Panel
		private int 			panelLeftEdge 		= 140;
		private string			decimals			= ""; // use to set number of decimal places for display of prices
		private StringFormat	formatLeft			= new StringFormat();
		private StringFormat	formatCenter		= new StringFormat();
		private StringFormat	formatRight			= new StringFormat();
		private SolidBrush		textBrushBackground	= new SolidBrush(Color.Empty);	//background 
		private SolidBrush		textBrushBackground1	= new SolidBrush(Color.DimGray);	//background 
		private SolidBrush		textBrushHighPrice	= new SolidBrush(Color.Green);
		private SolidBrush		textBrushLowPrice	= new SolidBrush(Color.Red);
		private SolidBrush		textBrushClosePrice	= new SolidBrush(Color.Gainsboro);
		private SolidBrush		textBrushHighCCI	= new SolidBrush(Color.RoyalBlue);
		private SolidBrush		textBrushLowCCI		= new SolidBrush(Color.RoyalBlue);
		private SolidBrush		textBrushHighDiff	= new SolidBrush(Color.RoyalBlue);
		private SolidBrush		textBrushLowDiff	= new SolidBrush(Color.RoyalBlue);
		private SolidBrush		textBrushCCI		= new SolidBrush(Color.White);
		private SolidBrush		textBrushTransparent= new SolidBrush(Color.Transparent);
		private Font			textFontSmValues	= new Font("Tahoma", 10,FontStyle.Bold);
		private Font			textFontValues		= new Font("Arial", 16);
		
        private int location_HPrice = 30; // Default setting for Location_Price
        private int location_CPrice = 35; // Default setting for Location_Price
        private int location_LPrice = 40; // Default setting for Location_Price
		
        private int location_projHPrice = 10; // Default setting for Location_Price
        private int location_projLPrice = 15; // Default setting for Location_Price

        private int location_prevHPrice = 30; // Default setting for Location_Price
        private int location_prevLPrice = 35; // Default setting for Location_Price

		private int location_HDiff = 60; // Default setting for Location_Price
        private int location_LDiff = 75; // Default setting for Location_Price
		
        private int location_prevCCIDiff = 68; // Default setting for Location_Price
        private int location_CCI = 67; // Default setting for Location_Price
		//
		private int periods = 14;
		
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
//			priceSeries				= new DataSeries(this);

			AutoScale			= true;
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= true;
			DisplayInDataBox	= false;
			PaintPriceMarkers	= false;
			PlotsConfigurable	= true;
			Name				= "CCI Panel";
		}

        protected override void OnBarUpdate()
        {

			if (CurrentBar == 0)
			{
			// Set the stringformat parameter for decimal places to suit the instrument.
			// This ensures that trailing zeros are always displayed - maybe an easier way to do this?
				int tickLength;
				double temp1 = TickSize - (int)TickSize;// get fractional part of TickSize
				if (temp1 < 0.001 && temp1 > 0 )	// c# will use scientific notation for small numbers. Attempt to cope with this here.
				{
					decimals = (temp1*1000).ToString();	// make it into a string, after removing 3 leading zeros
					tickLength = (decimals.Length)+3;	// get the number of characters in the string(then add back the 3 previously removed)
				}
				else				// no need to cope with scientific notation(hopefully)
				{
					decimals = temp1.ToString();		// make it into a string
					tickLength = decimals.Length;		// get the number of characters in the string
				}
				switch (tickLength)						// set format depending on length of string
				{
					case 1:  decimals = "f0";	// eg  YM 1t = 1 point
						break;
					case 3:  decimals = "f1";	// eg ER2 1t = 0.1 point 
						break;
					case 4:  decimals = "f2";	// eg  NQ 1t = 0.25 point
						break;
					case 5:  decimals = "f3";	// eg 1t = 0.001 point
						break;
					case 6:  decimals = "f4";	// eg  6E 1t = 0.0001 point
						break;
					case 7:  decimals = "f5";	// eg 1t = 0.00001 point
						break;
					case 8:  decimals = "f6";	// eg 6J 1t = 0.000001 point
						break;
					default: decimals = "";		// default is no fixed decimal format
						break;
					// more options can be added if neccessary......
				}
				formatCenter.Alignment = StringAlignment.Center;	// text centered
				formatRight.Alignment = StringAlignment.Far;		// text right aligned
				formatLeft.Alignment = StringAlignment.Near;		// text right aligned

				// For Range Bars only ~ get the range setting (in ticks), also use later as flag (>0=we are using range bars)
			// (".Final0" & ".Custom1" are to allow custom bar types i.e RangeW bar type)

			}
		}

		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (CurrentBar < Periods)
                return;

			CCI_Forecaster_V7_DE ccif = CCI_Forecaster_V7_DE(4,200,5,50,2.5,120,200,0,15,0,Periods,100,100,75,50,33,12,false,"Points",10,10,150,150);
			CCI cci = CCI(Periods);
			int 	widthX50 = (int)(bounds.X + bounds.Width - PanelLeftEdge+2 + PanelLeftEdge*0.5);
			int 	widthX10 = (int)(bounds.X + bounds.Width - PanelLeftEdge+2 + PanelLeftEdge*0.1);
			int 	widthX 	= (int)(bounds.X + bounds.Width - PanelLeftEdge+2 + PanelLeftEdge*0);
			int 	widthX90 = (int)(bounds.X + bounds.Width - PanelLeftEdge+2 + PanelLeftEdge*0.9);
			double	projectedhigh = Low[0]+Bars.Period.Value*TickSize+TickSize;
			double	projectedlow = High[0]-Bars.Period.Value*TickSize-TickSize;
			double	ProjHighDiff=(ccif.PlotCCIHigh[0]-cci[1]);
			double	ProjLowDiff=ccif.PlotCCILow[0]-cci[1];
			double	CCIDiff=cci[1]-cci[2];
			double	CCIDiff2=cci[2]-cci[3];
			string projectedhighZN = FormatZN(projectedhigh);
			string projectedlowZN = FormatZN(projectedlow);
			string projectedhighZB = FormatZB(projectedhigh);
			string projectedlowZB = FormatZB(projectedlow);
			string highZN = FormatZN(High[0]);
			string lowZN = FormatZN(Low[0]);
			string highZB = FormatZB(High[0]);
			string lowZB = FormatZB(Low[0]);
			string highZN1 = FormatZN(High[1]);
			string lowZN1 = FormatZN(Low[1]);
			string highZB1 = FormatZB(High[1]);
			string lowZB1 = FormatZB(Low[1]);
			string closeZB = FormatZB(Close[0]);
			string closeZN = FormatZN(Close[0]);
			Pen		linepen = new Pen(Color.White,2);
			
			graphics.FillRectangle(textBrushBackground, widthX, bounds.Y, bounds.Width, bounds.Height);
			graphics.FillRectangle(textBrushBackground1, widthX, bounds.Y +(bounds.Height*location_projLPrice/100)+22, bounds.Width,(bounds.Height*location_projLPrice/100)-60);
			
			graphics.DrawString("H:   " + ((Instrument.MasterInstrument.Name == "ZB" ? projectedhighZB : (Instrument.MasterInstrument.Name == "ZN") ? projectedhighZN : projectedhigh.ToString(decimals))), textFontSmValues, textBrushHighPrice, widthX50, bounds.Y + (bounds.Height*location_projHPrice/100), formatCenter);
			graphics.DrawString("L:   " + ((Instrument.MasterInstrument.Name == "ZB" ? projectedlowZB : (Instrument.MasterInstrument.Name == "ZN") ? projectedlowZN : projectedlow.ToString(decimals))), textFontSmValues, textBrushLowPrice, widthX50, bounds.Y + (bounds.Height*location_projLPrice/100), formatCenter);

			graphics.DrawString(((Instrument.MasterInstrument.Name == "ZB" ? highZB : (Instrument.MasterInstrument.Name == "ZN") ? highZN : High[0].ToString(decimals))), textFontSmValues, textBrushHighPrice, widthX90, bounds.Y + (bounds.Height*location_HPrice/100), formatRight);
			graphics.DrawString(((Instrument.MasterInstrument.Name == "ZB" ? lowZB : (Instrument.MasterInstrument.Name == "ZN") ? lowZN : Low[0].ToString(decimals))), textFontSmValues, textBrushLowPrice, widthX90, bounds.Y + (bounds.Height*location_LPrice/100), formatRight);
			graphics.DrawString("C:  " + (Instrument.MasterInstrument.Name == "ZB" ? closeZB : (Instrument.MasterInstrument.Name == "ZN") ? closeZN : Close[0].ToString(decimals)), textFontSmValues, textBrushClosePrice, widthX90, bounds.Y + (bounds.Height*location_CPrice/100), formatRight);

			graphics.DrawString(((Instrument.MasterInstrument.Name == "ZB" ? highZB1 : (Instrument.MasterInstrument.Name == "ZN") ? highZN1 : High[1].ToString(decimals))), textFontSmValues, (Close[1] == High[1] ? textBrushClosePrice : textBrushHighPrice), widthX, bounds.Y + (bounds.Height*location_HPrice/100), formatLeft);
			graphics.DrawString(((Instrument.MasterInstrument.Name == "ZB" ? lowZB1 : (Instrument.MasterInstrument.Name == "ZN") ? lowZN1 : Low[1].ToString(decimals))), textFontSmValues, (Close[1] == High[1] ? textBrushLowPrice : textBrushClosePrice), widthX, bounds.Y + (bounds.Height*location_LPrice/100), formatLeft);

			graphics.DrawString(ccif.PlotCCIHigh[0].ToString("f2") + " / " + ProjHighDiff.ToString("f2"), textFontSmValues, (ProjHighDiff > CCIDiff ? textBrushHighPrice : textBrushLowPrice), widthX90, bounds.Y + (bounds.Height*location_HDiff/100), formatRight);
			graphics.DrawString(ccif.PlotCCILow[0].ToString("f2") + " / " + ProjLowDiff.ToString("f2"), textFontSmValues, (ProjLowDiff > CCIDiff ? textBrushHighPrice : textBrushLowPrice), widthX90, bounds.Y + (bounds.Height*location_LDiff/100), formatRight);

			graphics.DrawString(CCIDiff.ToString("f2"), textFontSmValues, (CCIDiff > CCIDiff2? textBrushHighPrice : textBrushLowPrice), widthX, bounds.Y + (bounds.Height*location_prevCCIDiff/100), formatLeft);
			graphics.DrawString(cci[0].ToString("f2"), textFontValues, textBrushCCI, widthX90, bounds.Y + (bounds.Height*location_CCI/100), formatRight);
		}
		private string FormatZN(double price)
		{
		return String.Format("{0}'{1:000}", Math.Truncate(price), (price - Math.Truncate(price)) * 320);
		}
		
		private string FormatZB(double price)
		{
		return String.Format("{0}'{1:00}", Math.Truncate(price), (price - Math.Truncate(price)) * 32);
		}
		#region Properties

		[Description("CCI Periods")]
		[Category("Parameters")]
		[Gui.Design.DisplayName("CCI Periods")]
		public int Periods
		{
			get { return periods; }
			set { periods = Math.Max(2,value); }
		}
		
		[Description("Left edge of Panel, larger number inceases width, change chart Right Side Margin slightly more")]
        [Category("Panel")]
        public int PanelLeftEdge
        {
            get { return panelLeftEdge; }
            set { panelLeftEdge = Math.Max(4, value); }
        }
		
		[XmlIgnore()]
		[Description("Small Font")]
		[Category("Fonts")]
		[Gui.Design.DisplayName("Small Font")]
		public Font TextFontSmValues
		{
			get { return textFontSmValues; }
			set { textFontSmValues = value; }
		}

		[Browsable(false)]
		public string TextFontSmValuesSerialize
		{
		get { return NinjaTrader.Gui.Design.SerializableFont.ToString(textFontSmValues); }
		set { textFontSmValues = NinjaTrader.Gui.Design.SerializableFont.FromString(value); }
		}

		[XmlIgnore()]
		[Description("Large Font")]
		[Category("Fonts")]
		[Gui.Design.DisplayName("Large Font")]
		public Font TextFontValues
		{
			get { return textFontValues; }
			set { textFontValues = value; }
		}

		[Browsable(false)]
		public string TextFontValuesSerialize
		{
		get { return NinjaTrader.Gui.Design.SerializableFont.ToString(textFontValues); }
		set { textFontValues = NinjaTrader.Gui.Design.SerializableFont.FromString(value); }
		}

		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private CCI_Panel_V7[] cacheCCI_Panel_V7 = null;

        private static CCI_Panel_V7 checkCCI_Panel_V7 = new CCI_Panel_V7();

        /// <summary>
        /// A panel for CCI traders.  Reading from the top: \nCurrent bar range forecast High Close + 1 tick\nCurrent bar range forecast Low Close - 1 tick.\nPrevious High (white if close was at high) and Current Bar High\nLast Price\nPrevious Low (white if close was at low) and Current Bar Low.\nCCI stats, High close CCI location and cci differential (green if > previous, red if <)\nprevious CCI differential and current CCI location\nLow close CCI location and differential (green if > previous, red if <).
        /// </summary>
        /// <returns></returns>
        public CCI_Panel_V7 CCI_Panel_V7(int periods)
        {
            return CCI_Panel_V7(Input, periods);
        }

        /// <summary>
        /// A panel for CCI traders.  Reading from the top: \nCurrent bar range forecast High Close + 1 tick\nCurrent bar range forecast Low Close - 1 tick.\nPrevious High (white if close was at high) and Current Bar High\nLast Price\nPrevious Low (white if close was at low) and Current Bar Low.\nCCI stats, High close CCI location and cci differential (green if > previous, red if <)\nprevious CCI differential and current CCI location\nLow close CCI location and differential (green if > previous, red if <).
        /// </summary>
        /// <returns></returns>
        public CCI_Panel_V7 CCI_Panel_V7(Data.IDataSeries input, int periods)
        {
            if (cacheCCI_Panel_V7 != null)
                for (int idx = 0; idx < cacheCCI_Panel_V7.Length; idx++)
                    if (cacheCCI_Panel_V7[idx].Periods == periods && cacheCCI_Panel_V7[idx].EqualsInput(input))
                        return cacheCCI_Panel_V7[idx];

            lock (checkCCI_Panel_V7)
            {
                checkCCI_Panel_V7.Periods = periods;
                periods = checkCCI_Panel_V7.Periods;

                if (cacheCCI_Panel_V7 != null)
                    for (int idx = 0; idx < cacheCCI_Panel_V7.Length; idx++)
                        if (cacheCCI_Panel_V7[idx].Periods == periods && cacheCCI_Panel_V7[idx].EqualsInput(input))
                            return cacheCCI_Panel_V7[idx];

                CCI_Panel_V7 indicator = new CCI_Panel_V7();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Periods = periods;
                Indicators.Add(indicator);
                indicator.SetUp();

                CCI_Panel_V7[] tmp = new CCI_Panel_V7[cacheCCI_Panel_V7 == null ? 1 : cacheCCI_Panel_V7.Length + 1];
                if (cacheCCI_Panel_V7 != null)
                    cacheCCI_Panel_V7.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheCCI_Panel_V7 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// A panel for CCI traders.  Reading from the top: \nCurrent bar range forecast High Close + 1 tick\nCurrent bar range forecast Low Close - 1 tick.\nPrevious High (white if close was at high) and Current Bar High\nLast Price\nPrevious Low (white if close was at low) and Current Bar Low.\nCCI stats, High close CCI location and cci differential (green if > previous, red if <)\nprevious CCI differential and current CCI location\nLow close CCI location and differential (green if > previous, red if <).
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CCI_Panel_V7 CCI_Panel_V7(int periods)
        {
            return _indicator.CCI_Panel_V7(Input, periods);
        }

        /// <summary>
        /// A panel for CCI traders.  Reading from the top: \nCurrent bar range forecast High Close + 1 tick\nCurrent bar range forecast Low Close - 1 tick.\nPrevious High (white if close was at high) and Current Bar High\nLast Price\nPrevious Low (white if close was at low) and Current Bar Low.\nCCI stats, High close CCI location and cci differential (green if > previous, red if <)\nprevious CCI differential and current CCI location\nLow close CCI location and differential (green if > previous, red if <).
        /// </summary>
        /// <returns></returns>
        public Indicator.CCI_Panel_V7 CCI_Panel_V7(Data.IDataSeries input, int periods)
        {
            return _indicator.CCI_Panel_V7(input, periods);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// A panel for CCI traders.  Reading from the top: \nCurrent bar range forecast High Close + 1 tick\nCurrent bar range forecast Low Close - 1 tick.\nPrevious High (white if close was at high) and Current Bar High\nLast Price\nPrevious Low (white if close was at low) and Current Bar Low.\nCCI stats, High close CCI location and cci differential (green if > previous, red if <)\nprevious CCI differential and current CCI location\nLow close CCI location and differential (green if > previous, red if <).
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CCI_Panel_V7 CCI_Panel_V7(int periods)
        {
            return _indicator.CCI_Panel_V7(Input, periods);
        }

        /// <summary>
        /// A panel for CCI traders.  Reading from the top: \nCurrent bar range forecast High Close + 1 tick\nCurrent bar range forecast Low Close - 1 tick.\nPrevious High (white if close was at high) and Current Bar High\nLast Price\nPrevious Low (white if close was at low) and Current Bar Low.\nCCI stats, High close CCI location and cci differential (green if > previous, red if <)\nprevious CCI differential and current CCI location\nLow close CCI location and differential (green if > previous, red if <).
        /// </summary>
        /// <returns></returns>
        public Indicator.CCI_Panel_V7 CCI_Panel_V7(Data.IDataSeries input, int periods)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.CCI_Panel_V7(input, periods);
        }
    }
}
#endregion
