  #region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Kase Dev Stop (Stop by the Standard Deviation from the ATR)
    /// </summary>
    [Description("Kase Dev Stop (Stop by the Standard Deviation from the ATR)")]
    public class DevStop2 : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int period = 20; // Default setting for Period
            private int fastMA = 5;  // Default setting for FastMA
            private int slowMA = 15; // Default setting for SlowMA
		
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkBlue), PlotStyle.Line, "Warning"));
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkBlue), PlotStyle.Line, "Stop1"));
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkBlue), PlotStyle.Line, "Stop2"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Firebrick), PlotStyle.Line, "Stop3"));
			
			Plots[0].Pen.DashStyle = DashStyle.Dash;
			Plots[1].Pen.DashStyle = DashStyle.Dash;
			Plots[2].Pen.DashStyle = DashStyle.Dash;
			Plots[3].Pen.DashStyle = DashStyle.Dash;
            Overlay				= true;
        }

		protected bool IsUpTrend()
		{
			return (EMA(Close,FastMA)[0] >= EMA(Close,SlowMA)[0]);
			
			
			//	MetaStock forumaula for Peak detection
			//RWH:=(H-Ref(L,-Per1))/(ATR(Per1)*Sqrt(Per1));
			//RWL:=(Ref(H,-Per1)-L)/(ATR(Per1)*Sqrt(Per1));
			//Pk:=Mov((RWH-RWL),3,W);

//			double high = High[0], low = Low[0];
//			double factor = ATR(3)[0]*Math.Sqrt(3);
//			DataSeries Result = new DataSeries(this);
//
//			
//			for (int i = 0; i < 3; ++i) {
//				Result[i] = ((high - Low[i])- (High[i] - low))/factor;
//			}
//			
//			return WMA(Result,3)[0];
		}
		
		protected bool isTrendChange() {
			bool isCurrentUp = (EMA(Close,FastMA)[0] >= EMA(Close,SlowMA)[0]);
			bool isPreviousUp = (EMA(Close,FastMA)[1] >= EMA(Close,SlowMA)[1]);
			
			return !(isCurrentUp == isPreviousUp);
		}
        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (CurrentBar <= Period+1)
				return;
			
//			DataSeries UpTrendStopLine0   = new DataSeries(this);
//			DataSeries UpTrendStopLine1   = new DataSeries(this);
//			DataSeries UpTrendStopLine2   = new DataSeries(this);
//			DataSeries UpTrendStopLine3   = new DataSeries(this);
//			DataSeries DownTrendStopLine0 = new DataSeries(this);
//			DataSeries DownTrendStopLine1 = new DataSeries(this);
//			DataSeries DownTrendStopLine2 = new DataSeries(this);
//			DataSeries DownTrendStopLine3 = new DataSeries(this);
//
//			
//			var AVTR = SMA(XDayReversal(2),Period);
//			var SD 	 = StdDev(XDayReversal(2),period);
//			for (int i=0; i < period; i++) {
//				UpTrendStopLine0[i] = High[i] - AVTR[i];
//				UpTrendStopLine1[i] = High[i] - AVTR[i] - SD[i];
//				UpTrendStopLine2[i] = High[i] - AVTR[i] - SD[i]*2.2;
//				UpTrendStopLine3[i] = High[i] - AVTR[i] - SD[i]*3.6;
//				
//				DownTrendStopLine0[i] = Low[i] + AVTR[i];
//				DownTrendStopLine1[i] = Low[i] + AVTR[i] + SD[i];
//				DownTrendStopLine2[i] = Low[i] + AVTR[i] + SD[i]*2.2;
//				DownTrendStopLine3[i] = Low[i] + AVTR[i] + SD[i]*3.6;
//		    }
//			
//
//			bool isUpTrend = IsUpTrend();
//			double line0 = (isUpTrend)? MAX(UpTrendStopLine0,Period)[0] : MIN(DownTrendStopLine0,Period)[0];
//			double line1 = (isUpTrend)? MAX(UpTrendStopLine1,Period)[0] : MIN(DownTrendStopLine1,Period)[0];
//			double line2 = (isUpTrend)? MAX(UpTrendStopLine2,Period)[0] : MIN(DownTrendStopLine2,Period)[0];
//			double line3 = (isUpTrend)? MAX(UpTrendStopLine3,Period)[0] : MIN(DownTrendStopLine3,Period)[0];
//			
			bool isUpTrend = IsUpTrend();
			double std  = StdDev(EMA(TRD(Period), Period), Period)[0];
			double high = MAX(High,Period)[0];
			double low  = MIN(Low, Period)[0];
			double atr  = TRD(Period)[0];
			
			double line0 = (isUpTrend) ? high - atr 				: low + atr;
			double line1 = (isUpTrend) ? high - atr - std 		 	: low + atr + std;
			double line2 = (isUpTrend) ? high - atr - std * 2.2 	: low + atr + std * 2.2;
			double line3 = (isUpTrend) ? high - atr - std * 3.6 	: low + atr + std * 3.6;
			
			
			int backPeriod = (isTrendChange()) ? 1 : 3;
			
			Warning.Set(line0);
			Stop1.Set(line1);
			Stop2.Set(line2);
			Stop3.Set(line3);	
			if (isUpTrend) {
				Warning.Set(MAX(Warning, backPeriod)[0]);
				Stop1.Set(MAX(Stop1, backPeriod)[0]);
				Stop2.Set(MAX(Stop2, backPeriod)[0]);
				Stop3.Set(MAX(Stop3, backPeriod)[0]);	
			}
			else {
				Warning.Set(MIN(Warning, backPeriod)[0]);
				Stop1.Set(MIN(Stop1, backPeriod)[0]);
				Stop2.Set(MIN(Stop2, backPeriod)[0]);
				Stop3.Set(MIN(Stop3, backPeriod)[0]);		
			}
		

			

			
			
			
			

//			{Cynthia Kase}
//Per1:=Input("Max Length",2,100,30);
//
//RWH:=(H-Ref(L,-Per1))/(ATR(Per1)*Sqrt(Per1));
//RWL:=(Ref(H,-Per1)-L)/(ATR(Per1)*Sqrt(Per1));
//
//Pk:=Mov((RWH-RWL),3,W);
//AVTR:=Mov(HHV(H,2) - LLV(L,2),20, S);
//SD:=Stdev(HHV(H,2) - LLV(L,2),20);
//Val4:=If(Pk>0,HHV(H-AVTR-3*SD,20),LLV(L+AVTR+3*SD,20));
//Val3:=If(Pk>0,HHV(H-AVTR-2*SD,20),LLV(L+AVTR+2*SD,20));
//Val2:=If(Pk>0,HHV(H-AVTR-SD,20),LLV(L+AVTR+SD,20));
//Val1:=If(Pk>0,HHV(H-AVTR,20),LLV(L+AVTR,20));
//
//Val4;
//Val3;
//Val2;
//Val1;


			

//            Warning.Set(High[0]-AVTR[0]);
//            Stop1.Set(High[0]-AVTR[0]-SD[0]);
//            Stop2.Set(High[0]-AVTR[0]-SD[0]*2.2);
//            Stop3.Set(High[0]-AVTR[0]-SD[0]*3.6);

			
			
			//AVTR:=Mov(HHV(H,2) - LLV(L,2),20, S);
//SD:=Stdev(HHV(H,2) - LLV(L,2),20);
//HHV(H-AVTR-3.6*SD, 20);
//HHV(H-AVTR-2.2*SD,20);
//HHV(H-AVTR-SD,20);
//HHV(H-AVTR,20);
			
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Warning
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Stop1
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Stop2
        {
            get { return Values[2]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Stop3
        {
            get { return Values[3]; }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int FastMA
        {
            get { return fastMA; }
            set { fastMA = Math.Max(1, value); }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int SlowMA
        {
            get { return slowMA; }
            set { slowMA = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DevStop2[] cacheDevStop2 = null;

        private static DevStop2 checkDevStop2 = new DevStop2();

        /// <summary>
        /// Kase Dev Stop (Stop by the Standard Deviation from the ATR)
        /// </summary>
        /// <returns></returns>
        public DevStop2 DevStop2(int fastMA, int period, int slowMA)
        {
            return DevStop2(Input, fastMA, period, slowMA);
        }

        /// <summary>
        /// Kase Dev Stop (Stop by the Standard Deviation from the ATR)
        /// </summary>
        /// <returns></returns>
        public DevStop2 DevStop2(Data.IDataSeries input, int fastMA, int period, int slowMA)
        {
            if (cacheDevStop2 != null)
                for (int idx = 0; idx < cacheDevStop2.Length; idx++)
                    if (cacheDevStop2[idx].FastMA == fastMA && cacheDevStop2[idx].Period == period && cacheDevStop2[idx].SlowMA == slowMA && cacheDevStop2[idx].EqualsInput(input))
                        return cacheDevStop2[idx];

            lock (checkDevStop2)
            {
                checkDevStop2.FastMA = fastMA;
                fastMA = checkDevStop2.FastMA;
                checkDevStop2.Period = period;
                period = checkDevStop2.Period;
                checkDevStop2.SlowMA = slowMA;
                slowMA = checkDevStop2.SlowMA;

                if (cacheDevStop2 != null)
                    for (int idx = 0; idx < cacheDevStop2.Length; idx++)
                        if (cacheDevStop2[idx].FastMA == fastMA && cacheDevStop2[idx].Period == period && cacheDevStop2[idx].SlowMA == slowMA && cacheDevStop2[idx].EqualsInput(input))
                            return cacheDevStop2[idx];

                DevStop2 indicator = new DevStop2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.FastMA = fastMA;
                indicator.Period = period;
                indicator.SlowMA = slowMA;
                Indicators.Add(indicator);
                indicator.SetUp();

                DevStop2[] tmp = new DevStop2[cacheDevStop2 == null ? 1 : cacheDevStop2.Length + 1];
                if (cacheDevStop2 != null)
                    cacheDevStop2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDevStop2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Kase Dev Stop (Stop by the Standard Deviation from the ATR)
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DevStop2 DevStop2(int fastMA, int period, int slowMA)
        {
            return _indicator.DevStop2(Input, fastMA, period, slowMA);
        }

        /// <summary>
        /// Kase Dev Stop (Stop by the Standard Deviation from the ATR)
        /// </summary>
        /// <returns></returns>
        public Indicator.DevStop2 DevStop2(Data.IDataSeries input, int fastMA, int period, int slowMA)
        {
            return _indicator.DevStop2(input, fastMA, period, slowMA);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Kase Dev Stop (Stop by the Standard Deviation from the ATR)
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DevStop2 DevStop2(int fastMA, int period, int slowMA)
        {
            return _indicator.DevStop2(Input, fastMA, period, slowMA);
        }

        /// <summary>
        /// Kase Dev Stop (Stop by the Standard Deviation from the ATR)
        /// </summary>
        /// <returns></returns>
        public Indicator.DevStop2 DevStop2(Data.IDataSeries input, int fastMA, int period, int slowMA)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DevStop2(input, fastMA, period, slowMA);
        }
    }
}
#endregion
