#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class DevStop : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int period = 30; // Default setting for Period
            private int fastMA = 10; // Default setting for FastMA
            private int slowMA = 21; // Default setting for SlowMA
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkBlue), PlotStyle.Line, "Warning"));
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkBlue), PlotStyle.Line, "Stop1"));
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkBlue), PlotStyle.Line, "Stop2"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Firebrick), PlotStyle.Line, "Stop3"));
			
			Plots[0].Pen.DashStyle = DashStyle.Dash;
			Plots[1].Pen.DashStyle = DashStyle.Dash;
			Plots[2].Pen.DashStyle = DashStyle.Dash;
			Plots[3].Pen.DashStyle = DashStyle.Dash;
            Overlay				= true;
        }

		protected bool IsUpTrend()
		{
			return (SMA(Close,FastMA)[0] > SMA(Close,SlowMA)[0]);
			
			
			//	MetaStock forumaula for Peak detection
			//RWH:=(H-Ref(L,-Per1))/(ATR(Per1)*Sqrt(Per1));
			//RWL:=(Ref(H,-Per1)-L)/(ATR(Per1)*Sqrt(Per1));
			//Pk:=Mov((RWH-RWL),3,W);

//			double high = High[0], low = Low[0];
//			double factor = ATR(3)[0]*Math.Sqrt(3);
//			DataSeries Result = new DataSeries(this);
//
//			
//			for (int i = 0; i < 3; ++i) {
//				Result[i] = ((high - Low[i])- (High[i] - low))/factor;
//			}
//			
//			return WMA(Result,3)[0];
		}
        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (CurrentBar <= Period)
				return;
			
			DataSeries UpTrendStopLine0   = new DataSeries(this);
			DataSeries UpTrendStopLine1   = new DataSeries(this);
			DataSeries UpTrendStopLine2   = new DataSeries(this);
			DataSeries UpTrendStopLine3   = new DataSeries(this);
			DataSeries DownTrendStopLine0 = new DataSeries(this);
			DataSeries DownTrendStopLine1 = new DataSeries(this);
			DataSeries DownTrendStopLine2 = new DataSeries(this);
			DataSeries DownTrendStopLine3 = new DataSeries(this);

			
			var AVTR = SMA(XDayReversal(2),Period);
			var SD 	 = StdDev(XDayReversal(2),period);
			for (int i=0; i < period; i++) {
				UpTrendStopLine0[i] = High[i] - AVTR[i];
				UpTrendStopLine1[i] = High[i] - AVTR[i] - SD[i];
				UpTrendStopLine2[i] = High[i] - AVTR[i] - SD[i]*2.2;
				UpTrendStopLine3[i] = High[i] - AVTR[i] - SD[i]*3.6;
				
				DownTrendStopLine0[i] = Low[i] + AVTR[i];
				DownTrendStopLine1[i] = Low[i] + AVTR[i] + SD[i];
				DownTrendStopLine2[i] = Low[i] + AVTR[i] + SD[i]*2.2;
				DownTrendStopLine3[i] = Low[i] + AVTR[i] + SD[i]*3.6;
		    }
			

			bool isUpTrend = IsUpTrend();
			double line0 = (isUpTrend)? MAX(UpTrendStopLine0,Period)[0] : MIN(DownTrendStopLine0,Period)[0];
			double line1 = (isUpTrend)? MAX(UpTrendStopLine1,Period)[0] : MIN(DownTrendStopLine1,Period)[0];
			double line2 = (isUpTrend)? MAX(UpTrendStopLine2,Period)[0] : MIN(DownTrendStopLine2,Period)[0];
			double line3 = (isUpTrend)? MAX(UpTrendStopLine3,Period)[0] : MIN(DownTrendStopLine3,Period)[0];
			
		
            Warning.Set(line0);
            Stop1.Set(line1);
            Stop2.Set(line2);
            Stop3.Set(line3);

			
			
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Warning
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Stop1
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Stop2
        {
            get { return Values[2]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Stop3
        {
            get { return Values[3]; }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int FastMA
        {
            get { return fastMA; }
            set { fastMA = Math.Max(1, value); }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int SlowMA
        {
            get { return slowMA; }
            set { slowMA = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DevStop[] cacheDevStop = null;

        private static DevStop checkDevStop = new DevStop();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public DevStop DevStop(int fastMA, int period, int slowMA)
        {
            return DevStop(Input, fastMA, period, slowMA);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public DevStop DevStop(Data.IDataSeries input, int fastMA, int period, int slowMA)
        {
            if (cacheDevStop != null)
                for (int idx = 0; idx < cacheDevStop.Length; idx++)
                    if (cacheDevStop[idx].FastMA == fastMA && cacheDevStop[idx].Period == period && cacheDevStop[idx].SlowMA == slowMA && cacheDevStop[idx].EqualsInput(input))
                        return cacheDevStop[idx];

            lock (checkDevStop)
            {
                checkDevStop.FastMA = fastMA;
                fastMA = checkDevStop.FastMA;
                checkDevStop.Period = period;
                period = checkDevStop.Period;
                checkDevStop.SlowMA = slowMA;
                slowMA = checkDevStop.SlowMA;

                if (cacheDevStop != null)
                    for (int idx = 0; idx < cacheDevStop.Length; idx++)
                        if (cacheDevStop[idx].FastMA == fastMA && cacheDevStop[idx].Period == period && cacheDevStop[idx].SlowMA == slowMA && cacheDevStop[idx].EqualsInput(input))
                            return cacheDevStop[idx];

                DevStop indicator = new DevStop();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.FastMA = fastMA;
                indicator.Period = period;
                indicator.SlowMA = slowMA;
                Indicators.Add(indicator);
                indicator.SetUp();

                DevStop[] tmp = new DevStop[cacheDevStop == null ? 1 : cacheDevStop.Length + 1];
                if (cacheDevStop != null)
                    cacheDevStop.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDevStop = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DevStop DevStop(int fastMA, int period, int slowMA)
        {
            return _indicator.DevStop(Input, fastMA, period, slowMA);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.DevStop DevStop(Data.IDataSeries input, int fastMA, int period, int slowMA)
        {
            return _indicator.DevStop(input, fastMA, period, slowMA);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DevStop DevStop(int fastMA, int period, int slowMA)
        {
            return _indicator.DevStop(Input, fastMA, period, slowMA);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.DevStop DevStop(Data.IDataSeries input, int fastMA, int period, int slowMA)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DevStop(input, fastMA, period, slowMA);
        }
    }
}
#endregion
