#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Utility indicator for calculating the XDay back difference between the high and the low values
    /// </summary>
    [Description("Utility indicator for calculating the XDay back difference between the high and the low values")]
    public class XDayReversal : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int period = 2; // Default setting for Period
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "Plot0"));
            Overlay				= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (CurrentBar < Period) {
				return;
			}
			
			double diff = MAX(High,Period)[0] - MIN(Low, Period)[0];
				
            Plot0.Set(diff);
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(2, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private XDayReversal[] cacheXDayReversal = null;

        private static XDayReversal checkXDayReversal = new XDayReversal();

        /// <summary>
        /// Utility indicator for calculating the XDay back difference between the high and the low values
        /// </summary>
        /// <returns></returns>
        public XDayReversal XDayReversal(int period)
        {
            return XDayReversal(Input, period);
        }

        /// <summary>
        /// Utility indicator for calculating the XDay back difference between the high and the low values
        /// </summary>
        /// <returns></returns>
        public XDayReversal XDayReversal(Data.IDataSeries input, int period)
        {
            if (cacheXDayReversal != null)
                for (int idx = 0; idx < cacheXDayReversal.Length; idx++)
                    if (cacheXDayReversal[idx].Period == period && cacheXDayReversal[idx].EqualsInput(input))
                        return cacheXDayReversal[idx];

            lock (checkXDayReversal)
            {
                checkXDayReversal.Period = period;
                period = checkXDayReversal.Period;

                if (cacheXDayReversal != null)
                    for (int idx = 0; idx < cacheXDayReversal.Length; idx++)
                        if (cacheXDayReversal[idx].Period == period && cacheXDayReversal[idx].EqualsInput(input))
                            return cacheXDayReversal[idx];

                XDayReversal indicator = new XDayReversal();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                XDayReversal[] tmp = new XDayReversal[cacheXDayReversal == null ? 1 : cacheXDayReversal.Length + 1];
                if (cacheXDayReversal != null)
                    cacheXDayReversal.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheXDayReversal = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Utility indicator for calculating the XDay back difference between the high and the low values
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.XDayReversal XDayReversal(int period)
        {
            return _indicator.XDayReversal(Input, period);
        }

        /// <summary>
        /// Utility indicator for calculating the XDay back difference between the high and the low values
        /// </summary>
        /// <returns></returns>
        public Indicator.XDayReversal XDayReversal(Data.IDataSeries input, int period)
        {
            return _indicator.XDayReversal(input, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Utility indicator for calculating the XDay back difference between the high and the low values
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.XDayReversal XDayReversal(int period)
        {
            return _indicator.XDayReversal(Input, period);
        }

        /// <summary>
        /// Utility indicator for calculating the XDay back difference between the high and the low values
        /// </summary>
        /// <returns></returns>
        public Indicator.XDayReversal XDayReversal(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.XDayReversal(input, period);
        }
    }
}
#endregion
