// 
// Copyright (C) 2007, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//
#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion


namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Sample MA indicator that allows you to select different MA types.
	/// Author: ???
	/// Modif by sam028, falling/risinf parameters were not correct.
	/// Date: 04 oct 2009
	/// http://forum.bigmiketrading.com/free_downloads/ninjatrader/indicators/
    /// </summary>
    [Description("Paint the different MA in different color if it's rising or falling.")]
    public class ColorSampleUniversalMovingAverage : Indicator
    {
        #region Variables
		// Create a variable that stores the user's selection for a moving average 
		private ColorUniversalMovingAverage	matype	= ColorUniversalMovingAverage.SMA;
		private int				period	= 14;
		private DataSeries MAHolder;
		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			// Adds a plot for the MA values to be stored in
			Add(new Plot(Color.Lime, "MARising"));
			Add(new Plot(Color.Red, "MAFalling"));
			
			MAHolder = new DataSeries(this);
			
            CalculateOnBarClose	= true;
            Overlay				= true;
            PriceTypeSupported	= true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if ( CurrentBar < 2 )
				return;
			// We use a switch which allows NinjaTrader to only execute code pertaining to our case
			switch (matype)
			{
				// If the matype is defined as an EMA then...
				case ColorUniversalMovingAverage.EMA:
				{
					// Sets the plot to be equal to the EMA's plot
					MAHolder.Set(EMA(Period)[0]);
					break;
				}
				
				// If the matype is defined as a HMA then...
				case ColorUniversalMovingAverage.HMA:
				{
					// Sets the plot to be equal to the HMA's plot
					MAHolder.Set(HMA(Period)[0]);
					break;
				}
				
				// If the matype is defined as a SMA then...
				case ColorUniversalMovingAverage.SMA:
				{
					// Sets the plot to be equal to the SMA's plot
					MAHolder.Set(SMA(Period)[0]);
					break;
				}
				
				// If the matype is defined as a WMA then...
				case ColorUniversalMovingAverage.WMA:
				{
					// Sets the plot to be equal to the WMA's plot
					MAHolder.Set(WMA(Period)[0]);
					break;
				}
			}
			if ( MAHolder[1] < MAHolder[0])
			{
				MARising[1] = MAHolder[1];
				MARising.Set(MAHolder[0]);
			}
			else
			{
				MAFalling[1] = MAHolder[1];
				MAFalling.Set(MAHolder[0]);
			}
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries MAFalling
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries MARising
        {
            get { return Values[0]; }
        }
		
		// Creates the user definable parameter for the moving average type.
		[Description("Choose a Moving Average type.")]
		[Category("Parameters")]
		public ColorUniversalMovingAverage MAType
		{
			get { return matype; }
			set { matype = value; }
		}
		
		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}
        #endregion
    }
}

/* Creates an enum that is assigned to UniversalMovingAverage.
Basically it assigns a numerical value to each item in the list and the items can be referenced without the use
of their numerical value.
For more information on enums you can read up on it here: http://www.csharp-station.com/Tutorials/Lesson17.aspx */
public enum ColorUniversalMovingAverage
{
	EMA,
	HMA,
	SMA,
	WMA,
}
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ColorSampleUniversalMovingAverage[] cacheColorSampleUniversalMovingAverage = null;

        private static ColorSampleUniversalMovingAverage checkColorSampleUniversalMovingAverage = new ColorSampleUniversalMovingAverage();

        /// <summary>
        /// Paint the different MA in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public ColorSampleUniversalMovingAverage ColorSampleUniversalMovingAverage(ColorUniversalMovingAverage mAType, int period)
        {
            return ColorSampleUniversalMovingAverage(Input, mAType, period);
        }

        /// <summary>
        /// Paint the different MA in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public ColorSampleUniversalMovingAverage ColorSampleUniversalMovingAverage(Data.IDataSeries input, ColorUniversalMovingAverage mAType, int period)
        {
            checkColorSampleUniversalMovingAverage.MAType = mAType;
            mAType = checkColorSampleUniversalMovingAverage.MAType;
            checkColorSampleUniversalMovingAverage.Period = period;
            period = checkColorSampleUniversalMovingAverage.Period;

            if (cacheColorSampleUniversalMovingAverage != null)
                for (int idx = 0; idx < cacheColorSampleUniversalMovingAverage.Length; idx++)
                    if (cacheColorSampleUniversalMovingAverage[idx].MAType == mAType && cacheColorSampleUniversalMovingAverage[idx].Period == period && cacheColorSampleUniversalMovingAverage[idx].EqualsInput(input))
                        return cacheColorSampleUniversalMovingAverage[idx];

            ColorSampleUniversalMovingAverage indicator = new ColorSampleUniversalMovingAverage();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.MAType = mAType;
            indicator.Period = period;
            indicator.SetUp();

            ColorSampleUniversalMovingAverage[] tmp = new ColorSampleUniversalMovingAverage[cacheColorSampleUniversalMovingAverage == null ? 1 : cacheColorSampleUniversalMovingAverage.Length + 1];
            if (cacheColorSampleUniversalMovingAverage != null)
                cacheColorSampleUniversalMovingAverage.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheColorSampleUniversalMovingAverage = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Paint the different MA in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColorSampleUniversalMovingAverage ColorSampleUniversalMovingAverage(ColorUniversalMovingAverage mAType, int period)
        {
            return _indicator.ColorSampleUniversalMovingAverage(Input, mAType, period);
        }

        /// <summary>
        /// Paint the different MA in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public Indicator.ColorSampleUniversalMovingAverage ColorSampleUniversalMovingAverage(Data.IDataSeries input, ColorUniversalMovingAverage mAType, int period)
        {
            return _indicator.ColorSampleUniversalMovingAverage(input, mAType, period);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Paint the different MA in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColorSampleUniversalMovingAverage ColorSampleUniversalMovingAverage(ColorUniversalMovingAverage mAType, int period)
        {
            return _indicator.ColorSampleUniversalMovingAverage(Input, mAType, period);
        }

        /// <summary>
        /// Paint the different MA in different color if it's rising or falling.
        /// </summary>
        /// <returns></returns>
        public Indicator.ColorSampleUniversalMovingAverage ColorSampleUniversalMovingAverage(Data.IDataSeries input, ColorUniversalMovingAverage mAType, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ColorSampleUniversalMovingAverage(input, mAType, period);
        }

    }
}
#endregion
