#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Larry Williams Accumulation Distribution indicator with a Zero Lag EMA 
    /// </summary>
    [Description("Williams Acc Dist with Zero Lag EMA")]
	[Gui.Design.DisplayName("Williams Acc Dist w/ZLEMA")]
    public class WilliamsAD_ZeroLag : Indicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
		
		private int period = 57;
		private double trueRangeHigh, trueRangeLow, priceMove;
				
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
        Add(new Plot(new Pen(Color.Blue, 2), "WillamsAD"));					// plot 0
		Add(new Plot(new Pen(Color.DarkViolet, 2), "WilliamsADZLEMA"));							// plot 1
			
		Plots[0].Pen.Width = 3;
		Plots[1].Pen.Width = 2;
				
		Plots[1].Pen.DashStyle = DashStyle.Dash;
			
		trueRangeHigh = trueRangeLow = priceMove = 0d;

		Overlay	= false;
      		PriceTypeSupported = true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
		if (CurrentBar >0)
			{
			// calculate true range high and low
			trueRangeHigh = Math.Max(High[0], Close[1]);
			trueRangeLow = Math.Min(Low[0], Close[1]);
				
			priceMove = 0;

			// compare closing price to yesterdays
			if(Close[0] > Close[1])
				{
				priceMove = Close[0] - trueRangeLow;
				}	
				else if(Close[0] < Close[1])
				{
				priceMove = Close[0] - trueRangeHigh;
				}
				else if(Close[0] == Close[1])
				{
				priceMove = 0d;
            	}
				
			AD.Set((CurrentBar == 0 ? (Close[0] - Low[0]) : AD[1]) + priceMove);
			}	
			
				
		if (CurrentBar > period-1)
			{	
			ADMA.Set(ZLEMA(AD, period)[0]);	
			}
		}
		
        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries AD
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ADMA
        {
            get { return Values[1]; }
        }
		
		#endregion
    }
}
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private WilliamsAD_ZeroLag[] cacheWilliamsAD_ZeroLag = null;

        private static WilliamsAD_ZeroLag checkWilliamsAD_ZeroLag = new WilliamsAD_ZeroLag();

        /// <summary>
        /// Williams Acc Dist with Zero Lag EMA
        /// </summary>
        /// <returns></returns>
        public WilliamsAD_ZeroLag WilliamsAD_ZeroLag()
        {
            return WilliamsAD_ZeroLag(Input);
        }

        /// <summary>
        /// Williams Acc Dist with Zero Lag EMA
        /// </summary>
        /// <returns></returns>
        public WilliamsAD_ZeroLag WilliamsAD_ZeroLag(Data.IDataSeries input)
        {
            if (cacheWilliamsAD_ZeroLag != null)
                for (int idx = 0; idx < cacheWilliamsAD_ZeroLag.Length; idx++)
                    if (cacheWilliamsAD_ZeroLag[idx].EqualsInput(input))
                        return cacheWilliamsAD_ZeroLag[idx];

            lock (checkWilliamsAD_ZeroLag)
            {
                if (cacheWilliamsAD_ZeroLag != null)
                    for (int idx = 0; idx < cacheWilliamsAD_ZeroLag.Length; idx++)
                        if (cacheWilliamsAD_ZeroLag[idx].EqualsInput(input))
                            return cacheWilliamsAD_ZeroLag[idx];

                WilliamsAD_ZeroLag indicator = new WilliamsAD_ZeroLag();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                WilliamsAD_ZeroLag[] tmp = new WilliamsAD_ZeroLag[cacheWilliamsAD_ZeroLag == null ? 1 : cacheWilliamsAD_ZeroLag.Length + 1];
                if (cacheWilliamsAD_ZeroLag != null)
                    cacheWilliamsAD_ZeroLag.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheWilliamsAD_ZeroLag = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Williams Acc Dist with Zero Lag EMA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.WilliamsAD_ZeroLag WilliamsAD_ZeroLag()
        {
            return _indicator.WilliamsAD_ZeroLag(Input);
        }

        /// <summary>
        /// Williams Acc Dist with Zero Lag EMA
        /// </summary>
        /// <returns></returns>
        public Indicator.WilliamsAD_ZeroLag WilliamsAD_ZeroLag(Data.IDataSeries input)
        {
            return _indicator.WilliamsAD_ZeroLag(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Williams Acc Dist with Zero Lag EMA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.WilliamsAD_ZeroLag WilliamsAD_ZeroLag()
        {
            return _indicator.WilliamsAD_ZeroLag(Input);
        }

        /// <summary>
        /// Williams Acc Dist with Zero Lag EMA
        /// </summary>
        /// <returns></returns>
        public Indicator.WilliamsAD_ZeroLag WilliamsAD_ZeroLag(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.WilliamsAD_ZeroLag(input);
        }
    }
}
#endregion
