#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Version 1.0 11/04/08
	/// Converted from MQL by Elliott Wave and PrTester.
    /// </summary>
    [Description("Qualitative Quantitative Estimation. QQE is a combination moving average RSI + ATR.")]
    public class QQE : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int rSI_Period = 14; // Default setting for RSI_Period
		
			private int Wilders_Period;
			private int StartBar, LastAlertBar;
			private int sF=5;
		
		    private DataSeries TrLevelSlow;
			private DataSeries AtrRsi;
			private DataSeries MaAtrRsi;
			private DataSeries RsiAr;
			private DataSeries RsiMa;
		
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            
			Add(new Plot (new Pen(Color.FromKnownColor(KnownColor.DodgerBlue),2), PlotStyle.Line, "Value1"));
            Add(new Plot(new Pen(Color.FromKnownColor(KnownColor.Gold),2), PlotStyle.Line, "Value2"));
            Plots[1].Pen.DashStyle = DashStyle.Dash;
			
			Add(new Line(Color.Gray, 30, "Lower Line"));
			Add(new Line(Color.Gray, 70, "Upper Line"));
			Add(new Line(Color.Gray, 50, "Mid Line"));
			Lines[0].Pen.DashStyle = DashStyle.Dash;
			Lines[1].Pen.DashStyle = DashStyle.Dash;
			
			
			CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= true;
			
			AtrRsi = new DataSeries(this);
			MaAtrRsi = new DataSeries(this);


			Wilders_Period=rSI_Period * 2 - 1;
			if (Wilders_Period < SF)
				StartBar=SF;
			else
				StartBar=Wilders_Period;
				}

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			double rsi0, rsi1, dar, tr, dv;
			
			if(CurrentBar <= StartBar)
				return;
			
				
			Value1.Set(EMA(RSI(rSI_Period,3),sF)[0]);
			
				
			
			AtrRsi.Set(Math.Abs(Value1[1] - Value1[0]));
			
			MaAtrRsi.Set(EMA(AtrRsi,Wilders_Period)[0]);
		
			tr = Value2[1];
			rsi1 = Value1[1];

			rsi0 = Value1[0];
			dar = EMA(MaAtrRsi, Wilders_Period)[0] * 4.236;
	
			dv = tr;
			if (rsi0 < tr)
			{
				tr = rsi0 + dar;
				if (rsi1 < dv)
					if (tr > dv)
						tr = dv;
			}
			else if (rsi0 > tr)
			{
				tr = rsi0 - dar;
				if (rsi1 > dv)
					if (tr < dv)
						tr = dv;
			}
			Value2.Set(tr);
		}
		
        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Value1
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Value2
        {
            get { return Values[1]; }
        }

        [Description("Period for the RSI")]
        [Category("Parameters")]
        public int RSI_Period
        {
            get { return rSI_Period; }
            set { rSI_Period = Math.Max(1, value); }
        }
		[Description("Smoothing Factor")]
        [Category("Parameters")]
        public int SF
        {
            get { return sF; }
            set { sF = Math.Max(1, value); }
        }
		
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private QQE[] cacheQQE = null;

        private static QQE checkQQE = new QQE();

        /// <summary>
        /// Qualitative Quantitative Estimation. QQE is a combination moving average RSI + ATR.
        /// </summary>
        /// <returns></returns>
        public QQE QQE(int rSI_Period, int sF)
        {
            return QQE(Input, rSI_Period, sF);
        }

        /// <summary>
        /// Qualitative Quantitative Estimation. QQE is a combination moving average RSI + ATR.
        /// </summary>
        /// <returns></returns>
        public QQE QQE(Data.IDataSeries input, int rSI_Period, int sF)
        {
            checkQQE.RSI_Period = rSI_Period;
            rSI_Period = checkQQE.RSI_Period;
            checkQQE.SF = sF;
            sF = checkQQE.SF;

            if (cacheQQE != null)
                for (int idx = 0; idx < cacheQQE.Length; idx++)
                    if (cacheQQE[idx].RSI_Period == rSI_Period && cacheQQE[idx].SF == sF && cacheQQE[idx].EqualsInput(input))
                        return cacheQQE[idx];

            QQE indicator = new QQE();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.RSI_Period = rSI_Period;
            indicator.SF = sF;
            indicator.SetUp();

            QQE[] tmp = new QQE[cacheQQE == null ? 1 : cacheQQE.Length + 1];
            if (cacheQQE != null)
                cacheQQE.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheQQE = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Qualitative Quantitative Estimation. QQE is a combination moving average RSI + ATR.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QQE QQE(int rSI_Period, int sF)
        {
            return _indicator.QQE(Input, rSI_Period, sF);
        }

        /// <summary>
        /// Qualitative Quantitative Estimation. QQE is a combination moving average RSI + ATR.
        /// </summary>
        /// <returns></returns>
        public Indicator.QQE QQE(Data.IDataSeries input, int rSI_Period, int sF)
        {
            return _indicator.QQE(input, rSI_Period, sF);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Qualitative Quantitative Estimation. QQE is a combination moving average RSI + ATR.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.QQE QQE(int rSI_Period, int sF)
        {
            return _indicator.QQE(Input, rSI_Period, sF);
        }

        /// <summary>
        /// Qualitative Quantitative Estimation. QQE is a combination moving average RSI + ATR.
        /// </summary>
        /// <returns></returns>
        public Indicator.QQE QQE(Data.IDataSeries input, int rSI_Period, int sF)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.QQE(input, rSI_Period, sF);
        }

    }
}
#endregion
