// v0.1 by Mike Winfrey and Gumphrie 


#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using System.Runtime.InteropServices;
using System.Text;
using System.Collections;
using System.Windows.Forms;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.Design;
#endregion


public enum EMAMultiPlots
{
	One,
	Two,
	Three,
	Four,
	None,
}
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	
	/// <summary>
	/// SpreadAlert
	/// </summary>
	[Description("EMA_Multi")]
	[Gui.Design.DisplayName("EMA Multi")]
	public class EMA_Multi : Indicator
	{
		
		#region Variables
		private int period = 1;
		
		private DataSeries	    alertSeries;
		
		private SolidBrush LineBrush = new SolidBrush(Color.DimGray);
		private int             lineWidth = 1;
		private int             barWidth = 2;
		
		
		private EMAMultiPlots noPlots = EMAMultiPlots.Four;
		
	
		
		private int numBars1=2;
		private int numBars2=3;
		private int numBars3=4;
		private int numBars4=5;
		
		private int iNoAlts=0;
		
		
		private SolidBrush TradeSellBrush = new SolidBrush(Color.Red);
		private SolidBrush TradeBuyBrush = new SolidBrush(Color.Green);
		private SolidBrush TradeHoldBrush = new SolidBrush(Color.Gray);
		
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			
			Add(new Plot(new Pen(Color.Black, 2), PlotStyle.Line, "EMA_Plot"));
						
			Add(new Plot(new Pen(Color.BlueViolet, 1), PlotStyle.Line, "Alt_EMA_Plot1"));
			Add(new Plot(new Pen(Color.DodgerBlue, 1), PlotStyle.Line, "Alt_EMA_Plot2"));
			Add(new Plot(new Pen(Color.Orange, 1), PlotStyle.Line, "Alt_EMA_Plot3"));
			Add(new Plot(new Pen(Color.Red, 1), PlotStyle.Line, "Alt_EMA_Plot4"));
			
			alertSeries		= new DataSeries(this);
			
			Overlay				= false;
	//		PriceType			= Data.PriceType.Typical; // (H+L)/2
			PriceTypeSupported	= true;
			
			DisplayInDataBox = false; 
            CalculateOnBarClose = true;
			PaintPriceMarkers = false; 
		}

		
		
		/// <summary>
		/// Calculates the indicator value(s) at the current index.
		/// </summary>
		protected override void OnBarUpdate()
		{	
			if (CurrentBar<2) 
				return;
			
			if (0==iNoAlts)
			{
				switch (noPlots)
				{	
					case EMAMultiPlots.One:
						iNoAlts=1;
						break;
					case EMAMultiPlots.Two:
						iNoAlts=2;
						break;
					case EMAMultiPlots.Three:
						iNoAlts=3;
						break;
					case EMAMultiPlots.Four:
						iNoAlts=4;
						break;
				}
			}
			
							
			
			EMA_Plot.Set(EMA(Input,period)[0]);
			
			DataSeries dsAlt1 = EMA(Input,numBars1).Value;
			DataSeries dsAlt2 = EMA(Input,numBars2).Value;
			DataSeries dsAlt3 = EMA(Input,numBars3).Value;
			DataSeries dsAlt4 = EMA(Input,numBars4).Value;
			
			if (iNoAlts>0) 	Alt_EMA_Plot1.Set(dsAlt1.Get(CurrentBar));
			if (iNoAlts>1)	Alt_EMA_Plot2.Set(dsAlt2.Get(CurrentBar));
			if (iNoAlts>2)	Alt_EMA_Plot3.Set(dsAlt3.Get(CurrentBar));
			if (iNoAlts>3)	Alt_EMA_Plot4.Set(dsAlt4.Get(CurrentBar));
			
			
			if (Rising(dsAlt1) && Rising(dsAlt2) && Rising(dsAlt3) && Rising(dsAlt4))
			{
				alertSeries.Set(1);
			}
			else if (Falling(dsAlt1) && Falling(dsAlt2) && Falling(dsAlt3) && Falling(dsAlt4))
			{
				alertSeries.Set(-1);
			}
			
			if ((EMA(Close,numBars1)[1]>EMA(Close,numBars1)[2]) && 
				(EMA(Close,numBars2)[1]>EMA(Close,numBars2)[2]) && 
				(EMA(Close,numBars3)[1]>EMA(Close,numBars3)[2]) && 
				(EMA(Close,numBars4)[1]>EMA(Close,numBars4)[2]))
			{
				
			}
			
		}
		
		
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (base.Bars == null) return;

			Exception caughtException;
			
					
			
        	int index 	= -1;
			
			
				
			
			int bars = base.ChartControl.BarsPainted;
            int barPaintWidth = base.ChartControl.ChartStyle.GetBarPaintWidth(base.ChartControl.BarWidth);
		    
			if ((((base.ChartControl.LastBarPainted - base.ChartControl.BarsPainted) +1) + bars)-Bars.Count!=0) bars--;
			
            while (bars >= 0) 
            {
				index = ((base.ChartControl.LastBarPainted - base.ChartControl.BarsPainted) +1) + bars;
				
                if (base.ChartControl.ShowBarsRequired || ((index - base.Displacement) >= base.BarsRequired))   
				{
		  			try
					{
						double emaVal   = EMA_Plot.Get(index);
						int x = (((base.ChartControl.CanvasRight - base.ChartControl.BarMarginRight) - (barPaintWidth / 2)) - ((base.ChartControl.BarsPainted - 1) * base.ChartControl.BarSpace)) + (bars * base.ChartControl.BarSpace);
                        int y1 = (bounds.Y + bounds.Height) - ((int) (((emaVal - min) / ChartControl.MaxMinusMin(max, min)) * bounds.Height));
						int y = (bounds.Y + bounds.Height) - ((int) (((0 - min) / ChartControl.MaxMinusMin(max, min)) * bounds.Height));
						int barOffset = (int)((double)(barWidth-1)/2);
						
						// Trade
						double alertVal = alertSeries.Get(index);
						
						if (!double.IsNaN(alertVal)) 
                    	{
							if (1==alertVal)
							{
								graphics.FillRectangle(TradeBuyBrush,x-barOffset,y1,barWidth,y-y1);
							}
							else if (-1==alertVal)
							{
								graphics.FillRectangle(TradeSellBrush,x-barOffset,y1,barWidth,y-y1);
							}
							else
							{
								graphics.FillRectangle(TradeHoldBrush,x-barOffset,y1,barWidth,y-y1);							
							}
							
						}
						
						
						
						
					}
					catch (Exception exception) {caughtException=exception;}
				}
				bars--;
			}	
			
			// Default plotting in base class. 
			base.Plot(graphics, bounds, min, max);
		}
		

		#region Properties
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries EMA_Plot
		{
			get { return Values[0]; }
		}
		
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Alt_EMA_Plot1
		{
			get { return Values[1]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Alt_EMA_Plot2
		{
			get { return Values[2]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Alt_EMA_Plot3
		{
			get { return Values[3]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Alt_EMA_Plot4
		{
			get { return Values[4]; }
		}
		

                
		/// <summary>
		/// </summary>
		[Description("Use to adjust the lag")]
		[Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Min(1,value); }
		}
		
		
		[Browsable(false)]
    	public string BarWidthSerialize
    	{
        		get { return this.BarWidth.ToString(); }
        		set { this.BarWidth = Convert.ToInt32(value); }
    	}
		
		/// <summary>
		/// </summary>
		[Description("Use to the width of the EMA bars"), XmlIgnore, VisualizationOnly]
		[Category("Plots")]
		[NinjaTrader.Gui.Design.DisplayName("Bar width")]
		public int BarWidth
		{
			get { return barWidth; }
			set { barWidth = Math.Max(0,value); }
		}
	

		[Description("Number of Adaptive Alternative plots to plot")]
        [Category("Parameters")]
		public EMAMultiPlots EMAMultiPlotNo
		{
			get { return noPlots; }
            set { noPlots = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Numbars for Adaptive Alternative - Plot One")]
		[Category("Parameters")]
		public int Alt_Numbars_Plot1
		{
			get { return numBars1; }
			set { numBars1 = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Numbars for Adaptive Alternative - Plot Two")]
		[Category("Parameters")]
		public int Alt_Numbars_Plot2
		{
			get { return numBars2; }
			set { numBars2 = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Numbars for Adaptive Alternative - Plot Three")]
		[Category("Parameters")]
		public int Alt_Numbars_Plot3
		{
			get { return numBars3; }
			set { numBars3 = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Numbars for Adaptive Alternative - Plot Four")]
		[Category("Parameters")]
		public int Alt_Numbars_Plot4
		{
			get { return numBars4; }
			set { numBars4 = value; }
		}

		

		[Browsable(false)]
    	public string TradeSellSerialize
    	{
        		get { return SerializableColor.ToString(this.TradeSellColor); }
        		set { this.TradeSellColor = SerializableColor.FromString(value); }
    	}
		
		[Description("Colour for Sell Trade"), XmlIgnore, VisualizationOnly]
		[Category("Plots")]
		public Color TradeSellColor
        {
            get { return this.TradeSellBrush.Color; }
        	set { this.TradeSellBrush = new SolidBrush(value); }
        }
		
		[Browsable(false)]
    	public string TradeBuySerialize
    	{
        		get { return SerializableColor.ToString(this.TradeBuyColor); }
        		set { this.TradeBuyColor = SerializableColor.FromString(value); }
    	}
		
		[Description("Colour for Buy Trade"), XmlIgnore, VisualizationOnly]
		[Category("Plots")]
		public Color TradeBuyColor
        {
            get { return this.TradeBuyBrush.Color; }
        	set { this.TradeBuyBrush = new SolidBrush(value); }
        }
		
		[Browsable(false)]
    	public string TradeHoldSerialize
    	{
        		get { return SerializableColor.ToString(this.TradeHoldColor); }
        		set { this.TradeHoldColor = SerializableColor.FromString(value); }
    	}
		
		[Description("Colour for No Trade"), XmlIgnore, VisualizationOnly]
		[Category("Plots")]
		public Color TradeHoldColor
        {
            get { return this.TradeHoldBrush.Color; }
        	set { this.TradeHoldBrush = new SolidBrush(value); }
        }

		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private EMA_Multi[] cacheEMA_Multi = null;

        private static EMA_Multi checkEMA_Multi = new EMA_Multi();

        /// <summary>
        /// EMA_Multi
        /// </summary>
        /// <returns></returns>
        public EMA_Multi EMA_Multi(int alt_Numbars_Plot1, int alt_Numbars_Plot2, int alt_Numbars_Plot3, int alt_Numbars_Plot4, EMAMultiPlots eMAMultiPlotNo, int period)
        {
            return EMA_Multi(Input, alt_Numbars_Plot1, alt_Numbars_Plot2, alt_Numbars_Plot3, alt_Numbars_Plot4, eMAMultiPlotNo, period);
        }

        /// <summary>
        /// EMA_Multi
        /// </summary>
        /// <returns></returns>
        public EMA_Multi EMA_Multi(Data.IDataSeries input, int alt_Numbars_Plot1, int alt_Numbars_Plot2, int alt_Numbars_Plot3, int alt_Numbars_Plot4, EMAMultiPlots eMAMultiPlotNo, int period)
        {
            if (cacheEMA_Multi != null)
                for (int idx = 0; idx < cacheEMA_Multi.Length; idx++)
                    if (cacheEMA_Multi[idx].Alt_Numbars_Plot1 == alt_Numbars_Plot1 && cacheEMA_Multi[idx].Alt_Numbars_Plot2 == alt_Numbars_Plot2 && cacheEMA_Multi[idx].Alt_Numbars_Plot3 == alt_Numbars_Plot3 && cacheEMA_Multi[idx].Alt_Numbars_Plot4 == alt_Numbars_Plot4 && cacheEMA_Multi[idx].EMAMultiPlotNo == eMAMultiPlotNo && cacheEMA_Multi[idx].Period == period && cacheEMA_Multi[idx].EqualsInput(input))
                        return cacheEMA_Multi[idx];

            lock (checkEMA_Multi)
            {
                checkEMA_Multi.Alt_Numbars_Plot1 = alt_Numbars_Plot1;
                alt_Numbars_Plot1 = checkEMA_Multi.Alt_Numbars_Plot1;
                checkEMA_Multi.Alt_Numbars_Plot2 = alt_Numbars_Plot2;
                alt_Numbars_Plot2 = checkEMA_Multi.Alt_Numbars_Plot2;
                checkEMA_Multi.Alt_Numbars_Plot3 = alt_Numbars_Plot3;
                alt_Numbars_Plot3 = checkEMA_Multi.Alt_Numbars_Plot3;
                checkEMA_Multi.Alt_Numbars_Plot4 = alt_Numbars_Plot4;
                alt_Numbars_Plot4 = checkEMA_Multi.Alt_Numbars_Plot4;
                checkEMA_Multi.EMAMultiPlotNo = eMAMultiPlotNo;
                eMAMultiPlotNo = checkEMA_Multi.EMAMultiPlotNo;
                checkEMA_Multi.Period = period;
                period = checkEMA_Multi.Period;

                if (cacheEMA_Multi != null)
                    for (int idx = 0; idx < cacheEMA_Multi.Length; idx++)
                        if (cacheEMA_Multi[idx].Alt_Numbars_Plot1 == alt_Numbars_Plot1 && cacheEMA_Multi[idx].Alt_Numbars_Plot2 == alt_Numbars_Plot2 && cacheEMA_Multi[idx].Alt_Numbars_Plot3 == alt_Numbars_Plot3 && cacheEMA_Multi[idx].Alt_Numbars_Plot4 == alt_Numbars_Plot4 && cacheEMA_Multi[idx].EMAMultiPlotNo == eMAMultiPlotNo && cacheEMA_Multi[idx].Period == period && cacheEMA_Multi[idx].EqualsInput(input))
                            return cacheEMA_Multi[idx];

                EMA_Multi indicator = new EMA_Multi();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Alt_Numbars_Plot1 = alt_Numbars_Plot1;
                indicator.Alt_Numbars_Plot2 = alt_Numbars_Plot2;
                indicator.Alt_Numbars_Plot3 = alt_Numbars_Plot3;
                indicator.Alt_Numbars_Plot4 = alt_Numbars_Plot4;
                indicator.EMAMultiPlotNo = eMAMultiPlotNo;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                EMA_Multi[] tmp = new EMA_Multi[cacheEMA_Multi == null ? 1 : cacheEMA_Multi.Length + 1];
                if (cacheEMA_Multi != null)
                    cacheEMA_Multi.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheEMA_Multi = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// EMA_Multi
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Multi EMA_Multi(int alt_Numbars_Plot1, int alt_Numbars_Plot2, int alt_Numbars_Plot3, int alt_Numbars_Plot4, EMAMultiPlots eMAMultiPlotNo, int period)
        {
            return _indicator.EMA_Multi(Input, alt_Numbars_Plot1, alt_Numbars_Plot2, alt_Numbars_Plot3, alt_Numbars_Plot4, eMAMultiPlotNo, period);
        }

        /// <summary>
        /// EMA_Multi
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Multi EMA_Multi(Data.IDataSeries input, int alt_Numbars_Plot1, int alt_Numbars_Plot2, int alt_Numbars_Plot3, int alt_Numbars_Plot4, EMAMultiPlots eMAMultiPlotNo, int period)
        {
            return _indicator.EMA_Multi(input, alt_Numbars_Plot1, alt_Numbars_Plot2, alt_Numbars_Plot3, alt_Numbars_Plot4, eMAMultiPlotNo, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// EMA_Multi
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Multi EMA_Multi(int alt_Numbars_Plot1, int alt_Numbars_Plot2, int alt_Numbars_Plot3, int alt_Numbars_Plot4, EMAMultiPlots eMAMultiPlotNo, int period)
        {
            return _indicator.EMA_Multi(Input, alt_Numbars_Plot1, alt_Numbars_Plot2, alt_Numbars_Plot3, alt_Numbars_Plot4, eMAMultiPlotNo, period);
        }

        /// <summary>
        /// EMA_Multi
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Multi EMA_Multi(Data.IDataSeries input, int alt_Numbars_Plot1, int alt_Numbars_Plot2, int alt_Numbars_Plot3, int alt_Numbars_Plot4, EMAMultiPlots eMAMultiPlotNo, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.EMA_Multi(input, alt_Numbars_Plot1, alt_Numbars_Plot2, alt_Numbars_Plot3, alt_Numbars_Plot4, eMAMultiPlotNo, period);
        }
    }
}
#endregion
