#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Collections;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region Global Enums

public enum anaPlotAlignIBR37 {Left, Right, DoNotPlot}
public enum anaSessionCountIBR37 {First, Second, Third, Hybrid}
public enum anaPreSessionIBR37 {AsianSession, EuropeanSession, Full, None}

#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Current Open, High, Low and Fibonacci Levels.
	/// </summary>
	[Description("anaIBRangeBandsV37.")]
	public class anaIBRangeBandsV37 : Indicator
	{
		#region Variables
		private	SolidBrush[]		brushes					= { new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black), 
																new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),
																new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black),
																new SolidBrush(Color.Black), new SolidBrush(Color.Black), new SolidBrush(Color.Black)}; 
		private DateTime 			startTime				= Cbi.Globals.MinDate;
		private DateTime			plotStart				= Cbi.Globals.MinDate;
		private DateTime			currentDate				= Cbi.Globals.MinDate;
		private DateTime			sessionStartTimeLocal	= Cbi.Globals.MinDate;
		private DateTime			sessionEndTimeLocal		= Cbi.Globals.MinDate;
		private DateTime			sessionStartTime		= Cbi.Globals.MinDate;
		private DateTime  			instrumentSessionDate	= Cbi.Globals.MinDate;
		private DateTime			asianStartTimeLocal		= Cbi.Globals.MinDate;
		private DateTime 			asianEndTimeLocal		= Cbi.Globals.MinDate;
		private DateTime			europeanStartTimeLocal	= Cbi.Globals.MinDate;
		private DateTime 			europeanEndTimeLocal	= Cbi.Globals.MinDate;
		private TimeSpan			openingPeriod			= new TimeSpan(0,60,0);
		private TimeSpan			initTime				= new TimeSpan(0,0,0);
		private TimeSpan			asianStartTime			= new TimeSpan(8,0,0);
		private TimeSpan 			asianEndTime			= new TimeSpan(15,0,0);
		private TimeSpan			europeanStartTime		= new TimeSpan(8,0,0);
		private TimeSpan 			europeanEndTime			= new TimeSpan(13,0,0);
		private TimeSpan			tradingDayStartTime		= new TimeSpan(0,0,0);
		private TimeSpan			selectedStartTime		= new TimeSpan(0,0,0);
		private double				currentOpen				= 0;
		private	double				openingRangeHigh		= double.MinValue;
		private	double				openingRangeLow			= double.MaxValue;
		private	double				preSessionHigh			= double.MinValue;
		private	double				preSessionLow			= double.MaxValue;
		private	double				asianSessionHigh		= double.MinValue;
		private	double				asianSessionLow			= double.MaxValue;
		private	double				europeanSessionHigh		= double.MinValue;
		private	double				europeanSessionLow		= double.MaxValue;
		private double				displaySize				= 0.0;
		private double				multiplier1				= 0.5;
		private double				multiplier2				= 1.0;
		private double				multiplier3				= 2.0;
		private double				upperBand1				= 0.0;
		private double				upperBand2				= 0.0;
		private double				upperBand3				= 0.0;
		private double				lowerBand1				= 0.0;
		private double				lowerBand2				= 0.0;
		private double				lowerBand3				= 0.0;
		private double				initialBalance			= 0.0;
		private SolidBrush			textBrush				= new SolidBrush(Color.Red);
		private Font				textFont				= new Font("Arial", 12);
		private string				errorData1				= "Opening range can only be displayed on intraday charts.";
		private	string				errorData2				= "Insufficient historical data to calculate opening range of current session. Please increase chart look back period.";
        private float				errorTextWidth			= 0;
        private float				errorTextHeight			= 0;
		private bool				firstSession			= false;
		private bool				plotOHL					= false;
		private bool				isCurrency				= false;
		private bool				preSessionOpen			= false;
		private bool				asianSessionOpen		= false;
		private bool				europeanSessionOpen		= false;
		private bool				sessionOpen				= false;
		private bool				initOpeningRange		= false;
		private bool				initAsian				= false;
		private bool				initEuropean			= false;
		private bool				asian					= false;
		private bool				european				= false;
		private bool				noPreSession			= false;
		private bool				showCurrentOpen			= true;
		private ArrayList			newSessionBarIdxArr1	= new ArrayList();
		private anaPlotAlignIBR37	plotLabels				= anaPlotAlignIBR37.Right;
		private anaSessionCountIBR37 selectedSession		= anaSessionCountIBR37.Hybrid;
		private anaSessionCountIBR37 activeSession			= anaSessionCountIBR37.Second;
		private anaPreSessionIBR37	selectedPreSession		= anaPreSessionIBR37.None;	
		private	StringFormat		stringFormatFar			= new StringFormat();
		private	StringFormat		stringFormatNear		= new StringFormat();
		private	StringFormat		stringFormatCenter		= new StringFormat();
		private int					countDown				= 0;
		private int					numberOfSessions		= 1;
		private int					sessionCount			= 0;
		private int					startBarOfSession		= 0;
		private int					width					= 1000;
		private int					labelOffset				= 20;
		private int					opacity					= 3;
		private Color				initialBalanceColor		= Color.PowderBlue;
		private Color				initialMidColor			= Color.PowderBlue;
		private Color				initialBalanceFillColor	= Color.PowderBlue;
		private Color				bandColor				= Color.Goldenrod;
		private Color				rthOpenColor			= Color.White;
		private Color				nightSessionColor		= Color.Salmon;
		private Color				developingColor			= Color.Gray;
		private int 				plot0Width 				= 1;
		private DashStyle 			dash0Style 				= DashStyle.Solid;
		private int 				plot2Width 				= 1;
		private DashStyle 			dash2Style 				= DashStyle.Dash;
		private int 				plot3Width 				= 1;
		private DashStyle 			dash3Style 				= DashStyle.Solid;
		private int 				plot9Width 				= 1;
		private DashStyle 			dash9Style 				= DashStyle.Dot;
		private int 				plot10Width 			= 1;
		private DashStyle 			dash10Style 			= DashStyle.Solid;		
		private string				cetName					= "Central European Standard Time";
		private TimeZoneInfo		cetZone;
		private string				tstName					= "Tokyo Standard Time";
		private TimeZoneInfo		tstZone;	
		
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-High"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Low"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Mid"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Upper1"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Upper2"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Upper3"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Lower1"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Lower2"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"IB-Lower3"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"RTH Open"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"Pre-High"));
			Add(new Plot(new Pen(Color.Gray,1), PlotStyle.Line,"Pre-Low"));
			
			AutoScale						= false;
			Overlay							= true;
			PlotsConfigurable				= false;
			ZOrder							= 1;
			stringFormatNear.Alignment 		= StringAlignment.Near;
			stringFormatCenter.Alignment 	= StringAlignment.Center;
			stringFormatFar.Alignment		= StringAlignment.Far;
		}
		
		protected override void OnStartUp()
		{
			Plots[0].Pen.Color = initialBalanceColor;
			Plots[1].Pen.Color = initialBalanceColor;
			Plots[2].Pen.Color = initialMidColor;
			Plots[3].Pen.Color = bandColor;
			Plots[4].Pen.Color = bandColor;
			Plots[5].Pen.Color = bandColor;
			Plots[6].Pen.Color = bandColor;
			Plots[7].Pen.Color = bandColor;
			Plots[8].Pen.Color = bandColor;
			Plots[9].Pen.Color = rthOpenColor;
			Plots[10].Pen.Color = nightSessionColor;
			Plots[11].Pen.Color = nightSessionColor;
			
			if (Instrument.MasterInstrument.InstrumentType == Cbi.InstrumentType.Currency || Instrument.MasterInstrument.Name == "DX"|| Instrument.MasterInstrument.Name == "6A"
				|| Instrument.MasterInstrument.Name == "6B" || Instrument.MasterInstrument.Name == "6C" ||Instrument.MasterInstrument.Name == "6E"
				|| Instrument.MasterInstrument.Name == "6J" || Instrument.MasterInstrument.Name == "6M" || Instrument.MasterInstrument.Name == "6S"
				|| Instrument.MasterInstrument.Name == "6N" || Instrument.MasterInstrument.Name == "E7" || Instrument.MasterInstrument.Name == "J7"
				|| Instrument.MasterInstrument.Name == "M6A" || Instrument.MasterInstrument.Name == "M6B" || Instrument.MasterInstrument.Name == "M6C"
				|| Instrument.MasterInstrument.Name == "M6E" || Instrument.MasterInstrument.Name == "M6J" || Instrument.MasterInstrument.Name == "M6S")
				isCurrency = true;
			
			if (selectedSession == anaSessionCountIBR37.Hybrid)
			{
				if (isCurrency)
					activeSession = anaSessionCountIBR37.Third;
				else
					activeSession = anaSessionCountIBR37.Second;
			}
			else 
				activeSession = selectedSession; 
			
			if (Instrument.MasterInstrument.Name == "FDAX" || Instrument.MasterInstrument.Name == "FESX" ||Instrument.MasterInstrument.Name == "FGBL" ||
				Instrument.MasterInstrument.Name == "FGBM")
			{
				asian	 	= false;
				european 	= false;
				Plots[10].Name = "Pre-High";
				Plots[11].Name = "Pre-Low";
			}	
			else if (selectedPreSession == anaPreSessionIBR37.AsianSession)
			{
				asian = true;
				european = false;
				try
				{	
					tstZone = TimeZoneInfo.FindSystemTimeZoneById(tstName); 
				}
				catch (TimeZoneNotFoundException ex2)
				{
					throw new TimeZoneNotFoundException( String.Format("The time zone '{0}'cannot be found.", tstName), ex2);
					asian = false;
				}
				if (asian)
				{
					Plots[10].Name = "AS-High";
					Plots[11].Name = "AS-Low";
				}
			}
			else if (selectedPreSession == anaPreSessionIBR37.EuropeanSession)
			{
				asian = false;
				european = true;
				try
				{
					cetZone = TimeZoneInfo.FindSystemTimeZoneById(cetName);
				}
				catch (TimeZoneNotFoundException ex1)
				{
					throw new TimeZoneNotFoundException( String.Format("The time zone '{0}'cannot be found.", cetName), ex1);
					european = false;
				}
				if (european)
				{
					Plots[10].Name = "EU-High";
					Plots[11].Name = "EU-Low";
				}
			}
			else if (selectedPreSession == anaPreSessionIBR37.Full)
			{
				asian	 	= false;
				european 	= false;
				Plots[10].Name = "Pre-High";
				Plots[11].Name = "Pre-Low";
			}
			if (selectedPreSession == anaPreSessionIBR37.None)
				noPreSession = true;
				
			Plots[0].Pen.Width = plot0Width;
			Plots[0].Pen.DashStyle = dash0Style;
			Plots[1].Pen.Width= plot0Width;
			Plots[1].Pen.DashStyle = dash0Style;
			Plots[2].Pen.Width = plot2Width;
			Plots[2].Pen.DashStyle = dash2Style;
			Plots[3].Pen.Width = plot3Width;
			Plots[3].Pen.DashStyle = dash3Style;
			Plots[4].Pen.Width= plot3Width;
			Plots[4].Pen.DashStyle = dash3Style;
			Plots[5].Pen.Width = plot3Width;
			Plots[5].Pen.DashStyle = dash3Style;
			Plots[6].Pen.Width = plot3Width;
			Plots[6].Pen.DashStyle = dash3Style;
			Plots[7].Pen.Width= plot3Width;
			Plots[7].Pen.DashStyle = dash3Style;
			Plots[8].Pen.Width = plot3Width;
			Plots[8].Pen.DashStyle = dash3Style;
			Plots[9].Pen.Width = plot9Width;
			Plots[9].Pen.DashStyle = dash9Style;
			Plots[10].Pen.Width = plot10Width;
			Plots[10].Pen.DashStyle = dash10Style;
			Plots[11].Pen.Width = plot10Width;
			Plots[11].Pen.DashStyle = dash10Style;

			if (AutoScale)
				AutoScale = false;
			if (Instrument.MasterInstrument.InstrumentType == Cbi.InstrumentType.Currency && (TickSize == 0.00001 || TickSize == 0.001))
				displaySize = 5* TickSize;
			else
				displaySize = TickSize;
			countDown = 0;
		}

		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if (Bars == null)
				return; 
			if (!Data.BarsType.GetInstance(Bars.Period.Id).IsIntraday)
			{
				textBrush.Color = ChartControl.AxisColor;
				DrawTextFixed("errortag1", errorData1, TextPosition.Center, textBrush.Color, textFont, Color.Transparent,Color.Transparent,0);
				return;
			}
			if (CurrentBar == 0)
			{	
				currentDate = Bars.GetTradingDayFromLocal(Time[0]);
				sessionCount = 1;
				return;
			}

			if (Bars.FirstBarOfSession && FirstTickOfBar)
			{
				Bars.Session.GetNextBeginEnd(Bars, 0, out sessionStartTimeLocal, out sessionEndTimeLocal);
				sessionStartTime = TimeZoneInfo.ConvertTime(sessionStartTimeLocal, TimeZoneInfo.Local, Bars.Session.TimeZoneInfo);
				if (european)
				{
					instrumentSessionDate = TimeZoneInfo.ConvertTime(sessionEndTimeLocal,TimeZoneInfo.Local, cetZone).Date;
					europeanStartTimeLocal = TimeZoneInfo.ConvertTime(instrumentSessionDate + EuropeanStartTime, cetZone, TimeZoneInfo.Local);
					europeanEndTimeLocal = TimeZoneInfo.ConvertTime(instrumentSessionDate + EuropeanEndTime, cetZone, TimeZoneInfo.Local);
				}
				if (asian)
				{
					instrumentSessionDate = TimeZoneInfo.ConvertTime(sessionEndTimeLocal,TimeZoneInfo.Local, tstZone).Date;
					asianStartTimeLocal = TimeZoneInfo.ConvertTime(instrumentSessionDate + AsianStartTime, tstZone, TimeZoneInfo.Local);
					asianEndTimeLocal = TimeZoneInfo.ConvertTime(instrumentSessionDate + AsianEndTime, tstZone, TimeZoneInfo.Local);
				}
			}
			
			DateTime lastBarTimeStamp1 = Bars.GetTradingDayFromLocal(Time[0]);
			if (lastBarTimeStamp1 != currentDate)
			{	
				if (countDown == 0)
				{
					plotStart = sessionStartTimeLocal;
					countDown = - 1;
				}	
				sessionCount = 1;
				if (Time[0] >= startTime.AddDays(1) && numberOfSessions == 1)
					firstSession = true;
				else	
					firstSession = false;
				if (lastBarTimeStamp1.Date.DayOfWeek != DayOfWeek.Monday || countDown == 0)
					tradingDayStartTime = new TimeSpan(sessionStartTime.Hour, sessionStartTime.Minute,0);
				if (activeSession == anaSessionCountIBR37.First || numberOfSessions == 1 && 
					(lastBarTimeStamp1.Date.DayOfWeek != DayOfWeek.Monday || countDown == 0))
					selectedStartTime = new TimeSpan(sessionStartTime.Hour, sessionStartTime.Minute,0);
				if (activeSession == anaSessionCountIBR37.First || firstSession)
				{
					preSessionOpen 		= false;
					asianSessionOpen	= false;
					initAsian			= false;
					europeanSessionOpen = false;
					initEuropean		= false;
					currentOpen			= Open[0];
					openingRangeHigh	= High[0];
					openingRangeLow		= Low[0];
					sessionOpen 		= true;
					initOpeningRange 	= true;
					initTime			= sessionStartTimeLocal.TimeOfDay;
					startBarOfSession	= CurrentBar;
				}
				else
				{
					preSessionHigh 		= High[0];
					preSessionLow 		= Low[0];
					preSessionOpen 		= true;
					if(Time[0] > asianStartTimeLocal)
					{
						asianSessionHigh 	= High[0];
						asianSessionLow 	= Low[0];
						asianSessionOpen	= true;
						initAsian 			= true;
					}
					else
					{
						asianSessionOpen 	= false;
						initAsian 			= false;
					}
					if(Time[0] > europeanStartTimeLocal)
					{
						europeanSessionHigh = High[0];
						europeanSessionLow 	= Low[0];
						europeanSessionOpen	= true;
						initEuropean 		= true;
					}
					else
					{
						europeanSessionOpen = false;
						initEuropean 		= false;
					}
					sessionOpen 		= false;
					initOpeningRange 	= false;
				}
				currentDate = lastBarTimeStamp1;
				plotOHL = true;
			}
			else if (Bars.FirstBarOfSession)
			{
				if (FirstTickOfBar)
				{
					sessionCount = sessionCount +1;
					numberOfSessions = Math.Min(3, Math.Max(sessionCount, numberOfSessions));
					if ((activeSession == anaSessionCountIBR37.Second && sessionCount == 2 || activeSession == anaSessionCountIBR37.Third && 
						sessionCount == 3) && (lastBarTimeStamp1.Date.DayOfWeek != DayOfWeek.Monday || countDown == 0))
						selectedStartTime = new TimeSpan(sessionStartTime.Hour, sessionStartTime.Minute,0);
				}
				if (sessionCount == 2)
				{
					if (activeSession == anaSessionCountIBR37.First)
						sessionOpen			= false;
					else if (activeSession == anaSessionCountIBR37.Second)
					{
						preSessionOpen		= false;
						europeanSessionOpen = false;
						asianSessionOpen	= false;
						currentOpen			= Open[0];
						openingRangeHigh	= High[0];
						openingRangeLow		= Low[0];
						sessionOpen			= true;
						initOpeningRange	= true;
						initTime			= sessionStartTimeLocal.TimeOfDay;
						startBarOfSession	= CurrentBar;
					}
					else
					{
						preSessionOpen		= true;
						preSessionHigh		= Math.Max(preSessionHigh, High[0]);
						preSessionLow		= Math.Min(preSessionLow, Low[0]);
						if (!asianSessionOpen && Time[0] > asianStartTimeLocal && Time[0]<= asianEndTimeLocal)
						{
							asianSessionHigh 	= High[0];
							asianSessionLow 	= Low[0];
							asianSessionOpen	= true;
							initAsian			= true;
						}	
						else if (asianSessionOpen && Time[0]<= asianEndTimeLocal)
						{
							asianSessionHigh	= Math.Max(asianSessionHigh, High[0]);
							asianSessionLow		= Math.Min(asianSessionLow, Low[0]);
						}
						else
							asianSessionOpen = false;
						if (!europeanSessionOpen && Time[0] > europeanStartTimeLocal && Time[0]<= europeanEndTimeLocal)
						{
							europeanSessionHigh = High[0];
							europeanSessionLow 	= Low[0];
							europeanSessionOpen	= true;
							initEuropean		= true;
						}	
						else if (europeanSessionOpen && Time[0]<= europeanEndTimeLocal)
						{
							europeanSessionHigh	= Math.Max(europeanSessionHigh, High[0]);
							europeanSessionLow	= Math.Min(europeanSessionLow, Low[0]);
						}
						else
							europeanSessionOpen = false;
						sessionOpen			= false;
					}
				}
				else if (sessionCount == 3)
				{	
					preSessionOpen 		= false;
					asianSessionOpen	= false;
					europeanSessionOpen = false;
					if (activeSession != anaSessionCountIBR37.Third)
						sessionOpen		= false;
					else 
					{
						currentOpen			= Open[0];
						openingRangeHigh	= High[0];
						openingRangeLow		= Low[0];
						sessionOpen			= true;
						initOpeningRange	= true;
						initTime			= sessionStartTimeLocal.TimeOfDay;
						startBarOfSession	= CurrentBar;
					}
				}
				else
					sessionOpen = false;
			}
			else if (preSessionOpen)
			{
				preSessionHigh		= Math.Max(preSessionHigh, High[0]);
				preSessionLow		= Math.Min(preSessionLow, Low[0]);
				if (!asianSessionOpen && Time[0] > asianStartTimeLocal && Time[0]<= asianEndTimeLocal)
				{
					asianSessionHigh 	= High[0];
					asianSessionLow 	= Low[0];
					asianSessionOpen	= true;
					initAsian			= true;
				}	
				else if (asianSessionOpen && Time[0]<= asianEndTimeLocal)
				{
					asianSessionHigh	= Math.Max(asianSessionHigh, High[0]);
					asianSessionLow		= Math.Min(asianSessionLow, Low[0]);
				}
				else
					asianSessionOpen = false;
				if (!europeanSessionOpen && Time[0] > europeanStartTimeLocal && Time[0]<= europeanEndTimeLocal)
				{
					europeanSessionHigh = High[0];
					europeanSessionLow 	= Low[0];
					europeanSessionOpen	= true;
					initEuropean 		= true;
				}	
				else if (europeanSessionOpen && Time[0]<= europeanEndTimeLocal)
				{
					europeanSessionHigh	= Math.Max(europeanSessionHigh, High[0]);
					europeanSessionLow	= Math.Min(europeanSessionLow, Low[0]);
				}
				else
					europeanSessionOpen = false;
			}
			else if (sessionOpen && Time[0] <= sessionStartTimeLocal.Add(openingPeriod))
			{
				openingRangeHigh	= Math.Max(openingRangeHigh, High[0]);
				openingRangeLow		= Math.Min(openingRangeLow, Low[0]);
			}
			if (plotOHL && asian && initAsian)
			{
				PreSessionHigh.Set(Math.Round(asianSessionHigh/displaySize)*displaySize);
				PreSessionLow.Set(Math.Round(asianSessionLow/displaySize)*displaySize);
			}
			else if (plotOHL && european && initEuropean)
			{
				PreSessionHigh.Set(Math.Round(europeanSessionHigh/displaySize)*displaySize);
				PreSessionLow.Set(Math.Round(europeanSessionLow/displaySize)*displaySize);
			}
			else if (plotOHL && !asian && !european && !noPreSession && activeSession != anaSessionCountIBR37.First && (numberOfSessions > 1 || !firstSession))
			{
				PreSessionHigh.Set(Math.Round(preSessionHigh/displaySize)*displaySize);
				PreSessionLow.Set(Math.Round(preSessionLow/displaySize)*displaySize);
			}
			else
			{
				PreSessionHigh.Set(0);
				PreSessionLow.Set(0);
			}
				
			if (plotOHL && initOpeningRange)
			{
				initialBalance = openingRangeHigh - openingRangeLow;
				upperBand1 = openingRangeHigh + multiplier1*initialBalance;
				upperBand2 = openingRangeHigh + multiplier2*initialBalance;
				upperBand3 = openingRangeHigh + multiplier3*initialBalance;
				lowerBand1 = openingRangeLow - multiplier1*initialBalance;
				lowerBand2 = openingRangeLow - multiplier2*initialBalance;
				lowerBand3 = openingRangeLow - multiplier3*initialBalance;
				if(ShowCurrentOpen)
					CurrentOpen.Set(Math.Round(currentOpen/displaySize)*displaySize);
				else
					CurrentOpen.Set(0);
				OpeningRangeHigh.Set(Math.Round(openingRangeHigh/displaySize)*displaySize);
   			  	OpeningRangeLow.Set(Math.Round(openingRangeLow/displaySize)*displaySize);
				OpeningRangeMidline.Set(Math.Round((openingRangeLow + 0.5*(openingRangeHigh-openingRangeLow))/displaySize)* displaySize);
				RangeBandUpper1.Set(Math.Round(upperBand1/displaySize)*displaySize);
				RangeBandUpper2.Set(Math.Round(upperBand2/displaySize)*displaySize);
				RangeBandUpper3.Set(Math.Round(upperBand3/displaySize)*displaySize);
				RangeBandLower1.Set(Math.Round(lowerBand1/displaySize)*displaySize);
				RangeBandLower2.Set(Math.Round(lowerBand2/displaySize)*displaySize);
				RangeBandLower3.Set(Math.Round(lowerBand3/displaySize)*displaySize);
				DrawRegion("tagIB" + startBarOfSession, CurrentBar-startBarOfSession, 0, OpeningRangeHigh, OpeningRangeLow, Color.Transparent, initialBalanceFillColor, opacity);
			}
			else
			{
				CurrentOpen.Set(0);
				OpeningRangeHigh.Set(0);
   			  	OpeningRangeLow.Set(0);
				OpeningRangeMidline.Set(0);
				RangeBandUpper1.Set(0);
				RangeBandUpper2.Set(0);
				RangeBandUpper3.Set(0);
				RangeBandLower1.Set(0);
				RangeBandLower2.Set(0);
				RangeBandLower3.Set(0);
			}
		}

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Options")]
		[Gui.Design.DisplayNameAttribute("Session # for RTH")]
		public anaSessionCountIBR37 SelectedSession
		{
			get { return selectedSession; }
			set { selectedSession = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Session used for calculating OHL")]
		[GridCategory("Options")]
		[Gui.Design.DisplayNameAttribute("Pre-Session")]
		public anaPreSessionIBR37 SelectedPreSession
		{
			get { return selectedPreSession; }
			set { selectedPreSession = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Option to show CurrentOpen")]
		[GridCategory("Options")]
		[Gui.Design.DisplayNameAttribute("Show Current Open")]
		public bool ShowCurrentOpen 
		{
			get { return showCurrentOpen; }
			set { showCurrentOpen = value; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Multiplier for Initial Balance")]
		[GridCategory("Options")]
		[Gui.Design.DisplayNameAttribute("Multiplier 1")]
		public double Multiplier1
		{
			get { return multiplier1; }
			set { multiplier1 = Math.Max(0, value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("Multiplier for Initial Balance")]
		[GridCategory("Options")]
		[Gui.Design.DisplayNameAttribute("Multiplier 2")]
		public double Multiplier2
		{
			get { return multiplier2; }
			set { multiplier2 = Math.Max(0, value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("Multiplier for Initial Balance")]
		[GridCategory("Options")]
		[Gui.Design.DisplayNameAttribute("Multiplier 3")]
		public double Multiplier3
		{
			get { return multiplier3; }
			set { multiplier3 = Math.Max(0, value); }
		}
				
		///<summary
		///</summary>
		[XmlIgnore]
		[Browsable(false)]
		public TimeSpan OpeningPeriod
		{
			get { return openingPeriod;}
			set { openingPeriod = value;}
		}	
	
		///<summary
		///</summary>
		[Description("Enter Opening Period in Hours and Minutes")]
		[GridCategory("Options")]
		[Gui.Design.DisplayNameAttribute("Opening Period (h:min)")]
		public string S_OpeningPeriod	
		{
			get 
			{ 
				return string.Format("{0:D2}:{1:D2}", openingPeriod.Hours, openingPeriod.Minutes);
			}
			set 
			{ 
			string[]values =((string)value).Split(':');
			openingPeriod = new TimeSpan(Convert.ToInt16(values[0]),Convert.ToInt16(values[1]),0);
			}
		}

		///<summary
		///</summary>
		[Browsable(false)]
		[XmlIgnore]
		public TimeSpan AsianStartTime
		{
			get { return asianStartTime;}
			set { asianStartTime = value;}
		}	
	
		///<summary
		///</summary>
		[Description("Session Start Time for Asian Session \nPlease Use Tokio Standard Time!")]
		[Category("User defined values")]
		[Gui.Design.DisplayNameAttribute("Asia Session Begin TST")]
		public string S_AsianStartTime
		{
			get 
			{ 
				return string.Format("{0:D2}:{1:D2}", asianStartTime.Hours, asianStartTime.Minutes);
			}
			set 
			{ 
			string[]values =((string)value).Split(':');
			asianStartTime = new TimeSpan(Convert.ToInt16(values[0]),Convert.ToInt16(values[1]),0);
			}
		}
		
		///<summary
		///</summary>
		[Browsable(false)]
		[XmlIgnore]
		public TimeSpan AsianEndTime
		{
			get { return asianEndTime;}
			set { asianEndTime = value;}
		}	
	
		///<summary
		///</summary>
		[Description("Session End Time for Asian Session \nPlease Use Tokio Standard Time!")]
		[Category("User defined values")]
		[Gui.Design.DisplayNameAttribute("Asia Session End TST")]
		public string S_AsianEndTime
		{
			get 
			{ 
				return string.Format("{0:D2}:{1:D2}", asianEndTime.Hours, asianEndTime.Minutes);
			}
			set 
			{ 
			string[]values =((string)value).Split(':');
			asianEndTime = new TimeSpan(Convert.ToInt16(values[0]),Convert.ToInt16(values[1]),0);
			}
		}		

		///<summary
		///</summary>
		[Browsable(false)]
		[XmlIgnore]
		public TimeSpan EuropeanStartTime
		{
			get { return europeanStartTime;}
			set { europeanStartTime = value;}
		}	
	
		///<summary
		///</summary>
		[Description("Session Start Time for European Session \nPlease Use Central European Time!")]
		[Category("User defined values")]
		[Gui.Design.DisplayNameAttribute("Europe Session Begin CET")]
		public string S_EuropeanStartTime
		{
			get 
			{ 
				return string.Format("{0:D2}:{1:D2}", europeanStartTime.Hours, europeanStartTime.Minutes);
			}
			set 
			{ 
			string[]values =((string)value).Split(':');
			europeanStartTime = new TimeSpan(Convert.ToInt16(values[0]),Convert.ToInt16(values[1]),0);
			}
		}
		
		///<summary
		///</summary>
		[Browsable(false)]
		[XmlIgnore]
		public TimeSpan EuropeanEndTime
		{
			get { return europeanEndTime;}
			set { europeanEndTime = value;}
		}	
	
		///<summary
		///</summary>
		[Description("Session End Time for European Session \nPlease Use Central European Time!")]
		[Category("User defined values")]
		[Gui.Design.DisplayNameAttribute("Europe Session End CET")]
		public string S_EuropeanEndTime
		{
			get 
			{ 
				return string.Format("{0:D2}:{1:D2}", europeanEndTime.Hours, europeanEndTime.Minutes);
			}
			set 
			{ 
			string[]values =((string)value).Split(':');
			europeanEndTime = new TimeSpan(Convert.ToInt16(values[0]),Convert.ToInt16(values[1]),0);
			}
		}	
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries OpeningRangeHigh
		{
			get { return Values[0]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries OpeningRangeLow
		{
			get { return Values[1]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries OpeningRangeMidline
		{
			get { return Values[2]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries RangeBandUpper1
		{
			get { return Values[3]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries RangeBandUpper2
		{
			get { return Values[4]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries RangeBandUpper3
		{
			get { return Values[5]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries RangeBandLower1
		{
			get { return Values[6]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries RangeBandLower2
		{
			get { return Values[7]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries RangeBandLower3
		{
			get { return Values[8]; }
		}				
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries CurrentOpen
		{
			get { return Values[9]; }
		}

		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries PreSessionHigh
		{
			get { return Values[10]; }
		}
		
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore]
		public DataSeries PreSessionLow
		{
			get { return Values[11]; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Option where to plot labels")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Label Position")]
		public anaPlotAlignIBR37 PlotLabels
		{
			get { return plotLabels; }
			set { plotLabels = value; }
		}
			
		/// <summary>
		/// </summary>
		[Description("Label distance from line.")]
		[Category("Plot arameters")]
		[Gui.Design.DisplayNameAttribute("Label Offset")]
		public int LabelOffset
		{
			get { return labelOffset; }
			set { labelOffset = Math.Max(1, value); }
		}
			
		
		/// <summary>
		/// </summary>
		[Description("Length of the plots as # of bars.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Max. Plot Length # Bars")]
		public int Width
		{
			get { return width; }
			set { width = Math.Max(0, value); }
		}

		/// <summary>
		/// </summary>
		[Description("Opacity of Ranges ")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Range Opacity")]
		public int Opacity
		{
			get { return opacity; }
			set { opacity = Math.Min(10, Math.Max(1, value)); }
		}

		/// <summary>
		/// </summary>
		[XmlIgnore()]
		[Description("Select Color for Initial Balance")]
		[Category("Plot Colors")]
		[Gui.Design.DisplayName("Initial Balance")]
		public Color InitialBalanceColor
		{
			get { return initialBalanceColor; }
			set { initialBalanceColor = value; }
		}

		// Serialize Color object
		[Browsable(false)]
		public string InitialBalanceColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(initialBalanceColor); }
			set { initialBalanceColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}

		/// <summary>
		/// </summary>
		[XmlIgnore()]
		[Description("Select Color for Midline of Initial Balance")]
		[Category("Plot Colors")]
		[Gui.Design.DisplayName("Initial Balance Midline")]
		public Color InitialMidColor
		{
			get { return initialMidColor; }
			set { initialMidColor = value; }
		}

		// Serialize Color object
		[Browsable(false)]
		public string InitialMidColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(initialMidColor); }
			set { initialMidColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
 
 		/// <summary>
		/// </summary>
		[XmlIgnore()]
		[Description("Select Fill Color for Initial Balance")]
		[Category("Plot Colors")]
		[Gui.Design.DisplayName("Initial Balance Fill")]
		public Color InitialBalanceFillColor
		{
			get { return initialBalanceFillColor; }
			set { initialBalanceFillColor = value; }
		}

		// Serialize Color object
		[Browsable(false)]
		public string InitialBalanceFillColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(initialBalanceFillColor); }
			set { initialBalanceFillColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
 
		/// <summary>
		/// </summary>
		[XmlIgnore]
		[Description("Select Color for Range Bands")]
		[Category("Plot Colors")]
		[Gui.Design.DisplayName("Range Bands")]
		public Color BandColor
		{
			get { return bandColor; }
			set { bandColor = value; }
		}
		
		// Serialize Color object
		[Browsable(false)]
		public string BandColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(bandColor); }
			set { bandColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
				
		/// <summary>
		/// </summary>
		[XmlIgnore]
		[Description("Select Color for RTH Open")]
		[Category("Plot Colors")]
		[Gui.Design.DisplayName("RTH Open")]
		public Color RTHOpenColor
		{
			get { return rthOpenColor; }
			set { rthOpenColor = value; }
		}
		
		// Serialize Color object
		[Browsable(false)]
		public string RTHOpenColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(rthOpenColor); }
			set { rthOpenColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		/// <summary>
		/// </summary>
		[XmlIgnore]
		[Description("Select Color for Night Session Range")]
		[Category("Plot Colors")]
		[Gui.Design.DisplayName("Night Session")]
		public Color NightSessionColor
		{
			get { return nightSessionColor; }
			set { nightSessionColor = value; }
		}
		
		// Serialize Color object
		[Browsable(false)]
		public string NightSessionColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(nightSessionColor); }
			set { nightSessionColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("Select color for developing Initial Balance")]
		[Category("Plot Colors")]
		[Gui.Design.DisplayName("Incomplete Range")]
		public Color DeveloppingColor
		{
			get { return developingColor; }
			set { developingColor = value; }
		}
		
		// Serialize Color object
		[Browsable(false)]
		public string DeveloppingColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(developingColor); }
			set { developingColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("Line Width for Initial Balance.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width Initial Balance")]
		public int Plot0Width
		{
			get { return plot0Width; }
			set { plot0Width = Math.Max(1, value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("DashStyle for Initial Balance.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Dash Style Initial Balance")]
		public DashStyle Dash0Style
		{
			get { return dash0Style; }
			set { dash0Style = value; }
		} 
		
		/// <summary>
		/// </summary>
		[Description("Line Width for Midrange.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width Midrange")]
		public int Plot2Width
		{
			get { return plot2Width; }
			set { plot2Width = Math.Max(1, value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("DashStyle for Midrange.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Dash Style Midrange")]
		public DashStyle Dash2Style
		{
			get { return dash2Style; }
			set { dash2Style = value; }
		} 		

		/// <summary>
		/// </summary>
		[Description("Line Width for Range Bands.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width Range Bands")]
		public int Plot3Width
		{
			get { return plot3Width; }
			set { plot3Width = Math.Max(1, value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("DashStyle for Range Bands.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Dash Style Range Bands")]
		public DashStyle Dash3Style
		{
			get { return dash3Style; }
			set { dash3Style = value; }
		} 
		
		/// <summary>
		/// </summary>
		[Description("Line Width for RTH Open.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width for RTH Open")]
		public int Plot9Width
		{
			get { return plot9Width; }
			set { plot9Width = Math.Max(1, value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("DashStyle for RTH Open.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Dash Style RTH Open")]
		public DashStyle Dash9Style
		{
			get { return dash9Style; }
			set { dash9Style = value; }
		} 
		
		/// <summary>
		/// </summary>
		[Description("Line Width for Pre-Session Range.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Line Width Pre-Session Range")]
		public int Plot10Width
		{
			get { return plot10Width; }
			set { plot10Width = Math.Max(1, value); }
		}
		
		/// <summary>
		/// </summary>
		[Description("DashStyle for Pre-Session Range.")]
		[Category("Plot Parameters")]
		[Gui.Design.DisplayNameAttribute("Dash Style Pre-Session Range")]
		public DashStyle Dash10Style
		{
			get { return dash10Style; }
			set { dash10Style = value; }
		} 		
		
	
		#endregion

		#region Miscellaneous

		public override string FormatPriceMarker(double price)
		{
			double truncatedPart = Math.Truncate(price);
			int fractionalPart = Convert.ToInt32(320 * Math.Abs(price - truncatedPart) - 0.0001); // rounding down for ZF and ZT
			string fraction = "";
			string priceMarker = "";
			if (TickSize == 0.03125) 
			{
				fractionalPart = fractionalPart / 10;
				fraction = fractionalPart.ToString();
				if (fractionalPart < 10)
					fraction = "'0" + fraction;
				else 
					fraction = "'" + fraction;
				priceMarker = truncatedPart.ToString() + fraction;
			}
			else if (TickSize == 0.015625 || TickSize == 0.0078125)
			{
				fraction = fractionalPart.ToString();
				if (fractionalPart < 10)
					fraction = "'00" + fraction;
				if (fractionalPart < 100)
					fraction = "'0" + fraction;
				else	
					fraction = "'" + fraction;
				priceMarker = truncatedPart.ToString() + fraction;
			}
			else
				priceMarker = price.ToString(Gui.Globals.GetTickFormatString(TickSize));
			return priceMarker;
		}		
		
		internal void InvalidateNow()
		{
			if (Disposed || ChartControl == null)
				return;
			ChartControl.Invalidate(true);
		}

		/// <summary>
        /// Overload this method to handle the termination of an indicator. Use this method to dispose of any resources vs overloading the Dispose() method.
		/// </summary>
		protected override void OnTermination()
		{
			textBrush.Dispose();
			foreach (SolidBrush solidBrush in brushes)
				solidBrush.Dispose();
			stringFormatCenter.Dispose();
			stringFormatFar.Dispose();	
			stringFormatNear.Dispose();
		}
	
		/// <summary>
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="bounds"></param>
		/// <param name="min"></param>
		/// <param name="max"></param>
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			if (Bars == null || ChartControl == null)
				return;

			// plot error if data not complete
			DateTime lastBarPaintedTime = Cbi.Globals.MinDate;
			DateTime lastBarSessionBegin = Cbi.Globals.MinDate;
			DateTime lastBarSessionEnd = Cbi.Globals.MinDate;
			DateTime plotPeriodStart = Cbi.Globals.MinDate;
			DateTime referencePeriodEnd = Cbi.Globals.MinDate;
			if (ChartControl.EquidistantBars)
				lastBarPaintedTime = Bars.Get(Math.Min(Bars.Count - 1, ChartControl.LastBarPainted)).Time;
			else
				lastBarPaintedTime = Bars.Get(Math.Min(Bars.Count - 1, Bars.GetBar(ChartControl.LastBarTimePainted))).Time;
			DateTime plotSessionDate = Bars.GetTradingDayFromLocal(lastBarPaintedTime);
			Bars.Session.GetNextBeginEnd(lastBarPaintedTime, out lastBarSessionBegin, out lastBarSessionEnd);
			textBrush.Color = ChartControl.AxisColor;
			if (Bars.Count > 0 && plotStart >= lastBarSessionEnd)
				graphics.DrawString(errorData2, textFont, textBrush, bounds.X + bounds.Width/2, bounds.Y + bounds.Height/2, stringFormatCenter);			
			
			for (int seriesCount = 0; seriesCount < Values.Length; seriesCount++)
			{
				SolidBrush		brush					= brushes[seriesCount];
				int				lastX					= -1;
				int				lastY					= -1;
				int 			firstX					= -1;
				SmoothingMode	oldSmoothingMode		= graphics.SmoothingMode;
				Gui.Chart.Plot	plot					= Plots[seriesCount];
				DataSeries		series					= (DataSeries) Values[seriesCount];
				Color			cacheColor				= plot.Pen.Color;
				
				using (GraphicsPath	path = new GraphicsPath())
				{
					if (brush.Color != cacheColor)	
						brush = new SolidBrush(cacheColor);

					if (asian && ( plot.Name == "AS-High" || plot.Name == "AS-Low"))
					{
						plotPeriodStart = TimeZoneInfo.ConvertTime(plotSessionDate + AsianStartTime, tstZone, TimeZoneInfo.Local);
						referencePeriodEnd = TimeZoneInfo.ConvertTime(plotSessionDate + AsianEndTime, tstZone, TimeZoneInfo.Local);
					}
					else if (european && ( plot.Name == "EU-High" || plot.Name == "EU-Low"))
					{
						plotPeriodStart = TimeZoneInfo.ConvertTime(plotSessionDate + EuropeanStartTime, cetZone, TimeZoneInfo.Local);
						referencePeriodEnd = TimeZoneInfo.ConvertTime(plotSessionDate + EuropeanEndTime, cetZone, TimeZoneInfo.Local);
					}
					else if (plot.Name == "Pre-High" || plot.Name == "Pre-Low")
					{
						plotPeriodStart = TimeZoneInfo.ConvertTime(plotSessionDate + tradingDayStartTime, Bars.Session.TimeZoneInfo, TimeZoneInfo.Local);
						referencePeriodEnd = TimeZoneInfo.ConvertTime(plotSessionDate + selectedStartTime, Bars.Session.TimeZoneInfo, TimeZoneInfo.Local);
					}
					else
					{
						plotPeriodStart = TimeZoneInfo.ConvertTime(plotSessionDate + selectedStartTime, Bars.Session.TimeZoneInfo, TimeZoneInfo.Local);
						referencePeriodEnd = plotPeriodStart.Add(openingPeriod);
					}
					if(lastBarPaintedTime <= plotPeriodStart)
					{
						if (referencePeriodEnd > plotPeriodStart)
							referencePeriodEnd = referencePeriodEnd.AddDays(-1);
						plotPeriodStart= plotPeriodStart.AddDays(-1);
					}
					if (lastBarPaintedTime <= referencePeriodEnd)
					{
						plot.Pen.Color = developingColor;
						brush.Color = developingColor;
					}
					
					for (int idx = this.LastBarIndexPainted; idx >= Math.Max(this.FirstBarIndexPainted, this.LastBarIndexPainted - width); idx--)
					{
						if (idx - Displacement < 0 || idx - Displacement >= Bars.Count || (!ChartControl.ShowBarsRequired && idx - Displacement < BarsRequired))
							continue;
						else if (!series.IsValidPlot(idx))
							continue;
						if(Bars.Get(idx).Time < plotPeriodStart)
							break;

						double	val = series.Get(idx);
						int		x	= ChartControl.GetXByBarIdx(BarsArray[0], idx);
						int		y	= ChartControl.GetYByValue(this, val);

						if (lastX >= 0)
						{
							if (y != lastY) 
								y = lastY;
							path.AddLine(lastX - plot.Pen.Width / 2, lastY, x - plot.Pen.Width / 2, y);
						}
						lastX	= x;
						lastY	= y;
						if (idx == this.LastBarIndexPainted)
							firstX	= x;
					}
	
					graphics.SmoothingMode = SmoothingMode.AntiAlias;
					graphics.DrawPath(plot.Pen, path);
					graphics.SmoothingMode = oldSmoothingMode;
					if (PlotLabels == anaPlotAlignIBR37.Right)
					 	graphics.DrawString(plot.Name, ChartControl.Font, brush, firstX + LabelOffset, lastY - ChartControl.Font.GetHeight() / 2, stringFormatNear);
					if (PlotLabels == anaPlotAlignIBR37.Left)
					 	graphics.DrawString(plot.Name, ChartControl.Font, brush, lastX - LabelOffset, lastY - ChartControl.Font.GetHeight() / 2, stringFormatFar);
				}
				plot.Pen.Color = cacheColor;
			}
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private anaIBRangeBandsV37[] cacheanaIBRangeBandsV37 = null;

        private static anaIBRangeBandsV37 checkanaIBRangeBandsV37 = new anaIBRangeBandsV37();

        /// <summary>
        /// anaIBRangeBandsV37.
        /// </summary>
        /// <returns></returns>
        public anaIBRangeBandsV37 anaIBRangeBandsV37(double multiplier1, double multiplier2, double multiplier3, string s_OpeningPeriod, anaPreSessionIBR37 selectedPreSession, anaSessionCountIBR37 selectedSession, bool showCurrentOpen)
        {
            return anaIBRangeBandsV37(Input, multiplier1, multiplier2, multiplier3, s_OpeningPeriod, selectedPreSession, selectedSession, showCurrentOpen);
        }

        /// <summary>
        /// anaIBRangeBandsV37.
        /// </summary>
        /// <returns></returns>
        public anaIBRangeBandsV37 anaIBRangeBandsV37(Data.IDataSeries input, double multiplier1, double multiplier2, double multiplier3, string s_OpeningPeriod, anaPreSessionIBR37 selectedPreSession, anaSessionCountIBR37 selectedSession, bool showCurrentOpen)
        {
            if (cacheanaIBRangeBandsV37 != null)
                for (int idx = 0; idx < cacheanaIBRangeBandsV37.Length; idx++)
                    if (Math.Abs(cacheanaIBRangeBandsV37[idx].Multiplier1 - multiplier1) <= double.Epsilon && Math.Abs(cacheanaIBRangeBandsV37[idx].Multiplier2 - multiplier2) <= double.Epsilon && Math.Abs(cacheanaIBRangeBandsV37[idx].Multiplier3 - multiplier3) <= double.Epsilon && cacheanaIBRangeBandsV37[idx].S_OpeningPeriod == s_OpeningPeriod && cacheanaIBRangeBandsV37[idx].SelectedPreSession == selectedPreSession && cacheanaIBRangeBandsV37[idx].SelectedSession == selectedSession && cacheanaIBRangeBandsV37[idx].ShowCurrentOpen == showCurrentOpen && cacheanaIBRangeBandsV37[idx].EqualsInput(input))
                        return cacheanaIBRangeBandsV37[idx];

            lock (checkanaIBRangeBandsV37)
            {
                checkanaIBRangeBandsV37.Multiplier1 = multiplier1;
                multiplier1 = checkanaIBRangeBandsV37.Multiplier1;
                checkanaIBRangeBandsV37.Multiplier2 = multiplier2;
                multiplier2 = checkanaIBRangeBandsV37.Multiplier2;
                checkanaIBRangeBandsV37.Multiplier3 = multiplier3;
                multiplier3 = checkanaIBRangeBandsV37.Multiplier3;
                checkanaIBRangeBandsV37.S_OpeningPeriod = s_OpeningPeriod;
                s_OpeningPeriod = checkanaIBRangeBandsV37.S_OpeningPeriod;
                checkanaIBRangeBandsV37.SelectedPreSession = selectedPreSession;
                selectedPreSession = checkanaIBRangeBandsV37.SelectedPreSession;
                checkanaIBRangeBandsV37.SelectedSession = selectedSession;
                selectedSession = checkanaIBRangeBandsV37.SelectedSession;
                checkanaIBRangeBandsV37.ShowCurrentOpen = showCurrentOpen;
                showCurrentOpen = checkanaIBRangeBandsV37.ShowCurrentOpen;

                if (cacheanaIBRangeBandsV37 != null)
                    for (int idx = 0; idx < cacheanaIBRangeBandsV37.Length; idx++)
                        if (Math.Abs(cacheanaIBRangeBandsV37[idx].Multiplier1 - multiplier1) <= double.Epsilon && Math.Abs(cacheanaIBRangeBandsV37[idx].Multiplier2 - multiplier2) <= double.Epsilon && Math.Abs(cacheanaIBRangeBandsV37[idx].Multiplier3 - multiplier3) <= double.Epsilon && cacheanaIBRangeBandsV37[idx].S_OpeningPeriod == s_OpeningPeriod && cacheanaIBRangeBandsV37[idx].SelectedPreSession == selectedPreSession && cacheanaIBRangeBandsV37[idx].SelectedSession == selectedSession && cacheanaIBRangeBandsV37[idx].ShowCurrentOpen == showCurrentOpen && cacheanaIBRangeBandsV37[idx].EqualsInput(input))
                            return cacheanaIBRangeBandsV37[idx];

                anaIBRangeBandsV37 indicator = new anaIBRangeBandsV37();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Multiplier1 = multiplier1;
                indicator.Multiplier2 = multiplier2;
                indicator.Multiplier3 = multiplier3;
                indicator.S_OpeningPeriod = s_OpeningPeriod;
                indicator.SelectedPreSession = selectedPreSession;
                indicator.SelectedSession = selectedSession;
                indicator.ShowCurrentOpen = showCurrentOpen;
                Indicators.Add(indicator);
                indicator.SetUp();

                anaIBRangeBandsV37[] tmp = new anaIBRangeBandsV37[cacheanaIBRangeBandsV37 == null ? 1 : cacheanaIBRangeBandsV37.Length + 1];
                if (cacheanaIBRangeBandsV37 != null)
                    cacheanaIBRangeBandsV37.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheanaIBRangeBandsV37 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// anaIBRangeBandsV37.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaIBRangeBandsV37 anaIBRangeBandsV37(double multiplier1, double multiplier2, double multiplier3, string s_OpeningPeriod, anaPreSessionIBR37 selectedPreSession, anaSessionCountIBR37 selectedSession, bool showCurrentOpen)
        {
            return _indicator.anaIBRangeBandsV37(Input, multiplier1, multiplier2, multiplier3, s_OpeningPeriod, selectedPreSession, selectedSession, showCurrentOpen);
        }

        /// <summary>
        /// anaIBRangeBandsV37.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaIBRangeBandsV37 anaIBRangeBandsV37(Data.IDataSeries input, double multiplier1, double multiplier2, double multiplier3, string s_OpeningPeriod, anaPreSessionIBR37 selectedPreSession, anaSessionCountIBR37 selectedSession, bool showCurrentOpen)
        {
            return _indicator.anaIBRangeBandsV37(input, multiplier1, multiplier2, multiplier3, s_OpeningPeriod, selectedPreSession, selectedSession, showCurrentOpen);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// anaIBRangeBandsV37.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaIBRangeBandsV37 anaIBRangeBandsV37(double multiplier1, double multiplier2, double multiplier3, string s_OpeningPeriod, anaPreSessionIBR37 selectedPreSession, anaSessionCountIBR37 selectedSession, bool showCurrentOpen)
        {
            return _indicator.anaIBRangeBandsV37(Input, multiplier1, multiplier2, multiplier3, s_OpeningPeriod, selectedPreSession, selectedSession, showCurrentOpen);
        }

        /// <summary>
        /// anaIBRangeBandsV37.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaIBRangeBandsV37 anaIBRangeBandsV37(Data.IDataSeries input, double multiplier1, double multiplier2, double multiplier3, string s_OpeningPeriod, anaPreSessionIBR37 selectedPreSession, anaSessionCountIBR37 selectedSession, bool showCurrentOpen)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.anaIBRangeBandsV37(input, multiplier1, multiplier2, multiplier3, s_OpeningPeriod, selectedPreSession, selectedSession, showCurrentOpen);
        }
    }
}
#endregion
