//An attempt to develop a pattern recognition system for CCI Trading

#region Using declarations
using System;
using System.IO;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Detects common CCI patterns
	/// version 2.0
    /// </summary>
    [Description("CCI Patterns Forecaster with Data Extraction 1.0")]
    [Gui.Design.DisplayName("CCI Patterns and Data Extraction")]	 // name as shown in available indicators list.
    public class CCI_Forecaster_DE : Indicator
    {
        #region Variables
		private int		sideWinder0		= 60; // will be changed to 30 if Range Bars are detected
		private double 	extremes		= 200;
        private double	rejectLevel		= 100; // Default setting for RejectLevel
		private int		trendLength		= 12;
		private int 	periods			= 14;
		private int 	LastDate;
		private double	minCCIPts   	= 0; //Default minimum CCI change for all non-ZLR signals
		//ZLR variable
		private double	minZLRPts   	= 15; //Default minimum ZLR change
		private double	maxSignalValue	= 120;
		private double	minZLRValue		= 0;
		private Color	zLRColorL		= Color.DarkGreen;
		private Color	zLRColorS		= Color.Red;
		private int		zLRLineThick	= 4;
		private Color	zLRLineColorS	= Color.Pink;
		private Color	zLRLineColorL	= Color.PaleGreen;
		private double sumchopzone3L = 0;
		private double sumchopzone3S = 0;
		private double sumchopzone5L = 0;
		private double sumchopzone5S = 0;
		private double sumchopzone6L = 0;
		private double sumchopzone6S = 0;
		private double sumchopzone7L = 0;
		private double sumchopzone7S = 0;
		private double sumchopzone8L = 0;
		private double sumchopzone8S = 0;
		private bool ZLRL_H = false;
		private bool ZLRL_L = false;
		private bool ZLRL_E = false;
		private bool ZLRS_H = false;
		private bool ZLRS_L = false;
		private bool ZLRS_E = false;
		
		//famir variable
		private double	famirLimits		= 50;
		private double	famirHookMin	= 5;
	    private int 	Direction=1; int Trend=1; 
//		private	int 	PrevTrend, Trendbars;
//		private	int 	Above100,Below100;
		private Color	famirColorL		= Color.DarkGreen;
		private Color	famirColorS		= Color.Red;
		private bool FamirL_H = false;
		private bool FamirL_L = false;
		private bool FamirL_E = false;
		private bool FamirS_H = false;
		private bool FamirS_L = false;
		private bool FamirS_E = false;
		//Vegas variables
		private double	swingHigh		= 0;
		private double	swingLow		= 0;
		private double	vswingHigh		= 0;
		private double	vswingLow		= 0;
		private double	vTHFEPenetrationLevel = 185;// Level that the CCI must penetrate through to reach the swing high/low
		private double	vMaxSwingPoint	= 185; // Max high or low for swing back to trend after swing high/low
		private int 	vMaxSwingBars	= 10;
		private Color	vegasColorL		= Color.DarkGreen;
		private Color	vegasColorS		= Color.Red;
		private	bool VegasL_H = false;
		private	bool VegasL_L = false;
		private	bool VegasL_E = false;
		private	bool VegasS_H = false;
		private	bool VegasS_L = false;
		private	bool VegasS_E = false;
		//GB100 variables
		private Color	gBColorL		= Color.DarkGreen;
		private Color	gBColorS		= Color.Red;
		private int		gBLineThick		= 2;
		private	bool GBL_H = false;
		private	bool GBL_L = false;
		private	bool GBL_E = false;
		private	bool GBS_H = false;
		private	bool GBS_L = false;
		private	bool GBS_E = false;
		// Tony variables
		protected int	tonyLong		= 0;
		protected int	tonyShort		= 0;
		private Color	tonyColorL		= Color.DarkGreen;
		private Color	tonyColorS		= Color.Red;
		private	bool TonyL_H = false;
		private	bool TonyL_L = false;
		private	bool TonyL_E = false;
		private	bool TonyS_H = false;
		private	bool TonyS_L = false;
		private	bool TonyS_E = false;
		//Ghost variables
		private	string	usePoints		= "Points";
		private double	usePointsAmount	= 10;
		protected int	gstLong			= 0;
		protected int	gstShort		= 0;
		private bool	showGhostPeaks	= true;
		private Color	ghostColorL		= Color.DarkGreen;
		private Color	ghostColorS		= Color.Red;
		private	bool GhostL_H = false;
		private	bool GhostL_L = false;
		private	bool GhostL_E = false;
		private	bool GhostS_H = false;
		private	bool GhostS_L = false;
		private	bool GhostS_E = false;
		private	double gstLeftPk = 0;
		private	double gstMiddlePk = 0;
		private	double gstRightPk = 0;
		private	double gstLeftLow = 0;
		private	double gstRightLow = 0;
		private	int gstLeftPkBars = 0;
		private	int gstMiddlePkBars = 0;
		private	int gstRightPkBars = 0;
		private	int gstLeftLowBars = 0;
		private	int gstRightLowBars = 0;
		private	int lbPeriodup;
		private	int lbPerioddown;
		private	double gstChangePerBar;
		private	bool gstTrendBrkShortH;
		private	bool gstTrendBrkLongH;
		private	bool gstTrendBrkShortL;
		private	bool gstTrendBrkLongL;
		private double gstColor = 0.5;
		//CCI Forecaster Variables
		private bool 	cCIShowForecasterArrows		= false;
		private bool 	cCIShowForecasterDots		= false;
		private bool	cCIShowForecasterHistory 	= false;
		private Color	cCIForecasterColorH		= Color.DarkGreen;
		private Color	cCIForecasterColorL		= Color.Red;
		private int n =  0;
		private double typUp = 0;//Last Bar Typical Price at high close
		private double typDown = 0;//Last Bar Typical Price at low close
		private double meanUp = 0;
		private double meanDown = 0;
		private double nMeanUp = 0;
		private double nMeanDown = 0;
		private double CCIup= 0;
		private double CCIdown=0;
		private double newCCIup= 0;
		private double newCCIdown=0;
		private double nCCIup= 0;
		private double nCCIdown=0;
		private double newTypUp = 0;
		private double newTypDown =0;
		private double oldTypUp = 0;
		private double oldTypDown =0;
		//LSMA Forecaster Values
		private int 	lSMAPeriods		= 25;
		//Display options
		private	bool	soundAlert			= false;
		private	int		alertInterval 		= 60;
		private	bool	showOneTwenty		= false;
		private	bool	showFamirLimits		= false;
		private	bool	showMomoChange		= false;
		private	bool	soundMomoAlert		= false;
		private int		lineExtension		= 6;
 		private Color	oneTwentyColor		= Color.White;
 		private Color	famirLimitsColor	= Color.White;
 		private Color	gstTrendColor		= Color.Yellow;
 		private Color	vegasTrendColor		= Color.PaleGreen;
		private Font	textFontLabels		= new Font("Tahoma", 7);//Version labels
		private Font	signalLabels		= new Font("Tahoma", 10,FontStyle.Bold,GraphicsUnit.Point);//Signal labels
		private string	alertFile			= "Alert4.wav";
		private int		textAnchorL			= 250;
		private int		textAnchorS			= 195;
		private int		chopCrosses			= 4;
		private bool 	showChopCrosses		= true;
		//Patterns to show
		private bool	show_ZLR			= true;
		private bool	show_Famir			= true;
		private bool	show_Vegas			= true;
		private bool	show_GB100			= true;
		private bool	show_Tony			= true;
		private bool	show_Ghost			= true;
		//Pattern Series
		private IntSeries	wCCIPatternSeries;
		private IntSeries	wCCIDirectionSeries;
		private IntSeries	wCCICloseAtSeries;
		private IntSeries	wCCIBarEndSeries;
		private BoolSeries	sidewaysMktSeries;
		
		private Color	CZIdownColor;
		private Color	CZIupColor;
		private int		cZILineThick	=2;
		private int		lSMALineThick	=2;
		private int		cziHighsw;
		private int		cziLowsw;
		private bool	showLSMA_Fore		= true;
		private bool	showCZI_Fore		= true;
		private Color	lSMAForecasterColorH = Color.DarkGreen;
		private Color	lSMAForecasterColorL = Color.Red;
		
		//Sideways
		private int 	sidewaysbar;//Bar when sideways market began
		private int 	sidewaysboundary = 100;
		private int 	resetbar = 1;//Bar when sideways market ended
		private int 	ChopXings;
		private bool	sideways;
		private Color	sidewaysColor = Color.Yellow;
		private int		sidewaysTransparency= 1;
        private double 	EMAAngleFactor;
		private bool	showSWForecaster = false;
		private bool	useSWForecaster = false;
		// SW Variables
		private double rad2deg = 180/Math.PI;
		private double MedianEMA = 0;
		private double MedianLSMA = 0;
		private double LSMAAngleH = 0;
		private double LSMAAngleL = 0;
		private double EMASlopeH = 0;
		private double EMASlopeL = 0;
		private double EMAAngleH = 0;
		private double EMAAngleL = 0;
		private double SWValueH = 0; 
		private double SWValueL = 0; 
		private double SWAbsH = 0; 
		private double SWAbsL = 0; 

		//Bars Ago
		private int BarsAgo_0Xup 		= 0;// 0 line cross up
		private int BarsAgo_0Xdown 		= 0;// 0 line cross down
		private int BarsAgo_5Xup 		= 0;// 5 line cross up
		private int BarsAgo_5Xdown 		= 0;// -5 line cross down
		private int BarsAgo_100Xup 		= 0;// 100 line cross up
		private int BarsAgo_100Xdown 	= 0;// 100 line cross down
		private int BarsAgo_n100Xup 	= 0;// -100 line cross down
		private int BarsAgo_n100Xdown 	= 0;// -100 line cross up
		private int BarsAgoExtremeXup 	= 0;// Extreme cross up
		private int BarsAgoExtremeXdown = 0;// Extreme cross down
		private int BarsAgoSidewaysreset = 0;// Extreme cross down
		private int BarsAgoSidewaysresetup 	= 0;// Extreme cross down
		private int barsAgoSwingH 		= 0;
		private int barsAgoSwingL 		= 0;
		private int trendcountL 		= 0;//How long since chop zone 2 non aqua bars
		private int trendcountS 		= 0;//How long since chop zone 2 non red bars
		private int pcbar 				= 0;//Where is the close within the current bar

		private double multiplier = .05714285714;
		private double emaprev = 0;
		private double EMAup = 0;
		private double EMAdown = 0;
		private double projectedHigh 	= 0;
		private double projectedLow 	= 0;
		private double projectedHigh1 	= 0;
		private double projectedLow1 	= 0;
		private bool   pcbarreset		= true;
		//Momo Change Variables
		private int BarsAgoLongPattern	= 0;
		private int BarsAgoShortPattern	= 0;
		private bool LongMomoChange = false;
		private bool ShortMomoChange = false;
		
		//Data Extraction
		private bool 	useDataExtraction = false;
		private string 	closingTime 	= "3:55 PM";
		private string	filePath 		= @Cbi.Core.UserDataDir.ToString() + "Signals.csv";
		private			StreamWriter 	sw;
		private string 	Pattern 		= "";
		private string	TDirection		= "";
		private int		closePosition 	= 0;
		private bool	signal			= false;
		private int		signalbar		= 0;
		private string	closeorOpen 	= "Open";
		private int		bE_Ticks		= 10;
		private int		mAE_Ticks		= 16;
		private int		opp_End_MAE_Ticks	= 10;
		private double 	BEStop			= 0;
		private int		stopTicks		= 16;
		private bool	stoppedout		= false;
		private bool	breakeven		= false;
		private int		bETicks			= 10;
		private int		bE_Offset_Ticks = -5;
		private bool	return_be		= false;
		private bool	breakeven2		= false;
		private int		bE_Ticks_2		= 13;
		private int		bE_Offset_Ticks_2 = 1;
		private bool	return_be_2		= false;
		private bool	momochange		= false;
		private double	momoexit		=0;
		private bool	cross_100		= false;
		private bool 	hold 			= false;
		private double 	entrypoint;
		private DateTime 	BETime;
		private DateTime 	BETime2;
		private bool 	stopReverse 	= false;
		private int		target			= 0;
		
		private DateTime SSTime;//Session Start Time


		//Javier's  variables
		private double[,] peak;
		private int BarsAgoPeakH;
		private int BarsAgoPeakL;
		private bool HH = false;
		private bool LL = false;
		private double peakvalH;
		private double peakvalL;
		private double peakvalTotal;
		private double peakval5pc;
		private double swresetH;
		private double swresetL;
		private bool useJavierSideways = false;


		WoodiesCCI myWoodies;
		
		#endregion
        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
		
        protected override void Initialize()
        {
		#region Initialize
           	Add(new Plot(Color.FromKnownColor(KnownColor.Chartreuse), PlotStyle.Dot, "PlotCCIHigh"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Crimson), PlotStyle.Dot, "PlotCCILow"));
			wCCIPatternSeries	= new IntSeries(this);
			wCCIDirectionSeries	= new IntSeries(this);
			wCCICloseAtSeries	= new IntSeries(this);
			wCCIBarEndSeries	= new IntSeries(this);
			sidewaysMktSeries	= new BoolSeries(this);
			BarsRequired = 15;

			CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
			DrawOnPricePanel	= false;
//			myWoodies = WoodiesCCI(2, 5, Periods, 34, 25, 6, 30, 100, 2);
			//Javier's array
			peak = new double[6,2];
		#endregion
		}
        protected override void OnStartUp()
		{
			myWoodies = WoodiesCCI(2, 5, Periods, 34, 25, 6, 30, 100, 2);
		}

		/// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (CurrentBar < Math.Max(34,Math.Max(periods,lSMAPeriods))) return;
//			if (CurrentBar == 34) DrawText("CB44", "34", 0, 265, Color.Red);
			if(Bars.FirstBarOfSession && FirstTickOfBar) 
			{
				SSTime = Time[0];
				BETime = SSTime;
				BETime2 = SSTime;
			}
			projectedHigh 	= Low[0]+Bars.Period.Value*TickSize;
			projectedLow 	= High[0]-Bars.Period.Value*TickSize;
			
			pcbar = ((GetCurrentBid() <= projectedLow) ? -1 : ((GetCurrentAsk()>=projectedHigh) ? 1 : 0));//Is the bid/ask outside bar range?
			if(pcbar == 0)
				pcbar = ((Close[0]-Low[0])/(High[0]-Low[0])<.1 ? -1 :((Close[0]-Low[0])/(High[0]-Low[0])>.9 ? 1 : 0));//Where is the close within the current bar
				
			if(projectedHigh != projectedHigh1 || projectedLow != projectedLow1)
			{	projectedHigh1 = projectedHigh;
				projectedLow1 = projectedLow;
				OnNewHighLow();
				pcbarreset = true;
			}
			else
			{
				if(pcbar != 0)
				{	OnNewHighLow();
					pcbarreset = true;//reset to true if we get close to a high/low
				}
				else if(pcbarreset)//recalculate patterns if we got close to a high/low and retreated
				{	OnNewHighLow();
					pcbarreset = false;
				}
			}
			
			DrawPatterns();
			PlotCCILow.Set(CCIdown);
			PlotCCIHigh.Set(CCIup);
			if (!CCIShowForecasterHistory)
			{
			PlotCCILow.Reset(1);
			PlotCCIHigh.Reset(1);
			}
			if(UseDataExtraction) DataExtraction();
		}
		
		protected void OnNewHighLow()
		{
			BarsAgo_0Xup 	= MRO(delegate{return (myWoodies[0] > 0 && (myWoodies[Math.Min(CurrentBar, 1)]==0 ? myWoodies[Math.Min(CurrentBar, 2)]<0 : myWoodies[Math.Min(CurrentBar, 1)]<0));},1,CurrentBar-2) +1;// 0 line cross up
			BarsAgo_0Xdown 	= MRO(delegate{return (myWoodies[0] < 0 && (myWoodies[Math.Min(CurrentBar, 1)]==0 ? myWoodies[Math.Min(CurrentBar, 2)]>0 : myWoodies[Math.Min(CurrentBar, 1)]>0));},1,CurrentBar-2) +1;// 0 line cross down
			BarsAgo_5Xup 	= MRO(delegate{return (myWoodies[0] > 5 && (myWoodies[Math.Min(CurrentBar, 1)]==5 ? myWoodies[Math.Min(CurrentBar, 2)]<5 : myWoodies[Math.Min(CurrentBar, 1)]<5));},1,CurrentBar-2) +1;// 0 line cross up
			BarsAgo_5Xdown 	= MRO(delegate{return (myWoodies[0] < -5 && (myWoodies[Math.Min(CurrentBar, 1)]==-5 ? myWoodies[Math.Min(CurrentBar, 2)]>-5 : myWoodies[Math.Min(CurrentBar, 1)]>-5));},1,CurrentBar-2) +1;// 0 line cross down
			BarsAgo_100Xup 	= MRO(delegate{return (myWoodies[0] > 100 && (myWoodies[Math.Min(CurrentBar, 1)]==100 ? myWoodies[Math.Min(CurrentBar, 2)]<100 : myWoodies[Math.Min(CurrentBar, 1)]<100));},1,CurrentBar-2) +1;// 100 line cross up
			BarsAgo_100Xdown = MRO(delegate{return (myWoodies[0] < 100 && (myWoodies[Math.Min(CurrentBar, 1)]==100 ? myWoodies[Math.Min(CurrentBar, 2)]>100 : myWoodies[Math.Min(CurrentBar, 1)]>100));},1,CurrentBar-2) +1;// 100 line cross down
			BarsAgo_n100Xup	= MRO(delegate{return (myWoodies[0] > -100 && (myWoodies[Math.Min(CurrentBar, 1)]==-100 ? myWoodies[Math.Min(CurrentBar, 2)]<-100 : myWoodies[Math.Min(CurrentBar, 1)]<-100));},1,CurrentBar-2) +1;// -100 line cross down
			BarsAgo_n100Xdown= MRO(delegate{return (myWoodies[0] < -100 && (myWoodies[Math.Min(CurrentBar, 1)]==-100 ? myWoodies[Math.Min(CurrentBar, 2)]>-100 : myWoodies[Math.Min(CurrentBar, 1)]>-100));},1,CurrentBar-2) +1;// -100 line cross up
			BarsAgoExtremeXup = MRO(delegate{return (myWoodies[0]>-Extremes && (myWoodies[Math.Min(CurrentBar, 1)]==-Extremes ? myWoodies[Math.Min(CurrentBar, 2)]<-Extremes : myWoodies[Math.Min(CurrentBar, 1)]<-Extremes));},1,CurrentBar-2) +1;// Extreme cross up
			BarsAgoExtremeXdown = MRO(delegate{return (myWoodies[0]<Extremes && (myWoodies[Math.Min(CurrentBar, 1)]==Extremes ? myWoodies[Math.Min(CurrentBar, 2)]>Extremes : myWoodies[Math.Min(CurrentBar, 1)]>Extremes));},1,CurrentBar-2) +1;// Extreme cross down
			wCCIPatternSeries.Set(0);
			wCCIDirectionSeries.Set(0);
			wCCIBarEndSeries.Set(0);
			
			#region DETERMINATION OF TREND
				if(myWoodies[0]>0)
					{Direction = 1;}//On which side of 0 is the CCI
				if(myWoodies[0]<0)
					{Direction = -1;}
				if(FirstTickOfBar)
				{
					if(((BarsAgo_0Xup >= 7 && myWoodies[0]<0) || (BarsAgo_0Xup >= 6 && myWoodies[0]>0)) && BarsAgo_100Xup <= BarsAgo_0Xup && myWoodies[Math.Min(CurrentBar,1)]>0) Trend = 1;
					if(((BarsAgo_0Xdown >= 7 && myWoodies[0]>0) || (BarsAgo_0Xdown >= 6 && myWoodies[0]<0)) && BarsAgo_n100Xdown <= BarsAgo_0Xdown && myWoodies[Math.Min(CurrentBar,1)]<0) Trend = -1;
				}
			#endregion
			//Initialize Data Series
			wCCICloseAtSeries.Set(0);		
			if(Close[0] == Low[0]) wCCICloseAtSeries.Set(-1);
			else if(Close[0] == High[0]) wCCICloseAtSeries.Set(1);
			
			LastDate = ToDay(DateTime.Now);
			#region CCI Forecaster
			emaprev = EMA(34)[Math.Min(CurrentBar,1)];
			EMAup = (projectedHigh*multiplier)+(emaprev * (1-multiplier));
			EMAdown = (projectedLow*multiplier)+(emaprev*(1-multiplier));

					n =  Periods - 1;
					typUp = (Low[0] + (2*projectedHigh))/3;//Last Bar Typical Price at high close
					typDown = (High[0] + (2*projectedLow))/3;//Last Bar Typical Price at low close
					///Sum of Typical Prices
					for (int i = (Periods - 2); i >= 1; i--)
					{
						typUp += Typical[i];
						typDown += Typical[i];
							
					}
					newTypUp = typUp + (Low[0] + (2*projectedHigh))/3;
					newTypDown =typDown + (High[0] + (2*projectedLow))/3;
					oldTypUp = typUp + Typical[n] ;
					oldTypDown = typDown + Typical[n];
					meanUp =  Math.Abs(Typical[n] - oldTypUp/Periods);
					meanDown = Math.Abs(Typical[n] - oldTypDown/Periods);
					meanUp += Math.Abs((Low[0] + (2*projectedHigh))/3 - oldTypUp/Periods);
					meanDown += Math.Abs((High[0] + (2*projectedLow))/3 - oldTypDown/Periods);
					nMeanUp = Math.Abs(projectedHigh - newTypUp/Periods);
					nMeanDown = Math.Abs(projectedLow - newTypDown/Periods);
					nMeanUp += Math.Abs((Low[0] + (2*projectedHigh))/3 - newTypUp/Periods);
					nMeanDown += Math.Abs((High[0] + (2*projectedLow))/3 - newTypDown/Periods);
					for (int idx = ( Periods - 2); idx >= 1; idx--)
					{
						meanUp += Math.Abs(Typical[idx] - oldTypUp/Periods);
						meanDown += Math.Abs(Typical[idx] - oldTypDown/Periods);
						nMeanUp += Math.Abs(Typical[idx] - newTypUp/Periods);
						nMeanDown += Math.Abs(Typical[idx] - newTypDown/Periods);
					}
				
					CCIup =((Low[0] + (2*projectedHigh))/3 - oldTypUp/Periods) / (meanUp == 0 ? 1 : (0.015 * (meanUp / Periods)));
					CCIdown =((High[0] + (2*projectedLow))/3 - oldTypDown/Periods) / (meanDown == 0 ? 1 : (0.015 * (meanDown / Periods)));

/*					if(CCIShowForecasterArrows == true)
					{
					DrawArrowUp("LowCCI",true, 0, CCIdown, CCIForecasterColorL);
					DrawArrowDown("HighCCI",true, 0, CCIup, CCIForecasterColorH);
					}
					else if (CCIShowForecasterDots == true)
					{
					DrawDot("LowCCI",false,0,CCIdown,CCIForecasterColorL);
					DrawDot("HighCCI",false,0,CCIup,CCIForecasterColorH);
					}
*/			// Plot CCI Forecaster
//			Plots[0].Pen.Width = 2;
//			Plots[Math.Min(CurrentBar,1)].Pen.Width = 2;
			PlotCCILow.Set(CCIdown);
			PlotCCIHigh.Set(CCIup);
					

			#endregion
					
			if(ToDay(Time[0]) == LastDate) //Don't do this unless necessary
			{
			#region LSMA Forecaster
				if(ShowLSMA_Fore == true)
				{
					if(projectedHigh>LinRegPredictor(LSMAPeriods).LRHighClose[0])
						DrawLine(/*CurrentBar.ToString()+*/"LSMAHighClose",true,1,9,0,9,LSMAForecasterColorH,DashStyle.Solid,LSMALineThick);
					else
						DrawLine(/*CurrentBar.ToString()+*/"LSMAHighClose",true,1,9,0,9,LSMAForecasterColorL,DashStyle.Solid,LSMALineThick);
					
					if(projectedLow>LinRegPredictor(LSMAPeriods).LRLowClose[0])
						DrawLine(/*CurrentBar.ToString()+*/"LSMALowClose",true,1,-7,0,-7,LSMAForecasterColorH,DashStyle.Solid,LSMALineThick);
					else
						DrawLine(/*CurrentBar.ToString()+*/"LSMALowClose",true,1,-7,0,-7,LSMAForecasterColorL,DashStyle.Solid,LSMALineThick);
				}
			#endregion

			#region CZI Forecaster
			if(ShowCZI_Fore == true)
			{
				double cziHigh = Math.Round((projectedHigh-EMAup)/TickSize,1);
				double cziLow = Math.Round((projectedLow-EMAdown)/TickSize,1);
				if(cziHigh>=4)//.25)
					cziHighsw=4;
					else if(cziHigh>=3)//.15)
					cziHighsw=3;
						else if(cziHigh>=2)//.1)
						cziHighsw=2;
							else if(cziHigh>=1)//.1)
							cziHighsw=1;
								else if(cziHigh<=-4)//.25)
								cziHighsw=-4;
									else if(cziHigh<=-3)//.15)
									cziHighsw=-3;
										else if(cziHigh<=-2)//.1)
										cziHighsw=-2;
											else if(cziHigh<=-1)//.1)
											cziHighsw=-1;
												else cziHighsw=0;
					if(cziLow>=4)//.25)
						cziLowsw=4;
						else if(cziLow>=3)//.15)
						cziLowsw=3;
							else if(cziLow>=2)//.1)
							cziLowsw=2;
								else if(cziLow>=1)//.1)
								cziLowsw=1;
									else if(cziLow<=-4)//.25)
									cziLowsw=-4;
										else if(cziLow<=-3)//.15)
										cziLowsw=-3;
											else if(cziLow<=-2)//.1)
											cziLowsw=-2;
												else if(cziLow<=-1)//.1)
												cziLowsw=-1;
													else cziLowsw=0;
					
					switch (cziHighsw)
					{
						case 4:
							CZIupColor = Color.Cyan;
							break;
						case 3:
							CZIupColor = Color.DarkGreen;
							break;
						case 2:
							CZIupColor = Color.DarkSeaGreen;
							break;
						case 1:
							CZIupColor = Color.Lime;
							break;
						case 0:
							CZIupColor = Color.Yellow;
							break;
						case -1:
							CZIupColor = Color.Gold;
							break;
						case -2:
							CZIupColor = Color.Orange;
							break;
						case -3:
							CZIupColor = Color.OrangeRed;
							break;
						case -4:
							CZIupColor = Color.DarkRed;
							break;
						default:
							break;
					}
					switch (cziLowsw)
					{
						case 4:
							CZIdownColor = Color.Cyan;
							break;
						case 3:
							CZIdownColor = Color.DarkGreen;
							break;
						case 2:
							CZIdownColor = Color.DarkSeaGreen;
							break;
						case 1:
							CZIdownColor = Color.Lime;
							break;
						case 0:
							CZIdownColor = Color.Yellow;
							break;
						case -1:
							CZIdownColor = Color.Gold;
							break;
						case -2:
							CZIdownColor = Color.Orange;
							break;
						case -3:
							CZIdownColor = Color.OrangeRed;
							break;
						case -4:
							CZIdownColor = Color.DarkRed;
							break;
						default:
							break;
					}
	
				}
//	DrawText(CurrentBar.ToString()+"CZI",(Close[0]==High[0]?cziHighsw.ToString():cziLowsw.ToString())+"\n"+myWoodies.ChopZone,0,50,Color.Red);
			#endregion

			#region SW Forecaster
				SWAbsH = 0; 
				SWAbsL = 0; 

			if(ShowSWForecaster || UseSWForecaster)
			{
				MedianEMA = (EMA(34)[Math.Min(CurrentBar,1)]+EMA(34)[Math.Min(CurrentBar,2)])/2;
				MedianLSMA = (LinReg(LSMAPeriods)[Math.Min(CurrentBar,1)]+LinReg(LSMAPeriods)[Math.Min(CurrentBar,2)])/2;
				LSMAAngleH = (Math.Atan((LinRegPredictor(LSMAPeriods).LRHighClose[0]-(LinReg(25)[Math.Min(CurrentBar,1)]+LinReg(25)[Math.Min(CurrentBar,2)])/2)/1.5/TickSize))*rad2deg;
				LSMAAngleL = (Math.Atan((LinRegPredictor(LSMAPeriods).LRLowClose[0]-(LinReg(25)[Math.Min(CurrentBar,1)]+LinReg(25)[Math.Min(CurrentBar,2)])/2)/1.5/TickSize))*rad2deg;
				EMASlopeH = (EMAup-MedianEMA)/1.5/TickSize;
				EMASlopeL = (EMAdown-MedianEMA)/1.5/TickSize;
				EMAAngleH = (Math.Atan((EMAup-(EMA(34)[Math.Min(CurrentBar,1)]+EMA(34)[Math.Min(CurrentBar,2)])/2)/1.5/TickSize))*rad2deg;
				EMAAngleL = (Math.Atan((EMAdown-(EMA(34)[Math.Min(CurrentBar,1)]+EMA(34)[Math.Min(CurrentBar,2)])/2)/1.5/TickSize))*rad2deg;
				SWValueH = LSMAAngleH + EMAAngleH; 
				SWValueL = LSMAAngleL + EMAAngleL; 
				SWAbsH = Math.Abs(SWValueH); 
				SWAbsL = Math.Abs(SWValueL); 

				RemoveDrawObject((CurrentBar-1).ToString()+"FSW");
			}
			#endregion
			
			#region Draw CZI and SW Forecasts
			if(myWoodies[0]<-75)
					{
					DrawLine(/*CurrentBar.ToString()+*/"CZIup",true,1,109,0,109,CZIupColor,DashStyle.Solid,CZILineThick);
					DrawLine(/*CurrentBar.ToString()+*/"CZIdown",true,1,96,0,96,CZIdownColor,DashStyle.Solid,CZILineThick);
						if(ShowSWForecaster == true)
						{
							DrawLine(/*CurrentBar.ToString()+*/"SWup",true,1,209,0,209,SWAbsH>=100?Color.LimeGreen:(SWAbsH>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
							DrawLine(/*CurrentBar.ToString()+*/"SWdown",true,1,196,0,196,SWAbsL>=100?Color.LimeGreen:(SWAbsL>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
						}
					RemoveDrawObject("CZIup2");
					RemoveDrawObject("CZIdown2");
					RemoveDrawObject("SWup2");
					RemoveDrawObject("SWdown2");
					
					}
					else if(myWoodies[0]>75)
					{
					DrawLine(/*CurrentBar.ToString()+*/"CZIup2",true,1,-91,0,-91,CZIupColor,DashStyle.Solid,CZILineThick);
					DrawLine(/*CurrentBar.ToString()+*/"CZIdown2",true,1,-104,0,-104,CZIdownColor,DashStyle.Solid,CZILineThick);
					if(ShowSWForecaster == true)
					{
						DrawLine(/*CurrentBar.ToString()+*/"SWup2",true,1,-191,0,-191,SWAbsH>=100?Color.LimeGreen:(SWAbsH>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
						DrawLine(/*CurrentBar.ToString()+*/"SWdown2",true,1,-204,0,-204,SWAbsL>=100?Color.LimeGreen:(SWAbsL>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
					}
					RemoveDrawObject("CZIup");
					RemoveDrawObject("CZIdown");
					RemoveDrawObject("SWup");
					RemoveDrawObject("SWdown");
					}
					else
					{
					DrawLine(/*CurrentBar.ToString()+*/"CZIup2",true,1,-91,0,-91,CZIupColor,DashStyle.Solid,CZILineThick);
					DrawLine(/*CurrentBar.ToString()+*/"CZIdown2",true,1,-104,0,-104,CZIdownColor,DashStyle.Solid,CZILineThick);
					DrawLine(/*CurrentBar.ToString()+*/"CZIup",true,1,109,0,109,CZIupColor,DashStyle.Solid,CZILineThick);
					DrawLine(/*CurrentBar.ToString()+*/"CZIdown",true,1,96,0,96,CZIdownColor,DashStyle.Solid,CZILineThick);
						if(ShowSWForecaster == true)
						{
							DrawLine(/*CurrentBar.ToString()+*/"SWup",true,1,209,0,209,SWAbsH>=100?Color.LimeGreen:(SWAbsH>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
							DrawLine(/*CurrentBar.ToString()+*/"SWdown",true,1,196,0,196,SWAbsL>=100?Color.LimeGreen:(SWAbsL>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
							DrawLine(/*CurrentBar.ToString()+*/"SWup2",true,1,-191,0,-191,SWAbsH>=100?Color.LimeGreen:(SWAbsH>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
							DrawLine(/*CurrentBar.ToString()+*/"SWdown2",true,1,-204,0,-204,SWAbsL>=100?Color.LimeGreen:(SWAbsL>=30?Color.Yellow:Color.Red),DashStyle.Solid,CZILineThick);
						}

					}
//	DrawLine(CurrentBar.ToString()+"SW",1,208,0,208,Close[0]==High[0]?(SWAbsH>=100?Color.LimeGreen:(SWAbsH>=30?Color.Yellow:Color.DarkRed)):(SWAbsL>=100?Color.LimeGreen:(SWAbsL>=30?Color.Yellow:Color.DarkRed)),DashStyle.Solid,CZILineThick);
//	DrawLine(CurrentBar.ToString()+"CZ",1,108,0,108,Close[0]==High[0]?CZIupColor:CZIdownColor,DashStyle.Solid,CZILineThick);
			#endregion
			}					
			#region Sideways market
			if(FirstTickOfBar && !UseJavierSideways)
			{
			BarsAgoSidewaysreset 		= MRO(delegate{return (Math.Abs(myWoodies[Math.Min(CurrentBar, 1)])>=Extremes);},1,CurrentBar-2) +1;// Extreme cross up
			int swBarsAgo_100Xup 		= MRO(delegate{return (myWoodies[Math.Min(CurrentBar, 1)] > Sidewaysboundary && (myWoodies[Math.Min(CurrentBar, 2)]==Sidewaysboundary ? myWoodies[Math.Min(CurrentBar, 3)]<Sidewaysboundary : myWoodies[Math.Min(CurrentBar, 2)]<Sidewaysboundary));},1,CurrentBar-2) +1;// 100 line cross up
			int swBarsAgo_n100Xdown		= MRO(delegate{return (myWoodies[Math.Min(CurrentBar, 1)] < -Sidewaysboundary && (myWoodies[Math.Min(CurrentBar, 2)]==-Sidewaysboundary ? myWoodies[Math.Min(CurrentBar, 3)]>-Sidewaysboundary : myWoodies[Math.Min(CurrentBar, 2)]>-Sidewaysboundary));},1,CurrentBar-2) +1;// 100 line cross down
				if(ChopXings<ChopCrosses)
				{
					ChopXings = CountIf(delegate{return((myWoodies[Math.Min(CurrentBar,1)]>0 && myWoodies[Math.Min(CurrentBar,2)]<0) || (myWoodies[Math.Min(CurrentBar,1)]<0 && myWoodies[Math.Min(CurrentBar,2)]>0));},Math.Min(Math.Max((swBarsAgo_n100Xdown-1),1), Math.Max((swBarsAgo_100Xup-1),1))-1);
//					-(Math.Abs(myWoodies[(Math.Min(Math.Max((BarsAgo_n100Xdown-1),1), Math.Max((BarsAgo_100Xup-1),1)))])+Math.Abs(myWoodies[(Math.Min(Math.Max((BarsAgo_n100Xdown-1),1), Math.Max((BarsAgo_100Xup-1),1)))+1])>Math.Abs(myWoodies[(Math.Min(Math.Max((BarsAgo_n100Xdown-1),1), Math.Max((BarsAgo_100Xup-1),1)))]) ? 1 : 0));
					sidewaysbar = CurrentBar-1;//Set bar # of sideways market start
				}
				
				sideways = ChopXings>=ChopCrosses;// && Math.Abs(myWoodies[Math.Min(CurrentBar,1)])<Extremes;
				if((BarsAgoSidewaysreset<=(CurrentBar-sidewaysbar)&& BarsAgoSidewaysreset!=0))// || (BarsAgoSidewaysresetup<=(CurrentBar-sidewaysbar) && BarsAgoSidewaysresetup!=0))
				{
					sideways = false;
					ChopXings = 0;
					resetbar = CurrentBar-1;//Set bar # of sideways market end
				}
				

				if(sideways)
					sidewaysMktSeries.Set(true);
				else
					sidewaysMktSeries.Set(false);
				
				if(ShowChopCrosses && sideways) 
				{
					DrawRectangle(sidewaysbar.ToString()+"sideways",true,CurrentBar-sidewaysbar,Extremes,0,-Extremes,SidewaysColor,SidewaysColor,SidewaysTransparency);
				}
			}
			if(ChopXings==ChopCrosses) 
				DrawTextFixed("chop","SIDEWAYS MARKET",TextPosition.TopRight);
			else
				RemoveDrawObject("chop");

			#endregion
			
			#region Javier's sideways reset
			if(FirstTickOfBar && UseJavierSideways)
			{
				if(CurrentBar>50 && !sideways)
				{
					HH = false;
					LL = false;
					for(int i=0;i<6;i++)
					{
						BarsAgoPeakH = MRO(delegate {return(myWoodies[0]<myWoodies[Math.Min(CurrentBar,1)] && myWoodies[Math.Min(CurrentBar,1)]>myWoodies[Math.Min(CurrentBar,2)]);},(i+1),CurrentBar)+1;
						BarsAgoPeakL = MRO(delegate {return(myWoodies[0]>myWoodies[Math.Min(CurrentBar,1)] && myWoodies[Math.Min(CurrentBar,1)]<myWoodies[Math.Min(CurrentBar,2)]);},(i+1),CurrentBar)+1;
						peak[i,0] = (BarsAgoPeakH > 0 ? myWoodies[BarsAgoPeakH] : 0);
						peak[i,1] = (BarsAgoPeakL > 0 ? myWoodies[BarsAgoPeakL] : 0);
					}
					for(int k=0;k<5;k++)
					{
						if((peak[k,0]>peak[(k+1),0] ||  peak[k,0] >= Extremes) && !HH)
						{
							HH=true;
							if(peak[k,0] >= Extremes && k > 0)
								peakvalH = peak[(k-1),0];
							else
								peakvalH = peak[k,0];
						}
						if((peak[k,1]<peak[(k+1),1] ||  peak[k,0] <= -Extremes) && !LL)
						{
							LL=true;
							if(peak[k,1] <= -Extremes  & k > 0)
								peakvalL = peak[(k-1),1];
							else
								peakvalL = peak[k,1];
						}
						if(HH && LL)
						break;
					}
					peakval5pc = (peakvalH + Math.Abs(peakvalL))*.05;
					swresetH = peakvalH+peakval5pc;
					swresetL = peakvalL-peakval5pc;
				}
					int BarsAgoSidewaysresetdown = MRO(delegate{return ((myWoodies[Math.Min(CurrentBar,1)]<swresetL));},1,CurrentBar-2) +1;// Extreme cross down
					int BarsAgoSidewaysresetup   = MRO(delegate{return ((myWoodies[Math.Min(CurrentBar,1)]>swresetH ));},1,CurrentBar-2) +1;// Extreme cross up
				
				int swBarsAgo_100Xup 		= MRO(delegate{return (myWoodies[Math.Min(CurrentBar, 1)] > Sidewaysboundary && (myWoodies[Math.Min(CurrentBar, 2)]==Sidewaysboundary ? myWoodies[Math.Min(CurrentBar, 3)]<Sidewaysboundary : myWoodies[Math.Min(CurrentBar, 2)]<Sidewaysboundary));},1,CurrentBar-2) +1;// 100 line cross up
				int swBarsAgo_n100Xdown		= MRO(delegate{return (myWoodies[Math.Min(CurrentBar, 1)] < -Sidewaysboundary && (myWoodies[Math.Min(CurrentBar, 2)]==-Sidewaysboundary ? myWoodies[Math.Min(CurrentBar, 3)]>-Sidewaysboundary : myWoodies[Math.Min(CurrentBar, 2)]>-Sidewaysboundary));},1,CurrentBar-2) +1;// 100 line cross down
				if(ChopXings<ChopCrosses)
				{
					ChopXings = CountIf(delegate{return((myWoodies[Math.Min(CurrentBar,1)]>0 && myWoodies[Math.Min(CurrentBar,2)]<0) || (myWoodies[Math.Min(CurrentBar,1)]<0 && myWoodies[Math.Min(CurrentBar,2)]>0));},Math.Min(Math.Min(Math.Max((swBarsAgo_n100Xdown-1),1), Math.Max((swBarsAgo_100Xup-1),1)),CurrentBar-resetbar)-1);
					sidewaysbar = CurrentBar-1;//Set bar # of sideways market start
				}
				
				if(sideways &&((BarsAgoSidewaysresetdown<=(CurrentBar-sidewaysbar)&& BarsAgoSidewaysresetdown!=0) || (BarsAgoSidewaysresetup<=(CurrentBar-sidewaysbar) && BarsAgoSidewaysresetup!=0)))
				{
					ChopXings = 0;
					resetbar = CurrentBar-1;//Set bar # of sideways market end
				}
				
				sideways = ChopXings==ChopCrosses;

				if(ShowChopCrosses && sideways) 
				{
				DrawRectangle(sidewaysbar.ToString()+"sideways",true,CurrentBar-sidewaysbar,swresetH,0,swresetL,SidewaysColor,SidewaysColor,SidewaysTransparency);
//					DrawRectangle(sidewaysbar.ToString()+"sideways",true,CurrentBar-sidewaysbar,SidewaysReset,0,-SidewaysReset,SidewaysColor,SidewaysColor,SidewaysTransparency);
				}
			
			if(ChopXings==ChopCrosses) 
				DrawTextFixed("chop","SIDEWAYS MARKET",TextPosition.TopRight);
			else
				RemoveDrawObject("chop");
			}
			#endregion
			
			if((ShowChopCrosses == true && sideways == true) || sideways == false)//Don't show patterns during choppy sideways markey
			{
			#region Reset Patterns
				ZLRL_H = false;
				ZLRL_L = false;
				ZLRL_E = false;
				ZLRS_H = false;
				ZLRS_L = false;
				ZLRS_E = false;
				FamirL_H = false;
				FamirL_L = false;
				FamirL_E = false;
				FamirS_H = false;
				FamirS_L = false;
				FamirS_E = false;
				VegasL_H = false;
				VegasL_L = false;
				VegasL_E = false;
				VegasS_H = false;
				VegasS_L = false;
				VegasS_E = false;
				GBL_H	= false;
				GBL_L 	= false;
				GBL_E	= false;
				GBS_H	= false;
				GBS_L 	= false;
				GBS_E	= false;
				TonyL_H = false;
				TonyL_L = false;
				TonyL_E = false;
				TonyS_H = false;
				TonyS_L = false;
				TonyS_E = false;
				GhostL_H = false;
				GhostL_L = false;
				GhostL_E = false;
				GhostS_H = false;
				GhostS_L = false;
				GhostS_E = false;
			#endregion
				
			#region ZLR
				bool czL1 = false;
				bool czS1 = false;
				if(showCZI_Fore)
				{
				czL1 = (ToDay(Time[0]) == LastDate ? cziHighsw : myWoodies.ChopZone[0])  == 4;
				czS1 = (ToDay(Time[0]) == LastDate ? cziLowsw : myWoodies.ChopZone[0])   == -4;
				}
				else
				{
				czL1 = myWoodies.ChopZone[Math.Min(CurrentBar,0)]  == 4;
				czS1 = myWoodies.ChopZone[Math.Min(CurrentBar,0)]   == -4;
				
				}
				bool czL2 = myWoodies.ChopZone[Math.Min(CurrentBar,1)]  == 4;
				bool czS2 = myWoodies.ChopZone[Math.Min(CurrentBar,1)]   == -4;
				bool czL3 = myWoodies.ChopZone[Math.Min(CurrentBar,2)]  == 4;
				bool czS3 = myWoodies.ChopZone[Math.Min(CurrentBar,2)]   == -4;
				bool czL4 = myWoodies.ChopZone[Math.Min(CurrentBar,3)]  == 4;
				bool czS4 = myWoodies.ChopZone[Math.Min(CurrentBar,3)]   == -4;
				bool czL5 = myWoodies.ChopZone[Math.Min(CurrentBar,4)]  == 4;
				bool czS5 = myWoodies.ChopZone[Math.Min(CurrentBar,4)]   == -4;
				bool czL6 = myWoodies.ChopZone[Math.Min(CurrentBar,5)]  == 4;
				bool czS6 = myWoodies.ChopZone[Math.Min(CurrentBar,5)]   == -4;
				bool czL7 = myWoodies.ChopZone[Math.Min(CurrentBar,6)]  == 4;
				bool czS7 = myWoodies.ChopZone[Math.Min(CurrentBar,6)]   == -4;
				bool czL8 = myWoodies.ChopZone[Math.Min(CurrentBar,7)]  == 4;
				bool czS8 = myWoodies.ChopZone[Math.Min(CurrentBar,7)]   == -4;
				bool czL9 = myWoodies.ChopZone[Math.Min(CurrentBar,8)]  == 4;
				bool czS9 = myWoodies.ChopZone[Math.Min(CurrentBar,8)]   == -4;

				bool cziLong = (czL1 && czL2 && czL3)
								|| (czL5 && czL4 && czL3 && !czL2 && czL1)
								|| ((czL6 && czL5 && czL4 && !czL3 && !czL2 && czL1) || (czL6 && czL5 && czL4 && !czL3 && czL2 && czL1))
								|| ((czL7 && czL6 && czL5 && !czL4 && czL3 && !czL2 && czL1) || (czL7 && czL6 && czL5 && !czL4 && !czL3 && czL2 && czL1))
								|| ((czL8 && czL7 && czL6 && !czL5 && czL4 && !czL3 && czL2 && czL1) || (czL8 && czL7 && czL6 && !czL5 && czL4 && czL3 && !czL2 && czL1))
								|| (czL9 && czL8 && czL7 && !czL6 && czL5 && czL4 && !czL3 && czL2 && czL1);
				bool cziShort = (czS1 && czS2 && czS3)
								|| (czS5 && czS4 && czS3 && !czS2 && czS1)
								|| ((czS6 && czS5 && czS4 && !czS3 && !czS2 && czS1) || (czS6 && czS5 && czS4 && !czS3 && czS2 && czS1))
								|| ((czS7 && czS6 && czS5 && !czS4 && czS3 && !czS2 && czS1) || (czS7 && czS6 && czS5 && !czS4 && !czS3 && czS2 && czS1))
								|| ((czS8 && czS7 && czS6 && !czS5 && czS4 && !czS3 && czS2 && czS1) || (czS8 && czS7 && czS6 && !czS5 && czS4 && czS3 && !czS2 && czS1))
								|| (czS9 && czS8 && czS7 && !czS6 && czS5 && czS4 && !czS3 && czS2 && czS1);
				//******* ZLR LONG ENTRY ******
				
				// Check for up trend, sidewinder must be neutral or trending and CCI can't be greater than 120
				if(useSWForecaster == false)
				{
					if ((Trend == 1 && Direction == 1 && myWoodies.Sidewinder[0] >= 0
					&& (cziLong)//sumchopzone3L>=11 || sumchopzone5L >= 16 || sumchopzone6L >= 18 || sumchopzone7L >= 21 || sumchopzone8L >= 24)
					))
					{
					ZLRL_H = (CCIup<=MaxSignalValue 
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinZLRPts 
						&& CCIup >= MinZLRValue); 
					ZLRL_L = (CCIdown<=MaxSignalValue 
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinZLRPts 
						&& CCIdown >= MinZLRValue); 
					}
				}
				else
					if ((Trend == 1 && Direction == 1
						&& (cziLong)//sumchopzone3L>=11 || sumchopzone5L >= 16 || sumchopzone6L >= 18 || sumchopzone7L >= 21 || sumchopzone8L >= 24)
						))
					{
						ZLRL_H = CCIup<=MaxSignalValue 
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinZLRPts 
						&& CCIup >= MinZLRValue 
							&& SWAbsH >= 30;
						ZLRL_L = CCIdown<=MaxSignalValue 
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinZLRPts 
						&& CCIdown >= MinZLRValue 
							&& SWAbsL >= 30;
					}	
					if(ZLRL_L && ZLRL_H) ZLRL_E = true;
					
				//******* ZLR SHORT ENTRY *******
				if(!ZLRL_H && !ZLRL_L)// If there is no ZLR Long, check ZLR Shorts
				{
					if(useSWForecaster == false)
					{
						if ((Trend == -1 && Direction == -1 && myWoodies.Sidewinder[0] >= 0
							&& (cziShort)//sumchopzone3S<=-11 || sumchopzone5S <= -16 || sumchopzone6S <= -18 || sumchopzone7S <= -21 || sumchopzone8S <= -24)
							))
						{
							ZLRS_H = (CCIup>=-MaxSignalValue 
							&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinZLRPts 
							&& CCIup <= -MinZLRValue); 

							ZLRS_L = (CCIdown>=-MaxSignalValue 
							&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinZLRPts 
							&& CCIdown <= -MinZLRValue); 

							}
					}
					else
						if (Trend == -1 && Direction == -1
							&& (cziShort)//sumchopzone3S<=-11 || sumchopzone5S <= -16 || sumchopzone6S <= -18 || sumchopzone7S <= -21 || sumchopzone8S <= -24)
							)
						{
							ZLRS_H = (CCIup>=-MaxSignalValue 
							&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinZLRPts 
							&& CCIup <= -MinZLRValue) 
							&& SWAbsH >= 30;
							
							ZLRS_L = (CCIdown>=-MaxSignalValue 
							&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinZLRPts 
							&& CCIdown <= -MinZLRValue) 
							&& SWAbsL >= 30;
						}
					if(ZLRS_L && ZLRS_H) ZLRS_E = true;
				}
				#endregion

			#region Famir
				//	HookL11;
			if(!ZLRL_H && ! ZLRL_L) // If there is no ZLR Long, check Famir Long
			{
				if(	myWoodies[Math.Min(CurrentBar,2)]>=myWoodies[Math.Min(CurrentBar,1)]+FamirHookMin
					&& myWoodies[Math.Min(CurrentBar,2)]>myWoodies[Math.Min(CurrentBar,3)]
					&& myWoodies[Math.Min(CurrentBar,1)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,1)]<FamirLimits
					&& myWoodies[Math.Min(CurrentBar,2)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,2)]<FamirLimits
					)
				{
					FamirL_H = (CCIup>myWoodies[Math.Min(CurrentBar,1)] 
					&& (CCIup>myWoodies[Math.Min(CurrentBar,2)] || (CCIup>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
					&& CCIup<=MaxSignalValue
					&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
					&& projectedHigh>LinRegPredictor(LSMAPeriods).LRHighClose[0]
					&& Trend==-1
					);
						
					FamirL_L = ( CCIdown>myWoodies[Math.Min(CurrentBar,1)] 
					&& (CCIdown>myWoodies[Math.Min(CurrentBar,2)] || (CCIdown>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
					&& CCIdown<=MaxSignalValue
					&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
					&& projectedLow>LinRegPredictor(LSMAPeriods).LRLowClose[0]
					&& Trend==-1
					);
				}	 

				//	HookL12;
					
				if(	myWoodies[Math.Min(CurrentBar,1)]>myWoodies[Math.Min(CurrentBar,2)]
					&& myWoodies[Math.Min(CurrentBar,3)]>myWoodies[Math.Min(CurrentBar,1)]
					&& myWoodies[Math.Min(CurrentBar,3)]>=myWoodies[Math.Min(CurrentBar,2)]+FamirHookMin
					&& myWoodies[Math.Min(CurrentBar,3)]>myWoodies[Math.Min(CurrentBar,4)]
					&& myWoodies[Math.Min(CurrentBar,2)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,2)]<FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]<FamirLimits
					&& !FamirL_H && !FamirL_L
					)
				{

					FamirL_H = ( CCIup>myWoodies[Math.Min(CurrentBar,1)]
						&& (CCIup>myWoodies[Math.Min(CurrentBar,3)] || (CCIup>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
						&& CCIup<=MaxSignalValue
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						&& projectedHigh>LinRegPredictor(LSMAPeriods).LRHighClose[0]
						&& Trend==-1
					);
						
					FamirL_L = ( CCIdown>myWoodies[Math.Min(CurrentBar,1)] 
						&& (CCIdown>myWoodies[Math.Min(CurrentBar,3)] || (CCIdown>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
						&& CCIdown<=MaxSignalValue
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						&& projectedLow>LinRegPredictor(LSMAPeriods).LRLowClose[0]
						&& Trend==-1
					);
				}

				 //******** HookL21
				
				if(myWoodies[Math.Min(CurrentBar,2)]>myWoodies[Math.Min(CurrentBar,1)]
					&& myWoodies[Math.Min(CurrentBar,3)]>myWoodies[Math.Min(CurrentBar,2)]
					&& myWoodies[Math.Min(CurrentBar,3)]>=myWoodies[Math.Min(CurrentBar,1)]+FamirHookMin
					&& myWoodies[Math.Min(CurrentBar,3)]>myWoodies[Math.Min(CurrentBar,4)]
					&& myWoodies[Math.Min(CurrentBar,1)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,1)]<FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]<FamirLimits
					&& !FamirL_H && !FamirL_L
					)
				{
					FamirL_H = ( CCIup>myWoodies[Math.Min(CurrentBar,1)]
						&& (CCIup>myWoodies[Math.Min(CurrentBar,3)] || (CCIup>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
						&& CCIup<=MaxSignalValue
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						&& projectedHigh>LinRegPredictor(LSMAPeriods).LRHighClose[0]
						&& Trend==-1
						);

					FamirL_L = ( CCIdown>myWoodies[Math.Min(CurrentBar,1)] 
						&& (CCIdown>myWoodies[Math.Min(CurrentBar,3)] || (CCIdown>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
						&& CCIdown<=MaxSignalValue
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						&& projectedLow>LinRegPredictor(LSMAPeriods).LRLowClose[0]
						&& Trend==-1
					);
				}

				//***********HookL22

				if(myWoodies[Math.Min(CurrentBar,1)]>myWoodies[Math.Min(CurrentBar,2)]
						&& myWoodies[Math.Min(CurrentBar,3)]>myWoodies[Math.Min(CurrentBar,2)]
						&& myWoodies[Math.Min(CurrentBar,4)]>myWoodies[Math.Min(CurrentBar,3)]
						&& myWoodies[Math.Min(CurrentBar,4)]>myWoodies[Math.Min(CurrentBar,1)]
						&& myWoodies[Math.Min(CurrentBar,4)]>=myWoodies[Math.Min(CurrentBar,2)]+FamirHookMin
						&& myWoodies[Math.Min(CurrentBar,4)]>myWoodies[Math.Min(CurrentBar,5)]
						&& myWoodies[Math.Min(CurrentBar,2)]>-FamirLimits
						&& myWoodies[Math.Min(CurrentBar,2)]<FamirLimits
						&& myWoodies[Math.Min(CurrentBar,4)]>-FamirLimits
						&& myWoodies[Math.Min(CurrentBar,4)]<FamirLimits
					&& !FamirL_H && !FamirL_L
					)
					{
					FamirL_H = ( CCIup>myWoodies[Math.Min(CurrentBar,1)]
						&& (CCIup>myWoodies[Math.Min(CurrentBar,4)] || (CCIup>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
						&& CCIup<=MaxSignalValue
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						&& projectedHigh>LinRegPredictor(LSMAPeriods).LRHighClose[0]
						&& Trend==-1
						);
						
					FamirL_L = ( CCIdown>myWoodies[Math.Min(CurrentBar,1)] 
						&& (CCIdown>myWoodies[Math.Min(CurrentBar,3)] || (CCIdown>0 && myWoodies[Math.Min(CurrentBar,1)]<0))
						&& CCIdown<=MaxSignalValue
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						&& projectedLow>LinRegPredictor(LSMAPeriods).LRLowClose[0]
						&& Trend==-1
						);
					}

					if(FamirL_L && FamirL_H) FamirL_E = true;
			}
				//**************************ENTRIES SHORT*********
				// *************HOOKS11
			if(!FamirL_H && !FamirL_L && !ZLRS_H && !ZLRS_L)//If there is no Famir Long or ZLR Short , check Famir Short
			{
				if(myWoodies[Math.Min(CurrentBar,2)]<=myWoodies[Math.Min(CurrentBar,1)]-FamirHookMin
					&& myWoodies[Math.Min(CurrentBar,2)]<myWoodies[Math.Min(CurrentBar,1)]
					&& myWoodies[Math.Min(CurrentBar,2)]<myWoodies[Math.Min(CurrentBar,3)]
					&& myWoodies[Math.Min(CurrentBar,1)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,1)]<FamirLimits
					&& myWoodies[Math.Min(CurrentBar,2)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,2)]<FamirLimits
					&& !FamirS_H && !FamirS_L
				)
				{
				FamirS_H = ( CCIup<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIup<myWoodies[Math.Min(CurrentBar,2)] || (CCIup<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIup>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinCCIPts 
					&& projectedHigh<LinRegPredictor(LSMAPeriods).LRHighClose[0]
					&& Trend==1
					);	
						
				FamirS_L = ( CCIdown<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIdown<myWoodies[Math.Min(CurrentBar,2)] || (CCIdown<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIdown>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinCCIPts 
					&& projectedLow<LinRegPredictor(LSMAPeriods).LRLowClose[0]
					&& Trend==1
					);
				}	
			
			   //******* HookS12
			
				if(myWoodies[Math.Min(CurrentBar,1)]<myWoodies[Math.Min(CurrentBar,2)]
					&& myWoodies[Math.Min(CurrentBar,3)]<=myWoodies[Math.Min(CurrentBar,2)]-FamirHookMin
					&& myWoodies[Math.Min(CurrentBar,3)]<myWoodies[Math.Min(CurrentBar,4)]
					&& myWoodies[Math.Min(CurrentBar,3)]<myWoodies[Math.Min(CurrentBar,1)]
					&& myWoodies[Math.Min(CurrentBar,2)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,2)]<FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]<FamirLimits
					&& !FamirS_H && !FamirS_L
				)
				{
				FamirS_H = ( CCIup<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIup<myWoodies[Math.Min(CurrentBar,3)] || (CCIup<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIup>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinCCIPts 
					&& projectedHigh<LinRegPredictor(LSMAPeriods).LRHighClose[0]
					&& Trend==1
					);

				FamirS_L = ( CCIdown<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIdown<myWoodies[Math.Min(CurrentBar,3)] || (CCIdown<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIdown>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinCCIPts 
					&& projectedLow<LinRegPredictor(LSMAPeriods).LRLowClose[0]
					&& Trend==1
					);	
				}	
			
			 //******** HookS21

				if(myWoodies[Math.Min(CurrentBar,2)]<myWoodies[Math.Min(CurrentBar,1)]
					&& myWoodies[Math.Min(CurrentBar,3)]<myWoodies[Math.Min(CurrentBar,4)]
					&& myWoodies[Math.Min(CurrentBar,3)]<myWoodies[Math.Min(CurrentBar,2)]
					&& myWoodies[Math.Min(CurrentBar,3)]<=myWoodies[Math.Min(CurrentBar,1)]-FamirHookMin
					&& myWoodies[Math.Min(CurrentBar,1)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,1)]<FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,3)]<FamirLimits
					&& !FamirS_H && !FamirS_L
				)
				{
				FamirS_H = ( CCIup<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIup<myWoodies[Math.Min(CurrentBar,3)] || (CCIup<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIup>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinCCIPts 
					&& projectedHigh<LinRegPredictor(LSMAPeriods).LRHighClose[0]
					&& Trend==1
					);	

				FamirS_L = ( CCIdown<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIdown<myWoodies[Math.Min(CurrentBar,3)] || (CCIdown<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIdown>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinCCIPts 
					&& projectedLow<LinRegPredictor(LSMAPeriods).LRLowClose[0]
					&& Trend==1
					);	
				}
			
			   //***********HookS22

				if(myWoodies[Math.Min(CurrentBar,1)]<myWoodies[Math.Min(CurrentBar,2)]
					&& myWoodies[Math.Min(CurrentBar,3)]<myWoodies[Math.Min(CurrentBar,2)]
					&& myWoodies[Math.Min(CurrentBar,4)]<myWoodies[Math.Min(CurrentBar,3)]
					&& myWoodies[Math.Min(CurrentBar,4)]<myWoodies[Math.Min(CurrentBar,5)]
					&& myWoodies[Math.Min(CurrentBar,4)]<myWoodies[Math.Min(CurrentBar,1)]
					&& myWoodies[Math.Min(CurrentBar,4)]<=myWoodies[Math.Min(CurrentBar,2)]-FamirHookMin
					&& myWoodies[Math.Min(CurrentBar,2)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,2)]<FamirLimits
					&& myWoodies[Math.Min(CurrentBar,4)]>-FamirLimits
					&& myWoodies[Math.Min(CurrentBar,4)]<FamirLimits
					&& !FamirS_H && !FamirS_L
				)
				{
				FamirS_H = ( CCIup<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIup<myWoodies[Math.Min(CurrentBar,4)] || (CCIup<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIup>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinCCIPts 
					&& projectedHigh<LinRegPredictor(LSMAPeriods).LRHighClose[0]
					&& Trend==1
					);

				FamirS_L = ( CCIdown<myWoodies[Math.Min(CurrentBar,1)]
					&& (CCIdown<myWoodies[Math.Min(CurrentBar,4)] || (CCIdown<0 && myWoodies[Math.Min(CurrentBar,1)]>0))
					&& CCIdown>=-MaxSignalValue
					&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinCCIPts 
					&& projectedLow<LinRegPredictor(LSMAPeriods).LRLowClose[0]
					&& Trend==1
					);
				}

				if(FamirS_L && FamirS_H) FamirS_E = true;
			}					
			#endregion
				
			#region Vegas
			if (BarsAgoExtremeXup < 23 && !FamirL_L && !FamirL_H) 
			{
//VT Long
				swingHigh 		= MAX(myWoodies,BarsAgoExtremeXup)[Math.Min(CurrentBar, 1)]; 
				barsAgoSwingH 	= MRO(delegate{return myWoodies[0] == swingHigh;},1,CurrentBar-2);
				vswingLow 		= MIN(myWoodies,barsAgoSwingH)[Math.Min(CurrentBar, 1)]; 
				if ((swingHigh > -VTHFEPenetrationLevel 
					&& swingHigh < 0)
					&& myWoodies[Math.Min(CurrentBar,2)] < swingHigh
					&& myWoodies[Math.Min(CurrentBar,1)] < swingHigh 
					&& barsAgoSwingH < 11
					&& barsAgoSwingH >= 4
					&& myWoodies[Math.Min(CurrentBar,1)]<0
					&& myWoodies[Math.Min(CurrentBar,2)]<0
					&& vswingLow >= -vMaxSwingPoint
					&& barsAgoSwingH <= VMaxSwingBars
					)
				{
					VegasL_H = (CCIup > swingHigh
						&& projectedHigh>LinRegPredictor(LSMAPeriods).LRHighClose[0]
						&& CCIup<=MaxSignalValue
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						);
					
					VegasL_L = (CCIdown > swingHigh
						&& projectedLow>LinRegPredictor(LSMAPeriods).LRLowClose[0]
						&& CCIdown<=MaxSignalValue
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						);
				}
				if(VegasL_L && VegasL_H) VegasL_E = true;
			}
			
			if (BarsAgoExtremeXdown < 23 && !FamirS_L && !FamirS_H) 
			{
				swingLow 		= MIN(myWoodies,BarsAgoExtremeXdown)[Math.Min(CurrentBar, 1)]; 
				barsAgoSwingL 	= MRO(delegate{return myWoodies[0] == swingLow;},1,CurrentBar-2);
				vswingHigh 		= MAX(myWoodies,barsAgoSwingL)[Math.Min(CurrentBar, 1)]; 
				//VT Short
				if ((swingLow < VTHFEPenetrationLevel && swingLow > 0 )
					&& myWoodies[Math.Min(CurrentBar,2)] > swingLow 
					&& myWoodies[Math.Min(CurrentBar,1)] > swingLow 
					&& barsAgoSwingL < 11
					&& barsAgoSwingL >= 4
					&& myWoodies[Math.Min(CurrentBar,1)]>0
					&& myWoodies[Math.Min(CurrentBar,2)]>0
					&& vswingHigh <= VMaxSwingPoint
					&& barsAgoSwingL <= VMaxSwingBars
					)
				{
					VegasS_H = (	CCIup < swingLow
						&& CCIup>=-MaxSignalValue
						&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinCCIPts 
						&& projectedHigh<LinRegPredictor(LSMAPeriods).LRHighClose[0]
						);
					
					VegasS_L = (	CCIdown < swingLow
						&& CCIdown>=-MaxSignalValue
						&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinCCIPts 
						&& projectedLow<LinRegPredictor(LSMAPeriods).LRLowClose[0]
						);
				}
					if(VegasS_L && VegasS_H) VegasS_E = true;
			}
			#endregion

			#region GB100
			trendcountL	= MRO(delegate{return myWoodies.ChopZone[0] < 4;},3,CurrentBar);//How long since chop zone 2 non aqua bars
			trendcountS	= MRO(delegate{return myWoodies.ChopZone[0] > -4;},3,CurrentBar);//How long since chop zone 2 non red bars
			
			if(!ZLRL_L && !ZLRL_H)
			{
				if(trendcountL >= TrendLength && Trend == 1
					&& BarsAgo_0Xdown < 6
					&& BarsAgo_n100Xup < BarsAgo_0Xdown//Crossed below -100 since it crossed below 0
				)
				{
					GBL_H = (CCIup > -100 && myWoodies[Math.Min(CurrentBar,1)] < -100
						&& (ToDay(Time[0]) == LastDate ? cziHighsw : myWoodies.ChopZone[0]) == 4
						&& CCIup<=MaxSignalValue
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						);
	
					GBL_L = (CCIdown > -100 && myWoodies[Math.Min(CurrentBar,1)] < -100
						&& (ToDay(Time[0]) == LastDate ? cziLowsw : myWoodies.ChopZone[0]) == 4
						&& CCIdown<=MaxSignalValue
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						);
				}
					if(GBL_L && GBL_H) GBL_E = true;
			}
			if(!ZLRS_L && !ZLRS_H)
			{
				if(	trendcountS >= TrendLength && Trend == -1
					&& BarsAgo_0Xup < 6
					&& BarsAgo_100Xdown < BarsAgo_0Xup
					)
				{
					GBS_H = ( CCIup < 100 && myWoodies[Math.Min(CurrentBar,1)] > 100
						&& (ToDay(Time[0]) == LastDate ? cziHighsw : myWoodies.ChopZone[0]) == -4
						&& CCIup>=-MaxSignalValue
						&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinCCIPts 
						);
	
					GBS_L = ( CCIdown < 100 && myWoodies[Math.Min(CurrentBar,1)] > 100
						&& (ToDay(Time[0]) == LastDate ? cziLowsw : myWoodies.ChopZone[0]) == -4
						&& CCIdown>=-MaxSignalValue
						&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinCCIPts 
						);
					
				}
				if(GBS_L && GBS_H) GBS_E = true;
			}
			#endregion
			
			#region Tony
			if((!ZLRL_L && !ZLRL_H))
			{
				if	(Trend == 1
						&& BarsAgo_0Xdown < 10
						&& BarsAgo_0Xdown > 4
						&& myWoodies[Math.Min(CurrentBar,1)]<0
						&& BarsAgo_n100Xup >= BarsAgo_0Xdown//Crossed below -100 since it crossed below 0
					)
				{
					TonyL_H = (CCIup > 0 && CCIup<=MaxSignalValue
						&& CCIup-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						);
	
					TonyL_L = (CCIdown > 0
						&& CCIdown<=MaxSignalValue
						&& CCIdown-myWoodies[Math.Min(CurrentBar,1)]>=MinCCIPts 
						);
				}
				if(TonyL_L && TonyL_H) TonyL_E = true;
			}
			
			if((!ZLRS_L && !ZLRS_H))
			{
				if	(Trend==-1
						&& BarsAgo_0Xup < 10
						&& BarsAgo_0Xup > 4
						&& myWoodies[Math.Min(CurrentBar,1)]>0
						&& BarsAgo_100Xdown >= BarsAgo_0Xup
					)
				{
					TonyS_H = (CCIup < 0
						&& CCIup>=-MaxSignalValue
						&& myWoodies[Math.Min(CurrentBar,1)]-CCIup>=MinCCIPts 
						);
						
					TonyS_L = (CCIdown < 0
						&& CCIdown>=-MaxSignalValue
						&& myWoodies[Math.Min(CurrentBar,1)]-CCIdown>=MinCCIPts 
						);
				}
				if(TonyS_L && TonyS_H) TonyS_E = true;
			}
			#endregion
			
			#region Ghosts
				gstLong = 0;
				gstShort = 0;
				gstLeftPk = 0;
				gstMiddlePk = 0;
				gstRightPk = 0;
				gstLeftLow = 0;
				gstRightLow = 0;
				gstLeftPkBars = 0;
				gstMiddlePkBars = 0;
				gstRightPkBars = 0;
				gstLeftLowBars = 0;
				gstRightLowBars = 0;
				lbPeriodup = BarsAgo_0Xup;
				lbPerioddown = BarsAgo_0Xdown;
	
				ZigZag gstZigPoints = ZigZag(myWoodies,DeviationType.Points,UsePointsAmount,false);
				ZigZag gstZigPercent = ZigZag(myWoodies,DeviationType.Percent,UsePointsAmount,false);
	
					if(myWoodies[Math.Min(CurrentBar,1)]>0 && UsePoints == "Points")//Ghost Short using Points
					{
						//How many bars since peaks
						gstLeftPkBars = gstZigPoints.HighBar(0,3,BarsAgo_0Xup);
						gstMiddlePkBars = gstZigPoints.HighBar(0,2,BarsAgo_0Xup);
						gstRightPkBars = gstZigPoints.HighBar(0,1,BarsAgo_0Xup);
						//How many bars since troughs
						gstLeftLowBars = gstZigPoints.LowBar(0,2,BarsAgo_0Xup);
						gstRightLowBars = gstZigPoints.LowBar(0,1,BarsAgo_0Xup);
						//Get Peak Values
						gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);
						gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
						gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
						//Get trough values
						gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
						gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
					}
					if(myWoodies[Math.Min(CurrentBar,1)]<0 && UsePoints == "Points")//Ghost Long using Points
					{
						//How many bars since peaks
						gstLeftPkBars = gstZigPoints.LowBar(0,3,BarsAgo_0Xdown);
						gstMiddlePkBars = gstZigPoints.LowBar(0,2,BarsAgo_0Xdown);
						gstRightPkBars = gstZigPoints.LowBar(0,1,BarsAgo_0Xdown);
						//How many bars since troughs
						gstLeftLowBars = gstZigPoints.HighBar(0,2,BarsAgo_0Xdown);
						gstRightLowBars = gstZigPoints.HighBar(0,1,BarsAgo_0Xdown);
						//Get Peak Values
						gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);//
						gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
						gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
						//Get trough values
						gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
						gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
					}	
	
					if(myWoodies[Math.Min(CurrentBar,1)]>0 && UsePoints == "Percent")//Ghost Short using %
					{
						//How many bars since peaks
						gstLeftPkBars = gstZigPercent.HighBar(0,3,BarsAgo_0Xup);
						gstMiddlePkBars = gstZigPercent.HighBar(0,2,BarsAgo_0Xup);
						gstRightPkBars = gstZigPercent.HighBar(0,1,BarsAgo_0Xup);
						//How many bars since troughs
						gstLeftLowBars = gstZigPercent.LowBar(0,2,BarsAgo_0Xup);
						gstRightLowBars = gstZigPercent.LowBar(0,1,BarsAgo_0Xup);
						//Get Peak Values
						gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);
						gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
						gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
						//Get trough values
						gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
						gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
					}
					if(myWoodies[Math.Min(CurrentBar,1)]<0 && UsePoints == "Percent")//Ghost Long using %
					{
						//How many bars since peaks
						gstLeftPkBars = gstZigPercent.LowBar(0,3,BarsAgo_0Xdown);
						gstMiddlePkBars = gstZigPercent.LowBar(0,2,BarsAgo_0Xdown);
						gstRightPkBars = gstZigPercent.LowBar(0,1,BarsAgo_0Xdown);
						//How many bars since troughs
						gstLeftLowBars = gstZigPercent.HighBar(0,2,BarsAgo_0Xdown);
						gstRightLowBars = gstZigPercent.HighBar(0,1,BarsAgo_0Xdown);
						//Get Peak Values
						gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);
						gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
						gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
						//Get trough values
						gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
						gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
					}
	
				//Reset Right Peak if on first bar after what will become a new peak.
					if(gstRightLowBars<gstRightPkBars && Math.Abs(MAX(myWoodies,gstRightLowBars)[0]-gstRightLow) >= UsePointsAmount)
					{
						if(UsePoints == "Points")
						{
							if(Math.Abs(myWoodies[0])<= (Math.Abs(myWoodies[Math.Min(CurrentBar,1)])-UsePointsAmount))
							{
								gstLeftPk = gstMiddlePk;
								gstLeftPkBars = gstMiddlePkBars;
								gstMiddlePk = gstRightPk;
								gstMiddlePkBars = gstRightPkBars;
								gstRightPk = Math.Abs(myWoodies[Math.Min(CurrentBar,1)]);
								gstRightPkBars = 1;
							}
						}
							else if(Math.Abs(myWoodies[0])<= (Math.Abs(myWoodies[Math.Min(CurrentBar,1)])*((100-UsePointsAmount)/100)))
							{
								gstLeftPk = gstMiddlePk;
								gstLeftPkBars = gstMiddlePkBars;
								gstMiddlePk = gstRightPk;
								gstMiddlePkBars = gstRightPkBars;
								gstRightPk = Math.Abs(myWoodies[Math.Min(CurrentBar,1)]);
								gstRightPkBars = 1;
							}
						
					}
					
					gstChangePerBar = (gstRightLow-gstLeftLow)/(gstLeftLowBars-gstRightLowBars);//What is the slope of the trend line per bar
				//	Reset Left and Right Lows to provide proper trend line drawing			
					int newLeftLowBars = 0;
					int newRightLowBars = 0;
					double gap = 0;
					double gap1 = 0;
					if(gstChangePerBar>0)
					{
						for(int i = gstLeftLowBars; i > gstMiddlePkBars; --i)
						{
								if(Math.Abs(myWoodies[i]) < gstLeftLow+(gstLeftLowBars-i)*gstChangePerBar)
								{
									gap1 = gstLeftLow+(gstLeftLowBars-i)*gstChangePerBar - Math.Abs(myWoodies[i]);
									if(gap<gap1)
									{
										newLeftLowBars = i;
										gap = gap1;
										gstLeftLow = Math.Abs(myWoodies[i]);
									}
								}
						}
						if(newLeftLowBars != 0)
						{
							gstLeftLowBars = newLeftLowBars;
							gstChangePerBar = (gstRightLow-gstLeftLow)/(gstLeftLowBars-gstRightLowBars);//What is the slope of the trend line per bar
						}
						gap = 0;
						gap1 = 0;
						for(int i = gstRightLowBars; i > gstRightPkBars; --i)
						{
								if(Math.Abs(myWoodies[i]) < gstLeftLow+(gstLeftLowBars-i)*gstChangePerBar)
								{
									gap1 = gstLeftLow+(gstLeftLowBars-i)*gstChangePerBar - Math.Abs(myWoodies[i]);
									if(gap<gap1)
									{
										newRightLowBars = i;
										gap = gap1;
										gstRightLow = Math.Abs(myWoodies[i]);
									}
								}
						}
						if(newRightLowBars != 0)
						{
							gstRightLowBars = newRightLowBars;
							gstChangePerBar = (gstRightLow-gstLeftLow)/(gstLeftLowBars-gstRightLowBars);//What is the slope of the trend line per bar
						}
					}

					if(gstChangePerBar<0)
					{
						newRightLowBars = 0;
						gap = 0;
						gap1 = 0;
						for(int i = gstMiddlePkBars; i > gstRightLowBars; --i)
						{
								if(Math.Abs(myWoodies[i]) < gstLeftLow+(gstLeftLowBars-i)*gstChangePerBar)
								{
									gap1 = gstLeftLow+(gstLeftLowBars-i)*gstChangePerBar - Math.Abs(myWoodies[i]);
									if(gap<gap1)
									{
										newRightLowBars = i;
										gap = gap1;
										gstRightLow = Math.Abs(myWoodies[i]);
									}
								}
						}
						if(newRightLowBars != 0)
						{
							gstRightLowBars = newRightLowBars;
							gstChangePerBar = (gstRightLow-gstLeftLow)/(gstLeftLowBars-gstRightLowBars);//What is the slope of the trend line per bar
						}
					}
				//				
					gstTrendBrkShortH = CCIup<(gstLeftLow+(gstLeftLowBars*gstChangePerBar))
						&& myWoodies[Math.Min(CurrentBar,1)]>(gstLeftLow+((gstLeftLowBars-1)*gstChangePerBar)) 
						&& myWoodies[Math.Min(CurrentBar,1)]>0//Has there been a trend line break?
						|| (myWoodies[Math.Min(CurrentBar,1)]>(gstLeftLow+(gstLeftLowBars*gstChangePerBar)) 
							&& CCIup < 0 && myWoodies[Math.Min(CurrentBar,1)] > 0 
							&& (gstLeftLow+(gstLeftLowBars*gstChangePerBar))>-50);//Will there be a trend line break?

						gstTrendBrkShortL = CCIdown<(gstLeftLow+(gstLeftLowBars*gstChangePerBar))
						&& myWoodies[Math.Min(CurrentBar,1)]>(gstLeftLow+((gstLeftLowBars-1)*gstChangePerBar)) 
						&& myWoodies[Math.Min(CurrentBar,1)]>0//Has there been a trend line break?
						|| (myWoodies[Math.Min(CurrentBar,1)]>(gstLeftLow+(gstLeftLowBars*gstChangePerBar)) 
							&& CCIdown < 0 && myWoodies[Math.Min(CurrentBar,1)] > 0 
							&& (gstLeftLow+(gstLeftLowBars*gstChangePerBar))>-50);//Will there be a trend line break?
					
					bool gstGap = gstRightPk >= (gstLeftLow+((gstLeftLowBars-gstRightPkBars)*gstChangePerBar)) + gstColor;
				GhostS_H = (
						(
						(gstLeftPk < gstMiddlePk && gstRightPk < gstMiddlePk) 
						|| (gstLeftPk > gstMiddlePk && gstRightPk > gstMiddlePk)
						)
						&& gstTrendBrkShortH 
						&& BarsAgo_0Xup>gstLeftPkBars 
						&& gstLeftPkBars != -1 
						&& gstMiddlePkBars != -1 
						&& gstRightPkBars != -1
						&& gstMiddlePkBars<gstLeftLowBars 
						&& gstRightPkBars<gstRightLowBars	
						&& CCIup>=-MaxSignalValue
						&& gstGap
					);
				GhostS_L = (
					((gstLeftPk < gstMiddlePk && gstRightPk < gstMiddlePk) 
					|| (gstLeftPk > gstMiddlePk && gstRightPk > gstMiddlePk)
					)
					&& gstTrendBrkShortL ==true 
					&& BarsAgo_0Xup>gstLeftPkBars 
					&& gstLeftPkBars != -1 
					&& gstMiddlePkBars != -1 
					&& gstRightPkBars != -1
					&& gstMiddlePkBars<gstLeftLowBars 
					&& gstRightPkBars<gstRightLowBars	
					&& CCIdown>=-MaxSignalValue
					&& gstGap
					);
				
					gstTrendBrkLongH = (Math.Abs(CCIup)<(gstLeftLow+(gstLeftLowBars*gstChangePerBar))
						&& Math.Abs(myWoodies[Math.Min(CurrentBar,1)])>(gstLeftLow+((gstLeftLowBars-1)*gstChangePerBar))
						&& myWoodies[Math.Min(CurrentBar,1)]<0
						)
						|| (Math.Abs(myWoodies[Math.Min(CurrentBar,1)])>(gstLeftLow+(gstLeftLowBars*gstChangePerBar)) 
							&& CCIup > 0 && myWoodies[Math.Min(CurrentBar,1)] < 0 
							&& (gstLeftLow+(gstLeftLowBars*gstChangePerBar))>-50);//Will there be a trend line break?

					gstTrendBrkLongL = (Math.Abs(CCIdown)<(gstLeftLow+(gstLeftLowBars*gstChangePerBar))
						&& Math.Abs(myWoodies[Math.Min(CurrentBar,1)])>(gstLeftLow+((gstLeftLowBars-1)*gstChangePerBar))
						&& myWoodies[Math.Min(CurrentBar,1)]<0
						)
						|| (Math.Abs(myWoodies[Math.Min(CurrentBar,1)])>(gstLeftLow+(gstLeftLowBars*gstChangePerBar)) 
							&& CCIdown > 0 && myWoodies[Math.Min(CurrentBar,1)] < 0 
							&& (gstLeftLow+(gstLeftLowBars*gstChangePerBar))>-50);//Will there be a trend line break?
				
				
				//Ghosts Long
				GhostL_H = (
					((gstLeftPk < gstMiddlePk && gstRightPk < gstMiddlePk) 
					|| (gstLeftPk > gstMiddlePk && gstRightPk > gstMiddlePk)
					)
					&& gstTrendBrkLongH 
					&& BarsAgo_0Xdown>gstLeftPkBars && gstLeftPkBars != -1 
					&& gstMiddlePkBars != -1 && gstRightPkBars != -1
					&& gstMiddlePkBars<gstLeftLowBars 
					&& gstRightPkBars<gstRightLowBars	
					&& CCIup<=MaxSignalValue
					&& gstGap
					);
					
				GhostL_L = (
					((gstLeftPk < gstMiddlePk && gstRightPk < gstMiddlePk)
					|| (gstLeftPk > gstMiddlePk && gstRightPk > gstMiddlePk)
					)
					&& gstTrendBrkLongL 
					&& BarsAgo_0Xdown>gstLeftPkBars && gstLeftPkBars != -1 
					&& gstMiddlePkBars != -1 && gstRightPkBars != -1
					&& gstMiddlePkBars<gstLeftLowBars 
					&& gstRightPkBars<gstRightLowBars 
					&& CCIdown<=MaxSignalValue
					&& gstGap
					);
	
/*					DrawText(CurrentBar.ToString() + "GHOSTLTEXT0",BarsAgo_0Xdown.ToString(),0,-20,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT",gstLeftPk.ToString("###.#"),0,-70,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT1",gstLeftPkBars.ToString(),0,-95,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT2",gstMiddlePk.ToString("###.#"),0,-120,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT3",gstMiddlePkBars.ToString(),0,-145,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT4",gstRightPk.ToString("###.#"),0,-170,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT5",gstRightPkBars.ToString(),0,-195,Color.PaleGreen);
				
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT0a",BarsAgo_0Xup.ToString(),0,20,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT6",gstLeftLow.ToString("###.#"),0,120,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT7",gstLeftLowBars.ToString(),0,130,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT8",gstRightLow.ToString("###.#"),0,150,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT9",gstRightLowBars.ToString(),0,160,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "Slope",gstChangePerBar.ToString("##.#"),0,185,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "ShBreak",(gstLeftLow+(gstLeftLowBars*gstChangePerBar)).ToString("##.#"),0,210,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "cb",CurrentBar.ToString(),0,225,Color.PaleGreen);
*/					
	/*				DrawText(CurrentBar.ToString() + "GHOSTLTEXT0a",GhostL_H.ToString(),0,40,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT0b",GhostL_L.ToString(),0,20,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT0f",GhostL_E.ToString(),0,60,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT0c",GhostS_H.ToString(),0,-20,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT0d",GhostS_L.ToString(),0,-40,Color.PaleGreen);
					DrawText(CurrentBar.ToString() + "GHOSTLTEXT0e",GhostS_E.ToString(),0,-60,Color.PaleGreen);
	*/			
					if(GhostL_L && GhostL_H) GhostL_E = true;
					if(GhostS_L && GhostS_H) GhostS_E = true;
			#endregion
			
			#region Draw Momentum Change Exits
			if(ShowMomoChange == true)
			{
				BarsAgoLongPattern	= MRO(delegate{return (WCCIPattern[0] > 0 && WCCIDirection[0] >0);},1,CurrentBar-2);
				BarsAgoShortPattern	= MRO(delegate{return (WCCIPattern[0] > 0 && WCCIDirection[0] <0);},1,CurrentBar-2);
				LongMomoChange = (myWoodies[0]<=myWoodies[Math.Min(CurrentBar, 1)] && Open[0] >=Close[0]);
				ShortMomoChange = (myWoodies[0]>=myWoodies[Math.Min(CurrentBar, 1)] && Open[0] <=Close[0]);

				if(LongMomoChange && (BarsAgo_100Xdown==1 ? Open[0] >=Close[0] : BarsAgo_100Xdown > BarsAgoLongPattern) 
					&& MIN(Low,BarsAgoLongPattern)[0] > Close[BarsAgoLongPattern]-(Bars.Period.Value*TickSize)
					&& BarsAgoShortPattern>BarsAgoLongPattern)
				{	
					DrawArrowLine(CurrentBar.ToString()+"momol",true,0,250,0,210,Color.Red,DashStyle.Dash,2);
					if(SoundMomoAlert) Alert(CurrentBar.ToString() + "momoalert1", Priority.Medium, "Momo Change long", "Alert2.wav", alertInterval, Color.DarkGreen, Color.White);

				}
				else if(ShortMomoChange && (BarsAgo_n100Xup==1 ? Open[0] <=Close[0] : BarsAgo_n100Xup > BarsAgoShortPattern) 
					&& MAX(High,BarsAgoShortPattern)[0] < Close[BarsAgoShortPattern]+(Bars.Period.Value*TickSize)
					&& BarsAgoShortPattern<BarsAgoLongPattern)
				{	
					DrawArrowLine(CurrentBar.ToString()+"momos",true,0,-250,0,-210,Color.DarkGreen,DashStyle.Dash,2);
					if(SoundMomoAlert) Alert(CurrentBar.ToString() + "momoalert2", Priority.Medium, "Momo Change short", "Alert2.wav", alertInterval, Color.DarkGreen, Color.White);
				}
					else
					{	RemoveDrawObject(CurrentBar.ToString() + "momol");
						RemoveDrawObject(CurrentBar.ToString() + "momos");
					}		
//				DrawText(CurrentBar.ToString() + "momoTEXT0",BarsAgo_100Xdown.ToString(),0,-20,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT4",BarsAgo_n100Xup.ToString(),0,-20,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT",BarsAgoLongPattern.ToString(),0,-70,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT1",BarsAgoShortPattern.ToString(),0,-95,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT2",MIN(Low,BarsAgoLongPattern+1)[0].ToString("###.##"),0,-120,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "GHOSTLTEXT2",MAX(High,BarsAgoShortPattern+1)[0].ToString("###.##"),0,-120,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "GHOSTLTEXT3",Close[BarsAgoLongPattern].ToString("###.##"),0,-145,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "GHOSTLTEXT3",Close[BarsAgoShortPattern].ToString("###.##"),0,-145,Color.PaleGreen);
			

			}
			#endregion
			}//End sideways if statement
		}
		
		protected void DrawPatterns()
		{
			DrawTextFixed("version","Snaphook's CCI Forecaster v7.3.2",TextPosition.BottomRight);

			#region ZLR
		//LONG
			if(((ZLRL_H  && pcbar != -1) || (ZLRL_L && pcbar != 1) || ZLRL_E) && Show_ZLR)
			{
				wCCIPatternSeries.Set(1);
				wCCIDirectionSeries.Set(1);
				if(ZLRLineThick >0) DrawLine(CurrentBar.ToString() + "ZLRLLine",true, 0,  myWoodies[0],0,0, ZLRLineColorL,DashStyle.Solid,ZLRLineThick);
				if(soundAlert)
				{
					Alert(CurrentBar.ToString(), Priority.Medium, "Zero Line Reject Long", @AlertFile, alertInterval, Color.DarkGreen, Color.White);
				}
				if(ZLRL_E)
				{
					wCCIBarEndSeries.Set(0);
					DrawText(CurrentBar.ToString()+"ZLRTriggerL",true,"Z\ne",0,TextAnchorL-SignalLabels.SizeInPoints,1,ZLRColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
				}
				else
				{
					if(ZLRL_H)
					{
						wCCIBarEndSeries.Set(1);
						DrawText(CurrentBar.ToString()+"ZLRTriggerL",true,"Z\nt",0,TextAnchorL-SignalLabels.SizeInPoints,1,ZLRColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
					else
					{
						wCCIBarEndSeries.Set(-1);
						DrawText(CurrentBar.ToString()+"ZLRTriggerL",true,"Z\nb",0,TextAnchorL-SignalLabels.SizeInPoints,1,ZLRColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
				}
			}		
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "ZLRL");
				RemoveDrawObject(CurrentBar.ToString() + "ZLRLLine");
				RemoveDrawObject(CurrentBar.ToString() + "ZLRTriggerL");
			}
		// SHORT
			if(((ZLRS_H  && pcbar != -1) || (ZLRS_L && pcbar != 1) || ZLRS_E) && Show_ZLR)
			{
				wCCIPatternSeries.Set(1);
				wCCIDirectionSeries.Set(-1);
				if(ZLRLineThick >0) DrawLine(CurrentBar.ToString() + "ZLRSLine",true, 0,  myWoodies[0],0,0, ZLRLineColorS,DashStyle.Solid,ZLRLineThick);
				if(soundAlert == true)
				{
					Alert(CurrentBar.ToString(), Priority.Medium, "Zero Line Reject Short", @AlertFile, alertInterval, Color.Red, Color.White);
				}
				if(ZLRS_E)
				{
					wCCIBarEndSeries.Set(0);
					DrawText(CurrentBar.ToString()+"ZLRTriggerS",true,"Z\ne",0,TextAnchorS-SignalLabels.SizeInPoints,1,ZLRColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
				}
				else
				{
					if(ZLRS_H)
					{
						wCCIBarEndSeries.Set(1);
						DrawText(CurrentBar.ToString()+"ZLRTriggerS",true,"Z\nt",0,TextAnchorS-SignalLabels.SizeInPoints,1,ZLRColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
					else
					{
						wCCIBarEndSeries.Set(-1);
						DrawText(CurrentBar.ToString()+"ZLRTriggerS",true,"Z\nb",0,TextAnchorS-SignalLabels.SizeInPoints,1,ZLRColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
				}	
			}
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "ZLRS");
				RemoveDrawObject(CurrentBar.ToString() + "ZLRSLine");
				RemoveDrawObject(CurrentBar.ToString() + "ZLRTriggerS");
			}
				
			#endregion
			
			#region Famir
			if(((FamirL_H  && pcbar != -1) || (FamirL_L && pcbar != 1) || FamirL_E) && Show_Famir && WCCIDirection[0]!= 1)
				{
				wCCIPatternSeries.Set(2);
				wCCIDirectionSeries.Set(1);
				if(soundAlert == true)
				{
					Alert(CurrentBar.ToString(), Priority.Medium, "Famir Long", @AlertFile, alertInterval, Color.Red, Color.White);
				}
				if(FamirL_E)
					{
						wCCIBarEndSeries.Set(0);
						DrawText(CurrentBar.ToString()+"FamirTriggerL",true,"F\ne",0,TextAnchorL-SignalLabels.SizeInPoints,1,FamirColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
				else
				{
					if(FamirL_H)
					{
						wCCIBarEndSeries.Set(1);
						DrawText(CurrentBar.ToString()+"FamirTriggerL",true,"F\nt",0,TextAnchorL-SignalLabels.SizeInPoints,1,FamirColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
					else
					{
						wCCIBarEndSeries.Set(-1);
						DrawText(CurrentBar.ToString()+"FamirTriggerL",true,"F\nb",0,TextAnchorL-SignalLabels.SizeInPoints,1,FamirColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
				}
			}		
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "FamirTriggerL");
			}
			
			if(((FamirS_H  && pcbar != -1) || (FamirS_L && pcbar != 1) || FamirS_E) && Show_Famir && WCCIDirection[0]!= -1)
			{
				wCCIPatternSeries.Set(2);
				wCCIDirectionSeries.Set(-1);
				if(soundAlert == true)
				{
					Alert(CurrentBar.ToString(), Priority.Medium, "Famir Short", @AlertFile, alertInterval, Color.Red, Color.White);
				}
				if(FamirS_E)
					{
						wCCIBarEndSeries.Set(0);
						DrawText(CurrentBar.ToString()+"FamirTriggerS",true,"F\ne",0,TextAnchorS-SignalLabels.SizeInPoints,1,FamirColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
				else
				{
					if(FamirS_H)
					{
						wCCIBarEndSeries.Set(1);
						DrawText(CurrentBar.ToString()+"FamirTriggerS",true,"F\nt",0,TextAnchorS-SignalLabels.SizeInPoints,1,FamirColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					else
					{
						wCCIBarEndSeries.Set(-1);
						DrawText(CurrentBar.ToString()+"FamirTriggerS",true,"F\nb",0,TextAnchorS-SignalLabels.SizeInPoints,1,FamirColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
					}
				}
			}		
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "FamirTriggerS");
			}
			#endregion
			
			#region Vegas
			//LONG
			if((((VegasL_H  && pcbar != -1) || (VegasL_L && pcbar != 1) || VegasL_E)) && Show_Vegas && WCCIDirection[0]!= 1)
				{
					wCCIPatternSeries.Set(3);
					wCCIDirectionSeries.Set(1);
					DrawLine(CurrentBar.ToString()+"VSH",true,barsAgoSwingH,swingHigh,0,swingHigh,VegasTrendColor,DashStyle.Dash,1);
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "Vegas Long", @AlertFile, alertInterval, Color.Red, Color.White);
					}
//							DrawLine(CurrentBar.ToString() + "VegasL", 0,  myWoodies[0],0,0, Color.PaleGreen,DashStyle.Solid,4);
					if(VegasL_E)
						{
							wCCIBarEndSeries.Set(0);
							DrawText(CurrentBar.ToString()+"VegasTriggerL",true,"V\ne",0,TextAnchorL-SignalLabels.SizeInPoints,1,VegasColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					else
					{
						if(VegasL_H)
						{
							wCCIBarEndSeries.Set(1);
							DrawText(CurrentBar.ToString()+"VegasTriggerL",true,"V\nt",0,TextAnchorL-SignalLabels.SizeInPoints,1,VegasColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
						else
						{
							wCCIBarEndSeries.Set(-1);
							DrawText(CurrentBar.ToString()+"VegasTriggerL",true,"V\nb",0,TextAnchorL-SignalLabels.SizeInPoints,1,VegasColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					}
				}		
				else
				{
					RemoveDrawObject(CurrentBar.ToString() + "VegasL");
					RemoveDrawObject(CurrentBar.ToString() + "VegasTriggerL");
					RemoveDrawObject(CurrentBar.ToString() + "VSH");
				}
			//SHORT	
				if((((VegasS_H  && pcbar != -1) || (VegasS_L && pcbar != 1) || VegasS_E)) && Show_Vegas && WCCIDirection[0]!= -1)
				{
					wCCIPatternSeries.Set(3);
					wCCIDirectionSeries.Set(-1);
					DrawLine(CurrentBar.ToString()+"VSL",true,barsAgoSwingL,swingLow,0,swingLow,VegasTrendColor,DashStyle.Dash,1);
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "Vegas Short", @AlertFile, alertInterval, Color.Red, Color.White);
					}
//							DrawLine(CurrentBar.ToString() + "VegasS", 0,  myWoodies[0],0,0, Color.PaleGreen,DashStyle.Solid,4);
					if(VegasS_E)
						{
							wCCIBarEndSeries.Set(0);
							DrawText(CurrentBar.ToString()+"VegasTriggerS",true,"V\ne",0,TextAnchorS-SignalLabels.SizeInPoints,1,VegasColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					else
					{
						if(VegasS_H)
						{
							wCCIBarEndSeries.Set(1);
							DrawText(CurrentBar.ToString()+"VegasTriggerS",true,"V\nt",0,TextAnchorS-SignalLabels.SizeInPoints,1,VegasColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
						else
						{
							wCCIBarEndSeries.Set(-1);
							DrawText(CurrentBar.ToString()+"VegasTriggerS",true,"V\nb",0,TextAnchorS-SignalLabels.SizeInPoints,1,VegasColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					}
				}		
				else
					{
//						RemoveDrawObject(CurrentBar.ToString() + "VegasS");
						RemoveDrawObject(CurrentBar.ToString() + "VegasTriggerS");
						RemoveDrawObject(CurrentBar.ToString() + "VSL");
					}
			#endregion
			
			#region GB100
			//LONG
				if((((GBL_H  && pcbar != -1) || (GBL_L && pcbar != 1) || GBL_E)) && Show_GB100 && WCCIDirection[0]!= 1)
				{
					wCCIPatternSeries.Set(4);
					wCCIDirectionSeries.Set(1);
					if(GBLineThick >0) DrawLine(CurrentBar.ToString() + "GBLLine",true, 0,  200,0,-200, Color.PaleGreen,DashStyle.Dash,GBLineThick);
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "GB100 Long", @AlertFile, alertInterval, Color.Red, Color.White);
					}
					if(GBL_E)
						{
						wCCIBarEndSeries.Set(0);
						DrawText(CurrentBar.ToString()+"GBTriggerL",true,"B\ne",0,TextAnchorL-SignalLabels.SizeInPoints,1,GBColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					else
					{
						if(GBL_H)
						{
						wCCIBarEndSeries.Set(1);
						DrawText(CurrentBar.ToString()+"GBTriggerL",true,"B\nt",0,TextAnchorL-SignalLabels.SizeInPoints,1,GBColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
						else
						{
						wCCIBarEndSeries.Set(-1);
						DrawText(CurrentBar.ToString()+"GBTriggerL",true,"B\nb",0,TextAnchorL-SignalLabels.SizeInPoints,1,GBColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					}
				}
				else
				{
					RemoveDrawObject(CurrentBar.ToString() + "GBLLine");
					RemoveDrawObject(CurrentBar.ToString() + "GBTriggerL");
				}
			//SHORT
				if((((GBS_H  && pcbar != -1) || (GBS_L && pcbar != 1) || GBS_E)) && Show_GB100 && WCCIDirection[0]!= -1)
				{
					wCCIPatternSeries.Set(4);
					wCCIDirectionSeries.Set(-1);
					if(GBLineThick >0) DrawLine(CurrentBar.ToString() + "GBSLine",true, 0,  200,0,-200, Color.Pink,DashStyle.Dash,GBLineThick);
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "GB100 Short", @AlertFile, alertInterval, Color.Red, Color.White);
					}
					if(GBS_E)
						{
							wCCIBarEndSeries.Set(0);
							DrawText(CurrentBar.ToString()+"GBTriggerS",true,"B\ne",0,TextAnchorS-SignalLabels.SizeInPoints,1,GBColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					else
					{
						if(GBS_H)
						{
							wCCIBarEndSeries.Set(1);
							DrawText(CurrentBar.ToString()+"GBTriggerS",true,"B\nt",0,TextAnchorS-SignalLabels.SizeInPoints,1,GBColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
						else
						{
							wCCIBarEndSeries.Set(-1);
							DrawText(CurrentBar.ToString()+"GBTriggerS",true,"B\nb",0,TextAnchorS-SignalLabels.SizeInPoints,1,GBColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					}
				}		
				else
				{
					RemoveDrawObject(CurrentBar.ToString() + "GBSLine");
					RemoveDrawObject(CurrentBar.ToString() + "GBTriggerS");
				}
			#endregion
			
			#region Tony
				if((((TonyL_H  && pcbar != -1) || (TonyL_L && pcbar != 1) || TonyL_E)) && Show_Tony && WCCIDirection[0]!= 1)
				{
					wCCIPatternSeries.Set(5);
					wCCIDirectionSeries.Set(1);
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "Tony Long", @AlertFile, alertInterval, Color.Red, Color.White);
					}
					if(TonyL_E)
						{
							wCCIBarEndSeries.Set(0);
							DrawText(CurrentBar.ToString()+"TonyTriggerL",true,"T\ne",0,TextAnchorL-SignalLabels.SizeInPoints,1,TonyColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					else
					{
						if(TonyL_H)
						{
							wCCIBarEndSeries.Set(1);
							DrawText(CurrentBar.ToString()+"TonyTriggerL",true,"T\nt",0,TextAnchorL-SignalLabels.SizeInPoints,1,TonyColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
						else
						{
							wCCIBarEndSeries.Set(-1);
							DrawText(CurrentBar.ToString()+"TonyTriggerL",true,"T\nb",0,TextAnchorL-SignalLabels.SizeInPoints,1,TonyColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					}
				}
				else
				{
					RemoveDrawObject(CurrentBar.ToString() + "TonyTriggerL");
				}
			
				if((((TonyS_H  && pcbar != -1) || (TonyS_L && pcbar != 1) || TonyS_E)) && Show_Tony && WCCIDirection[0]!= -1)
				{
					wCCIPatternSeries.Set(5);
					wCCIDirectionSeries.Set(-1);
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "Tony Short", @AlertFile, alertInterval, Color.Red, Color.White);
					}
					if(TonyS_E)
						{
							wCCIBarEndSeries.Set(0);
							DrawText(CurrentBar.ToString()+"TonyTriggerS",true,"T\ne",0,TextAnchorS-SignalLabels.SizeInPoints,1,TonyColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					else
					{
						if(TonyS_H)
						{
							wCCIBarEndSeries.Set(1);
							DrawText(CurrentBar.ToString()+"TonyTriggerS",true,"T\nt",0,TextAnchorS-SignalLabels.SizeInPoints,1,TonyColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
						else
						{
							wCCIBarEndSeries.Set(-1);
							DrawText(CurrentBar.ToString()+"TonyTriggerS",true,"T\nb",0,TextAnchorS-SignalLabels.SizeInPoints,1,TonyColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
						}
					}
				}		
				else
				{
					RemoveDrawObject(CurrentBar.ToString() + "TonyTriggerS");
				}
			#endregion
			
			#region Ghost
				if((((GhostL_H  && pcbar != -1) || (GhostL_L && pcbar != 1) || GhostL_E)) && Show_Ghost && WCCIDirection[0]!= 1)
					{
						wCCIPatternSeries.Set(6);
						wCCIDirectionSeries.Set(1);
						if(ShowGhostPeaks==true)
						{
							DrawText(CurrentBar.ToString() + "GHOST1L","p1",gstLeftPkBars,-gstLeftPk-10,GhostColorL);
							DrawText(CurrentBar.ToString() + "GHOST2L","p2",gstMiddlePkBars,-gstMiddlePk-10,GhostColorL);
							DrawText(CurrentBar.ToString() + "GHOST3L","p3",gstRightPkBars,-gstRightPk-10,GhostColorL);
						}
						if(SoundAlert==true)
						{
							Alert(CurrentBar.ToString() + "Ghost", Priority.Medium, "GHOST Long", @AlertFile, alertInterval, Color.DarkGreen, Color.White);
						}
						if(GhostL_E)
							{
								wCCIBarEndSeries.Set(0);
								DrawText(CurrentBar.ToString()+"GhostTriggerL",true,"G\ne",0,TextAnchorL-SignalLabels.SizeInPoints,1,GhostColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
								DrawLine(CurrentBar.ToString() + "GTrendL",true, gstLeftLowBars,-gstLeftLow,0,-(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
							}
						else
						{
							if(GhostL_H)
							{
								wCCIBarEndSeries.Set(1);
								DrawText(CurrentBar.ToString()+"GhostTriggerL",true,"G\nt",0,TextAnchorL-SignalLabels.SizeInPoints,1,GhostColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
								DrawLine(CurrentBar.ToString() + "GTrendL",true, gstLeftLowBars,-gstLeftLow,0,-(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
							}
							else
							{
								wCCIBarEndSeries.Set(-1);
								DrawText(CurrentBar.ToString()+"GhostTriggerL",true,"G\nb",0,TextAnchorL-SignalLabels.SizeInPoints,1,GhostColorL,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
								DrawLine(CurrentBar.ToString() + "GTrendL",true, gstLeftLowBars,-gstLeftLow,0,-(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
							}
						}
		
					}
					else
					{
						RemoveDrawObject(CurrentBar.ToString() + "GhostTriggerL");
						RemoveDrawObject(CurrentBar.ToString() + "GHOST1L");
						RemoveDrawObject(CurrentBar.ToString() + "GHOST2L");
						RemoveDrawObject(CurrentBar.ToString() + "GHOST3L");
						RemoveDrawObject(CurrentBar.ToString() + "GTrendL");
						
					}
				//Ghosts Short
				if((((GhostS_H  && pcbar != -1) || (GhostS_L && pcbar != 1) || GhostS_E)) && Show_Ghost && WCCIDirection[0]!= -1)
					{
						wCCIPatternSeries.Set(6);
						wCCIDirectionSeries.Set(-1);
						if(ShowGhostPeaks==true)
						{
							DrawText(CurrentBar.ToString() + "GHOST1S","p1",gstLeftPkBars,gstLeftPk+10,GhostColorS);
							DrawText(CurrentBar.ToString() + "GHOST2S","p2",gstMiddlePkBars,gstMiddlePk+10,GhostColorS);
							DrawText(CurrentBar.ToString() + "GHOST3S","p3",gstRightPkBars,gstRightPk+10,GhostColorS);
						}
						if(SoundAlert==true)
						{
							Alert(CurrentBar.ToString() + "Ghost", Priority.Medium, "GHOST Short", @AlertFile, alertInterval, GhostColorL, Color.White);
						}
						if(GhostS_E)
							{
								wCCIBarEndSeries.Set(0);
								DrawText(CurrentBar.ToString()+"GhostTriggerS",true,"G\ne",0,TextAnchorS-SignalLabels.SizeInPoints,1,GhostColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
								DrawLine(CurrentBar.ToString() + "GTrendS",true, gstLeftLowBars,gstLeftLow,0,(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
							}
						else
						{
							if(GhostS_H)
							{
								wCCIBarEndSeries.Set(1);
								DrawText(CurrentBar.ToString()+"GhostTriggerS",true,"G\nt",0,TextAnchorS-SignalLabels.SizeInPoints,1,GhostColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
								DrawLine(CurrentBar.ToString() + "GTrendS",true, gstLeftLowBars,gstLeftLow,0,(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
							}
							else
							{
								wCCIBarEndSeries.Set(-1);
								DrawText(CurrentBar.ToString()+"GhostTriggerS",true,"G\nb",0,TextAnchorS-SignalLabels.SizeInPoints,1,GhostColorS,SignalLabels,StringAlignment.Center,Color.White,Color.White,10);
								DrawLine(CurrentBar.ToString() + "GTrendS",true, gstLeftLowBars,gstLeftLow,0,(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
							}
						}
					}
					else
					{
						RemoveDrawObject(CurrentBar.ToString() + "GhostTriggerS");
						RemoveDrawObject(CurrentBar.ToString() + "GHOST1S");
						RemoveDrawObject(CurrentBar.ToString() + "GHOST2S");
						RemoveDrawObject(CurrentBar.ToString() + "GHOST3S");
						RemoveDrawObject(CurrentBar.ToString() + "GTrendS");
					}
			#endregion
			
				
			if(ShowOneTwenty == true)
			{	DrawLine("120",true,LineExtension,MaxSignalValue,0,MaxSignalValue,OneTwentyColor,DashStyle.Dash,1);
				DrawLine("-120",true,LineExtension,-MaxSignalValue,0,-MaxSignalValue,OneTwentyColor,DashStyle.Dash,1);	
			}
			if(ShowFamirLimits == true)
			{	DrawLine("flimits",true,LineExtension,FamirLimits,0,FamirLimits,FamirLimitsColor,DashStyle.Dash,1);
				DrawLine("-flimits",true,LineExtension,-FamirLimits,0,-FamirLimits,FamirLimitsColor,DashStyle.Dash,1);	
			}
			
			if(CCIShowForecasterArrows == true)
			{
			DrawArrowUp("LowCCI",true, 0, CCIdown, CCIForecasterColorL);
			DrawArrowDown("HighCCI",true, 0, CCIup, CCIForecasterColorH);
			}
			else if (CCIShowForecasterDots == true)
			{
			DrawDot("LowCCI",false,0,CCIdown,CCIForecasterColorL);
			DrawDot("HighCCI",false,0,CCIup,CCIForecasterColorH);
			}
			// Plot CCI Forecaster
//			Plots[0].Pen.Width = 2;
//			Plots[Math.Min(CurrentBar,1)].Pen.Width = 2;
//			PlotCCILow.Set(CCIdown);
//			PlotCCIHigh.Set(CCIup);
		}
		protected void DataExtraction()
		{
			if(Historical || !UseDataExtraction) return;

			StreamWriter sw;
		#region Trade Processing				
			//Get performance data for the pattern
			if(signal == true)
			{
					int j = CurrentBar-signalbar;
					
					//Did the close and direction agree?
					if((WCCIDirection[j] == 1 && Close[Math.Min(CurrentBar,1)]==High[Math.Min(CurrentBar,1)])
						|| (WCCIDirection[j] == -1 && Close[Math.Min(CurrentBar,1)]==Low[Math.Min(CurrentBar,1)]))
						hold = true;
					else
						hold = false;
					
					//Has a cross of the 100 occurred?
					if(Math.Abs(myWoodies[Math.Min(CurrentBar,2)])>100 && Math.Abs(myWoodies[Math.Min(CurrentBar,1)])<100  && j>1)
						cross_100 = true;
					else if(Math.Abs(myWoodies[Math.Min(CurrentBar,2)])<100 && Math.Abs(myWoodies[Math.Min(CurrentBar,1)])>100)//resets 100 X if cross occurred on a hold candle
						cross_100 = false;
					
////////////////   Check conditions   ///////////////////
				//Stopped out
					if(!breakeven && ((WCCIDirection[j] == 1 && Close[0]<=(entrypoint-(WCCICloseAt[j] != WCCIDirection[j] ? Opp_End_MAE_Ticks*TickSize :  MAE_Ticks*TickSize)))
						|| (WCCIDirection[j] == -1 && Close[0]>= (entrypoint + (WCCICloseAt[j] != WCCIDirection[j] ? Opp_End_MAE_Ticks*TickSize :  MAE_Ticks*TickSize))))
						)
					{
						try
						{
							sw = File.AppendText(@FilePath);
							if(WCCIDirection[j] == 1)
								sw.Write(","+Close[0]+","+MAX(High,j)[0]+",,");
							else
								sw.Write(","+Close[0]+","+MIN(Low,j)[0]+",,");
								
							sw.Flush();
							sw.Close();
						}
						catch (Exception e)
						{
							// Outputs the error to the log
							Log("You cannot write and read from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
							throw;
						}
						EndTrade("S");
					}
					
				//Move to BE
					if(!breakeven && ((WCCIDirection[j] == 1 && Close[0]>=(entrypoint+(BE_Ticks*TickSize)))
						|| (WCCIDirection[j] == -1 && Close[0]<=(entrypoint-(BE_Ticks*TickSize))))
						)
					{
						breakeven = true;
						BETime = Time[0];
					}
					
				//Move to BE 2
					if(!breakeven2 && ((WCCIDirection[j] == 1 && Close[0]>=(entrypoint+(BE_Ticks_2*TickSize)))
						|| (WCCIDirection[j] == -1 && Close[0]<=(entrypoint-(BE_Ticks_2*TickSize))))
						)
					{
						breakeven2 = true;
						BETime2 = Time[0];
					}
				//Target hit
						if(Target > 0 && ((WCCIDirection[j] == 1 && Close[0]>=entrypoint+Target*TickSize)
							|| (WCCIDirection[j] == -1 && Close[0]<=entrypoint-Target*TickSize)))
						{	
							try
							{
								sw = File.AppendText(@FilePath);
								if(momoexit == 0)
								{
									if(WCCIDirection[j] == 1)
										sw.Write(","+MIN(Low,(j))[0]+","+MAX(High,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+",");
									else
										sw.Write(","+MAX(High,(j))[0]+","+MIN(Low,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+",");
								}
								else
								{	if(WCCIDirection[j] == 1)
										sw.Write(","+MIN(Low,(j))[0]+","+MAX(High,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+","+momoexit);
									else
										sw.Write(","+MAX(High,(j))[0]+","+MIN(Low,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+","+momoexit);
								}
								
								sw.Flush();
								sw.Close();
							}
							catch (Exception e)
							{
								// Outputs the error to the log
								Log("You cannot read and write from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
								throw;
							}
							EndTrade("T");
						}
					
				//Momo change, a CCI hook against position w/candle close against position
					if(((WCCIDirection[j] == 1 && myWoodies[Math.Min(CurrentBar,1)]<myWoodies[Math.Min(CurrentBar,2)] && Close[Math.Min(CurrentBar,1)] == Low[Math.Min(CurrentBar,1)])
						|| (WCCIDirection[j] == -1 && myWoodies[Math.Min(CurrentBar,1)]>myWoodies[Math.Min(CurrentBar,2)] && Close[Math.Min(CurrentBar,1)] == High[Math.Min(CurrentBar,1)]))
						&& !stoppedout && !momochange)
					{
						momochange	= true;
						momoexit = Close[Math.Min(CurrentBar,1)]-WCCIDirection[j]*TickSize;
					}
////////////////////////////////////////////////////////
				
				//Moved to Brekeven
							if(breakeven2)
							{
								BEStop = entrypoint+(WCCIDirection[j]*BE_Offset_Ticks_2*TickSize);//New BE stop price
							}
							else if(breakeven)
								{
									BEStop = entrypoint+(WCCIDirection[j]*BE_Offset_Ticks*TickSize);//New BE stop price
								}
							
					//Returned to BE
						if(breakeven && ((WCCIDirection[j] == 1 && Close[0]<=BEStop)
							|| (WCCIDirection[j] == -1 && Close[0]>=BEStop))
						 )
						{
							try
							{
								sw = File.AppendText(@FilePath);
								if(momoexit == 0)
								{
									if(WCCIDirection[j] == 1)
										sw.Write(","+MIN(Low,(j))[0]+","+MAX(High,j)[0]+",,");
									else
										sw.Write(","+MAX(High,(j))[0]+","+MIN(Low,j)[0]+",,");
								}
								else
								{	if(WCCIDirection[j] == 1)
										sw.Write(","+MIN(Low,(j))[0]+","+MAX(High,j)[0]+",,"+momoexit);
									else
										sw.Write(","+MAX(High,(j))[0]+","+MIN(Low,j)[0]+",,"+momoexit);
								}
								sw.Flush();
								sw.Close();
							}
							catch (Exception e)
							{
								// Outputs the error to the log
								Log("You cannot write and read from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
								throw;
							}
							if(!breakeven2)
								EndTrade("B1");
							else
								EndTrade("B");
						}
			
					//100 line cross with close against position
						if(cross_100 && !hold)
						{
							try
							{
								sw = File.AppendText(@FilePath);
								if(momoexit == 0)
								{
									if(WCCIDirection[j] == 1)
										sw.Write(","+MIN(Low,(j-1))[Math.Min(CurrentBar,1)]+","+MAX(High,j)[Math.Min(CurrentBar,1)]+","+(Close[Math.Min(CurrentBar,1)]-WCCIDirection[j]*TickSize)+",");
									else
										sw.Write(","+MAX(High,(j-1))[Math.Min(CurrentBar,1)]+","+MIN(Low,j)[Math.Min(CurrentBar,1)]+","+(Close[Math.Min(CurrentBar,1)]-WCCIDirection[j]*TickSize)+",");
								}
								else
								{	if(WCCIDirection[j] == 1)
										sw.Write(","+MIN(Low,(j-1))[Math.Min(CurrentBar,1)]+","+MAX(High,j)[Math.Min(CurrentBar,1)]+","+(Close[Math.Min(CurrentBar,1)]-WCCIDirection[j]*TickSize)+","+momoexit);
									else
										sw.Write(","+MAX(High,(j-1))[Math.Min(CurrentBar,1)]+","+MIN(Low,j)[Math.Min(CurrentBar,1)]+","+(Close[Math.Min(CurrentBar,1)]-WCCIDirection[j]*TickSize)+","+momoexit);
								}
								
								sw.Flush();
								sw.Close();
							}
							catch (Exception e)
							{
								// Outputs the error to the log
								Log("You cannot write and read from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
								throw;
							}
							EndTrade("X");
						}

						//  Closing Time
					if(ToTime(Time[0]) > ToTime(Convert.ToDateTime(ClosingTime)))//Closing Time
					{
						try
						{
							sw = File.AppendText(@FilePath);
							if(momoexit == 0)
							{
								if(WCCIDirection[j] == 1)
									sw.Write(","+MIN(Low,j)[0]+","+MAX(High,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+",");
								else
									sw.Write(","+MAX(High,j)[0]+","+MIN(Low,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+",");
							}
							else
							{	if(WCCIDirection[j] == 1)
									sw.Write(","+MIN(Low,j)[0]+","+MAX(High,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+","+momoexit);
								else
									sw.Write(","+MAX(High,j)[0]+","+MIN(Low,j)[0]+","+(Close[0]-WCCIDirection[j]*TickSize)+","+momoexit);
							}
							
							sw.Flush();
							sw.Close();
						}
						catch (Exception e)
						{
							// Outputs the error to the log
							Log("You cannot write and read from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
							throw;
						}
						EndTrade("C");
					}
			}
		#endregion
			
		#region Trade Entry
			if(FirstTickOfBar && !Bars.FirstBarOfSession)
			{
/*				for(int i = 0; i <10000; i++)
				{if(i==5000) Print(i);}
*/				int k = CurrentBar-signalbar;

			//Stop and Reverse
				if(signalbar != 0 && WCCIPattern[Math.Min(CurrentBar,1)] != 0 && WCCIDirection[Math.Min(CurrentBar,1)] != WCCIDirection[k] && StopReverse && (WCCIDirection[k]==1 ? Close[Math.Min(CurrentBar,1)]<entrypoint : Close[Math.Min(CurrentBar,1)]>entrypoint))//Exit when a new opposing pattern exists with a losing position on the old pattern
				{
					try
					{
						sw = File.AppendText(@FilePath);
						if(momoexit == 0)
						{
							if(WCCIDirection[k] == 1)
								sw.Write(","+MIN(Low,k)[0]+","+MAX(High,k)[0]+",,");
							else
								sw.Write(","+MAX(High,k)[0]+","+MIN(Low,k)[0]+",,");
						}
						else
						{	if(WCCIDirection[k] == 1)
								sw.Write(","+MIN(Low,k)[0]+","+MAX(High,k)[0]+",,"+momoexit);
							else
								sw.Write(","+MAX(High,k)[0]+","+MIN(Low,k)[0]+",,"+momoexit);
						}
						
						sw.Flush();
						sw.Close();
					}
					catch (Exception e)
					{
						// Outputs the error to the log
						Log("You cannot write and read from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
						throw;
					}
					EndTrade("R");
				}
				
				
				Pattern = string.Empty;
				//What pattern do we have
				if(WCCIPattern[Math.Min(CurrentBar,1)] == 1)
				{
					Pattern = "ZLR";
				}
				else
					if(WCCIPattern[Math.Min(CurrentBar,1)] == 2)
					{
						Pattern = "FAMIR";
					}
				else
					if(WCCIPattern[Math.Min(CurrentBar,1)] == 3)
					{
						Pattern = "VEGAS";
					}
				else
					if(WCCIPattern[Math.Min(CurrentBar,1)] == 4)
					{
						Pattern = "GB";
					}
				else
					if(WCCIPattern[Math.Min(CurrentBar,1)] == 5)
					{
						Pattern = "TT";
					}
				else
					if(WCCIPattern[Math.Min(CurrentBar,1)] == 6)
					{
						Pattern = "GHOST";
						
					}
//				Print(Instrument.FullName + ",  " +ToTime(Time[Math.Min(CurrentBar,1)])+" - "+WCCIPattern[Math.Min(CurrentBar,1)]+ " - "+Pattern+",  Dir = "+WCCIDirection[Math.Min(CurrentBar,1)]+",  BarEnd = "+WCCIBarEnd[Math.Min(CurrentBar,1)]+",  cci[Math.Min(CurrentBar,1)]: "+CCI(14)[Math.Min(CurrentBar,2)].ToString("f0")+",  cci: "+CCI(14)[Math.Min(CurrentBar,1)].ToString("f0"));
				//Write the Header Row	
				if(!File.Exists(@FilePath))
				{	
					try
					{
						sw = File.AppendText(@FilePath);
						sw.Write("Date,Time,Direction,Pattern,Signal Entry,T/B Bar,CCI,Delta CCI,MAE,MFE,100 Cross,Momo Change,Exit Mode,Exit Time,Time to BE,Time to BE2");
						sw.Close();
					}
					catch (Exception e)
					{
						// Outputs the error to the log
						Log("That file is already open for reading.", NinjaTrader.Cbi.LogLevel.Error);
						throw;
					}
				}
				
				//If a new pattern is found, print the initial pattern data
				if(Pattern != string.Empty && !signal && ToTime(Time[Math.Min(CurrentBar,1)]) < ToTime(Convert.ToDateTime(ClosingTime))
					)
				{
					signal		= true;
					signalbar	= CurrentBar-1;//A pattern has been found
					
					if (WCCIDirection[Math.Min(CurrentBar,1)] == 1)
						TDirection = "L";
					else if (WCCIDirection[Math.Min(CurrentBar,1)] == -1)
						TDirection = "S";
					
					sw 			= File.AppendText(@FilePath);
					
					if(Low[Math.Min(CurrentBar,1)] < Close[Math.Min(CurrentBar,1)])
					{	closePosition = 1;	}
					else
					{	closePosition = -1;	}
					
					if(CloseorOpen == "Close")
						entrypoint = Close[Math.Min(CurrentBar,1)];
					else
						entrypoint = Open[0];
					int conbars = MRO(delegate{return (TDirection == "L" ? Close[0] == Low[0] : Close[0]==High[0]);},2,CurrentBar) +1;//How many consecutive bars of same color
					
					try
					{
						sw.Write("\n"+Time[Math.Min(CurrentBar,1)].ToString("M-dd-yyy")+","+Time[Math.Min(CurrentBar,1)].ToString("HH:mm")+","+TDirection+","+Pattern+","/*+conbars+","*/+entrypoint+","+closePosition+","+myWoodies[Math.Min(CurrentBar,1)].ToString("f0")+","+Math.Abs((myWoodies[Math.Min(CurrentBar,1)]-myWoodies[Math.Min(CurrentBar,2)])).ToString("f0"));
						sw.Flush();
						sw.Close();
					}
					catch (Exception e)
					{
						// Outputs the error to the log
						Log("You cannot write and read from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
						throw;
					}
				}
			}
		#endregion
		}
			
		public override void Dispose() 
		{
			// Disposes resources used by the StreamWriter
			if(sw != null)
			{
				sw.Dispose();
				sw = null;
			}
			
			// Required disposal call when overriding the Dispose() method
			base.Dispose();
		}
		
		public void EndTrade(string Xit)
		{
				int m = CurrentBar-signalbar;
				TimeSpan TimeToBE = BETime - Time[m];
				TimeSpan TimeToBE2 = BETime2 - Time[m];
			try
			{
				sw = File.AppendText(@FilePath);
				sw.Write(","+Xit+"," +Time[0].ToString("HH:mm")+","+(BETime == SSTime ? "" : TimeToBE.ToString())+","+(BETime2 == SSTime ? "" : TimeToBE2.ToString()));
				sw.Flush();
				sw.Close();
			}
			catch (Exception e)
			{
				// Outputs the error to the log
				Log("You cannot write and read from the same file at the same time.", NinjaTrader.Cbi.LogLevel.Error);
				throw;
			}
			signal = false;
			TDirection = string.Empty;
			signalbar = 0;
			stoppedout	= false;
			breakeven	= false;
			breakeven2	= false;
			cross_100 = false;
			return_be = false;
			momochange = false;
			momoexit = 0;
			BETime = SSTime;
			BETime2 = SSTime;
		}

		#region Properties
			#region PARAMETERS		
			[XmlIgnore()]
			[Description("CCI must go below this value before a ZLR or Vegas can be signaled")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("CCI Trend Level")]
			public double RejectLevel
			{
				get { return rejectLevel; }
				set { rejectLevel = Math.Max(0, Math.Min(100, value)); }
			}
			
			[Description("Number of bars for a trend to be in place for GB100 trades to trigger")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Trend Length for GB100")]
			public int TrendLength
			{
				get { return trendLength; }
				set { trendLength = value; }
			}
			
			[Description("CCI Periods")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("CCI Periods")]
			public int Periods
			{
				get { return periods; }
				set { periods = Math.Max(2,value); }
			}
			
			[Description("Minimum CCI point change between ghost peaks and valleys")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Ghost, Use Points/Percent Amount")]
			public double UsePointsAmount
			{
				get { return usePointsAmount; }
				set { usePointsAmount = Math.Max(0, Math.Max(1, value)); }
			}
			
			[Description("Type of ZigZag deviation (Points or Percent)")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Ghost, Use Points or Percent")]
			public string UsePoints
			{
				get { return usePoints; }
				set { if((value == "Points") || (value == "Percent"))
						{ usePoints = value;  }
					}
			}

			[Description("CCI must close above this value before before it is considered to have 'gone to extremes'.  This will also be the level at which a sideways market is reset.")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Extremes CCI Level")]
			public double Extremes
			{
				get { return extremes; }
				set { extremes = Math.Max(150, Math.Min(350, value)); }
			}

			[Description("Famir minimum CCI hook points (default = 3)")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Famir, CCI Points for Hook")]
			public double FamirHookMin
			{
				get { return famirHookMin; }
				set { famirHookMin = Math.Max(0, Math.Min(10, value)); }
			}

			[Description("Famir CCI boundaries (default = 50)")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Famir, Max CCI Level")]
			public double FamirLimits
			{
				get { return famirLimits; }
				set { famirLimits = Math.Max(0, Math.Min(100, value)); }
			}

			[Description("Level that the CCI must penetrate through to reach the swing high/low.")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Vegas, Penetration level before swing high/low")]
			public double VTHFEPenetrationLevel
			{
				get { return vTHFEPenetrationLevel; }
				set { vTHFEPenetrationLevel = Math.Max(0, Math.Min(200, value)); }
			}
			
			[Description("Max high or low for swing back to trend after swing high/low (default = 100).  NOT SWING HIGH/LOW.")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Vegas, Max Swing after swing high/low")]
			public double VMaxSwingPoint
			{
				get { return vMaxSwingPoint; }
				set { vMaxSwingPoint = Math.Max(0, Math.Min(200, value)); }
			}
			
			[Description("Max # of bars between swing high/low and trigger (default = 10).")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Vegas, Max Swing bars")]
			public int VMaxSwingBars
			{
				get { return vMaxSwingBars; }
				set { vMaxSwingBars = Math.Max(0, Math.Min(200, value)); }
			}
			
			[XmlIgnore()]
			[Description("The number of CCI points that must be between trend break line and a ghost right peak")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Ghost trendline/peak gap")]
			public double GstColor
			{
				get { return gstColor; }
				set { gstColor = Math.Max(0, Math.Min(10, value)); }
			}
			
			[Description("Minimum CCI point change before a ZLR can be signaled")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("ZLR, Minimum Point Change")]
			public double MinZLRPts
			{
				get { return minZLRPts; }
				set { minZLRPts = Math.Max(0, Math.Min(75, value)); }
			}

			[Description("Minimum CCI point change for a Famir, Vegas, GB100 or Tony to trigger.")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Minimum CCI Point Change")]
			public double MinCCIPts
			{
				get { return minCCIPts; }
				set { minCCIPts = Math.Max(0, Math.Min(100, value)); }
			}

			[Description("Maximum CCI value for a Pattern to be signaled")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Maximum Signal Level")]
			public double MaxSignalValue
			{
				get { return maxSignalValue; }
				set { maxSignalValue = Math.Max(75, Math.Min(200, value)); }
			}

			[Description("Minimum CCI value for a ZLR to be signaled")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("ZLR, Minimum Level")]
			public double MinZLRValue
			{
				get { return minZLRValue; }
				set { minZLRValue = Math.Max(0, Math.Min(100, value)); }
			}

			[Description("Numbers of 0 line crosses needed to declare a sideways market")]
			[Category("Parameters")]
			[Gui.Design.DisplayName("Sideways mkt crosses")]
			public int ChopCrosses
			{
				get { return chopCrosses; }
				set { chopCrosses = Math.Max(1, value); }
			}
			#endregion	

			#region FORECASTERS
			[Description("Show CCI Forecaster on chart as ARROWS?  This will take precedence over the dots.")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("CCI Forecaster, Show as Arrows?")]
			public bool CCIShowForecasterArrows
			{
				get { return cCIShowForecasterArrows; }
				set { cCIShowForecasterArrows = value; }
			}
			
			[Description("Show CCI Forecaster on chart as DOTS?  Turn arrows off to see the dots.")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("CCI Forecaster, Show as Dots?")]
			public bool CCIShowForecasterDots
			{
				get { return cCIShowForecasterDots; }
				set { cCIShowForecasterDots = value; }
			}
			
			[Description("Show CCI Forecaster historical dots on chart?")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("CCI Forecaster, Show History?")]
			public bool CCIShowForecasterHistory
			{
			get { return cCIShowForecasterHistory; }
			set { cCIShowForecasterHistory = value; }
			}
			
			[XmlIgnore()]
			[Description("High CCI Forecaster Color")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("CCI Forecaster, High Color")]
			public Color CCIForecasterColorH
			{
				get { return cCIForecasterColorH; }
				set { cCIForecasterColorH = value; }
			}

			[Browsable(false)]
			public string CCIForecasterColorHSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(cCIForecasterColorH); }
				set { cCIForecasterColorH = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Low CCI Forecaster Color")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("CCI Forecaster, Low Color")]
			public Color CCIForecasterColorL
			{
				get { return cCIForecasterColorL; }
				set { cCIForecasterColorL = value; }
			}

			[Browsable(false)]
			public string CCIForecasterColorLSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(cCIForecasterColorL); }
				set { cCIForecasterColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[Description("Numbers of bars used for LSMA calculations")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("LSMA Forecaster Periods")]
			public int LSMAPeriods
			{
				get { return lSMAPeriods; }
				set { lSMAPeriods = Math.Max(1, value); }
			}

			[Description("LSMA Forecaster Line Thickness")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("LSMA Forecaster Line Thickness")]
			public int LSMALineThick
			{
				get { return lSMALineThick; }
				set { lSMALineThick = Math.Max(1, Math.Min(6,value)); }
			}

			[XmlIgnore()]
			[Description("High LSMA Forecaster Color")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("LSMA Forecaster, High Color")]
			public Color LSMAForecasterColorH
			{
				get { return lSMAForecasterColorH; }
				set { lSMAForecasterColorH = value; }
			}

			[Browsable(false)]
			public string LSMAForecasterColorHSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(lSMAForecasterColorH); }
				set { lSMAForecasterColorH = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Low LSMA Forecaster Color")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("LSMA Forecaster, Low Color")]
			public Color LSMAForecasterColorL
			{
				get { return lSMAForecasterColorL; }
				set { lSMAForecasterColorL = value; }
			}

			[Browsable(false)]
			public string LSMAForecasterColorLSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(lSMAForecasterColorL); }
				set { lSMAForecasterColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[Description("Display the LSMA Forecaster?")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("LSMA Forecaster, Show Forecaster?")]
			public bool ShowLSMA_Fore
			{
				get { return showLSMA_Fore; }
				set { showLSMA_Fore = value; }
			}
			
			[Description("CZI Forecaster Line Thickness")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("Chop Zone Forecaster Line Thickness")]
			public int CZILineThick
			{
				get { return cZILineThick; }
				set { cZILineThick = Math.Max(1, Math.Min(6,value)); }
			}

			[Description("Display the CZI Forecaster?")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("Chop Zone Forecaster, Show Forecaster?")]
			public bool ShowCZI_Fore
			{
				get { return showCZI_Fore; }
				set { showCZI_Fore = value; }
			}
			
			[Description("Display Sidewinder Forecaster?")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("SW Forecaster, show?")]
			public bool ShowSWForecaster
			{
				get { return showSWForecaster; }
				set { showSWForecaster = value; }
			}

			[Description("Use Sidewinder Forecaster in ZLRs?")]
			[Category("Forecasters")]
			[Gui.Design.DisplayName("SW Forecaster, use?")]
			public bool UseSWForecaster
			{
				get { return useSWForecaster; }
				set { useSWForecaster = value; }
			}
			#endregion
			
			#region SOUND AND DISPLAY
			[Description("How often do you want the alert to sound?")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Alert Interval (sec.)")]
			public int AlertInterval
			{
				get { return alertInterval; }
				set { alertInterval = value; }
			}

			[Description("Where is the alert sound file located?  File name of .wav file to play. Provide either the absolute file path to any .wav file or just the name if the file is located in NinjaTrader Installation Folder sounds folder.  Create your own alert sounds, a different one for each contract traded, if you like.")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Alert .wav File")]
			public string AlertFile
			{
				get { return alertFile; }
				set { alertFile = value; }
			}

			[Description("Sound an alert when a CCI Pattern is signaled")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Alert Active?")]
			public bool SoundAlert
			{
				get { return soundAlert; }
				set { soundAlert = value; }
			}
			
			[Description("Sound an alert when a Momentum Reversal is signaled")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Momo Change Alert Active?")]
			public bool SoundMomoAlert
			{
				get { return soundMomoAlert; }
				set { soundMomoAlert = value; }
			}
			
			[Description("Display the +/- Famir Limit lines?")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Draw Famir Limits")]
			public bool ShowFamirLimits
			{
				get { return showFamirLimits; }
				set { showFamirLimits = value; }
			}

			[Description("Display the +/- 120 lines?")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Draw Max Signal Value")]
			public bool ShowOneTwenty
			{
				get { return showOneTwenty; }
				set { showOneTwenty = value; }
			}
			
			[Description("Display the +/- 120 lines?")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Ghost, Show Peaks?")]
			public bool ShowGhostPeaks
			{
				get { return showGhostPeaks; }
				set { showGhostPeaks = value; }
			}				
			
			[Description("Display the Momentum Change Exit Points?")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Momo Change, Show?")]
			public bool ShowMomoChange
			{
				get { return showMomoChange; }
				set { showMomoChange = value; }
			}				
			
			[Description("Numbers of bars back to extend 120 and Famir limits lines")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Draw Line Length")]
			public int LineExtension
			{
				get { return lineExtension; }
				set { lineExtension = Math.Max(1, value); }
			}
			
			[Description("Show the patterns during a sideways market?")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Sideways mkt, show patterns?")]
			public bool ShowChopCrosses
			{
				get { return showChopCrosses; }
				set { showChopCrosses = value; }
			}
			
			[Description("Use Javier's alternate sideways market indicator?")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Sideways mkt, Use Javier's alternate?")]
			public bool UseJavierSideways
			{
				get { return useJavierSideways; }
				set { useJavierSideways = value; }
			}
			
			[XmlIgnore()]
			[Description("Color for Sideway Alert Rectangle")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Sideways Color")]
			public Color SidewaysColor
			{
				get { return sidewaysColor; }
				set { sidewaysColor = value; }
			}
			
			[Browsable(false)]
			public string SidewaysColorSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(sidewaysColor); }
				set { sidewaysColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Sideways Market Rectangle Trabsparency")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Sideways Color Transparency")]
			public int SidewaysTransparency
			{
				get { return sidewaysTransparency; }
				set { sidewaysTransparency = Math.Max(0, Math.Min(10, value)); }
			}

			[XmlIgnore()]
			[Description("Color for Famir Limits")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Draw Famir Limits Color")]
			public Color FamirLimitsColor
			{
				get { return famirLimitsColor; }
				set { famirLimitsColor = value; }
			}
			
			[Browsable(false)]
			public string FamirLimitsColorSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(famirLimitsColor); }
				set { famirLimitsColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Color for 120 lines")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Draw Max Signal Value Color")]
			public Color OneTwentyColor
			{
				get { return oneTwentyColor; }
				set { oneTwentyColor = value; }
			}
			
			[Browsable(false)]
			public string OneTwentyColorSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(oneTwentyColor); }
				set { oneTwentyColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			
			[XmlIgnore()]
			[Description("Color for ghost trend lines")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Ghost Trend Color")]
			public Color GstTrendColor
			{
				get { return gstTrendColor; }
				set { gstTrendColor = value; }
			}
			
			[XmlIgnore()]
			[Description("Color for Vegas trend lines")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Vegas Trend Color")]
			public Color VegasTrendColor
			{
				get { return vegasTrendColor; }
				set { vegasTrendColor = value; }
			}
			
			[Browsable(false)]
			public string GstTrendColorSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(gstTrendColor); }
				set { gstTrendColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			
			[Description("Anchor point for Long trade text.")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Text Anchor, Long")]
			public int TextAnchorL
			{
				get { return textAnchorL; }
				set { textAnchorL  = Math.Max(-400, Math.Min(400, value)); }
			}

			[Description("Anchor point for Short trade text.")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Text Anchor, Short")]
			public int TextAnchorS
			{
				get { return textAnchorS; }
				set { textAnchorS  = Math.Max(-400, Math.Min(400, value)); }
			}

			[Browsable(false)]
			public string SignalLabelsFontSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableFont.ToString(signalLabels); }
			set { signalLabels = NinjaTrader.Gui.Design.SerializableFont.FromString(value); }
			}
			
			[XmlIgnore()]
			[Description("Signal Font to use")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Signal Font")]
			public Font SignalLabels
			{
				get { return signalLabels; }
				set { signalLabels = value; }
			}
			
			[Description("Boundary limits between which sideways market crosses must remain.")]
			[Category("Sound and Display")]
			[Gui.Design.DisplayName("Sideways Market Boundary")]
			public int Sidewaysboundary
			{
				get { return sidewaysboundary; }
				set { sidewaysboundary  = Math.Max(1, value); }
			}

			#endregion
			
			#region DATA SERIES
			[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
			[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
			public DataSeries PlotCCIHigh
			{
				get { return Values[0]; }
			}

			[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
			[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
			public DataSeries PlotCCILow
			{
				get { return Values[Math.Min(CurrentBar,1)]; }
			}
			
			[Browsable(false)]
			[XmlIgnore()]
			[Description("Woodies Pattern, ZLR, FAM, VT, GB, TT, GST")]
			public IntSeries WCCIPattern
			{
				get { Update();
				return wCCIPatternSeries; }
			}

			[Browsable(false)]
			[XmlIgnore()]
			[Description("Direction of the trade (1 = Long, -1 = Short")]
			public IntSeries WCCIDirection
			{
				get { Update();
				return wCCIDirectionSeries; }
			}

			[Browsable(false)]
			[XmlIgnore()]
			[Description("Location of close, Top (1) or Bottom (0) of bar")]
			public IntSeries WCCICloseAt
			{
				get { Update();
				return wCCICloseAtSeries; }
			}

			[Browsable(false)]
			[XmlIgnore()]
			[Description("Location of signal trigger, Top (1), Bottom (-1), Either (0) end of bar")]
			public IntSeries WCCIBarEnd
			{
				get { Update();
				return wCCIBarEndSeries; }
			}

			[Browsable(false)]
			[XmlIgnore()]
			[Description("Sideways Market, 1=Yes, 0=No")]
			public BoolSeries SidewaysMkt
			{
				get { Update();
				return sidewaysMktSeries; }
			}
			#endregion
			
			#region PATTERNS TO DISPLAY
			[Description("Display ZLR Patterns?")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("ZLR")]
			public bool Show_ZLR
			{
				get { return show_ZLR; }
				set { show_ZLR = value; }
			}

			[Description("ZLR Line Thickness. Set to 0 if no line.")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("ZLR Line Thickness")]
			public int ZLRLineThick
			{
				get { return zLRLineThick; }
				set { zLRLineThick = Math.Max(0, Math.Min(6,value)); }
			}

			[XmlIgnore()]
			[Description("ZLR Long Text Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("ZLR, Long Text Color")]
			public Color ZLRColorL
			{
				get { return zLRColorL; }
				set { zLRColorL = value; }
			}

			[Browsable(false)]
			public string ZLRColorLSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zLRColorL); }
			set { zLRColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			
			[XmlIgnore()]
			[Description("ZLR Short Text Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("ZLR, Short Text Color")]
			public Color ZLRColorS
			{
				get { return zLRColorS; }
				set { zLRColorS = value; }
			}

			[Browsable(false)]
			public string ZLRColorSSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zLRColorS); }
			set { zLRColorS = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			
			[XmlIgnore()]
			[Description("ZLR Long Line Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("ZLR, Long Line Color")]
			public Color ZLRLineColorL
			{
				get { return zLRLineColorL; }
				set { zLRLineColorL = value; }
			}

			[Browsable(false)]
			public string ZLRLineColorLSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zLRLineColorL); }
			set { zLRLineColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			
			[XmlIgnore()]
			[Description("ZLR Short Line Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("ZLR, Short Line Color")]
			public Color ZLRLineColorS
			{
				get { return zLRLineColorS; }
				set { zLRLineColorS = value; }
			}

			[Browsable(false)]
			public string ZLRLineColorSSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zLRLineColorS); }
			set { zLRLineColorS = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			
			[Description("Display Famir Patterns?")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Famir")]
			public bool Show_Famir
			{
				get { return show_Famir; }
				set { show_Famir = value; }
			}

			[XmlIgnore()]
			[Description("Famir Long Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Famir, Long Color")]
			public Color FamirColorL
			{
				get { return famirColorL; }
				set { famirColorL = value; }
			}

			[Browsable(false)]
			public string FamirColorLSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(famirColorL); }
			set { famirColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Famir Short Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Famir, Short Color")]
			public Color FamirColorS
			{
				get { return famirColorS; }
				set { famirColorS = value; }
			}

			[Browsable(false)]
			public string FamirColorSSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(famirColorS); }
			set { famirColorS = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[Description("Display Vegas Patterns?")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Vegas")]
			public bool Show_Vegas
			{
				get { return show_Vegas; }
				set { show_Vegas = value; }
			}

			[XmlIgnore()]
			[Description("Vegas Long Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Vegas, Long Color")]
			public Color VegasColorL
			{
				get { return vegasColorL; }
				set { vegasColorL = value; }
			}

			[Browsable(false)]
			public string VegasColorLSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(vegasColorL); }
			set { vegasColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Vegas Short Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Vegas, Short Color")]
			public Color VegasColorS
			{
				get { return vegasColorS; }
				set { vegasColorS = value; }
			}

			[Browsable(false)]
			public string VegasColorSSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(vegasColorS); }
			set { vegasColorS = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[Description("Display GB100 Patterns?")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("GB 100")]
			public bool Show_GB100
			{
				get { return show_GB100; }
				set { show_GB100 = value; }
			}

			[Description("GB 100 Line Thickness. Set to 0 if no line.")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("GB 100 Line Thickness")]
			public int GBLineThick
			{
				get { return gBLineThick; }
				set { gBLineThick = Math.Max(0, Math.Min(6,value)); }
			}

			[XmlIgnore()]
			[Description("GB 100 Long Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("GB 100, Long Color")]
			public Color GBColorL
			{
				get { return gBColorL; }
				set { gBColorL = value; }
			}

			[Browsable(false)]
			public string GBColorLSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(gBColorL); }
			set { gBColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("GB 100 Short Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("GB 100, Short Color")]
			public Color GBColorS
			{
				get { return gBColorS; }
				set { gBColorS = value; }
			}

			[Browsable(false)]
			public string GBColorSSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(gBColorS); }
			set { gBColorS = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[Description("Display Tony Patterns?")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Tony")]
			public bool Show_Tony
			{
				get { return show_Tony; }
				set { show_Tony = value; }
			}

			[XmlIgnore()]
			[Description("Tony Long Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Tony, Long Color")]
			public Color TonyColorL
			{
				get { return tonyColorL; }
				set { tonyColorL = value; }
			}

			[Browsable(false)]
			public string TonyColorLSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(tonyColorL); }
			set { tonyColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Tony Short Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Tony, Short Color")]
			public Color TonyColorS
			{
				get { return tonyColorS; }
				set { tonyColorS = value; }
			}

			[Browsable(false)]
			public string TonyColorSSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(tonyColorS); }
			set { tonyColorS = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[Description("Display Ghost Patterns?")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Ghost")]
			public bool Show_Ghost
			{
				get { return show_Ghost; }
				set { show_Ghost = value; }
			}
			[XmlIgnore()]
			[Description("Ghost Long Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Ghost, Long Color")]
			public Color GhostColorL
			{
				get { return ghostColorL; }
				set { ghostColorL = value; }
			}

			[Browsable(false)]
			public string GhostColorLSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(ghostColorL); }
			set { ghostColorL = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}

			[XmlIgnore()]
			[Description("Ghost Short Color")]
			[Category("Patterns to Display")]
			[Gui.Design.DisplayName("Ghost, Short Color")]
			public Color GhostColorS
			{
				get { return ghostColorS; }
				set { ghostColorS = value; }
			}
			
			[Browsable(false)]
			public string GhostColorSSerialize
			{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(ghostColorS); }
			set { ghostColorS = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}
			#endregion

			#region DATA EXTRACTION
			[Description("Use the data extraction utility?  This utility extracts performance data of all signals based on the following parameters.")]
			[Category("Data Extraction")]
			[Gui.Design.DisplayName("\tUse Data Extraction?")]
			public bool UseDataExtraction
			{
			get { return useDataExtraction; }
			set { useDataExtraction = value; }
			}

			[Description("Time for trading to end and close all positions.")]
			[Gui.Design.DisplayName("Session End Time")]
			[Category("Data Extraction")]
			public string ClosingTime
			{
				get { return closingTime; }
				set { closingTime =  value; }
			} 
			
			[Description("Number of ticks of MAE to trigger a crash stop")]
			[Category("Data Extraction")]
			public int MAE_Ticks
			{
				get { return mAE_Ticks; }
				set { mAE_Ticks = Math.Max(0, Math.Min(30, value)); }
			}

			[Description("Number of ticks to FINAL TARGET. Leave at 0 not to use a target.")]
			[Gui.Design.DisplayName("Ticks to Target")]
			[Category("Data Extraction")]
			public int Target
			{
				get { return target; }
				set { target = Math.Max(0, Math.Min(30, value)); }
			}

			[Description("Number of ticks of MAE to trigger a crash stop on opposite end triggered trades")]
			[Category("Data Extraction")]
			public int Opp_End_MAE_Ticks
			{
				get { return opp_End_MAE_Ticks; }
				set { opp_End_MAE_Ticks = Math.Max(0, Math.Min(30, value)); }
			}

		   [Description("Number of ticks of MFE to trigger a move to break even")]
			[Category("Data Extraction")]
			public int BE_Ticks
			{
				get { return bE_Ticks; }
				set { bE_Ticks = Math.Max(0, Math.Min(30, value)); }
			}

		   [Description("Number of ticks above (+) or below (-) the entry price to set the break even stop")]
			[Category("Data Extraction")]
			public int BE_Offset_Ticks
			{
				get { return bE_Offset_Ticks; }
				set { bE_Offset_Ticks = Math.Max(-10, Math.Min(100, value)); }
			}

			[Description("Number of ticks of MFE to trigger 2nd move to break even")]
			[Category("Data Extraction")]
			public int BE_Ticks_2
			{
				get { return bE_Ticks_2; }
				set { bE_Ticks_2 = Math.Max(0, Math.Min(80, value)); }
			}

		   [Description("Number of ticks above (+) or below (-) the entry price to set the break even stop")]
			[Category("Data Extraction")]
			public int BE_Offset_Ticks_2
			{
				get { return bE_Offset_Ticks_2; }
				set { bE_Offset_Ticks_2 = Math.Max(-10, Math.Min(100, value)); }
			}

			[Description("Do you want to log the signal bar Close or the next bar Open? (enter Close or Open)")]
			[Category("Data Extraction")]
			public string CloseorOpen
			{
				get { return closeorOpen; }
				set { if((value == "Close") || (value == "Open"))
						{ closeorOpen = value;  }
					}
			}
			
			[Description("Exit a losing trade and enter one in the opposite direction?.")]
			[Category("Data Extraction")]
			public bool StopReverse
			{
				get { return stopReverse; }
				set { stopReverse = value; }
			}

			[Description("Path to Data Export File.")]
			[Category("Data Extraction")]
			public string FilePath
			{
				get { return filePath; }
				set { filePath = value; }
			}
			#endregion
	#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private CCI_Forecaster_DE[] cacheCCI_Forecaster_DE = null;

        private static CCI_Forecaster_DE checkCCI_Forecaster_DE = new CCI_Forecaster_DE();

        /// <summary>
        /// CCI Patterns Forecaster with Data Extraction 1.0
        /// </summary>
        /// <returns></returns>
        public CCI_Forecaster_DE CCI_Forecaster_DE(int chopCrosses, double extremes, double famirHookMin, double famirLimits, double gstColor, double maxSignalValue, double minCCIPts, double minZLRPts, double minZLRValue, int periods, double rejectLevel, int trendLength, string usePoints, double usePointsAmount, int vMaxSwingBars, double vMaxSwingPoint, double vTHFEPenetrationLevel)
        {
            return CCI_Forecaster_DE(Input, chopCrosses, extremes, famirHookMin, famirLimits, gstColor, maxSignalValue, minCCIPts, minZLRPts, minZLRValue, periods, rejectLevel, trendLength, usePoints, usePointsAmount, vMaxSwingBars, vMaxSwingPoint, vTHFEPenetrationLevel);
        }

        /// <summary>
        /// CCI Patterns Forecaster with Data Extraction 1.0
        /// </summary>
        /// <returns></returns>
        public CCI_Forecaster_DE CCI_Forecaster_DE(Data.IDataSeries input, int chopCrosses, double extremes, double famirHookMin, double famirLimits, double gstColor, double maxSignalValue, double minCCIPts, double minZLRPts, double minZLRValue, int periods, double rejectLevel, int trendLength, string usePoints, double usePointsAmount, int vMaxSwingBars, double vMaxSwingPoint, double vTHFEPenetrationLevel)
        {
            if (cacheCCI_Forecaster_DE != null)
                for (int idx = 0; idx < cacheCCI_Forecaster_DE.Length; idx++)
                    if (cacheCCI_Forecaster_DE[idx].ChopCrosses == chopCrosses && Math.Abs(cacheCCI_Forecaster_DE[idx].Extremes - extremes) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].FamirHookMin - famirHookMin) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].FamirLimits - famirLimits) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].GstColor - gstColor) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MaxSignalValue - maxSignalValue) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MinCCIPts - minCCIPts) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MinZLRPts - minZLRPts) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MinZLRValue - minZLRValue) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].Periods == periods && Math.Abs(cacheCCI_Forecaster_DE[idx].RejectLevel - rejectLevel) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].TrendLength == trendLength && cacheCCI_Forecaster_DE[idx].UsePoints == usePoints && Math.Abs(cacheCCI_Forecaster_DE[idx].UsePointsAmount - usePointsAmount) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].VMaxSwingBars == vMaxSwingBars && Math.Abs(cacheCCI_Forecaster_DE[idx].VMaxSwingPoint - vMaxSwingPoint) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].VTHFEPenetrationLevel - vTHFEPenetrationLevel) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].EqualsInput(input))
                        return cacheCCI_Forecaster_DE[idx];

            lock (checkCCI_Forecaster_DE)
            {
                checkCCI_Forecaster_DE.ChopCrosses = chopCrosses;
                chopCrosses = checkCCI_Forecaster_DE.ChopCrosses;
                checkCCI_Forecaster_DE.Extremes = extremes;
                extremes = checkCCI_Forecaster_DE.Extremes;
                checkCCI_Forecaster_DE.FamirHookMin = famirHookMin;
                famirHookMin = checkCCI_Forecaster_DE.FamirHookMin;
                checkCCI_Forecaster_DE.FamirLimits = famirLimits;
                famirLimits = checkCCI_Forecaster_DE.FamirLimits;
                checkCCI_Forecaster_DE.GstColor = gstColor;
                gstColor = checkCCI_Forecaster_DE.GstColor;
                checkCCI_Forecaster_DE.MaxSignalValue = maxSignalValue;
                maxSignalValue = checkCCI_Forecaster_DE.MaxSignalValue;
                checkCCI_Forecaster_DE.MinCCIPts = minCCIPts;
                minCCIPts = checkCCI_Forecaster_DE.MinCCIPts;
                checkCCI_Forecaster_DE.MinZLRPts = minZLRPts;
                minZLRPts = checkCCI_Forecaster_DE.MinZLRPts;
                checkCCI_Forecaster_DE.MinZLRValue = minZLRValue;
                minZLRValue = checkCCI_Forecaster_DE.MinZLRValue;
                checkCCI_Forecaster_DE.Periods = periods;
                periods = checkCCI_Forecaster_DE.Periods;
                checkCCI_Forecaster_DE.RejectLevel = rejectLevel;
                rejectLevel = checkCCI_Forecaster_DE.RejectLevel;
                checkCCI_Forecaster_DE.TrendLength = trendLength;
                trendLength = checkCCI_Forecaster_DE.TrendLength;
                checkCCI_Forecaster_DE.UsePoints = usePoints;
                usePoints = checkCCI_Forecaster_DE.UsePoints;
                checkCCI_Forecaster_DE.UsePointsAmount = usePointsAmount;
                usePointsAmount = checkCCI_Forecaster_DE.UsePointsAmount;
                checkCCI_Forecaster_DE.VMaxSwingBars = vMaxSwingBars;
                vMaxSwingBars = checkCCI_Forecaster_DE.VMaxSwingBars;
                checkCCI_Forecaster_DE.VMaxSwingPoint = vMaxSwingPoint;
                vMaxSwingPoint = checkCCI_Forecaster_DE.VMaxSwingPoint;
                checkCCI_Forecaster_DE.VTHFEPenetrationLevel = vTHFEPenetrationLevel;
                vTHFEPenetrationLevel = checkCCI_Forecaster_DE.VTHFEPenetrationLevel;

                if (cacheCCI_Forecaster_DE != null)
                    for (int idx = 0; idx < cacheCCI_Forecaster_DE.Length; idx++)
                        if (cacheCCI_Forecaster_DE[idx].ChopCrosses == chopCrosses && Math.Abs(cacheCCI_Forecaster_DE[idx].Extremes - extremes) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].FamirHookMin - famirHookMin) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].FamirLimits - famirLimits) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].GstColor - gstColor) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MaxSignalValue - maxSignalValue) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MinCCIPts - minCCIPts) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MinZLRPts - minZLRPts) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].MinZLRValue - minZLRValue) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].Periods == periods && Math.Abs(cacheCCI_Forecaster_DE[idx].RejectLevel - rejectLevel) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].TrendLength == trendLength && cacheCCI_Forecaster_DE[idx].UsePoints == usePoints && Math.Abs(cacheCCI_Forecaster_DE[idx].UsePointsAmount - usePointsAmount) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].VMaxSwingBars == vMaxSwingBars && Math.Abs(cacheCCI_Forecaster_DE[idx].VMaxSwingPoint - vMaxSwingPoint) <= double.Epsilon && Math.Abs(cacheCCI_Forecaster_DE[idx].VTHFEPenetrationLevel - vTHFEPenetrationLevel) <= double.Epsilon && cacheCCI_Forecaster_DE[idx].EqualsInput(input))
                            return cacheCCI_Forecaster_DE[idx];

                CCI_Forecaster_DE indicator = new CCI_Forecaster_DE();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ChopCrosses = chopCrosses;
                indicator.Extremes = extremes;
                indicator.FamirHookMin = famirHookMin;
                indicator.FamirLimits = famirLimits;
                indicator.GstColor = gstColor;
                indicator.MaxSignalValue = maxSignalValue;
                indicator.MinCCIPts = minCCIPts;
                indicator.MinZLRPts = minZLRPts;
                indicator.MinZLRValue = minZLRValue;
                indicator.Periods = periods;
                indicator.RejectLevel = rejectLevel;
                indicator.TrendLength = trendLength;
                indicator.UsePoints = usePoints;
                indicator.UsePointsAmount = usePointsAmount;
                indicator.VMaxSwingBars = vMaxSwingBars;
                indicator.VMaxSwingPoint = vMaxSwingPoint;
                indicator.VTHFEPenetrationLevel = vTHFEPenetrationLevel;
                Indicators.Add(indicator);
                indicator.SetUp();

                CCI_Forecaster_DE[] tmp = new CCI_Forecaster_DE[cacheCCI_Forecaster_DE == null ? 1 : cacheCCI_Forecaster_DE.Length + 1];
                if (cacheCCI_Forecaster_DE != null)
                    cacheCCI_Forecaster_DE.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheCCI_Forecaster_DE = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// CCI Patterns Forecaster with Data Extraction 1.0
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CCI_Forecaster_DE CCI_Forecaster_DE(int chopCrosses, double extremes, double famirHookMin, double famirLimits, double gstColor, double maxSignalValue, double minCCIPts, double minZLRPts, double minZLRValue, int periods, double rejectLevel, int trendLength, string usePoints, double usePointsAmount, int vMaxSwingBars, double vMaxSwingPoint, double vTHFEPenetrationLevel)
        {
            return _indicator.CCI_Forecaster_DE(Input, chopCrosses, extremes, famirHookMin, famirLimits, gstColor, maxSignalValue, minCCIPts, minZLRPts, minZLRValue, periods, rejectLevel, trendLength, usePoints, usePointsAmount, vMaxSwingBars, vMaxSwingPoint, vTHFEPenetrationLevel);
        }

        /// <summary>
        /// CCI Patterns Forecaster with Data Extraction 1.0
        /// </summary>
        /// <returns></returns>
        public Indicator.CCI_Forecaster_DE CCI_Forecaster_DE(Data.IDataSeries input, int chopCrosses, double extremes, double famirHookMin, double famirLimits, double gstColor, double maxSignalValue, double minCCIPts, double minZLRPts, double minZLRValue, int periods, double rejectLevel, int trendLength, string usePoints, double usePointsAmount, int vMaxSwingBars, double vMaxSwingPoint, double vTHFEPenetrationLevel)
        {
            return _indicator.CCI_Forecaster_DE(input, chopCrosses, extremes, famirHookMin, famirLimits, gstColor, maxSignalValue, minCCIPts, minZLRPts, minZLRValue, periods, rejectLevel, trendLength, usePoints, usePointsAmount, vMaxSwingBars, vMaxSwingPoint, vTHFEPenetrationLevel);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// CCI Patterns Forecaster with Data Extraction 1.0
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.CCI_Forecaster_DE CCI_Forecaster_DE(int chopCrosses, double extremes, double famirHookMin, double famirLimits, double gstColor, double maxSignalValue, double minCCIPts, double minZLRPts, double minZLRValue, int periods, double rejectLevel, int trendLength, string usePoints, double usePointsAmount, int vMaxSwingBars, double vMaxSwingPoint, double vTHFEPenetrationLevel)
        {
            return _indicator.CCI_Forecaster_DE(Input, chopCrosses, extremes, famirHookMin, famirLimits, gstColor, maxSignalValue, minCCIPts, minZLRPts, minZLRValue, periods, rejectLevel, trendLength, usePoints, usePointsAmount, vMaxSwingBars, vMaxSwingPoint, vTHFEPenetrationLevel);
        }

        /// <summary>
        /// CCI Patterns Forecaster with Data Extraction 1.0
        /// </summary>
        /// <returns></returns>
        public Indicator.CCI_Forecaster_DE CCI_Forecaster_DE(Data.IDataSeries input, int chopCrosses, double extremes, double famirHookMin, double famirLimits, double gstColor, double maxSignalValue, double minCCIPts, double minZLRPts, double minZLRValue, int periods, double rejectLevel, int trendLength, string usePoints, double usePointsAmount, int vMaxSwingBars, double vMaxSwingPoint, double vTHFEPenetrationLevel)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.CCI_Forecaster_DE(input, chopCrosses, extremes, famirHookMin, famirLimits, gstColor, maxSignalValue, minCCIPts, minZLRPts, minZLRValue, periods, rejectLevel, trendLength, usePoints, usePointsAmount, vMaxSwingBars, vMaxSwingPoint, vTHFEPenetrationLevel);
        }
    }
}
#endregion
