#region Using declarations
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
#endregion


namespace NinjaTrader.Indicator
{
    [Description("MTFMAIndicator")]
    public class MTFMAIndicator : Indicator
    {
        #region Variables
		//Text
		
		private bool	textOnLeft = true;
		private bool	textOnTop = true;
		private 		TextPosition bPosition = TextPosition.BottomLeft;
		private 		TextPosition tPosition = TextPosition.TopLeft;
		private 		Font textFontMed = new Font("Arial", 14, FontStyle.Bold);
		#endregion

       	protected override void Initialize()
        {
			
			CalculateOnBarClose = false;
            Overlay = true;
            PriceTypeSupported	= false;
			PaintPriceMarkers = false;
			DisplayInDataBox = false;
			Add(PeriodType.Range,3);
			Add(PeriodType.Range, 5);
			
			// Note: Bars are added to the BarsArray and can be accessed via an index value
			// E.G. BarsArray[1] ---> Accesses the 3-Range Bars object added above
		}

		protected override void OnBarUpdate()
        {
			if (CurrentBars[0]<BarsRequired ||CurrentBars[1]<BarsRequired ||CurrentBars[2]<BarsRequired)//Make sure we have enough bars
				return;
				
			// Checks MA conditions on 5R (higher time frame) and Draw Visual Label on 3R (lower time frame)
			if (SMA(BarsArray[2], 7)[0] - SMA(BarsArray[2], 3)[0] <=2*TickSize//Maximum 2 pips between MAs
				&& Highs[2][0] > SMA(BarsArray[2], 7)[0]//Price breaks above SMA 7
				&& Rising(SMA(BarsArray[2],7)) && Rising(SMA(BarsArray[2],3)))//both SMAs Rising
			DrawTextFixed("Possible Long", " POSSIBLE LONG ON 3R ", tPosition, Color.White, textFontMed, Color.Gray, Color.DarkBlue, 10);
				else
			RemoveDrawObject("Possible Long");
			
			if (SMA(BarsArray[2], 3)[0] - SMA(BarsArray[2], 7)[0] <=2*TickSize//Maximum 2 pips between MAs
				&& Lows[2][0] < SMA(BarsArray[2], 7)[0]//Price breaks below SMA 7
				&& Falling(SMA(BarsArray[2],7)) && Falling(SMA(BarsArray[2],3)))//both SMAs Falling
			DrawTextFixed("Possible Short", " POSSIBLE SHORT ON 3R ", tPosition, Color.White, textFontMed, Color.Gray, Color.DarkOrange, 10);
				else
			RemoveDrawObject("Possible Short");
       		
		}	
		
		// Trim the indicator's label
		
		public override string ToString()
		{
		return Name + "";	
		}

        #region Properties
        #endregion
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private MTFMAIndicator[] cacheMTFMAIndicator = null;

        private static MTFMAIndicator checkMTFMAIndicator = new MTFMAIndicator();

        /// <summary>
        /// MTFMAIndicator
        /// </summary>
        /// <returns></returns>
        public MTFMAIndicator MTFMAIndicator()
        {
            return MTFMAIndicator(Input);
        }

        /// <summary>
        /// MTFMAIndicator
        /// </summary>
        /// <returns></returns>
        public MTFMAIndicator MTFMAIndicator(Data.IDataSeries input)
        {
            if (cacheMTFMAIndicator != null)
                for (int idx = 0; idx < cacheMTFMAIndicator.Length; idx++)
                    if (cacheMTFMAIndicator[idx].EqualsInput(input))
                        return cacheMTFMAIndicator[idx];

            lock (checkMTFMAIndicator)
            {
                if (cacheMTFMAIndicator != null)
                    for (int idx = 0; idx < cacheMTFMAIndicator.Length; idx++)
                        if (cacheMTFMAIndicator[idx].EqualsInput(input))
                            return cacheMTFMAIndicator[idx];

                MTFMAIndicator indicator = new MTFMAIndicator();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                MTFMAIndicator[] tmp = new MTFMAIndicator[cacheMTFMAIndicator == null ? 1 : cacheMTFMAIndicator.Length + 1];
                if (cacheMTFMAIndicator != null)
                    cacheMTFMAIndicator.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheMTFMAIndicator = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// MTFMAIndicator
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MTFMAIndicator MTFMAIndicator()
        {
            return _indicator.MTFMAIndicator(Input);
        }

        /// <summary>
        /// MTFMAIndicator
        /// </summary>
        /// <returns></returns>
        public Indicator.MTFMAIndicator MTFMAIndicator(Data.IDataSeries input)
        {
            return _indicator.MTFMAIndicator(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// MTFMAIndicator
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MTFMAIndicator MTFMAIndicator()
        {
            return _indicator.MTFMAIndicator(Input);
        }

        /// <summary>
        /// MTFMAIndicator
        /// </summary>
        /// <returns></returns>
        public Indicator.MTFMAIndicator MTFMAIndicator(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.MTFMAIndicator(input);
        }
    }
}
#endregion
