#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Opening range indicator for S/R
	/// Author:  Jason Chan (bearishtrader)
    /// Description:
	/// 
	/// Draw the upper and lower levels of the opening range.  Set the StartTime and EndTime according to your own local
	/// time preferences.  The defaults are 8:30 AM to 8:45 AM CST
	/// 
	/// *** You may freely distribute this script, but if you make changes please add your comments below
	/// 
	/// Revision Author      Date	    Comments  
	/// ________ ______		 ____	    ________
	/// 1.0      Jason Chan  04/24/2009 Initial release
	/// 2.0      Cory Ng     10/18/2009 add overnight session
	///
    /// </summary>
    [Description("Opening range with overnight session range")]
    public class ORange_OvernightV2 : Indicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
			private DateTime 	currentDate 	= Cbi.Globals.MinDate;
			private DateTime 	now;
		    private DateTime 	prevDay; 
		
			private int beginTime = 161400;
            private int endTime   = 093000;
			private DateTime startDateTime;
			private DateTime endDateTime;
			private double highestHigh = 0;
			private double lowestLow = 0;
			private bool firstTime;
			private Color rangeColor = Color.DarkGoldenrod;
			private int rangeColorOpacity = 2;			
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkGoldenrod), PlotStyle.Hash, "RangeTop"));
            Add(new Plot(Color.FromKnownColor(KnownColor.DarkGoldenrod), PlotStyle.Hash, "RangeBottom"));
			Plots[0].Pen = new Pen(Color.DarkGoldenrod, 2); Plots[0].Pen.DashStyle = DashStyle.Solid;
			Plots[1].Pen = new Pen(Color.DarkGoldenrod, 2); Plots[1].Pen.DashStyle = DashStyle.Solid;
            CalculateOnBarClose	= true;
            Overlay				= true;
            PriceTypeSupported	= false;			
			firstTime = true;
			now = DateTime.Today;     // today date
			prevDay = now.AddDays(-1);   // yesterday date
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {	
			if (Bars == null)
			return;
			//Only allowed on Intraday charts.
			if (!Data.BarsType.GetInstance(Bars.Period.Id).IsIntraday)
			{
				DrawTextFixed("error msg", "Open Range indicator only works on intraday intervals", TextPosition.BottomRight);
				return;
			}
			if (startDateTime > endDateTime)
			{
				DrawTextFixed("error msg", "Start Time > End Time, use daily Open Range indicator instead", TextPosition.BottomRight);
				return;
			}
			int sessionsBarsAgo = 0;
			DateTime bar = new DateTime(Bars.GetSessionBar(sessionsBarsAgo).Time.Year, Bars.GetSessionBar(sessionsBarsAgo).Time.Month, Bars.GetSessionBar(sessionsBarsAgo).Time.Day, Bars.Session.NextBeginTime.Hour, Bars.Session.NextBeginTime.Minute, Bars.Session.NextBeginTime.Second);
//			DateTime bar = new DateTime(Bars.GetSessionBar(sessionsBarsAgo).Time.Year, Bars.GetSessionBar(sessionsBarsAgo).Time.Month, Bars.GetSessionBar(sessionsBarsAgo).Time.Day, Bars.SessionBegin.Hour, Bars.SessionBegin.Minute, Bars.SessionBegin.Second);
			string format = "MM/dd/yyyy";
			// get the prior session high & low 
            // if (Bars.GetSessionBar(1) != null)
			if (bar.ToString(format) == prevDay.ToString(format))
			{		
			if ( ToTime(Time[0]) > beginTime && ToTime(Time[0]) <= 235900)
			{
				if (firstTime)
				{
				highestHigh = High[0]; lowestLow = Low[0]; firstTime = false;
				}
				if (High[0] >= highestHigh) highestHigh = High[0];				
				if (Low[0] <= lowestLow) lowestLow = Low[0];
			}
			else
			{
				firstTime = true;
			}
			
		    }
			
			// continue to compare value from today session high & low 
           // if (Bars.GetSessionBar(0) != null)
			if (bar.ToString(format) == now.ToString(format))
			{		
			if ( ToTime(Time[0]) > 0 && ToTime(Time[0]) <= endTime)
			{
				if (High[0] >= highestHigh) highestHigh = High[0];				
				if (Low[0] <= lowestLow) lowestLow = Low[0];
			}
	
			
			if (highestHigh > 0 && lowestLow > 0 ) {
				RangeTop.Set(highestHigh);
				RangeBottom.Set(lowestLow);
				DrawRegion("ColorRange", CurrentBar, 0, RangeTop, RangeBottom, Color.Transparent, RangeColor, RangeColorOpacity);
			}
			}
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries RangeTop
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries RangeBottom
        {
            get { return Values[1]; }
        }

        [Description("Start Time of open range, time format: HHMMss")]
        [Category("Parameters")]
        public int Begin_Time_HHMMss
        {
            get { return beginTime; }
            set { beginTime =  Math.Max(1, value); }

        }

        [Description("End time of opening range, time format: HHMMss")]
        [Category("Parameters")]	
        public int End_Time___HHMMss
        {
            get { return endTime; }
            set { endTime = Math.Max(1, value); }

        }
		
		[Description("Range Color")]
		[Category("Visual")]
		[Gui.Design.DisplayName("Range Area Color")]
		public Color RangeColor
		{
			get { return rangeColor; }
			set { rangeColor = value; }
		}
		
	//	[Browsable(false)]
	//	public string RangeColorSerialize
	//	{
	//		get { return NinjaTrader.Gui.Design.SerializableColor.ToString(rangeColor); }
	//		set { rangeColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
	//	}

		[Description("Range Color Opacity (least-most: 0-10)")]
		[Category("Visual")]
		[Gui.Design.DisplayName("Color Opacity")]
		public int RangeColorOpacity
		{
			get { return rangeColorOpacity; }
			set { rangeColorOpacity = Math.Max(value, 0); }
		}
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ORange_OvernightV2[] cacheORange_OvernightV2 = null;

        private static ORange_OvernightV2 checkORange_OvernightV2 = new ORange_OvernightV2();

        /// <summary>
        /// Opening range with overnight session range
        /// </summary>
        /// <returns></returns>
        public ORange_OvernightV2 ORange_OvernightV2(int begin_Time_HHMMss, int end_Time___HHMMss)
        {
            return ORange_OvernightV2(Input, begin_Time_HHMMss, end_Time___HHMMss);
        }

        /// <summary>
        /// Opening range with overnight session range
        /// </summary>
        /// <returns></returns>
        public ORange_OvernightV2 ORange_OvernightV2(Data.IDataSeries input, int begin_Time_HHMMss, int end_Time___HHMMss)
        {
            if (cacheORange_OvernightV2 != null)
                for (int idx = 0; idx < cacheORange_OvernightV2.Length; idx++)
                    if (cacheORange_OvernightV2[idx].Begin_Time_HHMMss == begin_Time_HHMMss && cacheORange_OvernightV2[idx].End_Time___HHMMss == end_Time___HHMMss && cacheORange_OvernightV2[idx].EqualsInput(input))
                        return cacheORange_OvernightV2[idx];

            lock (checkORange_OvernightV2)
            {
                checkORange_OvernightV2.Begin_Time_HHMMss = begin_Time_HHMMss;
                begin_Time_HHMMss = checkORange_OvernightV2.Begin_Time_HHMMss;
                checkORange_OvernightV2.End_Time___HHMMss = end_Time___HHMMss;
                end_Time___HHMMss = checkORange_OvernightV2.End_Time___HHMMss;

                if (cacheORange_OvernightV2 != null)
                    for (int idx = 0; idx < cacheORange_OvernightV2.Length; idx++)
                        if (cacheORange_OvernightV2[idx].Begin_Time_HHMMss == begin_Time_HHMMss && cacheORange_OvernightV2[idx].End_Time___HHMMss == end_Time___HHMMss && cacheORange_OvernightV2[idx].EqualsInput(input))
                            return cacheORange_OvernightV2[idx];

                ORange_OvernightV2 indicator = new ORange_OvernightV2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Begin_Time_HHMMss = begin_Time_HHMMss;
                indicator.End_Time___HHMMss = end_Time___HHMMss;
                Indicators.Add(indicator);
                indicator.SetUp();

                ORange_OvernightV2[] tmp = new ORange_OvernightV2[cacheORange_OvernightV2 == null ? 1 : cacheORange_OvernightV2.Length + 1];
                if (cacheORange_OvernightV2 != null)
                    cacheORange_OvernightV2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheORange_OvernightV2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Opening range with overnight session range
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ORange_OvernightV2 ORange_OvernightV2(int begin_Time_HHMMss, int end_Time___HHMMss)
        {
            return _indicator.ORange_OvernightV2(Input, begin_Time_HHMMss, end_Time___HHMMss);
        }

        /// <summary>
        /// Opening range with overnight session range
        /// </summary>
        /// <returns></returns>
        public Indicator.ORange_OvernightV2 ORange_OvernightV2(Data.IDataSeries input, int begin_Time_HHMMss, int end_Time___HHMMss)
        {
            return _indicator.ORange_OvernightV2(input, begin_Time_HHMMss, end_Time___HHMMss);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Opening range with overnight session range
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ORange_OvernightV2 ORange_OvernightV2(int begin_Time_HHMMss, int end_Time___HHMMss)
        {
            return _indicator.ORange_OvernightV2(Input, begin_Time_HHMMss, end_Time___HHMMss);
        }

        /// <summary>
        /// Opening range with overnight session range
        /// </summary>
        /// <returns></returns>
        public Indicator.ORange_OvernightV2 ORange_OvernightV2(Data.IDataSeries input, int begin_Time_HHMMss, int end_Time___HHMMss)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ORange_OvernightV2(input, begin_Time_HHMMss, end_Time___HHMMss);
        }
    }
}
#endregion
