//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private anaVisualEMA[] cacheanaVisualEMA = null;

        private static anaVisualEMA checkanaVisualEMA = new anaVisualEMA();

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The anaVisualEMA applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public anaVisualEMA anaVisualEMA(int periodEMA, VisualEMACalcMode thisCalcMode, VisualEMAPeriodType thisPeriodType, int thisPeriodValue, VisualEMAPriceType thisPriceType)
        {
            return anaVisualEMA(Input, periodEMA, thisCalcMode, thisPeriodType, thisPeriodValue, thisPriceType);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The anaVisualEMA applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public anaVisualEMA anaVisualEMA(Data.IDataSeries input, int periodEMA, VisualEMACalcMode thisCalcMode, VisualEMAPeriodType thisPeriodType, int thisPeriodValue, VisualEMAPriceType thisPriceType)
        {
            if (cacheanaVisualEMA != null)
                for (int idx = 0; idx < cacheanaVisualEMA.Length; idx++)
                    if (cacheanaVisualEMA[idx].PeriodEMA == periodEMA && cacheanaVisualEMA[idx].ThisCalcMode == thisCalcMode && cacheanaVisualEMA[idx].ThisPeriodType == thisPeriodType && cacheanaVisualEMA[idx].ThisPeriodValue == thisPeriodValue && cacheanaVisualEMA[idx].ThisPriceType == thisPriceType && cacheanaVisualEMA[idx].EqualsInput(input))
                        return cacheanaVisualEMA[idx];

            lock (checkanaVisualEMA)
            {
                checkanaVisualEMA.PeriodEMA = periodEMA;
                periodEMA = checkanaVisualEMA.PeriodEMA;
                checkanaVisualEMA.ThisCalcMode = thisCalcMode;
                thisCalcMode = checkanaVisualEMA.ThisCalcMode;
                checkanaVisualEMA.ThisPeriodType = thisPeriodType;
                thisPeriodType = checkanaVisualEMA.ThisPeriodType;
                checkanaVisualEMA.ThisPeriodValue = thisPeriodValue;
                thisPeriodValue = checkanaVisualEMA.ThisPeriodValue;
                checkanaVisualEMA.ThisPriceType = thisPriceType;
                thisPriceType = checkanaVisualEMA.ThisPriceType;

                if (cacheanaVisualEMA != null)
                    for (int idx = 0; idx < cacheanaVisualEMA.Length; idx++)
                        if (cacheanaVisualEMA[idx].PeriodEMA == periodEMA && cacheanaVisualEMA[idx].ThisCalcMode == thisCalcMode && cacheanaVisualEMA[idx].ThisPeriodType == thisPeriodType && cacheanaVisualEMA[idx].ThisPeriodValue == thisPeriodValue && cacheanaVisualEMA[idx].ThisPriceType == thisPriceType && cacheanaVisualEMA[idx].EqualsInput(input))
                            return cacheanaVisualEMA[idx];

                anaVisualEMA indicator = new anaVisualEMA();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.PeriodEMA = periodEMA;
                indicator.ThisCalcMode = thisCalcMode;
                indicator.ThisPeriodType = thisPeriodType;
                indicator.ThisPeriodValue = thisPeriodValue;
                indicator.ThisPriceType = thisPriceType;
                Indicators.Add(indicator);
                indicator.SetUp();

                anaVisualEMA[] tmp = new anaVisualEMA[cacheanaVisualEMA == null ? 1 : cacheanaVisualEMA.Length + 1];
                if (cacheanaVisualEMA != null)
                    cacheanaVisualEMA.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheanaVisualEMA = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The anaVisualEMA applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaVisualEMA anaVisualEMA(int periodEMA, VisualEMACalcMode thisCalcMode, VisualEMAPeriodType thisPeriodType, int thisPeriodValue, VisualEMAPriceType thisPriceType)
        {
            return _indicator.anaVisualEMA(Input, periodEMA, thisCalcMode, thisPeriodType, thisPeriodValue, thisPriceType);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The anaVisualEMA applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaVisualEMA anaVisualEMA(Data.IDataSeries input, int periodEMA, VisualEMACalcMode thisCalcMode, VisualEMAPeriodType thisPeriodType, int thisPeriodValue, VisualEMAPriceType thisPriceType)
        {
            return _indicator.anaVisualEMA(input, periodEMA, thisCalcMode, thisPeriodType, thisPeriodValue, thisPriceType);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The anaVisualEMA applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.anaVisualEMA anaVisualEMA(int periodEMA, VisualEMACalcMode thisCalcMode, VisualEMAPeriodType thisPeriodType, int thisPeriodValue, VisualEMAPriceType thisPriceType)
        {
            return _indicator.anaVisualEMA(Input, periodEMA, thisCalcMode, thisPeriodType, thisPeriodValue, thisPriceType);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The anaVisualEMA applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.anaVisualEMA anaVisualEMA(Data.IDataSeries input, int periodEMA, VisualEMACalcMode thisCalcMode, VisualEMAPeriodType thisPeriodType, int thisPeriodValue, VisualEMAPriceType thisPriceType)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.anaVisualEMA(input, periodEMA, thisCalcMode, thisPeriodType, thisPeriodValue, thisPriceType);
        }
    }
}
#endregion
