#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.
    /// </summary>
    [Description("The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.")]
    [Gui.Design.DisplayName("Tick Money Flow")]
    public class TMF : Indicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
		private int TickFlag = 0;
		private double OldPrice = 0;
		private double TMF0 = 0;
		private double NewTickVol = 0;
		private double MyBarVolume = 0;
		private int activeBar = -1;
		private DateTime startTime;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Red), PlotStyle.Line, "Plot0"));
            Add(new Line(Color.FromKnownColor(KnownColor.DarkOliveGreen), 0, "ZeroLine"));
            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
			startTime = DateTime.Now;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
			if (!CalculateOnBarClose && startTime.Ticks <= Time[0].Ticks)
			{
				if (CurrentBar != activeBar) MyBarVolume = 0;
    			NewTickVol = Volume[0] - MyBarVolume;
    			MyBarVolume = MyBarVolume + NewTickVol;
    			if (Close[0] >= GetCurrentAsk())
				{
        			TMF0 = TMF0 + (Close[0] * NewTickVol);
        			TickFlag = 1;
				}
    		
				if (Close[0] <= GetCurrentBid()) 
				{
					TMF0 = TMF0 - (Close[0] * NewTickVol);
					TickFlag = 2;
				}
				
				if ( ( Close[0] < GetCurrentAsk() && Close[0] > GetCurrentBid()) && Close[0] > OldPrice )
					TMF0 = TMF0 + (Close[0] * NewTickVol);
				if ( (Close[0] < GetCurrentAsk() && Close[0] > GetCurrentBid()) && Close[0] < OldPrice )  
					TMF0 = TMF0 - (Close[0]*NewTickVol);
				if ( (Close[0] < GetCurrentAsk() && Close[0] > GetCurrentBid()) && Close[0] == OldPrice && TickFlag == 1 )
					TMF0 = TMF0 + (Close[0]*NewTickVol);
				if ( (Close[0] < GetCurrentAsk() && Close[0] > GetCurrentBid()) && Close[0] == OldPrice && TickFlag == 2)
					TMF0 = TMF0 - (Close[0]*NewTickVol);
				OldPrice = Close[0];
				activeBar = CurrentBar;
			}
            Plot0.Set(TMF0);
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private TMF[] cacheTMF = null;

        private static TMF checkTMF = new TMF();

        /// <summary>
        /// The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.
        /// </summary>
        /// <returns></returns>
        public TMF TMF()
        {
            return TMF(Input);
        }

        /// <summary>
        /// The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.
        /// </summary>
        /// <returns></returns>
        public TMF TMF(Data.IDataSeries input)
        {

            if (cacheTMF != null)
                for (int idx = 0; idx < cacheTMF.Length; idx++)
                    if (cacheTMF[idx].EqualsInput(input))
                        return cacheTMF[idx];

            TMF indicator = new TMF();
            indicator.SetUp();
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;

            TMF[] tmp = new TMF[cacheTMF == null ? 1 : cacheTMF.Length + 1];
            if (cacheTMF != null)
                cacheTMF.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheTMF = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.TMF TMF()
        {
            return _indicator.TMF(Input);
        }

        /// <summary>
        /// The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.
        /// </summary>
        /// <returns></returns>
        public Indicator.TMF TMF(Data.IDataSeries input)
        {
            return _indicator.TMF(input);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.TMF TMF()
        {
            return _indicator.TMF(Input);
        }

        /// <summary>
        /// The tick money flow trend is your friend.  When the price and TMF are going the same way, the trend is your friend.  If they diverge do not trade.
        /// </summary>
        /// <returns></returns>
        public Indicator.TMF TMF(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.TMF(input);
        }

    }
}
#endregion
