// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
// 28.10.2010 - Modifications added by Jurbol. Colorcoding up or downslope. www.jurbol.com

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Exponential Moving Average. The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.
	/// </summary>
	[Description("The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.")]
	public class EMA_Slope_Color : Indicator
	{
		#region Variables
		private int			period		= 14;
		private Color       upColor         = Color.LimeGreen;
		private Color		dnColor         = Color.Red;
		private bool 	    slopeColor      = true;
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(Color.Orange, "EMA_Slope_Color"));
			Plots[0].Pen.Width = 2;

			Overlay				= true;
			PriceTypeSupported	= true;
			CalculateOnBarClose = false;
		}
		
		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			Value.Set(CurrentBar == 0 ? Input[0] : Input[0] * (2.0 / (1 + Period)) + (1 - (2.0 / (1 + Period))) * Value[1]);
		
			
			if(Rising(Value))
			{
			if(slopeColor)
			PlotColors[0][0] = upColor;
			}
			if(Falling(Value))
			{
			if(slopeColor)
			PlotColors[0][0] = dnColor;
			}
			
	}
			
		
		

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}
		
		[Description("SlopeColor?")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("01. Colorcode the EMA?")]
		public bool Slope
		{
			get { return slopeColor; }
			set { slopeColor = value; }
		}
		
		[XmlIgnore()]
        [Description("Color EMA Up")]
        [Category("Colors")]
		[Gui.Design.DisplayNameAttribute("01. Color EMA's Up")]
        public Color UpColor
        {
            get { return upColor; }
            set { upColor = value; }
        }
		[Browsable(false)]
		public string UpColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(UpColor); }
			set { UpColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[XmlIgnore()]
        [Description("Color EMA Dn")]
        [Category("Colors")]
		[Gui.Design.DisplayNameAttribute("02. Color EMA's Down")]
        public Color DnColor
        {
            get { return dnColor; }
            set { dnColor = value; }
        }
		[Browsable(false)]
		public string DnColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(DnColor); }
			set { DnColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private EMA_Slope_Color[] cacheEMA_Slope_Color = null;

        private static EMA_Slope_Color checkEMA_Slope_Color = new EMA_Slope_Color();

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public EMA_Slope_Color EMA_Slope_Color(int period, bool slope)
        {
            return EMA_Slope_Color(Input, period, slope);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public EMA_Slope_Color EMA_Slope_Color(Data.IDataSeries input, int period, bool slope)
        {
            if (cacheEMA_Slope_Color != null)
                for (int idx = 0; idx < cacheEMA_Slope_Color.Length; idx++)
                    if (cacheEMA_Slope_Color[idx].Period == period && cacheEMA_Slope_Color[idx].Slope == slope && cacheEMA_Slope_Color[idx].EqualsInput(input))
                        return cacheEMA_Slope_Color[idx];

            lock (checkEMA_Slope_Color)
            {
                checkEMA_Slope_Color.Period = period;
                period = checkEMA_Slope_Color.Period;
                checkEMA_Slope_Color.Slope = slope;
                slope = checkEMA_Slope_Color.Slope;

                if (cacheEMA_Slope_Color != null)
                    for (int idx = 0; idx < cacheEMA_Slope_Color.Length; idx++)
                        if (cacheEMA_Slope_Color[idx].Period == period && cacheEMA_Slope_Color[idx].Slope == slope && cacheEMA_Slope_Color[idx].EqualsInput(input))
                            return cacheEMA_Slope_Color[idx];

                EMA_Slope_Color indicator = new EMA_Slope_Color();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                indicator.Slope = slope;
                Indicators.Add(indicator);
                indicator.SetUp();

                EMA_Slope_Color[] tmp = new EMA_Slope_Color[cacheEMA_Slope_Color == null ? 1 : cacheEMA_Slope_Color.Length + 1];
                if (cacheEMA_Slope_Color != null)
                    cacheEMA_Slope_Color.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheEMA_Slope_Color = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Slope_Color EMA_Slope_Color(int period, bool slope)
        {
            return _indicator.EMA_Slope_Color(Input, period, slope);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Slope_Color EMA_Slope_Color(Data.IDataSeries input, int period, bool slope)
        {
            return _indicator.EMA_Slope_Color(input, period, slope);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Slope_Color EMA_Slope_Color(int period, bool slope)
        {
            return _indicator.EMA_Slope_Color(Input, period, slope);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Slope_Color applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Slope_Color EMA_Slope_Color(Data.IDataSeries input, int period, bool slope)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.EMA_Slope_Color(input, period, slope);
        }
    }
}
#endregion
