#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

#endregion
#region enums

public enum DeltaModeType
{
	BidAsk,
	UptickDowntick,
	UptickDowntickWithContinuation,
	Hybrid
}

#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// This uses the sample code from Gomi's GomCDSMA indicator.
	/// The multi color plotting will not work in NT6.5.
	/// version 001  January 1, 2010
    /// </summary>
    [Description("Zero Centered Stochastic of Gomi's Cumulative Volume Delta with Recording")]
     public class StochGomCD : Indicator
{
#region Variables 
 Indicator indic;
 GomCD gcd;
 bool initdone=false; 
//-----from stochastic	
	
	    private DeltaModeType dmType = DeltaModeType.BidAsk;
	
	    private int				periodD	= 3;	// SlowDperiod
		private int				periodK	= 11;	// Kperiod
		private int				smooth	= 3;	// SlowKperiod
		private DataSeries		den;
		private DataSeries		nom;
	    private DataSeries      kay;
	    string deltastring;
	
	      private Color downColor = Color.Red;
		  private Color upColor = Color.Lime;
	
// --- end of stochastic variables	
	
#endregion
 
protected override void Initialize()
{
 
	
	        CalculateOnBarClose = false;
 	        Overlay = false;
 	        PriceTypeSupported = false; 

	        Add(new Plot(Color.CornflowerBlue, "D"));
				Plots[0].Pen.DashStyle=DashStyle.Dot;
				Plots[0].Pen.Width =2;
			Add(new Plot(Color.Transparent, "K"));
				Plots[0].Pen.Width=2;			
			Add(new Line(Color.YellowGreen, -60, "Lower"));
			Add(new Line(Color.YellowGreen, 60, "Upper"));
			Add(new Line(Color.DimGray, 0, "Center"));
				Lines[2].Pen.DashStyle = DashStyle.Dash;
			den			= new DataSeries(this);
			nom			= new DataSeries(this);
			
	    
//----end stochastic	
	#if !NT7
		gcd=(GomCD(GomCDCalculationModeType.dmType,GomCDChartType.CumulativeChart,GomFileFormat.Binary,GomFilterModeType.None,1,false));
	#endif
}
 
protected override void OnBarUpdate()
{ 
	#if NT7              //This is Gomi's code from GomCDSMA.
		if (!initdone)
		{
			// we instantiate a gomCD
			gcd=GomCD(GomCDCalculationModeType.BidAsk,GomCDChartType.CumulativeChart,GomFileFormat.Binary,GomFilterModeType.None,1,false);
			//data series don't exist because they're created in onbarupdate() and for now only Initialize has been called.
			
			//dummy call to call OnBarUpdate so dataseries get created
			double dummy=gcd.DeltaValue[0];
			
			//now that the gcd Dataseries exist, we can work with gcd dataseries.
			
			//indic=SMA(gcd.DeltaClose,5); 
			//double dummy=indic.DeltaValue[0];
			initdone=true;
		}
	#endif
	
	//GCDSMA.Set(indic[0]);
		//code for stochastic starts here
		
	        nom.Set(gcd.DeltaClose[0] - MIN(gcd.DeltaLow, PeriodK)[0]);
			den.Set(MAX(gcd.DeltaHigh, PeriodK)[0] - MIN(gcd.DeltaLow, PeriodK)[0]);										// PeriodK = Kperiod
			
			K.Set((200 * SUM(nom, Smooth)[0] / (SUM(den, Smooth)[0] == 0 ? 1.0 : SUM(den, Smooth)[0])) -100   );	// Smooth  = SlowKperiod
			
			PlotColors[1][0] = ColorRising; //default color if not risng or falling
			if(Rising(K))
				PlotColors[1][0] = ColorRising;
			if(Falling(K))
				PlotColors[1][0] = ColorFalling;
			
			D.Set(SMA(K, PeriodD)[0]);						
		
		//code for stochastic end

}
   #region Properties
        [Description("DeltaMode Type")]
        [Category("Parameters")]
        public DeltaModeType DMType
        {
            get { return dmType; }
            set { dmType = value; }
        }

	    [XmlIgnore()]
        [Description("Color for Falling Plot")]
        [Category("Parameters")]
        public Color ColorFalling
        {
            get { return downColor; }
            set { downColor = value; }
        }
		
		// Serialize our Color object
		[Browsable(false)]
		public string ColorFallingSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(downColor); }
			set { downColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}

		[XmlIgnore()]
		[Description("Color for Rising Plot")]
        [Category("Parameters")]
        public Color ColorRising
        {
            get { return upColor; }
            set { upColor = value; }
        }
		
		[Browsable(false)]
		public string ColorRisingSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(upColor); }
			set { upColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}


[Browsable(false)] 
[XmlIgnore()]
//public DataSeries GCDSMA
//{
// get { return Values[0]; }
//}
	public DataSeries D
		{
			get { return Values[0]; }
		}

		/// <summary>
		/// Gets the slow K value.
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries K
		{
			get { return Values[1]; }
		}
		
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for moving average over K values")]
		[GridCategory("Parameters")]
		public int PeriodD
		{
			get { return periodD; }
			set { periodD = Math.Max(1, value); }
		}

		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculating the K values")]
		[GridCategory("Parameters")]
		public int PeriodK
		{
			get { return periodK; }
			set { periodK = Math.Max(1, value); }
		}

		/// <summary>
		/// </summary>
		[Description("Number of bars for smoothing the slow K values")]
		[GridCategory("Parameters")]
		public int Smooth
		{
			get { return smooth; }
			set { smooth = Math.Max(1, value); }
		}
#endregion
}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private StochGomCD[] cacheStochGomCD = null;

        private static StochGomCD checkStochGomCD = new StochGomCD();

        /// <summary>
        /// Zero Centered Stochastic of Gomi's Cumulative Volume Delta with Recording
        /// </summary>
        /// <returns></returns>
        public StochGomCD StochGomCD(Color colorFalling, Color colorRising, DeltaModeType dMType, int periodD, int periodK, int smooth)
        {
            return StochGomCD(Input, colorFalling, colorRising, dMType, periodD, periodK, smooth);
        }

        /// <summary>
        /// Zero Centered Stochastic of Gomi's Cumulative Volume Delta with Recording
        /// </summary>
        /// <returns></returns>
        public StochGomCD StochGomCD(Data.IDataSeries input, Color colorFalling, Color colorRising, DeltaModeType dMType, int periodD, int periodK, int smooth)
        {
            if (cacheStochGomCD != null)
                for (int idx = 0; idx < cacheStochGomCD.Length; idx++)
                    if (cacheStochGomCD[idx].ColorFalling == colorFalling && cacheStochGomCD[idx].ColorRising == colorRising && cacheStochGomCD[idx].DMType == dMType && cacheStochGomCD[idx].PeriodD == periodD && cacheStochGomCD[idx].PeriodK == periodK && cacheStochGomCD[idx].Smooth == smooth && cacheStochGomCD[idx].EqualsInput(input))
                        return cacheStochGomCD[idx];

            lock (checkStochGomCD)
            {
                checkStochGomCD.ColorFalling = colorFalling;
                colorFalling = checkStochGomCD.ColorFalling;
                checkStochGomCD.ColorRising = colorRising;
                colorRising = checkStochGomCD.ColorRising;
                checkStochGomCD.DMType = dMType;
                dMType = checkStochGomCD.DMType;
                checkStochGomCD.PeriodD = periodD;
                periodD = checkStochGomCD.PeriodD;
                checkStochGomCD.PeriodK = periodK;
                periodK = checkStochGomCD.PeriodK;
                checkStochGomCD.Smooth = smooth;
                smooth = checkStochGomCD.Smooth;

                if (cacheStochGomCD != null)
                    for (int idx = 0; idx < cacheStochGomCD.Length; idx++)
                        if (cacheStochGomCD[idx].ColorFalling == colorFalling && cacheStochGomCD[idx].ColorRising == colorRising && cacheStochGomCD[idx].DMType == dMType && cacheStochGomCD[idx].PeriodD == periodD && cacheStochGomCD[idx].PeriodK == periodK && cacheStochGomCD[idx].Smooth == smooth && cacheStochGomCD[idx].EqualsInput(input))
                            return cacheStochGomCD[idx];

                StochGomCD indicator = new StochGomCD();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ColorFalling = colorFalling;
                indicator.ColorRising = colorRising;
                indicator.DMType = dMType;
                indicator.PeriodD = periodD;
                indicator.PeriodK = periodK;
                indicator.Smooth = smooth;
                Indicators.Add(indicator);
                indicator.SetUp();

                StochGomCD[] tmp = new StochGomCD[cacheStochGomCD == null ? 1 : cacheStochGomCD.Length + 1];
                if (cacheStochGomCD != null)
                    cacheStochGomCD.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheStochGomCD = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Zero Centered Stochastic of Gomi's Cumulative Volume Delta with Recording
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.StochGomCD StochGomCD(Color colorFalling, Color colorRising, DeltaModeType dMType, int periodD, int periodK, int smooth)
        {
            return _indicator.StochGomCD(Input, colorFalling, colorRising, dMType, periodD, periodK, smooth);
        }

        /// <summary>
        /// Zero Centered Stochastic of Gomi's Cumulative Volume Delta with Recording
        /// </summary>
        /// <returns></returns>
        public Indicator.StochGomCD StochGomCD(Data.IDataSeries input, Color colorFalling, Color colorRising, DeltaModeType dMType, int periodD, int periodK, int smooth)
        {
            return _indicator.StochGomCD(input, colorFalling, colorRising, dMType, periodD, periodK, smooth);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Zero Centered Stochastic of Gomi's Cumulative Volume Delta with Recording
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.StochGomCD StochGomCD(Color colorFalling, Color colorRising, DeltaModeType dMType, int periodD, int periodK, int smooth)
        {
            return _indicator.StochGomCD(Input, colorFalling, colorRising, dMType, periodD, periodK, smooth);
        }

        /// <summary>
        /// Zero Centered Stochastic of Gomi's Cumulative Volume Delta with Recording
        /// </summary>
        /// <returns></returns>
        public Indicator.StochGomCD StochGomCD(Data.IDataSeries input, Color colorFalling, Color colorRising, DeltaModeType dMType, int periodD, int periodK, int smooth)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.StochGomCD(input, colorFalling, colorRising, dMType, periodD, periodK, smooth);
        }
    }
}
#endregion
