#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

	#region enums for Moving Avg
	//======================================================
			public enum maTypeC
				{
					SMA,
					EMA,
					HMA,
					TMA,
					WMA,
					VWMA,
					TEMA,
					ZeroLagTEMA,
					ZeroLagHATEMA,
					ADXVMA
				};
	//====================================================
	#endregion
				
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Moving Avg Channel  (Ver 3.2 08/02/2010  ...  by Photog53).   Creates a moving average channel between the High & Low of the selected MA.
    /// </summary>
    [Description("Moving Avg Channel....(Ver 3.2 12/02/2010 by Photog53)   Creates a moving average channel between the High & Low of the selected MA")]
    public class ChannelMA2 : Indicator
    {
        #region Variables
			private maTypeC aHighMA	= maTypeC.SMA;
			private maTypeC bDnType	= maTypeC.SMA;

			private int aHighPeriod	= 50;	
            private int bLowPeriod	= 50;	
            private int opacity		= 3;	
            private Color channelcolor	= Color.Gray; 
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
		{
            Add(new Plot(Color.FromKnownColor(KnownColor.Transparent), PlotStyle.Line, "HighL"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Transparent), PlotStyle.Line, "LowL"));
			//Add(new Plot(Color.FromKnownColor(KnownColor.Gray), PlotStyle.Line, "Middle"));
            //Plots[2].Pen.Width=2;
			//Plots[2].Pen.DashStyle = DashStyle.DashDotDot;
			
			CalculateOnBarClose	= true;
			Overlay				= true;
			PriceTypeSupported	= false;
			PaintPriceMarkers	= false;
			
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            //==============================================================
						
			#region Case/Switch Move Avg
			double U = 0;
			double L = 0;
			double M = 0;
			if (CurrentBar <= Math.Max(aHighPeriod, bLowPeriod)) return;
			switch (aHighMA)
			{
				case maTypeC.EMA: 
					//U = EMA(Input,aHighPeriod)[0]; 
					U = EMA(High,aHighPeriod)[0];
					break;
				case maTypeC.HMA: 
					U = HMA(High,aHighPeriod)[0];
					break;
				case maTypeC.TMA:
					U = TMA(High, aHighPeriod)[0];
					break;
				case maTypeC.WMA:
					U = WMA(High, aHighPeriod)[0];
					break;
				case maTypeC.VWMA:
					U = VWMA(High, aHighPeriod)[0];
					break;
				case maTypeC.TEMA:;
					U = TEMA(High, aHighPeriod)[0];
					break;
				case maTypeC.ZeroLagTEMA:
					U = ZeroLagTEMA(High, aHighPeriod)[0];
					break;
				case maTypeC.ZeroLagHATEMA:
					U = ZeroLagHATEMA(High, aHighPeriod)[0];
					break;
				case maTypeC.ADXVMA:
					U = ADXVMA(High, aHighPeriod)[0];
					break;
				default:
					U = SMA(High, aHighPeriod)[0];
					break;
			}
            HighL.Set(U);
			
  			switch (bDnType)
			{
				case maTypeC.EMA: 
					//L = EMA(Input,bLowPeriod)[0];
					L = EMA(Low,bLowPeriod)[0];
					//M = EMA(Close,bLowPeriod)[0];
					break;
				case maTypeC.HMA: 
					L = HMA(Low,bLowPeriod)[0];
					//M = HMA(Close,bLowPeriod)[0];
					break;
				case maTypeC.TMA:
					L = TMA(Low, bLowPeriod)[0];
					//M = TMA(Close, bLowPeriod)[0];
					break;
				case maTypeC.WMA:
					L = WMA(Low, bLowPeriod)[0];
					//M = WMA(Close, bLowPeriod)[0];
					break;
				case maTypeC.VWMA:
					L = VWMA(Low, bLowPeriod)[0];
					//M = VWMA(Close, bLowPeriod)[0];
					break;
				case maTypeC.TEMA:;
					L = TEMA(Low, bLowPeriod)[0];
					//M = TEMA(Close, bLowPeriod)[0];
					break;
				case maTypeC.ZeroLagTEMA:
					L = ZeroLagTEMA(Low, bLowPeriod)[0];
					//M = ZeroLagTEMA(Close, bLowPeriod)[0];
					break;
				case maTypeC.ZeroLagHATEMA:
					L = ZeroLagHATEMA(Low, bLowPeriod)[0];
					//M = ZeroLagHATEMA(Close, bLowPeriod)[0];
					break;
				case maTypeC.ADXVMA:
					L = ADXVMA(Low, bLowPeriod)[0];
					//M = ADXVMA(Close, bLowPeriod)[0];
					break;
				default:
					L = SMA(Low, bLowPeriod)[0];
					//M = SMA(Close, bLowPeriod)[0];
					break;
			}
 	        LowL.Set(L);
			//Middle.Set(M);
		#endregion
			

			DrawRegion("myregion", CurrentBar, 0, HighL, LowL, Color.Empty, channelcolor, Opacity);
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries HighL
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries LowL
        {
            get { return Values[1]; }
        }

        //[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        //[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        //public DataSeries Middle
        //{
        //    get { return Values[2]; }
        //}
		
		//================================================================================
        [Description("Select the Upper Line Moving Average")]
        [GridCategory("Parameters")]
		[Gui.Design.DisplayName ("High-MA  ")]
        public maTypeC AHighMA
        {
            get { return aHighMA; }
            set { aHighMA = value; }
        }
        [Description("Select the Upper Line Period")]
        [GridCategory("Parameters")]
		[Gui.Design.DisplayName ("High-MA Period")]
        public int AHighPeriod
        {
            get { return aHighPeriod; }
            set { aHighPeriod = Math.Max(1, value); }
        }		

		[Description("Select the Lower Line Moving Average")]
        [GridCategory("Parameters")]
		[Gui.Design.DisplayName ("Low-MA  ")]
        public maTypeC BLowMA
        {
            get { return bDnType; }
            set { bDnType = value; }
        }
        [Description("Select the Lower Line Moving Average")]
        [GridCategory("Parameters")]
		[Gui.Design.DisplayName ("Low-MA Period")]
        public int BLowPeriod
        {
            get { return bLowPeriod; }
            set { bLowPeriod = Math.Max(1, value); }
        }
		//===========================================================================================
        [Description("Controls contrast/visibility of the channel.   1=lightest....10=darkest.")]
        [GridCategory("Plots")]
        public int Opacity
        {
            get { return opacity; }
            set { opacity = Math.Max(1, value); }
        }
		
		[XmlIgnore()]
		[Description("Color for Painted Channel")]
        [GridCategory("Plots")]
        public Color Channelcolor
        {
            get { return channelcolor; }
            set { channelcolor = value; }
		}
		[Browsable(false)]
		public string ChannelcolorSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(channelcolor) ; }
				set { channelcolor = NinjaTrader.Gui.Design.SerializableColor.FromString(value) ; }
        }
		//  ************   end of modified code
        #endregion
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ChannelMA2[] cacheChannelMA2 = null;

        private static ChannelMA2 checkChannelMA2 = new ChannelMA2();

        /// <summary>
        /// Moving Avg Channel....(Ver 3.2 12/02/2010 by Photog53)   Creates a moving average channel between the High & Low of the selected MA
        /// </summary>
        /// <returns></returns>
        public ChannelMA2 ChannelMA2(maTypeC aHighMA, int aHighPeriod, maTypeC bLowMA, int bLowPeriod, Color channelcolor, int opacity)
        {
            return ChannelMA2(Input, aHighMA, aHighPeriod, bLowMA, bLowPeriod, channelcolor, opacity);
        }

        /// <summary>
        /// Moving Avg Channel....(Ver 3.2 12/02/2010 by Photog53)   Creates a moving average channel between the High & Low of the selected MA
        /// </summary>
        /// <returns></returns>
        public ChannelMA2 ChannelMA2(Data.IDataSeries input, maTypeC aHighMA, int aHighPeriod, maTypeC bLowMA, int bLowPeriod, Color channelcolor, int opacity)
        {
            if (cacheChannelMA2 != null)
                for (int idx = 0; idx < cacheChannelMA2.Length; idx++)
                    if (cacheChannelMA2[idx].AHighMA == aHighMA && cacheChannelMA2[idx].AHighPeriod == aHighPeriod && cacheChannelMA2[idx].BLowMA == bLowMA && cacheChannelMA2[idx].BLowPeriod == bLowPeriod && cacheChannelMA2[idx].Channelcolor == channelcolor && cacheChannelMA2[idx].Opacity == opacity && cacheChannelMA2[idx].EqualsInput(input))
                        return cacheChannelMA2[idx];

            lock (checkChannelMA2)
            {
                checkChannelMA2.AHighMA = aHighMA;
                aHighMA = checkChannelMA2.AHighMA;
                checkChannelMA2.AHighPeriod = aHighPeriod;
                aHighPeriod = checkChannelMA2.AHighPeriod;
                checkChannelMA2.BLowMA = bLowMA;
                bLowMA = checkChannelMA2.BLowMA;
                checkChannelMA2.BLowPeriod = bLowPeriod;
                bLowPeriod = checkChannelMA2.BLowPeriod;
                checkChannelMA2.Channelcolor = channelcolor;
                channelcolor = checkChannelMA2.Channelcolor;
                checkChannelMA2.Opacity = opacity;
                opacity = checkChannelMA2.Opacity;

                if (cacheChannelMA2 != null)
                    for (int idx = 0; idx < cacheChannelMA2.Length; idx++)
                        if (cacheChannelMA2[idx].AHighMA == aHighMA && cacheChannelMA2[idx].AHighPeriod == aHighPeriod && cacheChannelMA2[idx].BLowMA == bLowMA && cacheChannelMA2[idx].BLowPeriod == bLowPeriod && cacheChannelMA2[idx].Channelcolor == channelcolor && cacheChannelMA2[idx].Opacity == opacity && cacheChannelMA2[idx].EqualsInput(input))
                            return cacheChannelMA2[idx];

                ChannelMA2 indicator = new ChannelMA2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AHighMA = aHighMA;
                indicator.AHighPeriod = aHighPeriod;
                indicator.BLowMA = bLowMA;
                indicator.BLowPeriod = bLowPeriod;
                indicator.Channelcolor = channelcolor;
                indicator.Opacity = opacity;
                Indicators.Add(indicator);
                indicator.SetUp();

                ChannelMA2[] tmp = new ChannelMA2[cacheChannelMA2 == null ? 1 : cacheChannelMA2.Length + 1];
                if (cacheChannelMA2 != null)
                    cacheChannelMA2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheChannelMA2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Moving Avg Channel....(Ver 3.2 12/02/2010 by Photog53)   Creates a moving average channel between the High & Low of the selected MA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ChannelMA2 ChannelMA2(maTypeC aHighMA, int aHighPeriod, maTypeC bLowMA, int bLowPeriod, Color channelcolor, int opacity)
        {
            return _indicator.ChannelMA2(Input, aHighMA, aHighPeriod, bLowMA, bLowPeriod, channelcolor, opacity);
        }

        /// <summary>
        /// Moving Avg Channel....(Ver 3.2 12/02/2010 by Photog53)   Creates a moving average channel between the High & Low of the selected MA
        /// </summary>
        /// <returns></returns>
        public Indicator.ChannelMA2 ChannelMA2(Data.IDataSeries input, maTypeC aHighMA, int aHighPeriod, maTypeC bLowMA, int bLowPeriod, Color channelcolor, int opacity)
        {
            return _indicator.ChannelMA2(input, aHighMA, aHighPeriod, bLowMA, bLowPeriod, channelcolor, opacity);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Moving Avg Channel....(Ver 3.2 12/02/2010 by Photog53)   Creates a moving average channel between the High & Low of the selected MA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ChannelMA2 ChannelMA2(maTypeC aHighMA, int aHighPeriod, maTypeC bLowMA, int bLowPeriod, Color channelcolor, int opacity)
        {
            return _indicator.ChannelMA2(Input, aHighMA, aHighPeriod, bLowMA, bLowPeriod, channelcolor, opacity);
        }

        /// <summary>
        /// Moving Avg Channel....(Ver 3.2 12/02/2010 by Photog53)   Creates a moving average channel between the High & Low of the selected MA
        /// </summary>
        /// <returns></returns>
        public Indicator.ChannelMA2 ChannelMA2(Data.IDataSeries input, maTypeC aHighMA, int aHighPeriod, maTypeC bLowMA, int bLowPeriod, Color channelcolor, int opacity)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ChannelMA2(input, aHighMA, aHighPeriod, bLowMA, bLowPeriod, channelcolor, opacity);
        }
    }
}
#endregion
