
    #region Using declarations
    using System;
    using System.ComponentModel;
    using System.Diagnostics;
    using System.Drawing;
    using System.Drawing.Drawing2D;
    using System.Xml.Serialization;
    using NinjaTrader.Cbi;
    using NinjaTrader.Data;
    using NinjaTrader.Gui.Chart;
    #endregion

    // This namespace holds all indicators and is required. Do not change it.
    namespace NinjaTrader.Indicator
    {
    /// <summary>
    /// OBV and Bollinger bands	
	/// Found by sam028 and co on a french TA web site, not sure who is the author, maybe someone called mike_e...
	/// The idea: Short when sma is above BB upper band, Long when sma below BB...
	/// 03 sep 2009: code cleaned, add colors, SMA and std deviation parameters (sam028)
	/// 
	/// 
    /// </summary>
    [Description("OBVD")]
    public class OBVD : Indicator
    {
    #region Variables
    // Wizard generated variables
    // User defined variables (add any user defined variables below)
    private DataSeries totalprice;
    private DataSeries myobv;
	private DataSeries bollsup;
	private DataSeries bollinf;
	private double boll_stddev;
	private int sma_length;
	private bool colorSignal = true;
	private Color c_below;
	private Color c_above;
    #endregion

    /// <summary>
    /// This method is used to configure the indicator and is called once before any bar data is loaded.
    /// </summary>
    protected override void Initialize()
    {
	Add(new Plot(Color.FromKnownColor(KnownColor.Navy), PlotStyle.Line, "Pobv"));
	Add(new Plot(Color.FromKnownColor(KnownColor.LightSlateGray), PlotStyle.Line, "Pbollsup"));
	Add(new Plot(Color.FromKnownColor(KnownColor.LightSlateGray), PlotStyle.Line, "Pbollinf"));
	Add(new Plot(Color.FromKnownColor(KnownColor.Turquoise), PlotStyle.Line, "Pbollmoy"));
	Plots[0].Pen.Width = 2;
	CalculateOnBarClose = true;
	Overlay = false;

	c_above=Color.Tomato;
	c_below=Color.Lime;
	sma_length=20;
	boll_stddev=1.68;
	PriceTypeSupported = false;
	myobv = new DataSeries(this);
	totalprice = new DataSeries(this);
    }


    protected override void OnBarUpdate()
    {
    totalprice.Set((High[0]+Low[0]+Open[0]+Close[0])/4);
    if (CurrentBar < 2) {
    	myobv.Set(0);
    }
    else {
    	if (totalprice[0] > totalprice[1]) {
    		myobv.Set (myobv[1]+ Volume[0]);
    	}
    	else 
			if (totalprice[0] < totalprice[1]) {
    			myobv.Set (myobv[1]- Volume[0]);
    		}
    		else 
				if (totalprice[0] == totalprice[1]) {
    				myobv.Set (myobv[1]);
    			}
    }

	Pbollsup.Set(Bollinger(myobv,boll_stddev,sma_length).Upper[0]); 
	Pbollinf.Set(Bollinger(myobv,boll_stddev,sma_length).Lower[0]);
	Pbollmoy.Set(SMA(myobv,sma_length)[0]);
	Pobv.Set(myobv[0]);
	if (colorSignal) {
		if (myobv[0]>Pbollsup[0]){
			BackColor = c_above;
		}
		if (myobv[0]<Pbollinf[0]){
			BackColor = c_below;
		}		
	}
	
    }

    #region Properties

	[Description("SMA Length")]
    [Category("Parameters")]
    public int Sma_length
    {
		get { return sma_length; }
		set { sma_length = value; }
    }
	[Description("Bollinger std deviation")]
    [Category("Parameters")]
    public double Boll_stddev
    {
		get { return boll_stddev; }
		set { boll_stddev = value; }
    }
	[Category("Colors")]
	[Description("Color the signal ?")]
	[Gui.Design.DisplayName ("Color ?")]
	public bool ColorSignal
	{
		get { return colorSignal; }
		set { colorSignal = value; }
	}
	[Category("Colors")]
	[Description("Color above BB")]
	[Gui.Design.DisplayName ("Color above")]
	public Color C_above
	{
		get { return c_above; }
		set { c_above = value; }
	}		
	[Category("Colors")]
	[Description("Color below BB")]
	[Gui.Design.DisplayName ("Color below")]
	public Color C_below
	{
		get { return c_below; }
		set { c_below = value; }
	}		
	
    [Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
    [XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
    public DataSeries Pobv
    {
    get { return Values[0]; }
    }

    [Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
    [XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
    public DataSeries Pbollsup
    {
    get { return Values[1]; }
    }

    [Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
    [XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
    public DataSeries Pbollinf
    {
    get { return Values[2]; }
    }

    [Browsable(false)] // this line prevents the data series from being displayed in the indicator properties dialog, do not remove
    [XmlIgnore()] // this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
    public DataSeries Pbollmoy
    {
    get { return Values[3]; }
    }

    #endregion
    }
}

   
#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private OBVD[] cacheOBVD = null;

        private static OBVD checkOBVD = new OBVD();

        /// <summary>
        /// OBVD
        /// </summary>
        /// <returns></returns>
        public OBVD OBVD(double boll_stddev, int sma_length)
        {
            return OBVD(Input, boll_stddev, sma_length);
        }

        /// <summary>
        /// OBVD
        /// </summary>
        /// <returns></returns>
        public OBVD OBVD(Data.IDataSeries input, double boll_stddev, int sma_length)
        {
            checkOBVD.Boll_stddev = boll_stddev;
            boll_stddev = checkOBVD.Boll_stddev;
            checkOBVD.Sma_length = sma_length;
            sma_length = checkOBVD.Sma_length;

            if (cacheOBVD != null)
                for (int idx = 0; idx < cacheOBVD.Length; idx++)
                    if (Math.Abs(cacheOBVD[idx].Boll_stddev - boll_stddev) <= double.Epsilon && cacheOBVD[idx].Sma_length == sma_length && cacheOBVD[idx].EqualsInput(input))
                        return cacheOBVD[idx];

            OBVD indicator = new OBVD();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Boll_stddev = boll_stddev;
            indicator.Sma_length = sma_length;
            indicator.SetUp();

            OBVD[] tmp = new OBVD[cacheOBVD == null ? 1 : cacheOBVD.Length + 1];
            if (cacheOBVD != null)
                cacheOBVD.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheOBVD = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// OBVD
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.OBVD OBVD(double boll_stddev, int sma_length)
        {
            return _indicator.OBVD(Input, boll_stddev, sma_length);
        }

        /// <summary>
        /// OBVD
        /// </summary>
        /// <returns></returns>
        public Indicator.OBVD OBVD(Data.IDataSeries input, double boll_stddev, int sma_length)
        {
            return _indicator.OBVD(input, boll_stddev, sma_length);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// OBVD
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.OBVD OBVD(double boll_stddev, int sma_length)
        {
            return _indicator.OBVD(Input, boll_stddev, sma_length);
        }

        /// <summary>
        /// OBVD
        /// </summary>
        /// <returns></returns>
        public Indicator.OBVD OBVD(Data.IDataSeries input, double boll_stddev, int sma_length)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.OBVD(input, boll_stddev, sma_length);
        }

    }
}
#endregion
