
//An attempt to develop a pattern recognition system for Woodie's CCI

#region Using declarations
using System;
using System.IO;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Detects common Woodie's CCI patterns
	/// version 2.0
    /// </summary>
    [Description("Woodie's CCI Patterns")]
    [Gui.Design.DisplayName("Woodie's CCI Patterns")]	 // name as shown in available indicators list.
    public class WoodiesPatterns : Indicator
    {
        #region Variables
		
		private int		sideWinder0		= 60; // will be changed to 30 if Range Bars are detected
		private double 	extremes		= 200;
        private double	rejectLevel		= 100; // Default setting for RejectLevel
		private int		trendLength		= 12;
		//ZLR variable
		private double	minZLRPts   	= 15; //Default minimum ZLR change
		private double	maxSignalValue	= 120;
		private double	minZLRValue		= 0;
		private double	sumchopzone3 	= 0;
		private double	sumchopzone5 	= 0;
		private double	sumchopzone6 	= 0;
		private double	sumchopzone7 	= 0;
		private double	sumchopzone8 	= 0;
		protected int	zlrLong			= 0;
		protected int	zlrShort		= 0;
		//famir variable
		private double	famirLimits		= 50;
		private double	famirHookMin	= 3;
	    private int 	Direction=1; int Trend=1; 
		private	int 	PrevTrend, Trendbars;
		private	int 	Above100,Below100;
		private	int 	HookL11			= 0;
		private	int 	HookL12			= 0;
		private	int 	HookL21			= 0;
		private	int 	HookL22			= 0;
		private	int 	HookS11			= 0;
		private	int 	HookS12			= 0;
		private	int 	HookS21			= 0;
		private	int 	HookS22			= 0;
		protected int	famirLong		= 0;
		protected int	famirShort		= 0;
		//Vegas variables
		private double	swingHigh		= 0;
		private double	swingLow		= 0;
		protected int	vtLong			= 0;
		protected int	vtShort			= 0;
		//GB100 variables
		protected int	gbLong			= 0;
		protected int	gbShort			= 0;
		// Tony variables
		protected int	tonyLong		= 0;
		protected int	tonyShort		= 0;
		//Ghost variables
		private	string	usePoints		= "Points";
		private double	usePointsAmount	= 10;
		protected int	gstLong			= 0;
		protected int	gstShort		= 0;
		private bool	showGhostPeaks	= true;
		//CCI Predictor Variables
		private bool 	showPredictorArrows		= true;
		private bool 	showPredictorDots		= false;
		private int		period					= 14;
		private bool	showPredictorHistory 	= false;
		//Display options
		private	bool	soundAlert			= false;
		private	int		alertInterval 		= 60;
		private	bool	showOneTwenty		= false;
		private	bool	showFamirLimits		= false;
		private	bool	showMomoChange		= false;
		private	bool	soundMomoAlert		= false;
		private int		lineExtension		= 6;
 		private Color	oneTwentyColor		= Color.AntiqueWhite;
 		private Color	famirLimitsColor	= Color.AntiqueWhite;
 		private Color	gstTrendColor		= Color.Yellow;
		private Font	textFontLabels		= new Font("Tahoma", 7);//Version labels
		private string	alertFile			= "Alert4.wav";
		private int		rect1;
		private Color	rect1Color			= Color.Khaki;
		private int		rect1Transparency	= 1;
		private	bool	showRect1			= false;
		//Patterns to show
		private bool	show_ZLR			= true;
		private bool	show_Famir			= true;
		private bool	show_Vegas			= true;
		private bool	show_GB100			= true;
		private bool	show_Tony			= true;
		private bool	show_Ghost			= true;
		//Pattern Series
		private DataSeries	wCCIPatternSeries;
		private DataSeries	wCCIDirectionSeries;
		private DataSeries	wCCICloseAtSeries;
		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
           	Add(new Plot(Color.FromKnownColor(KnownColor.DarkOliveGreen), PlotStyle.Dot, "PlotCCIHigh"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Maroon), PlotStyle.Dot, "PlotCCILow"));
			
			wCCIPatternSeries	= new DataSeries(this);
			wCCIDirectionSeries	= new DataSeries(this);
			wCCICloseAtSeries	= new DataSeries(this);
			BarsRequired = 15;

			CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			DrawOnPricePanel	= false;
		}

		/// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			  if (CurrentBar < 20) 
        		return; 

			// Assign the WoodiesCCI indicator to a local variable for efficiency and readability
			if (Bars.Period.Id == PeriodType.Range || Bars.Period.Id == PeriodType.Custom1 || Bars.Period.Id == PeriodType.Final0)
				sideWinder0 = 30;
			WoodiesCCI myWoodies = WoodiesCCI(2, 5, 14, 34, 25, 6, sideWinder0, 100, 2);
			int BarsAgo_0Xup 		= MRO(delegate{return (myWoodies[0] > 0 && myWoodies[Math.Min(CurrentBar, 1)]==0 ? myWoodies[Math.Min(CurrentBar, 2)]<0 : myWoodies[Math.Min(CurrentBar, 1)]<0);},1,CurrentBar) +1;// 0 line cross up
			
			int BarsAgo_0Xdown 		= MRO(delegate{return (myWoodies[0] < 0 && (myWoodies[Math.Min(CurrentBar, 1)]==0 ? myWoodies[Math.Min(CurrentBar, 2)]>0 : myWoodies[Math.Min(CurrentBar, 1)]>0));},1,CurrentBar) +1;// 0 line cross down
			int BarsAgo_100Xup 		= MRO(delegate{return (myWoodies[0] > 100 && (myWoodies[Math.Min(CurrentBar, 1)]==0 ? myWoodies[Math.Min(CurrentBar, 2)]<100 : myWoodies[Math.Min(CurrentBar, 1)]<100));},1,CurrentBar) +1;// 100 line cross up
			int BarsAgo_100Xdown 	= MRO(delegate{return (myWoodies[0] < 100 && (myWoodies[Math.Min(CurrentBar, 1)]==100 ? myWoodies[Math.Min(CurrentBar, 2)]>100 : myWoodies[Math.Min(CurrentBar, 1)]>100));},1,CurrentBar) +1;// 100 line cross down
			int BarsAgo_n100Xup 	= MRO(delegate{return (myWoodies[0] > -100 && (myWoodies[Math.Min(CurrentBar, 1)]==-100 ? myWoodies[Math.Min(CurrentBar, 2)]<-100 : myWoodies[Math.Min(CurrentBar, 1)]<-100));},1,CurrentBar) +1;// -100 line cross down
			int BarsAgo_n100Xdown 	= MRO(delegate{return (myWoodies[0] < -100 && (myWoodies[Math.Min(CurrentBar, 1)]==-100 ? myWoodies[Math.Min(CurrentBar, 2)]>-100 : myWoodies[Math.Min(CurrentBar, 1)]>-100));},1,CurrentBar) +1;// -100 line cross up
			int BarsAgoExtremeXup 	= MRO(delegate{return (myWoodies[0]>-Extremes && (myWoodies[Math.Min(CurrentBar, 1)]==-Extremes ? myWoodies[Math.Min(CurrentBar, 2)]<-Extremes : myWoodies[Math.Min(CurrentBar, 1)]<-Extremes));},1,CurrentBar) +1;// Extreme cross up
			int BarsAgoExtremeXdown = MRO(delegate{return (myWoodies[0]<Extremes && (myWoodies[Math.Min(CurrentBar, 1)]==Extremes ? myWoodies[Math.Min(CurrentBar, 2)]>Extremes : myWoodies[Math.Min(CurrentBar, 1)]>Extremes));},1,CurrentBar) +1;// Extreme cross down
			
				swingHigh 			= MAX(myWoodies,BarsAgoExtremeXup)[Math.Min(CurrentBar, 1)]; 
				swingLow 			= MIN(myWoodies,BarsAgoExtremeXdown)[Math.Min(CurrentBar, 1)]; 
			int barsAgoSwingH 		= MRO(delegate{return myWoodies[0] == swingHigh;},1,CurrentBar);
			int barsAgoSwingL 		= MRO(delegate{return myWoodies[0] == swingLow;},1,CurrentBar);
			int barsAgoChopZoneL	= MRO(delegate{return myWoodies.ChopZone[0] < 0;},1,CurrentBar);//How long since chop zone was negative
			int barsAgoChopZoneS	= MRO(delegate{return myWoodies.ChopZone[0] > 0;},1,CurrentBar);//How long since chop zone was positive
			int trendcountL = MRO(delegate{return myWoodies.ChopZone[0] < 4;},3,CurrentBar);//How long since chop zone 2 non aqua bars
			int trendcountS = MRO(delegate{return myWoodies.ChopZone[0] > -4;},3,CurrentBar);//How long since chop zone 2 non red bars
			//Predictor variables
			double meanUp = 0;
			double meanDown = 0;
			double nMeanUp = 0;
			double nMeanDown = 0;
			double CCIup= 0;
			double CCIdown=0;
			double newCCIup= 0;
			double newCCIdown=0;
			double nCCIup= 0;
			double nCCIdown=0;
			double newTypUp = 0;
			double newTypDown =0;
			double oldTypUp = 0;
			double oldTypDown =0;
			bool zlrOKup = false;
			bool zlrOKdown = false;
			bool zlrVGup = false;
			bool zlrVGdown =false;
			
			if(ShowOneTwenty == true)
			{	DrawLine("120",LineExtension,MaxSignalValue,0,MaxSignalValue,OneTwentyColor,DashStyle.Dash,1);
				DrawLine("-120",LineExtension,-MaxSignalValue,0,-MaxSignalValue,OneTwentyColor,DashStyle.Dash,1);	
			}
			if(ShowFamirLimits == true)
			{	DrawLine("flimits",LineExtension,FamirLimits,0,FamirLimits,FamirLimitsColor,DashStyle.Dash,1);
				DrawLine("-flimits",LineExtension,-FamirLimits,0,-FamirLimits,FamirLimitsColor,DashStyle.Dash,1);	
			}
			if(ShowRect1 == true)
			{	
				DrawRectangle("R1",true,LineExtension,Rect1,0,-Rect1,Rect1Color,Rect1Color,Rect1Transparency);
			}
			DrawTextFixed("version","Woodies Patterns v. 2.0 beta",TextPosition.BottomLeft);
			
			#region DETERMINATION OF TREND
			if(myWoodies[0]>0)
				{Direction = 1;}//On which side of 0 is the CCI
			if(myWoodies[0]<0)
				{Direction = -1;}
			//CCI must exceed 100/-100 and be the right color for a new trend to begin
			if((myWoodies.ZoneBars[0] == 1 && BarsAgo_100Xup <= BarsAgo_0Xup && Direction == 1) || (myWoodies.ZoneBars[0] == 0 && BarsAgo_n100Xdown <= BarsAgo_0Xdown && Direction == -1))
				{Trend = Direction;}
			#endregion
			//Initialize Data Series
			wCCIPatternSeries.Set(0);
			wCCIDirectionSeries.Set(0);
			
				
			#region CCI Predictor
				if ((Bars.Period.Id == PeriodType.Range
					||Bars.Period.Id == PeriodType.Final0
					||Bars.Period.Id == PeriodType.Final1
					||Bars.Period.Id == PeriodType.Final2))
				{
					double range = Bars.Period.Value;
					int n =  Period - 1;
					double rangeValue = range * TickSize;
					double newCloseUp = Low[0] + rangeValue;
					double newCloseDown = High[0] - rangeValue;
					double typUp = (Low[0] + (2*newCloseUp))/3;//Last Bar Typical Price at high close
					double typDown = (High[0] + (2*newCloseDown))/3;//Last Bar Typical Price at low close
					///Sum of Typical Prices
					for (int i = (Period - 2); i >= 1; i--)
					{
						typUp += Typical[i];
						typDown += Typical[i];
							
					}
					newTypUp = typUp + (Low[0] + (2*newCloseUp))/3;
					newTypDown =typDown + (High[0] + (2*newCloseDown))/3;
					oldTypUp = typUp + Typical[n] ;
					oldTypDown = typDown + Typical[n];
					meanUp =  Math.Abs(Typical[n] - oldTypUp/Period);
					meanDown = Math.Abs(Typical[n] - oldTypDown/Period);
					meanUp += Math.Abs((Low[0] + (2*newCloseUp))/3 - oldTypUp/Period);
					meanDown += Math.Abs((High[0] + (2*newCloseDown))/3 - oldTypDown/Period);
					nMeanUp = Math.Abs(newCloseUp - newTypUp/Period);
					nMeanDown = Math.Abs(newCloseDown - newTypDown/Period);
					nMeanUp += Math.Abs((Low[0] + (2*newCloseUp))/3 - newTypUp/Period);
					nMeanDown += Math.Abs((High[0] + (2*newCloseDown))/3 - newTypDown/Period);
					for (int idx = ( Period - 2); idx >= 1; idx--)
					{
						meanUp += Math.Abs(Typical[idx] - oldTypUp/Period);
						meanDown += Math.Abs(Typical[idx] - oldTypDown/Period);
						nMeanUp += Math.Abs(Typical[idx] - newTypUp/Period);
						nMeanDown += Math.Abs(Typical[idx] - newTypDown/Period);
					}
				
					CCIup =((Low[0] + (2*newCloseUp))/3 - oldTypUp/Period) / (meanUp == 0 ? 1 : (0.015 * (meanUp / Period)));
					CCIdown =((High[0] + (2*newCloseDown))/3 - oldTypDown/Period) / (meanDown == 0 ? 1 : (0.015 * (meanDown / Period)));
//					newCCIup= (newCloseUp - newTypUp/Period) / (nMeanUp == 0 ? 1 : (0.015 * (nMeanUp / Period)));
//					newCCIdown= (newCloseDown - newTypDown/Period) / (nMeanDown == 0 ? 1 : (0.015 * (nMeanDown / Period)));			
					PlotCCILow.Set(CCIdown);
					PlotCCIHigh.Set(CCIup);
					
					if(ShowPredictorArrows == true)
					{
					DrawArrowUp("LowCCI",true, 0, CCIdown, Color.Maroon);
					DrawArrowDown("HighCCI",true, 0, CCIup, Color.DarkGreen);
					}
					else if (ShowPredictorDots == true)
					{
					DrawDot("LowCCI",false,0,CCIdown,Color.Maroon);
					DrawDot("HighCCI",false,0,CCIup,Color.DarkGreen);
					}

					if (FirstTickOfBar && !ShowPredictorHistory)
					{
					PlotCCILow.Reset(1);
					PlotCCIHigh.Reset(1);
					}
}
			#endregion

			if(Close[0] == Low[0])
			{
				wCCICloseAtSeries.Set(0);
			}
				else if(Close[0] == High[0])
			{
				wCCICloseAtSeries.Set(1);
			}
			
			#region ZLR
			sumchopzone3 = myWoodies.ChopZone[0] + myWoodies.ChopZone[1] + myWoodies.ChopZone[2];
			sumchopzone5 = sumchopzone3 + myWoodies.ChopZone[3] + myWoodies.ChopZone[4];
			sumchopzone6 = sumchopzone5 + myWoodies.ChopZone[5];
			sumchopzone7 = sumchopzone6 + myWoodies.ChopZone[6];
			sumchopzone8 = sumchopzone7 + myWoodies.ChopZone[7];
			zlrLong = 0;
			zlrShort = 0;
			//******* ZLR LONG ENTRY ******
			
			// Check for up trend, sidewinder must be neutral or trending and CCI can't be greater than 120
			if ((Trend == 1 && Direction == 1 && myWoodies.Sidewinder[0] >= 0 && myWoodies[0] - myWoodies[1] >= MinZLRPts)
				&& (sumchopzone3>=11 || sumchopzone5 >= 16 || sumchopzone6 >= 18 || sumchopzone7 >= 22 || sumchopzone8 >= 24)
				&& ((CCIup<=MaxSignalValue || (CCIdown>(myWoodies[1]+MinZLRPts) && CCIdown<=MaxSignalValue)) && myWoodies[0] <= MaxSignalValue && myWoodies[0] >= MinZLRValue))
			{
				zlrLong = 1;
				wCCIPatternSeries.Set(1);
				wCCIDirectionSeries.Set(1);
				if(Show_ZLR == true)
				{
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "Zero Line Reject Long", @AlertFile, alertInterval, Color.LimeGreen, Color.White);
					}
					if(CCIup<=MaxSignalValue)
					DrawLine(CurrentBar.ToString() + "ZLRL", 0,  myWoodies[0],0,0, Color.PaleGreen,DashStyle.Solid,4);
					else
					DrawLine(CurrentBar.ToString() + "ZLRL", 0,  myWoodies[0],0,0, Color.PaleGreen,DashStyle.Dash,4);
				}
			}
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "ZLRL");
			}
				
			//******* ZLR SHORT ENTRY *******
			
			if ((Trend == -1 && Direction == -1 && myWoodies.Sidewinder[0] >= 0 && myWoodies[1] - myWoodies[0] >= MinZLRPts)
				&& (sumchopzone3<=-11 || sumchopzone5 <= -16 || sumchopzone6 <= -18 || sumchopzone7 <= -22 || sumchopzone8 <= -24)
				&& ((CCIdown>=-MaxSignalValue || (CCIup<=(myWoodies[1]-MaxSignalValue) && CCIup>=-MaxSignalValue)) && myWoodies[0] >= -MaxSignalValue && myWoodies[0] <= -MinZLRValue))
			{
				zlrShort = 1;
				wCCIPatternSeries.Set(1);
				wCCIDirectionSeries.Set(-1);
				if(Show_ZLR == true)
				{
					if(soundAlert == true)
					{
						Alert(CurrentBar.ToString(), Priority.Medium, "Zero Line Reject Short", @AlertFile, alertInterval, Color.Red, Color.White);
					}
					if(CCIdown>=-MaxSignalValue)
					DrawLine(CurrentBar.ToString() + "ZLRS", 0,  myWoodies[0],0,0, Color.Pink,DashStyle.Solid,4);
					else
					DrawLine(CurrentBar.ToString() + "ZLRS", 0,  myWoodies[0],0,0, Color.Pink,DashStyle.Dash,4);
				}
			}
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "ZLRS");
			}
		
			#endregion

			#region Famir
				famirLong = 0;
				famirShort = 0;
				int HookL11=0;
				if( myWoodies[0]>myWoodies[1] 
					&& (myWoodies[0]>myWoodies[2] || (myWoodies[0]>0 && myWoodies[1]<0))
					&& myWoodies[2]>=myWoodies[1]+FamirHookMin
					&& myWoodies[2]>myWoodies[3]
					&& myWoodies[1]>-FamirLimits
					&& myWoodies[1]<FamirLimits
					&& myWoodies[2]>-FamirLimits
					&& myWoodies[2]<FamirLimits
					&& myWoodies[0]<=MaxSignalValue
					&& Close[0]>myWoodies.LinReg(25)[0]
					&& Trend==-1
					)
					 
				{
					HookL11=1;
				}
				  //******* HookL12
				
				int HookL12=0;
				
				if( myWoodies[0]>myWoodies[1]
					&& (myWoodies[0]>myWoodies[3] || (myWoodies[0]>0 && myWoodies[1]<0))
					&& myWoodies[1]>myWoodies[2]
					&& myWoodies[3]>myWoodies[1]
					&& myWoodies[3]>=myWoodies[2]+FamirHookMin
					&& myWoodies[3]>myWoodies[4]
					&& myWoodies[2]>-FamirLimits
					&& myWoodies[2]<FamirLimits
					&& myWoodies[3]>-FamirLimits
					&& myWoodies[3]<FamirLimits
					&& myWoodies[0]<=MaxSignalValue
					&& Close[0]>myWoodies.LinReg(25)[0]
					&& Trend==-1
					)	
				{
					HookL12=1;
				}	
				 //******** HookL21
				
				int HookL21=0;
				
				if( myWoodies[0]>myWoodies[1]
					&& (myWoodies[0]>myWoodies[3] || (myWoodies[0]>0 && myWoodies[1]<0))
					&& myWoodies[2]>myWoodies[1]
					&& myWoodies[3]>myWoodies[2]
					&& myWoodies[3]>=myWoodies[1]+FamirHookMin
					&& myWoodies[3]>myWoodies[4]
					&& myWoodies[1]>-FamirLimits
					&& myWoodies[1]<FamirLimits
					&& myWoodies[3]>-FamirLimits
					&& myWoodies[3]<FamirLimits
					&& myWoodies[0]<=MaxSignalValue
					&& Close[0]>myWoodies.LinReg(25)[0]
					&& Trend==-1
					)
				{
					HookL21=1;
				}
				 //***********HookL22
					int HookL22=0;
				
				if( myWoodies[0]>myWoodies[1]
					&& (myWoodies[0]>myWoodies[4] || (myWoodies[0]>0 && myWoodies[1]<0))
					&& myWoodies[1]>myWoodies[2]
					&& myWoodies[3]>myWoodies[2]
					&& myWoodies[4]>myWoodies[3]
					&& myWoodies[4]>myWoodies[1]
					&& myWoodies[4]>=myWoodies[2]+FamirHookMin
					&& myWoodies[4]>myWoodies[5]
					&& myWoodies[2]>-FamirLimits
					&& myWoodies[2]<FamirLimits
					&& myWoodies[4]>-FamirLimits
					&& myWoodies[4]<FamirLimits
					&& myWoodies[0]<=MaxSignalValue
					&& Close[0]>myWoodies.LinReg(25)[0]
					&& Trend==-1
					)
				{
					HookL22=1;
				}
				//**************************ENTRIES SHORT*********
				// *************HOOKS11
				
					int HookS11=0;
				if( myWoodies[0]<myWoodies[1]
					&& (myWoodies[0]<myWoodies[2] || (myWoodies[0]<0 && myWoodies[1]>0))
					&& myWoodies[2]<=myWoodies[1]-FamirHookMin
					&& myWoodies[2]<myWoodies[1]
					&& myWoodies[2]<myWoodies[3]
					&& myWoodies[1]>-FamirLimits
					&& myWoodies[1]<FamirLimits
					&& myWoodies[2]>-FamirLimits
					&& myWoodies[2]<FamirLimits
					&& myWoodies[0]>=-MaxSignalValue
					&& Close[0]< myWoodies.LinReg(25)[0]
					&& Trend==1
					)	
				{
					HookS11=1;

					}	
				
				   //******* HookS12
				
				int HookS12=0;
				
				if( myWoodies[0]<myWoodies[1]
					&& (myWoodies[0]<myWoodies[3] || (myWoodies[0]<0 && myWoodies[1]>0))
					&& myWoodies[1]<myWoodies[2]
					&& myWoodies[3]<=myWoodies[2]-FamirHookMin
					&& myWoodies[3]<myWoodies[4]
					&& myWoodies[3]<myWoodies[1]
					&& myWoodies[2]>-FamirLimits
					&& myWoodies[2]<FamirLimits
					&& myWoodies[3]>-FamirLimits
					&& myWoodies[3]<FamirLimits
					&& myWoodies[0]>=-MaxSignalValue
					&& Close[0]<myWoodies.LinReg(25)[0]
					&& Trend==1
					)
				{
					HookS12=1;
				}	
				
				 //******** HookS21
				
				int HookS21=0;
				
				if( myWoodies[0]<myWoodies[1]
					&& (myWoodies[0]<myWoodies[3] || (myWoodies[0]<0 && myWoodies[1]>0))
					&& myWoodies[2]<myWoodies[1]
					&& myWoodies[3]<myWoodies[4]
					&& myWoodies[3]<myWoodies[2]
					&& myWoodies[3]<=myWoodies[1]-FamirHookMin
					&& myWoodies[1]>-FamirLimits
					&& myWoodies[1]<FamirLimits
					&& myWoodies[3]>-FamirLimits
					&& myWoodies[3]<FamirLimits
					&& myWoodies[0]>=-MaxSignalValue
					&& Close[0]<myWoodies.LinReg(25)[0]
					&& Trend==1
					)
				{
					HookS21=1;
				}
				
				   //***********HookS22
					int HookS22=0;
				
				if( myWoodies[0]<myWoodies[1]
					&& (myWoodies[0]<myWoodies[4] || (myWoodies[0]<0 && myWoodies[1]>0))
					&& myWoodies[1]<myWoodies[2]
					&& myWoodies[3]<myWoodies[2]
					&& myWoodies[4]<myWoodies[3]
					&& myWoodies[4]<myWoodies[5]
					&& myWoodies[4]<myWoodies[1]
					&& myWoodies[4]<=myWoodies[2]-FamirHookMin
					&& myWoodies[2]>-FamirLimits
					&& myWoodies[2]<FamirLimits
					&& myWoodies[4]>-FamirLimits
					&& myWoodies[4]<FamirLimits
					&& myWoodies[0]>=-MaxSignalValue
					&& Close[0]<myWoodies.LinReg(25)[0]
					&& Trend==1
					)
				{
					HookS22=1;
				}
				
				//********************** ENTRIES
				if(CurrentBar<20)
					return;
					
				if(HookL11==1||HookL21==1||HookL12==1||HookL22==1)		
				{
					famirLong = 1;
					wCCIPatternSeries.Set(2);
					wCCIDirectionSeries.Set(1);
					if(Show_Famir == true)
					{
						if(SoundAlert==true)
						{
							Alert(CurrentBar.ToString() + "FAMIRL", Priority.Medium, "Famir Long", @AlertFile, alertInterval, Color.LimeGreen, Color.White);
						}
						DrawDiamond(CurrentBar.ToString() + "FAMIRL", true, 0,  -FamirLimits, Color.LimeGreen);
						DrawText(CurrentBar.ToString() + "FAMIRLTEXT","F",0,-FamirLimits-25,Color.LimeGreen);
					}
				}	
				else
				{	RemoveDrawObject(CurrentBar.ToString() + "FAMIRL");
					RemoveDrawObject(CurrentBar.ToString() + "FAMIRLTEXT");
				}

				if(HookS11==1||HookS12==1||HookS21==1||HookS22==1)	
				{
					famirShort = 1;
					wCCIPatternSeries.Set(2);
					wCCIDirectionSeries.Set(-1);
					if(Show_Famir == true)
					{
						if(SoundAlert==true)
						{
							Alert(CurrentBar.ToString() + "FAMIRS", Priority.Medium, "Famir Short", @AlertFile, alertInterval, Color.Red, Color.White);
						}
						DrawDiamond(CurrentBar.ToString() + "FAMIRS", true, 0,  FamirLimits, Color.Red);
						DrawText(CurrentBar.ToString() + "FAMIRSTEXT","F",0,FamirLimits+25,Color.Red);
					}
				}	
				else
				{	RemoveDrawObject(CurrentBar.ToString() + "FAMIRS");
					RemoveDrawObject(CurrentBar.ToString() + "FAMIRSTEXT");
				}
			#endregion
				
			#region Vegas
				vtLong = 0;
				vtShort = 0;

			//VT Long
			if (BarsAgoExtremeXup < 23 
			&& (swingHigh > -RejectLevel && swingHigh < 0)
			&& myWoodies[2] < swingHigh 
			&& myWoodies[1] < swingHigh 
			&& myWoodies[0] > swingHigh
			&& Close[0]>myWoodies.LinReg(25)[0]
			&& barsAgoSwingH < 11
			&& barsAgoSwingH >= 4
			&& myWoodies[0]<=MaxSignalValue
			&& myWoodies[1]<0)
			{
				vtLong = 1;
				wCCIPatternSeries.Set(3);
				wCCIDirectionSeries.Set(1);
			}
			
			//VT Short
			if (BarsAgoExtremeXdown < 23 
			&& (swingLow < RejectLevel && swingLow > 0)
			&& myWoodies[2] > swingLow 
			&& myWoodies[1] > swingLow 
			&& myWoodies[0] < swingLow
			&& Close[0] < myWoodies.LinReg(25)[0]
			&& barsAgoSwingL < 11
			&& barsAgoSwingL >= 4
			&& myWoodies[0]>=-MaxSignalValue
			&& myWoodies[1]>0)
			{
				vtShort = 1;
				wCCIPatternSeries.Set(3);
				wCCIDirectionSeries.Set(-1);
			}
			
				if(CurrentBar<20)
					return;
					
				if(vtLong == 1 && Show_Vegas == true)		
				{
					if(SoundAlert==true)
					{
						Alert(CurrentBar.ToString() + "VTL", Priority.Medium, "Vegas Long", @AlertFile, alertInterval, Color.LimeGreen, Color.White);
					}
					DrawTriangleUp(CurrentBar.ToString() + "VTL", true, 0,  -50, Color.LimeGreen);
					DrawText(CurrentBar.ToString() + "VTLTEXT","V",0,-75,Color.LimeGreen);
					//break;
				}	
				else
				{	RemoveDrawObject(CurrentBar.ToString() + "VTL");
					RemoveDrawObject(CurrentBar.ToString() + "VTLTEXT");
				}	
					
				if(vtShort==1 && Show_Vegas == true)	
				{
					if(SoundAlert==true)
					{
						Alert(CurrentBar.ToString() + "VTS", Priority.Medium, "Vegas Short", @AlertFile, alertInterval, Color.Red, Color.White);
					}
					DrawTriangleDown(CurrentBar.ToString() + "VTS", true, 0,  50, Color.Red);
					DrawText(CurrentBar.ToString() + "VTSTEXT","V",0,75,Color.Red);
					//break;
				}	
				else
				{	RemoveDrawObject(CurrentBar.ToString() + "VTS");
					RemoveDrawObject(CurrentBar.ToString() + "VTSTEXT");
				}

			#endregion

			#region GB100
			gbLong = 0;
			gbShort = 0;
			if(
				trendcountL >= TrendLength
				&& BarsAgo_0Xdown < 6
				&& BarsAgo_n100Xup < BarsAgo_0Xdown//Crossed below -100 since it crossed below 0
				&& myWoodies[0] > -100 && myWoodies[1] < -100
				&& myWoodies.ChopZone[0] == 4
				&& myWoodies[0]<=MaxSignalValue
				)
			{
				gbLong = 1;
				wCCIPatternSeries.Set(4);
				wCCIDirectionSeries.Set(1);
			}

			if(
				trendcountS >= TrendLength
				&& BarsAgo_0Xup < 6
				&& BarsAgo_100Xdown < BarsAgo_0Xup
				&& myWoodies[0] < 100 && myWoodies[1] > 100
				&& myWoodies.ChopZone[0] == -4
				&& myWoodies[0]>=-MaxSignalValue
				)
			{
				gbShort = 1;
				wCCIPatternSeries.Set(4);
				wCCIDirectionSeries.Set(-1);
			}
			
			if(CurrentBar<20)
				return;
				
			if(gbLong == 1 && Show_GB100 == true)		
			{
				if(SoundAlert==true)
				{
					Alert(CurrentBar.ToString() + "GBL", Priority.Medium, "GB100 Long", @AlertFile, alertInterval, Color.LimeGreen, Color.White);
				}
				DrawLine(CurrentBar.ToString() + "GBL", 0,  200,0,-200, Color.PaleGreen,DashStyle.Dash,4);
				//break;
			}	
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "GBL");
			}
				
			if(gbShort==1 && Show_GB100 == true)	
			{
				if(SoundAlert==true)
				{
					Alert(CurrentBar.ToString() + "GBS", Priority.Medium, "GB100 Short", @AlertFile, alertInterval, Color.Red, Color.White);
				}
				DrawLine(CurrentBar.ToString() + "GBS", 0,  200,0,-200, Color.Pink,DashStyle.Dash,4);
				//break;
			}	
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "GBS");
			}
			
			#endregion
			
			#region Tony
			tonyLong = 0;
			tonyShort = 0;
			if(Trend == 1
			&& Direction == 1
			&& BarsAgo_0Xdown < 10
			&& BarsAgo_0Xdown > 4
			&& BarsAgo_0Xup == 1
			&& BarsAgo_n100Xup >= BarsAgo_0Xdown//Crossed below -100 since it crossed below 0
			&& myWoodies[0] > 0
			&& myWoodies[0]<=MaxSignalValue
)
			{
				tonyLong = 1;
				wCCIPatternSeries.Set(5);
				wCCIDirectionSeries.Set(1);
			}

			if(Trend==-1
			&& Direction == -1
			&& BarsAgo_0Xup < 10
			&& BarsAgo_0Xup > 4
			&& BarsAgo_0Xdown == 1
			&& BarsAgo_100Xdown >= BarsAgo_0Xup
			&& myWoodies[0] < 0
			&& myWoodies[0]>=-MaxSignalValue
)
			{
				tonyShort = 1;
				wCCIPatternSeries.Set(5);
				wCCIDirectionSeries.Set(-1);
			}
			
			if(tonyLong == 1 && Show_Tony == true)		
			{
				if(SoundAlert==true)
				{
					Alert(CurrentBar.ToString() + "TONYL", Priority.Medium, "TONY Long", @AlertFile, alertInterval, Color.LimeGreen, Color.White);
				}
				DrawRectangle(CurrentBar.ToString() + "TONYL", 1, 50,0,-10, Color.PaleGreen, Color.PaleGreen,3);
				DrawText(CurrentBar.ToString() + "TONYLTEXT","T",0,75,Color.PaleGreen);
				//break;
			}	
			else
			{	RemoveDrawObject(CurrentBar.ToString() + "TONYL");
				RemoveDrawObject(CurrentBar.ToString() + "TONYLTEXT");
			}	
				
			if(tonyShort==1 && Show_Tony == true)	
			{
				if(SoundAlert==true)
				{
					Alert(CurrentBar.ToString() + "TONYS", Priority.Medium, "TONY Short", @AlertFile, alertInterval, Color.Red, Color.White);
				}
				DrawRectangle(CurrentBar.ToString() + "TONYS", 1, -50,0,10, Color.Pink,Color.Pink,3);
				DrawText(CurrentBar.ToString() + "TONYSTEXT","T",0,-75,Color.Pink);
				//break;
			}	
			else
			{	RemoveDrawObject(CurrentBar.ToString() + "TONYS");
				RemoveDrawObject(CurrentBar.ToString() + "TONYSTEXT");
			}
			#endregion
			
			#region Ghosts
			gstLong = 0;
			gstShort = 0;
			double gstLeftPk = 0;
			double gstMiddlePk = 0;
			double gstRightPk = 0;
			double gstLeftLow = 0;
			double gstRightLow = 0;
			int gstLeftPkBars = 0;
			int gstMiddlePkBars = 0;
			int gstRightPkBars = 0;
			int gstLeftLowBars = 0;
			int gstRightLowBars = 0;
			int lbPeriodup = BarsAgo_0Xup;
			int lbPerioddown = BarsAgo_0Xdown;
			double gstChangePerBar;
			bool gstTrendBrkShort;
			bool gstTrendBrkLong;

			ZigZag gstZigPoints = ZigZag(myWoodies,DeviationType.Points,UsePointsAmount,false);
			ZigZag gstZigPercent = ZigZag(myWoodies,DeviationType.Percent,UsePointsAmount,false);

			if(myWoodies[1]>0 && UsePoints == "Points")//Ghost Short
			{
				//How many bars since peaks
				gstLeftPkBars = gstZigPoints.HighBar(0,3,BarsAgo_0Xup);
				gstMiddlePkBars = gstZigPoints.HighBar(0,2,BarsAgo_0Xup);
				gstRightPkBars = gstZigPoints.HighBar(0,1,BarsAgo_0Xup);
				//How many bars since troughs
				gstLeftLowBars = gstZigPoints.LowBar(0,2,BarsAgo_0Xup);
				gstRightLowBars = gstZigPoints.LowBar(0,1,BarsAgo_0Xup);
				//Get Peak Values
				gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);
				gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
				gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
				//Get trough values
				gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
				gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
			}
			if(myWoodies[1]<0 && UsePoints == "Points")//Ghost Long
			{
				//How many bars since peaks
				gstLeftPkBars = gstZigPoints.LowBar(0,3,BarsAgo_0Xdown);
				gstMiddlePkBars = gstZigPoints.LowBar(0,2,BarsAgo_0Xdown);
				gstRightPkBars = gstZigPoints.LowBar(0,1,BarsAgo_0Xdown);
				//How many bars since troughs
				gstLeftLowBars = gstZigPoints.HighBar(0,2,BarsAgo_0Xdown);
				gstRightLowBars = gstZigPoints.HighBar(0,1,BarsAgo_0Xdown);
				//Get Peak Values
				gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);//(0,3,Math.Max(5,BarsAgo_0Xdown)));
				gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
				gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
				//Get trough values
				gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
				gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
			}	
			if(myWoodies[1]>0 && UsePoints == "Percent")//Ghost Short
			{
				//How many bars since peaks
				gstLeftPkBars = gstZigPercent.HighBar(0,3,BarsAgo_0Xup);
				gstMiddlePkBars = gstZigPercent.HighBar(0,2,BarsAgo_0Xup);
				gstRightPkBars = gstZigPercent.HighBar(0,1,BarsAgo_0Xup);
				//How many bars since troughs
				gstLeftLowBars = gstZigPercent.LowBar(0,2,BarsAgo_0Xup);
				gstRightLowBars = gstZigPercent.LowBar(0,1,BarsAgo_0Xup);
				//Get Peak Values
				gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);
				gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
				gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
				//Get trough values
				gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
				gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
			}
			if(myWoodies[1]<0 && UsePoints == "Percent")//Ghost Long
			{
				//How many bars since peaks
				gstLeftPkBars = gstZigPercent.LowBar(0,3,BarsAgo_0Xdown);
				gstMiddlePkBars = gstZigPercent.LowBar(0,2,BarsAgo_0Xdown);
				gstRightPkBars = gstZigPercent.LowBar(0,1,BarsAgo_0Xdown);
				//How many bars since troughs
				gstLeftLowBars = gstZigPercent.HighBar(0,2,BarsAgo_0Xdown);
				gstRightLowBars = gstZigPercent.HighBar(0,1,BarsAgo_0Xdown);
				//Get Peak Values
				gstLeftPk = Math.Abs(myWoodies[Math.Max(5,gstLeftPkBars)]);
				gstMiddlePk = Math.Abs(myWoodies[Math.Max(3,gstMiddlePkBars)]);
				gstRightPk = Math.Abs(myWoodies[Math.Max(0,gstRightPkBars)]);
				//Get trough values
				gstLeftLow = Math.Abs(myWoodies[Math.Max(4,gstLeftLowBars)]);
				gstRightLow = Math.Abs(myWoodies[Math.Max(1,gstRightLowBars)]);
			}
			//Reset Right Peak if on first bar after what will become a new peak.
			if(gstRightLowBars<gstRightPkBars)
			{
				if(UsePoints == "Points")
				{
					if(Math.Abs(myWoodies[0])<= (Math.Abs(myWoodies[1])-UsePointsAmount))
					{
						gstLeftPk = gstMiddlePk;
						gstLeftPkBars = gstMiddlePkBars;
						gstMiddlePk = gstRightPk;
						gstMiddlePkBars = gstRightPkBars;
						gstRightPk = Math.Abs(myWoodies[1]);
						gstRightPkBars = 1;
					}
				}
					else if(Math.Abs(myWoodies[0])<= (Math.Abs(myWoodies[1])*((100-UsePointsAmount)/100)))
					{
						gstLeftPk = gstMiddlePk;
						gstLeftPkBars = gstMiddlePkBars;
						gstMiddlePk = gstRightPk;
						gstMiddlePkBars = gstRightPkBars;
						gstRightPk = Math.Abs(myWoodies[1]);
						gstRightPkBars = 1;
					}
				
			}
			
				gstChangePerBar = (gstRightLow-gstLeftLow)/(gstLeftLowBars-gstRightLowBars);//What is the slope of the trend line per bar
				gstTrendBrkShort = myWoodies[0]<(gstLeftLow+(gstLeftLowBars*gstChangePerBar))
					&& myWoodies[1]>(gstLeftLow+((gstLeftLowBars-1)*gstChangePerBar)) 
					&& myWoodies[1]>0;//Has there been a trend line break?
				gstTrendBrkLong = (Math.Abs(myWoodies[0])<(gstLeftLow+(gstLeftLowBars*gstChangePerBar))
					&& Math.Abs(myWoodies[1])>(gstLeftLow+((gstLeftLowBars-1)*gstChangePerBar))
					&& myWoodies[0]<0)
				|| (Math.Abs(myWoodies[1])>(gstLeftLow+(gstLeftLowBars*gstChangePerBar)) && myWoodies[0] > 0 && myWoodies[1] < 0);//Has there been a trend line break?

/*				DrawText(CurrentBar.ToString() + "GHOSTLTEXT0",BarsAgo_0Xup.ToString(),0,-20,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT",gstLeftPk.ToString("###.#"),0,-70,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT1",Math.Max(0,gstLeftPkBars).ToString(),0,-95,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT2",gstMiddlePk.ToString("###.#"),0,-120,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT3",Math.Max(0,gstMiddlePkBars).ToString(),0,-145,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT4",gstRightPk.ToString("###.#"),0,-170,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT5",Math.Max(0,gstRightPkBars).ToString(),0,-195,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT6",gstLeftLow.ToString("###.#"),0,120,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT7",Math.Max(0,gstLeftLowBars).ToString(),0,130,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT8",gstRightLow.ToString("###.#"),0,150,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "GHOSTLTEXT9",Math.Max(0,gstRightLowBars).ToString(),0,160,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "Slope",gstChangePerBar.ToString("##.#"),0,185,Color.PaleGreen);
				DrawText(CurrentBar.ToString() + "ShBreak",(gstLeftLow+(gstLeftLowBars*gstChangePerBar)).ToString("##.#"),0,210,Color.PaleGreen);
*/			
			
			//Ghosts Long
			if(((gstLeftPk < gstMiddlePk && gstRightPk < gstMiddlePk) || (gstLeftPk > gstMiddlePk && gstRightPk > gstMiddlePk))
				&& gstTrendBrkLong && BarsAgo_0Xdown>gstLeftPkBars && gstLeftPkBars != -1 && gstMiddlePkBars != -1 && gstRightPkBars != -1
				&& gstMiddlePkBars<gstLeftLowBars && gstRightPkBars<gstRightLowBars	&& myWoodies[0]<=MaxSignalValue
				 && Show_Ghost == true)
			{
				DrawText(CurrentBar.ToString() + "GHOSTTEXT","G",0,myWoodies[0]-30,Color.PaleGreen);
				if(ShowGhostPeaks==true)
				{
					DrawText(CurrentBar.ToString() + "GHOST1","p1",gstLeftPkBars,-gstLeftPk-10,Color.Yellow);
					DrawText(CurrentBar.ToString() + "GHOST2","p2",gstMiddlePkBars,-gstMiddlePk-10,Color.Yellow);
					DrawText(CurrentBar.ToString() + "GHOST3","p3",gstRightPkBars,-gstRightPk-10,Color.Yellow);
					DrawLine(CurrentBar.ToString() + "GTrend", gstLeftLowBars,-gstLeftLow,0,-(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
				}
				if(SoundAlert==true)
				{
					Alert(CurrentBar.ToString() + "Ghost", Priority.Medium, "GHOST Long", @AlertFile, alertInterval, Color.LimeGreen, Color.White);
				}

//				DrawText(CurrentBar.ToString() + "GHOSTLL1","L1",gstLeftLowBars,-gstLeftLow+10,Color.Yellow);
//				DrawText(CurrentBar.ToString() + "GHOSTLL3","L2",gstRightLowBars,-gstRightLow+10,Color.Yellow);
//				if(myWoodies[0]<0)

				gstLong = 1;
				wCCIPatternSeries.Set(6);
				wCCIDirectionSeries.Set(1);
			}
			else
			//Ghosts Short
			if(((gstLeftPk < gstMiddlePk && gstRightPk < gstMiddlePk) || (gstLeftPk > gstMiddlePk && gstRightPk > gstMiddlePk))
				&& gstTrendBrkShort ==true && BarsAgo_0Xup>gstLeftPkBars && gstLeftPkBars != -1 && gstMiddlePkBars != -1 && gstRightPkBars != -1
				&& gstMiddlePkBars<gstLeftLowBars && gstRightPkBars<gstRightLowBars	&& myWoodies[0]>=-MaxSignalValue
				 && Show_Ghost == true)
			{
				DrawText(CurrentBar.ToString() + "GHOSTTEXT","G",0,myWoodies[0]+30,Color.Red);
				if(ShowGhostPeaks==true)
				{
					DrawText(CurrentBar.ToString() + "GHOST1","p1",gstLeftPkBars,gstLeftPk+10,Color.Yellow);
					DrawText(CurrentBar.ToString() + "GHOST2","p2",gstMiddlePkBars,gstMiddlePk+10,Color.Yellow);
					DrawText(CurrentBar.ToString() + "GHOST3","p3",gstRightPkBars,gstRightPk+10,Color.Yellow);
					DrawLine(CurrentBar.ToString() + "GTrend", gstLeftLowBars,gstLeftLow,0,(gstLeftLow+(gstLeftLowBars*gstChangePerBar)),GstTrendColor,DashStyle.Dash,1);
				}
				if(SoundAlert==true)
				{
					Alert(CurrentBar.ToString() + "Ghost", Priority.Medium, "GHOST Short", @AlertFile, alertInterval, Color.LimeGreen, Color.White);
				}
//				DrawText(CurrentBar.ToString() + "GHOSTLL1","L1",gstLeftLowBars,gstLeftLow-10,Color.Yellow);
//				DrawText(CurrentBar.ToString() + "GHOSTLL3","L2",gstRightLowBars,gstRightLow-10,Color.Yellow);
//				if(myWoodies[0]>0)
				gstShort = 1;
				wCCIPatternSeries.Set(6);
				wCCIDirectionSeries.Set(-1);
			}
			else
			{
				RemoveDrawObject(CurrentBar.ToString() + "GHOSTTEXT");
				RemoveDrawObject(CurrentBar.ToString() + "GHOST1");
				RemoveDrawObject(CurrentBar.ToString() + "GHOST2");
				RemoveDrawObject(CurrentBar.ToString() + "GHOST3");
				RemoveDrawObject(CurrentBar.ToString() + "GTrend");
			}
			#endregion
			
			#region Draw Momentum Change Exits
			if(ShowMomoChange == true)
			{
				int BarsAgoLongPattern	= MRO(delegate{return (WCCIPattern[0] > 0 && WCCIDirection[0] >0);},1,CurrentBar);
				int BarsAgoShortPattern	= MRO(delegate{return (WCCIPattern[0] > 0 && WCCIDirection[0] <0);},1,CurrentBar);
				bool LongMomoChange = (myWoodies[0]<=myWoodies[Math.Min(CurrentBar, 1)] && Open[0] >=Close[0]);
				bool ShortMomoChange = (myWoodies[0]>=myWoodies[Math.Min(CurrentBar, 1)] && Open[0] <=Close[0]);

				if(LongMomoChange && (BarsAgo_100Xdown==1 ? Open[0] >=Close[0] : BarsAgo_100Xdown > BarsAgoLongPattern) 
					&& MIN(Low,BarsAgoLongPattern)[0] > Close[BarsAgoLongPattern]-(Bars.Period.Value*TickSize)
					&& BarsAgoShortPattern>BarsAgoLongPattern)
				{	
					DrawArrowLine(CurrentBar.ToString()+"momol",true,0,250,0,210,Color.Red,DashStyle.Dash,2);
					if(SoundMomoAlert) Alert(CurrentBar.ToString() + "momoalert1", Priority.Medium, "Momo Change long", "Alert2.wav", alertInterval, Color.LimeGreen, Color.White);

				}
				else if(ShortMomoChange && (BarsAgo_n100Xup==1 ? Open[0] <=Close[0] : BarsAgo_n100Xup > BarsAgoShortPattern) 
					&& MAX(High,BarsAgoShortPattern)[0] < Close[BarsAgoShortPattern]+(Bars.Period.Value*TickSize)
					&& BarsAgoShortPattern<BarsAgoLongPattern)
				{	
					DrawArrowLine(CurrentBar.ToString()+"momos",true,0,-250,0,-210,Color.Lime,DashStyle.Dash,2);
					if(SoundMomoAlert) Alert(CurrentBar.ToString() + "momoalert2", Priority.Medium, "Momo Change short", "Alert2.wav", alertInterval, Color.LimeGreen, Color.White);
				}
//				DrawText(CurrentBar.ToString() + "momoTEXT0",BarsAgo_100Xdown.ToString(),0,-20,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT4",BarsAgo_n100Xup.ToString(),0,-20,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT",BarsAgoLongPattern.ToString(),0,-70,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT1",BarsAgoShortPattern.ToString(),0,-95,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "momoLTEXT2",MIN(Low,BarsAgoLongPattern+1)[0].ToString("###.##"),0,-120,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "GHOSTLTEXT2",MAX(High,BarsAgoShortPattern+1)[0].ToString("###.##"),0,-120,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "GHOSTLTEXT3",Close[BarsAgoLongPattern].ToString("###.##"),0,-145,Color.PaleGreen);
//				DrawText(CurrentBar.ToString() + "GHOSTLTEXT3",Close[BarsAgoShortPattern].ToString("###.##"),0,-145,Color.PaleGreen);
			

			}
			#endregion
		}

			#region Properties
					
				[Description("CCI must go below this value before a ZLR or Vegas can be signaled")]
				[Category("Parameters")]
				public double RejectLevel
				{
					get { return rejectLevel; }
					set { rejectLevel = Math.Max(0, Math.Min(100, value)); }
				}
				
				[Description("Number of bars for a trend to be in place for GB100 trades to trigger")]
				[Category("Parameters")]
				public int TrendLength
				{
					get { return trendLength; }
					set { trendLength = value; }
				}
				
				[Description("Minimum CCI point change between ghost peaks and valleys")]
				[Category("Parameters")]
				public double UsePointsAmount
				{
					get { return usePointsAmount; }
					set { usePointsAmount = Math.Max(0, Math.Max(1, value)); }
				}
				
				[Description("Type of ZigZag deviation (Points or Percent)")]
				[Category("Parameters")]
				public string UsePoints
				{
					get { return usePoints; }
					set { if((value == "Points") || (value == "Percent"))
							{ usePoints = value;  }
						}
				}

				[Description("CCI must close above this value before before it is considered to have 'gone to extremes'")]
				[Category("Parameters")]
				public double Extremes
				{
					get { return extremes; }
					set { extremes = Math.Max(175, Math.Min(250, value)); }
				}
		
				[Description("Famir minimum CCI hook points (default = 3)")]
				[Category("Parameters")]
				public double FamirHookMin
				{
					get { return famirHookMin; }
					set { famirHookMin = Math.Max(0, Math.Min(10, value)); }
				}
		
				[Description("Famir CCI boundaries (default = 50)")]
				[Category("Parameters")]
				public double FamirLimits
				{
					get { return famirLimits; }
					set { famirLimits = Math.Max(0, Math.Min(100, value)); }
				}
				
				[Description("Minimum CCI point change before a ZLR can be signaled")]
				[Category("Parameters")]
				public double MinZLRPts
				{
					get { return minZLRPts; }
					set { minZLRPts = Math.Max(0, Math.Min(75, value)); }
				}

				[Description("Maximum CCI value for a ZLR to be signaled")]
				[Category("Parameters")]
				public double MaxSignalValue
				{
					get { return maxSignalValue; }
					set { maxSignalValue = Math.Max(75, Math.Min(200, value)); }
				}

				[Description("Minimum CCI value for a ZLR to be signaled")]
				[Category("Parameters")]
				public double MinZLRValue
				{
					get { return minZLRValue; }
					set { minZLRValue = Math.Max(1, Math.Min(100, value)); }
				}

				[Description("Numbers of bars used for calculations")]
				[Category("CCI Predictor")]
				public int Period
				{
					get { return period; }
					set { period = Math.Max(1, value); }
				}
				
				[Description("Show CCI predictor on chart as ARROWS?  This will take precedence over the dots.")]
				[Category("CCI Predictor")]
				public bool ShowPredictorArrows
				{
					get { return showPredictorArrows; }
					set { showPredictorArrows = value; }
				}
				
				[Description("Show CCI predictor on chart as DOTS?  Turn arrows off to see the dots.")]
				[Category("CCI Predictor")]
				public bool ShowPredictorDots
				{
					get { return showPredictorDots; }
					set { showPredictorDots = value; }
				}
				
				[Description("Show CCI predictor historical dots on chart?")]
				[Category("CCI Predictor")]
				public bool ShowPredictorHistory
				{
				get { return showPredictorHistory; }
				set { showPredictorHistory = value; }
				}
				
				[Description("How often do you want the alert to sound?")]
				[Category("Sound and Display")]
				public int AlertInterval
				{
					get { return alertInterval; }
					set { alertInterval = value; }
				}
		
				[Description("Where is the alert sound file located?  File name of .wav file to play. Provide either the absolute file path or just the name if the file is located in NinjaTrader Installation Folder sounds folder")]
				[Category("Sound and Display")]
				public string AlertFile
				{
					get { return alertFile; }
					set { alertFile = value; }
				}

				[Description("Sound an alert when a CCI Pattern is signaled")]
				[Category("Sound and Display")]
				public bool SoundAlert
				{
					get { return soundAlert; }
					set { soundAlert = value; }
				}
				
				[Description("Sound an alert when a Momentum Reversal is signaled")]
				[Category("Sound and Display")]
				public bool SoundMomoAlert
				{
					get { return soundMomoAlert; }
					set { soundMomoAlert = value; }
				}
				
				[Description("Display the +/- Famir Limit lines?")]
				[Category("Sound and Display")]
				public bool ShowFamirLimits
				{
					get { return showFamirLimits; }
					set { showFamirLimits = value; }
				}

				[Description("Display the +/- 120 lines?")]
				[Category("Sound and Display")]
				public bool ShowOneTwenty
				{
					get { return showOneTwenty; }
					set { showOneTwenty = value; }
				}
				
				[Description("Display the +/- 120 lines?")]
				[Category("Sound and Display")]
				public bool ShowGhostPeaks
				{
					get { return showGhostPeaks; }
					set { showGhostPeaks = value; }
				}				
				
				[Description("Display the Momentum Change Exit Points?")]
				[Category("Sound and Display")]
				public bool ShowMomoChange
				{
					get { return showMomoChange; }
					set { showMomoChange = value; }
				}				
				
				[Description("Numbers of bars back to extend 120 and Famir limits lines")]
				[Category("Sound and Display")]
				public int LineExtension
				{
					get { return lineExtension; }
					set { lineExtension = Math.Max(1, value); }
				}
				
				[XmlIgnore()]
				[Description("Color for Famir Limits")]
				[Category("Sound and Display")]
				public Color FamirLimitsColor
				{
					get { return famirLimitsColor; }
					set { famirLimitsColor = value; }
				}
				
				[XmlIgnore()]
				[Description("Color for 120 lines")]
				[Category("Sound and Display")]
				public Color OneTwentyColor
				{
					get { return oneTwentyColor; }
					set { oneTwentyColor = value; }
				}
				
				[XmlIgnore()]
				[Description("Color for ghost trend lines")]
				[Category("Sound and Display")]
				public Color GstTrendColor
				{
					get { return gstTrendColor; }
					set { gstTrendColor = value; }
				}
				
				[Description("Rectangle value above and below 0 line.")]
				[Category("Sound and Display")]
				public int Rect1
				{
					get { return rect1; }
					set { rect1 = value; }
				}
				
				[XmlIgnore()]
				[Description("Color for rectangle")]
				[Category("Sound and Display")]
				public Color Rect1Color
				{
					get { return rect1Color; }
					set { rect1Color = value; }
				}
				
				[Description("Display rectangle?")]
				[Category("Sound and Display")]
				public bool ShowRect1
				{
					get { return showRect1; }
					set { showRect1 = value; }
				}

				[Description("Rectangle transparency (0 = clear, 10 = opaque)?")]
				[Category("Sound and Display")]
				public int Rect1Transparency
				{
					get { return rect1Transparency; }
					set { rect1Transparency  = Math.Max(0, Math.Min(10, value)); }
				}

				[Browsable(false)]
				public string FamirLimitsColorSerialize
				{
					get { return NinjaTrader.Gui.Design.SerializableColor.ToString(famirLimitsColor); }
					set { famirLimitsColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
				}

				[Browsable(false)]
				public string OneTwentyColorSerialize
				{
					get { return NinjaTrader.Gui.Design.SerializableColor.ToString(oneTwentyColor); }
					set { oneTwentyColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
				}
// Data Series
				[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
				[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
				public DataSeries PlotCCIHigh
				{
					get { return Values[0]; }
				}
	
				[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
				[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
				public DataSeries PlotCCILow
				{
					get { return Values[1]; }
				}
				
				[Browsable(false)]
				[XmlIgnore()]
				[Description("Woodies Pattern, ZLR, FAM, VT, GB, TT, GST")]
				public DataSeries WCCIPattern
				{
					get { Update();
					return wCCIPatternSeries; }
				}
	
				[Browsable(false)]
				[XmlIgnore()]
				[Description("Direction of the trade (1 = Long, -1 = Short")]
				public DataSeries WCCIDirection
				{
					get { Update();
					return wCCIDirectionSeries; }
				}

				[Browsable(false)]
				[XmlIgnore()]
				[Description("Location of close, Top (1) or Bottom (0) of bar")]
				public DataSeries WCCICloseAt
				{
					get { Update();
					return wCCICloseAtSeries; }
				}

				[Description("Display ZLR Patterns?")]
				[Category("Patterns to Display")]
				public bool Show_ZLR
				{
					get { return show_ZLR; }
					set { show_ZLR = value; }
				}

				[Description("Display Famir Patterns?")]
				[Category("Patterns to Display")]
				public bool Show_Famir
				{
					get { return show_Famir; }
					set { show_Famir = value; }
				}

				[Description("Display Vegas Patterns?")]
				[Category("Patterns to Display")]
				public bool Show_Vegas
				{
					get { return show_Vegas; }
					set { show_Vegas = value; }
				}

				[Description("Display GB100 Patterns?")]
				[Category("Patterns to Display")]
				public bool Show_GB100
				{
					get { return show_GB100; }
					set { show_GB100 = value; }
				}

				[Description("Display Tony Patterns?")]
				[Category("Patterns to Display")]
				public bool Show_Tony
				{
					get { return show_Tony; }
					set { show_Tony = value; }
				}

				[Description("Display Ghost Patterns?")]
				[Category("Patterns to Display")]
				public bool Show_Ghost
				{
					get { return show_Ghost; }
					set { show_Ghost = value; }
				}

			#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private WoodiesPatterns[] cacheWoodiesPatterns = null;

        private static WoodiesPatterns checkWoodiesPatterns = new WoodiesPatterns();

        /// <summary>
        /// Woodie's CCI Patterns
        /// </summary>
        /// <returns></returns>
        public WoodiesPatterns WoodiesPatterns(double extremes, double famirHookMin, double famirLimits, double maxSignalValue, double minZLRPts, double minZLRValue, double rejectLevel, int trendLength, string usePoints, double usePointsAmount)
        {
            return WoodiesPatterns(Input, extremes, famirHookMin, famirLimits, maxSignalValue, minZLRPts, minZLRValue, rejectLevel, trendLength, usePoints, usePointsAmount);
        }

        /// <summary>
        /// Woodie's CCI Patterns
        /// </summary>
        /// <returns></returns>
        public WoodiesPatterns WoodiesPatterns(Data.IDataSeries input, double extremes, double famirHookMin, double famirLimits, double maxSignalValue, double minZLRPts, double minZLRValue, double rejectLevel, int trendLength, string usePoints, double usePointsAmount)
        {
            checkWoodiesPatterns.Extremes = extremes;
            extremes = checkWoodiesPatterns.Extremes;
            checkWoodiesPatterns.FamirHookMin = famirHookMin;
            famirHookMin = checkWoodiesPatterns.FamirHookMin;
            checkWoodiesPatterns.FamirLimits = famirLimits;
            famirLimits = checkWoodiesPatterns.FamirLimits;
            checkWoodiesPatterns.MaxSignalValue = maxSignalValue;
            maxSignalValue = checkWoodiesPatterns.MaxSignalValue;
            checkWoodiesPatterns.MinZLRPts = minZLRPts;
            minZLRPts = checkWoodiesPatterns.MinZLRPts;
            checkWoodiesPatterns.MinZLRValue = minZLRValue;
            minZLRValue = checkWoodiesPatterns.MinZLRValue;
            checkWoodiesPatterns.RejectLevel = rejectLevel;
            rejectLevel = checkWoodiesPatterns.RejectLevel;
            checkWoodiesPatterns.TrendLength = trendLength;
            trendLength = checkWoodiesPatterns.TrendLength;
            checkWoodiesPatterns.UsePoints = usePoints;
            usePoints = checkWoodiesPatterns.UsePoints;
            checkWoodiesPatterns.UsePointsAmount = usePointsAmount;
            usePointsAmount = checkWoodiesPatterns.UsePointsAmount;

            if (cacheWoodiesPatterns != null)
                for (int idx = 0; idx < cacheWoodiesPatterns.Length; idx++)
                    if (Math.Abs(cacheWoodiesPatterns[idx].Extremes - extremes) <= double.Epsilon && Math.Abs(cacheWoodiesPatterns[idx].FamirHookMin - famirHookMin) <= double.Epsilon && Math.Abs(cacheWoodiesPatterns[idx].FamirLimits - famirLimits) <= double.Epsilon && Math.Abs(cacheWoodiesPatterns[idx].MaxSignalValue - maxSignalValue) <= double.Epsilon && Math.Abs(cacheWoodiesPatterns[idx].MinZLRPts - minZLRPts) <= double.Epsilon && Math.Abs(cacheWoodiesPatterns[idx].MinZLRValue - minZLRValue) <= double.Epsilon && Math.Abs(cacheWoodiesPatterns[idx].RejectLevel - rejectLevel) <= double.Epsilon && cacheWoodiesPatterns[idx].TrendLength == trendLength && cacheWoodiesPatterns[idx].UsePoints == usePoints && Math.Abs(cacheWoodiesPatterns[idx].UsePointsAmount - usePointsAmount) <= double.Epsilon && cacheWoodiesPatterns[idx].EqualsInput(input))
                        return cacheWoodiesPatterns[idx];

            WoodiesPatterns indicator = new WoodiesPatterns();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Extremes = extremes;
            indicator.FamirHookMin = famirHookMin;
            indicator.FamirLimits = famirLimits;
            indicator.MaxSignalValue = maxSignalValue;
            indicator.MinZLRPts = minZLRPts;
            indicator.MinZLRValue = minZLRValue;
            indicator.RejectLevel = rejectLevel;
            indicator.TrendLength = trendLength;
            indicator.UsePoints = usePoints;
            indicator.UsePointsAmount = usePointsAmount;
            indicator.SetUp();

            WoodiesPatterns[] tmp = new WoodiesPatterns[cacheWoodiesPatterns == null ? 1 : cacheWoodiesPatterns.Length + 1];
            if (cacheWoodiesPatterns != null)
                cacheWoodiesPatterns.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheWoodiesPatterns = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Woodie's CCI Patterns
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.WoodiesPatterns WoodiesPatterns(double extremes, double famirHookMin, double famirLimits, double maxSignalValue, double minZLRPts, double minZLRValue, double rejectLevel, int trendLength, string usePoints, double usePointsAmount)
        {
            return _indicator.WoodiesPatterns(Input, extremes, famirHookMin, famirLimits, maxSignalValue, minZLRPts, minZLRValue, rejectLevel, trendLength, usePoints, usePointsAmount);
        }

        /// <summary>
        /// Woodie's CCI Patterns
        /// </summary>
        /// <returns></returns>
        public Indicator.WoodiesPatterns WoodiesPatterns(Data.IDataSeries input, double extremes, double famirHookMin, double famirLimits, double maxSignalValue, double minZLRPts, double minZLRValue, double rejectLevel, int trendLength, string usePoints, double usePointsAmount)
        {
            return _indicator.WoodiesPatterns(input, extremes, famirHookMin, famirLimits, maxSignalValue, minZLRPts, minZLRValue, rejectLevel, trendLength, usePoints, usePointsAmount);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Woodie's CCI Patterns
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.WoodiesPatterns WoodiesPatterns(double extremes, double famirHookMin, double famirLimits, double maxSignalValue, double minZLRPts, double minZLRValue, double rejectLevel, int trendLength, string usePoints, double usePointsAmount)
        {
            return _indicator.WoodiesPatterns(Input, extremes, famirHookMin, famirLimits, maxSignalValue, minZLRPts, minZLRValue, rejectLevel, trendLength, usePoints, usePointsAmount);
        }

        /// <summary>
        /// Woodie's CCI Patterns
        /// </summary>
        /// <returns></returns>
        public Indicator.WoodiesPatterns WoodiesPatterns(Data.IDataSeries input, double extremes, double famirHookMin, double famirLimits, double maxSignalValue, double minZLRPts, double minZLRValue, double rejectLevel, int trendLength, string usePoints, double usePointsAmount)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.WoodiesPatterns(input, extremes, famirHookMin, famirLimits, maxSignalValue, minZLRPts, minZLRValue, rejectLevel, trendLength, usePoints, usePointsAmount);
        }

    }
}
#endregion
