#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Reverse suddenly
    /// </summary>
    [Description("Reverse suddenly")]
    public class DowTheory : Indicator
    {
        #region Variables
        // Wizard generated variables
        private double PrevHaut = 0;
		private double Haut		= 0;
		private double PrevBas	= 0;
		private double Bas		= 0;
		private bool    ProchainHaut = false;
		private bool	ProchainBas  = false;
		private int		CompteurHauts = 0;
		private int		CompteurBas = 0;
		private bool	LongOk = false;
		private bool    ShortOk = false;
		private string  Bias = string.Empty;
		private int		period = 10;
		private int		NbBarsPrevHauts = 0;
		private int		NbBarsPrevBas = 0;
		
 
		
        // User defined variables (add any user defined variables below)

        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
             Overlay = true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
			if (CurrentBar < 8) return;
			CompteurHauts = CompteurHauts + 1;
			CompteurBas = CompteurBas + 1;
			NbBarsPrevHauts = NbBarsPrevHauts + 1;
			NbBarsPrevBas = NbBarsPrevBas + 1;
			//Print("CompteurHauts = " + CompteurHauts);
			//Print("CompteurBas = " + CompteurBas);
            if (High[0] > MAX(High, Period)[1])
			{
				ProchainBas = true;
	    		if (ProchainHaut == true)
				{
					
					ProchainHaut = false;
					
					PrevHaut = Haut;
					RemoveDrawObject("PrevHaut");
					DrawText("PrevHaut", PrevHaut.ToString(),CompteurHauts,High[CompteurHauts] + 3 * TickSize, Color.Gold );
					NbBarsPrevHauts = CompteurHauts;
					
				}
				
				Haut = High[0];
				RemoveDrawObject("Haut");
				DrawText("Haut", High[0].ToString(),0,High[0] + 3 * TickSize, Color.Gold );
				RemoveDrawObject("LigneHaute");
				DrawLine("LigneHaute",true,NbBarsPrevHauts,PrevHaut,0,Haut,Color.Gold,DashStyle.Solid,1);
				CompteurHauts = 0;

				
			}
			if (Low[0] < MIN(Low, Period)[1])
			{
	    		ProchainHaut = true;
				if (ProchainBas == true)
				{
					
					ProchainBas = false;
					
					PrevBas = Bas;
					RemoveDrawObject("PrevBas");
					DrawText("PrevBas", PrevBas.ToString(),CompteurBas,Low[CompteurBas] - 3 * TickSize, Color.Gold );
					NbBarsPrevBas = CompteurBas;
					
				}
				
				Bas = Low[0];
				RemoveDrawObject("Bas");
				DrawText("Bas", Low[0].ToString(),0,Low[0] - 3 * TickSize, Color.Gold );
				RemoveDrawObject("LigneBasse");
				DrawLine("LigneBasse",true,NbBarsPrevBas,PrevBas,0,Bas,Color.Gold,DashStyle.Solid,1);
				CompteurBas = 0;
				
			}
			
			
			if (Haut > PrevHaut && Bas >= PrevBas)
			{
				LongOk = true;
			}
			else
			{
				LongOk = false;
			}
			if (Haut <= PrevHaut && Bas < PrevBas)
			{
				ShortOk = true;
			}
			else
			{
				ShortOk = false;
			}
			if (LongOk == true && ShortOk == false) Bias = "Bullish";
			if (ShortOk == true && LongOk == false) Bias = "Bearish";
			if (LongOk == false && ShortOk == false) Bias = "Choppy";
			
			DrawTextFixed("Bias", Bias.ToString(),TextPosition.TopRight);

					
        }

        #region Properties
		
		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("Period")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}
        
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DowTheory[] cacheDowTheory = null;

        private static DowTheory checkDowTheory = new DowTheory();

        /// <summary>
        /// Reverse suddenly
        /// </summary>
        /// <returns></returns>
        public DowTheory DowTheory(int period)
        {
            return DowTheory(Input, period);
        }

        /// <summary>
        /// Reverse suddenly
        /// </summary>
        /// <returns></returns>
        public DowTheory DowTheory(Data.IDataSeries input, int period)
        {
            if (cacheDowTheory != null)
                for (int idx = 0; idx < cacheDowTheory.Length; idx++)
                    if (cacheDowTheory[idx].Period == period && cacheDowTheory[idx].EqualsInput(input))
                        return cacheDowTheory[idx];

            lock (checkDowTheory)
            {
                checkDowTheory.Period = period;
                period = checkDowTheory.Period;

                if (cacheDowTheory != null)
                    for (int idx = 0; idx < cacheDowTheory.Length; idx++)
                        if (cacheDowTheory[idx].Period == period && cacheDowTheory[idx].EqualsInput(input))
                            return cacheDowTheory[idx];

                DowTheory indicator = new DowTheory();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                DowTheory[] tmp = new DowTheory[cacheDowTheory == null ? 1 : cacheDowTheory.Length + 1];
                if (cacheDowTheory != null)
                    cacheDowTheory.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDowTheory = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Reverse suddenly
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DowTheory DowTheory(int period)
        {
            return _indicator.DowTheory(Input, period);
        }

        /// <summary>
        /// Reverse suddenly
        /// </summary>
        /// <returns></returns>
        public Indicator.DowTheory DowTheory(Data.IDataSeries input, int period)
        {
            return _indicator.DowTheory(input, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Reverse suddenly
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DowTheory DowTheory(int period)
        {
            return _indicator.DowTheory(Input, period);
        }

        /// <summary>
        /// Reverse suddenly
        /// </summary>
        /// <returns></returns>
        public Indicator.DowTheory DowTheory(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DowTheory(input, period);
        }
    }
}
#endregion
