//	© Joydeep Mitra.
//	visit www.volumedigger.com for more indicators and strategies.

#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class dsInsideBar : Indicator
    {
        #region Variables
       	int period = 29;
		Color color = Color.Blue;
		int opacity = 2;
		bool showshadow = true;
		int shadowlength = 10;
		Color shadowcolor = Color.Green;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(PeriodType.Minute,period);
			
            CalculateOnBarClose	= true;	//inside bar will be true in every instance when a bar forms. so we wait for its completion.
            Overlay				= true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			if (CurrentBar < 1) return;
			
			if (BarsInProgress == 1)
			{
				if (!Bars.FirstBarOfSession && (High[0] - Low[0]) < ((High[1] - Low[1])/2.5) && (High[0] < Median[1] || Low[0] > Median[1]))
				{
					//highlight the inside bar
					base.DrawRectangle("rec" + CurrentBars[0],false,Times[1][0],Highs[1][0],Times[1][1],Lows[1][0],Color.Transparent,color,opacity);
					//highlight the shadow
					if (showshadow) base.DrawRectangle("rec1" + CurrentBars[0],false,Times[1][1],Highs[1][0],Times[1][-shadowlength],Lows[1][0],Color.Transparent,shadowcolor,opacity);
				}
				
			}
		}

        #region Properties
       
		[Description("Periodicity of the Secondary series (in minutes)")]
		[Category("Parameters")]
		public int PeriodicityValue
		{
			get{return period;}
			set{period = Math.Max(25,value);}
		}
		
		[Browsable(false)]
		public string InsideBarColorSerialize
		{
			get{return NinjaTrader.Gui.Design.SerializableColor.ToString(color);}
			set{color = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
		}
		[XmlIgnore()]
		[Description("Color of the Inside Bar region")]
		[Category("Parameters")]
		public Color InsideBarColor
		{
			get{return color;}
			set{color = value;}
		}
		[Description("Opacity Min - 1; Max - 10;")]
		[Category("Parameters")]
		public int Opacity
		{
			get{return opacity;}
			set{opacity = Math.Max(1,value);
				opacity = Math.Min(10,opacity);}
		}
		
		[Browsable(false)]
		public string ShadowColorSerialize
		{
			get{return NinjaTrader.Gui.Design.SerializableColor.ToString(shadowcolor);}
			set{shadowcolor = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
		}
		[XmlIgnore()]
		[Description("Shadow Color")]
		[Category("Parameters")]
		public Color ShadowColor
		{
			get{return shadowcolor;}
			set{shadowcolor = value;}
		}
		
		
		[Description("Show Shadow")]
		[Category("Parameters")]
		public bool ShowShadow
		{
			get{return showshadow;}
			set{showshadow = value;}
		}
		[Description("Shadow Length")]
		[Category("Parameters")]
		public int ShadowLength
		{
			get{return shadowlength;}
			set{shadowlength = Math.Max(1,value);}
		}
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private dsInsideBar[] cachedsInsideBar = null;

        private static dsInsideBar checkdsInsideBar = new dsInsideBar();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public dsInsideBar dsInsideBar(Color insideBarColor, int opacity, int periodicityValue, Color shadowColor, int shadowLength, bool showShadow)
        {
            return dsInsideBar(Input, insideBarColor, opacity, periodicityValue, shadowColor, shadowLength, showShadow);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public dsInsideBar dsInsideBar(Data.IDataSeries input, Color insideBarColor, int opacity, int periodicityValue, Color shadowColor, int shadowLength, bool showShadow)
        {
            if (cachedsInsideBar != null)
                for (int idx = 0; idx < cachedsInsideBar.Length; idx++)
                    if (cachedsInsideBar[idx].InsideBarColor == insideBarColor && cachedsInsideBar[idx].Opacity == opacity && cachedsInsideBar[idx].PeriodicityValue == periodicityValue && cachedsInsideBar[idx].ShadowColor == shadowColor && cachedsInsideBar[idx].ShadowLength == shadowLength && cachedsInsideBar[idx].ShowShadow == showShadow && cachedsInsideBar[idx].EqualsInput(input))
                        return cachedsInsideBar[idx];

            lock (checkdsInsideBar)
            {
                checkdsInsideBar.InsideBarColor = insideBarColor;
                insideBarColor = checkdsInsideBar.InsideBarColor;
                checkdsInsideBar.Opacity = opacity;
                opacity = checkdsInsideBar.Opacity;
                checkdsInsideBar.PeriodicityValue = periodicityValue;
                periodicityValue = checkdsInsideBar.PeriodicityValue;
                checkdsInsideBar.ShadowColor = shadowColor;
                shadowColor = checkdsInsideBar.ShadowColor;
                checkdsInsideBar.ShadowLength = shadowLength;
                shadowLength = checkdsInsideBar.ShadowLength;
                checkdsInsideBar.ShowShadow = showShadow;
                showShadow = checkdsInsideBar.ShowShadow;

                if (cachedsInsideBar != null)
                    for (int idx = 0; idx < cachedsInsideBar.Length; idx++)
                        if (cachedsInsideBar[idx].InsideBarColor == insideBarColor && cachedsInsideBar[idx].Opacity == opacity && cachedsInsideBar[idx].PeriodicityValue == periodicityValue && cachedsInsideBar[idx].ShadowColor == shadowColor && cachedsInsideBar[idx].ShadowLength == shadowLength && cachedsInsideBar[idx].ShowShadow == showShadow && cachedsInsideBar[idx].EqualsInput(input))
                            return cachedsInsideBar[idx];

                dsInsideBar indicator = new dsInsideBar();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.InsideBarColor = insideBarColor;
                indicator.Opacity = opacity;
                indicator.PeriodicityValue = periodicityValue;
                indicator.ShadowColor = shadowColor;
                indicator.ShadowLength = shadowLength;
                indicator.ShowShadow = showShadow;
                Indicators.Add(indicator);
                indicator.SetUp();

                dsInsideBar[] tmp = new dsInsideBar[cachedsInsideBar == null ? 1 : cachedsInsideBar.Length + 1];
                if (cachedsInsideBar != null)
                    cachedsInsideBar.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachedsInsideBar = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.dsInsideBar dsInsideBar(Color insideBarColor, int opacity, int periodicityValue, Color shadowColor, int shadowLength, bool showShadow)
        {
            return _indicator.dsInsideBar(Input, insideBarColor, opacity, periodicityValue, shadowColor, shadowLength, showShadow);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.dsInsideBar dsInsideBar(Data.IDataSeries input, Color insideBarColor, int opacity, int periodicityValue, Color shadowColor, int shadowLength, bool showShadow)
        {
            return _indicator.dsInsideBar(input, insideBarColor, opacity, periodicityValue, shadowColor, shadowLength, showShadow);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.dsInsideBar dsInsideBar(Color insideBarColor, int opacity, int periodicityValue, Color shadowColor, int shadowLength, bool showShadow)
        {
            return _indicator.dsInsideBar(Input, insideBarColor, opacity, periodicityValue, shadowColor, shadowLength, showShadow);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.dsInsideBar dsInsideBar(Data.IDataSeries input, Color insideBarColor, int opacity, int periodicityValue, Color shadowColor, int shadowLength, bool showShadow)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.dsInsideBar(input, insideBarColor, opacity, periodicityValue, shadowColor, shadowLength, showShadow);
        }
    }
}
#endregion
