#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Laguerre-ized ergodic candle oscillator
    /// </summary>
    [Description("EOTProlive.com FREE indicator.  Laguerre-ized ergodic candle oscillator.")]
    public class Z20090712LaguerreECO : Indicator
    {
        #region Variables
        // Wizard generated variables
            private double gamma = 0.300; // Default setting for Gamma
        // User defined variables (add any user defined variables below)
		    private WMA weightma;
		    private EMA expma;
		    private int smoothing = 8;
		    private int trigger = 5;
		    private double[] ol,pol,hl,phl,ll,pll,cl,pcl;
		    private DataSeries unsmoothed;
		    private int lastSeenBar = -1;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Gold), PlotStyle.Line, "Trigger"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Red), PlotStyle.Line, "ECO"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Cyan), PlotStyle.Bar, "Histogram"));
            Add(new Line(Color.FromKnownColor(KnownColor.Blue), 0, "Zero"));
            Overlay				= false;
            PriceTypeSupported	= false;
			Plots[0].Pen.Width = 2;
			Plots[1].Pen.Width = 2;
			Plots[2].Pen.Width = 2;
			weightma = null;
			expma = null;
			ol = new double[4];
			pol = new double[4];
			hl = new double[4];
			phl = new double[4];
			ll = new double[4];
			pll = new double[4];
			cl = new double[4];
			pcl = new double[4];
			unsmoothed = new DataSeries(this);
			lastSeenBar = -1;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {			
			if(CurrentBar == 1) {
			  for(int i = 0; i < 4; ++i) {
				pol[i] = Open[0];
				phl[i] = High[0];
				pll[i] = Low[0];
				pcl[i] = Close[0];
				lastSeenBar = CurrentBar;
			  }
			}

			if(CurrentBar != lastSeenBar) {
		      for(int i = 0; i < 4; ++i) {
			    pol[i] = ol[i]; // remember previous bar value...
			    phl[i] = hl[i]; 
			    pll[i] = ll[i]; 
			    pcl[i] = cl[i]; 
			  }
			  lastSeenBar = CurrentBar;
			}

			
			// update all the Laguerre numbers....
			ol[0] = (1-gamma)*Open[0] + gamma*pol[0];
			hl[0] = (1-gamma)*High[0] + gamma*phl[0];
			ll[0] = (1-gamma)*Low[0] + gamma*pll[0];
			cl[0] = (1-gamma)*Close[0] + gamma*pcl[0];
			for(int i = 1; i < 4; ++i) {
			  ol[i] = -gamma*ol[i-1] + pol[i-1] + gamma*pol[i];
			  hl[i] = -gamma*hl[i-1] + phl[i-1] + gamma*phl[i];
			  ll[i] = -gamma*ll[i-1] + pll[i-1] + gamma*pll[i];
			  cl[i] = -gamma*cl[i-1] + pcl[i-1] + gamma*pcl[i];
			}
						
			double value1 = 0.0;
			double value2 = 0.0;
			for(int i = 0; i < 4; ++i) {
				value1 += (cl[i] - ol[i]);
				value2 += (hl[i] - ll[i]);
			}
			
			if(value2 != 0.0) {
			  unsmoothed.Set(100.0*value1/value2);	
			} else {
			  if((CurrentBar > 1) && unsmoothed.ContainsValue(1)) {
				unsmoothed.Set(unsmoothed[1]);
			  } else {
			    unsmoothed.Set(0);	
			  }
			}
			
			if(weightma == null) {
				weightma = WMA(unsmoothed,smoothing);
				expma = EMA(weightma.Value,trigger);
			}
			
			ECO.Set(weightma[0]);
			TriggerLine.Set(expma[0]);
			Histogram.Set(weightma[0] - expma[0]);
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ECO
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries TriggerLine
        {
            get { return Values[0]; }
        }
		
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Histogram
        {
            get { return Values[2]; }
        }

        [Description("gamma")]
        [Category("Parameters")]
        public double Gamma
        {
            get { return gamma; }
            set { gamma = Math.Max(0.000, value); }
        }
        [Description("smoothing")]
        [Category("Parameters")]
        public int Smoothing
        {
            get { return smoothing; }
            set { smoothing = Math.Max(1, value); }
        }
        [Description("trigger")]
        [Category("Parameters")]
        public int Trigger
        {
            get { return trigger; }
            set { trigger = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private Z20090712LaguerreECO[] cacheZ20090712LaguerreECO = null;

        private static Z20090712LaguerreECO checkZ20090712LaguerreECO = new Z20090712LaguerreECO();

        /// <summary>
        /// EOTProlive.com FREE indicator.  Laguerre-ized ergodic candle oscillator.
        /// </summary>
        /// <returns></returns>
        public Z20090712LaguerreECO Z20090712LaguerreECO(double gamma, int smoothing, int trigger)
        {
            return Z20090712LaguerreECO(Input, gamma, smoothing, trigger);
        }

        /// <summary>
        /// EOTProlive.com FREE indicator.  Laguerre-ized ergodic candle oscillator.
        /// </summary>
        /// <returns></returns>
        public Z20090712LaguerreECO Z20090712LaguerreECO(Data.IDataSeries input, double gamma, int smoothing, int trigger)
        {
            checkZ20090712LaguerreECO.Gamma = gamma;
            gamma = checkZ20090712LaguerreECO.Gamma;
            checkZ20090712LaguerreECO.Smoothing = smoothing;
            smoothing = checkZ20090712LaguerreECO.Smoothing;
            checkZ20090712LaguerreECO.Trigger = trigger;
            trigger = checkZ20090712LaguerreECO.Trigger;

            if (cacheZ20090712LaguerreECO != null)
                for (int idx = 0; idx < cacheZ20090712LaguerreECO.Length; idx++)
                    if (Math.Abs(cacheZ20090712LaguerreECO[idx].Gamma - gamma) <= double.Epsilon && cacheZ20090712LaguerreECO[idx].Smoothing == smoothing && cacheZ20090712LaguerreECO[idx].Trigger == trigger && cacheZ20090712LaguerreECO[idx].EqualsInput(input))
                        return cacheZ20090712LaguerreECO[idx];

            Z20090712LaguerreECO indicator = new Z20090712LaguerreECO();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Gamma = gamma;
            indicator.Smoothing = smoothing;
            indicator.Trigger = trigger;
            indicator.SetUp();

            Z20090712LaguerreECO[] tmp = new Z20090712LaguerreECO[cacheZ20090712LaguerreECO == null ? 1 : cacheZ20090712LaguerreECO.Length + 1];
            if (cacheZ20090712LaguerreECO != null)
                cacheZ20090712LaguerreECO.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheZ20090712LaguerreECO = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// EOTProlive.com FREE indicator.  Laguerre-ized ergodic candle oscillator.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Z20090712LaguerreECO Z20090712LaguerreECO(double gamma, int smoothing, int trigger)
        {
            return _indicator.Z20090712LaguerreECO(Input, gamma, smoothing, trigger);
        }

        /// <summary>
        /// EOTProlive.com FREE indicator.  Laguerre-ized ergodic candle oscillator.
        /// </summary>
        /// <returns></returns>
        public Indicator.Z20090712LaguerreECO Z20090712LaguerreECO(Data.IDataSeries input, double gamma, int smoothing, int trigger)
        {
            return _indicator.Z20090712LaguerreECO(input, gamma, smoothing, trigger);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// EOTProlive.com FREE indicator.  Laguerre-ized ergodic candle oscillator.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Z20090712LaguerreECO Z20090712LaguerreECO(double gamma, int smoothing, int trigger)
        {
            return _indicator.Z20090712LaguerreECO(Input, gamma, smoothing, trigger);
        }

        /// <summary>
        /// EOTProlive.com FREE indicator.  Laguerre-ized ergodic candle oscillator.
        /// </summary>
        /// <returns></returns>
        public Indicator.Z20090712LaguerreECO Z20090712LaguerreECO(Data.IDataSeries input, double gamma, int smoothing, int trigger)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.Z20090712LaguerreECO(input, gamma, smoothing, trigger);
        }

    }
}
#endregion
