/// #############################################################
/// #															#
/// #                 PriceActionSwingRelation                  #
/// #														    #
/// #     06.06.2010 by dorschden, die.unendlichkeit@gmx.de     #
/// #														    #
/// #############################################################

#region Updates
/// Version 1.0.1 - 06.06.2010
/// - Rename some variables
#endregion

#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using PriceActionSwing.Utility;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
	/// Look for long entries if the value is above 0 and for short vice versa.	
	/// Shows the current price position in relation to the swings: 
	/// -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom
    /// </summary>
    [Description("Look for long entrys if the value is above 0 and for short vice versa. Shows the current price position in relation to the swings: -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom.")]
    public class PriceActionSwingRelation : Indicator
    {
        #region Variables
//===================================================================
		private SwingMode		calcMode			= SwingMode.Standard;
        private int 			calcSize 			= 8;
		private int 			dtbStrength			= 15;
		private double 			psarAcceleration	= 0.02;
		private double 			psarAccelerationMax	= 0.2;
		private double 			psarAccelerationStep= 0.02;
		
        private IDataSeries 	priceSwingRel;
//===================================================================
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			Add(new Plot(new Pen(Color.Firebrick, 2), PlotStyle.Dot, 	"DoubleTop"));
			Add(new Plot(new Pen(Color.Red, 	  2), PlotStyle.Dot, 	"DownTrend"));
			Add(new Plot(new Pen(Color.Gold,      2), PlotStyle.Square, "NoWhere"));
			Add(new Plot(new Pen(Color.Green,     2), PlotStyle.Dot,    "UpTrend"));
			Add(new Plot(new Pen(Color.Lime,  	  2), PlotStyle.Dot, 	"DoubleBottom"));
			
			Add(new Line(Color.DarkGray, 0, "Zero line"));
			
			CalculateOnBarClose = true;
            Overlay 			= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			// Set the PriceActionSwingRelation value to to the priceSwingRel series
			if (CurrentBar < 1 && priceSwingRel == null)
				priceSwingRel = PriceActionSwing(Input, calcMode, calcSize, dtbStrength, psarAcceleration, 
					psarAccelerationMax, psarAccelerationStep).PriceSwingRelation;
			
			int relation = Convert.ToInt32(priceSwingRel[0]);
			
			switch (relation) {
				case -2:
					DoubleTop.Set(relation);
					break;
				case -1:
					DownTrend.Set(relation);
					break;
				case 0:
					NoWhere.Set(relation);
					break;
				case 1:
					UpTrend.Set(relation);
					break;
				case 2:
					DoubleBottom.Set(relation);
					break;
			}
        }

        #region Properties
		#region Plots
//===================================================================
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries DoubleTop
        {
            get { return Values[0]; }
        }
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries DownTrend
        {
            get { return Values[1]; }
        }
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries NoWhere
        {
            get { return Values[2]; }
        }
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries UpTrend
        {
            get { return Values[3]; }
        }
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries DoubleBottom
        {
            get { return Values[4]; }
        }
//===================================================================
		#endregion
		
		#region Parameters
//===================================================================
		/// <summary>
		/// Double top and bottom strength.
		/// </summary>
		[Description("Double top and bottom strength.")]
        [Category("Parameters")]
		[Gui.Design.DisplayName("DB/DT strength")]
        public int DtbStrength
        {
            get { return dtbStrength; }
            set { dtbStrength = Math.Max(1, value); }
        }	
		
		/// <summary>
		/// For Standard or ZigZagUTC mode - small value = small swings - bigger value = bigger swings.
		/// </summary>
        [Description("For Standard or ZigZagUTC mode - small value = small swings - bigger value = bigger swings.")]
        [Category("Parameters")]
		[Gui.Design.DisplayName("Calculation size")]
        public int CalcSize
        {
            get { return calcSize; }
            set { calcSize = Math.Max(1, value); }
        }
		
		/// <summary>
		/// Swing calculation mode.
		/// </summary>
        [Description("Swing calculation mode.")]
        [Category("Parameters")]
		[Gui.Design.DisplayName("Calculation mode")]
        public SwingMode CalcMode
        {
            get { return calcMode; }
            set { calcMode =  value; }
        }
		
        /// <summary>
        /// For PSAR mode only - The initial acceleration factor.
        /// </summary>
        [Description("For PSAR mode only - The initial acceleration factor.")]
        [Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("PSAR Acceleration")]
        public double PsarAcceleration
        {
            get { return psarAcceleration; }
            set { psarAcceleration = Math.Max(0.00, value); }
        }

        /// <summary>
        /// For PSAR mode only - The acceleration step factor.
        /// </summary>
        [Description("For PSAR mode only - The acceleration step factor.")]
        [Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("PSAR Acceleration step")]
        public double PsarAccelerationStep
        {
            get { return psarAccelerationStep; }
            set { psarAccelerationStep = Math.Max(0.02, value); }
        }

		/// <summary>
		/// For PSAR mode only - The maximum acceleration.
		/// </summary>
		[Description("For PSAR mode only - The maximum acceleration.")]
		[Category("Parameters")]
		[Gui.Design.DisplayNameAttribute("PSAR Acceleration max")]
		public double PsarAccelerationMax
		{
			get { return psarAccelerationMax; }
			set { psarAccelerationMax = Math.Max(0.02, value); }
		}
//===================================================================
		#endregion
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PriceActionSwingRelation[] cachePriceActionSwingRelation = null;

        private static PriceActionSwingRelation checkPriceActionSwingRelation = new PriceActionSwingRelation();

        /// <summary>
        /// Look for long entrys if the value is above 0 and for short vice versa. Shows the current price position in relation to the swings: -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom.
        /// </summary>
        /// <returns></returns>
        public PriceActionSwingRelation PriceActionSwingRelation(SwingMode calcMode, int calcSize, int dtbStrength, double psarAcceleration, double psarAccelerationMax, double psarAccelerationStep)
        {
            return PriceActionSwingRelation(Input, calcMode, calcSize, dtbStrength, psarAcceleration, psarAccelerationMax, psarAccelerationStep);
        }

        /// <summary>
        /// Look for long entrys if the value is above 0 and for short vice versa. Shows the current price position in relation to the swings: -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom.
        /// </summary>
        /// <returns></returns>
        public PriceActionSwingRelation PriceActionSwingRelation(Data.IDataSeries input, SwingMode calcMode, int calcSize, int dtbStrength, double psarAcceleration, double psarAccelerationMax, double psarAccelerationStep)
        {
            checkPriceActionSwingRelation.CalcMode = calcMode;
            calcMode = checkPriceActionSwingRelation.CalcMode;
            checkPriceActionSwingRelation.CalcSize = calcSize;
            calcSize = checkPriceActionSwingRelation.CalcSize;
            checkPriceActionSwingRelation.DtbStrength = dtbStrength;
            dtbStrength = checkPriceActionSwingRelation.DtbStrength;
            checkPriceActionSwingRelation.PsarAcceleration = psarAcceleration;
            psarAcceleration = checkPriceActionSwingRelation.PsarAcceleration;
            checkPriceActionSwingRelation.PsarAccelerationMax = psarAccelerationMax;
            psarAccelerationMax = checkPriceActionSwingRelation.PsarAccelerationMax;
            checkPriceActionSwingRelation.PsarAccelerationStep = psarAccelerationStep;
            psarAccelerationStep = checkPriceActionSwingRelation.PsarAccelerationStep;

            if (cachePriceActionSwingRelation != null)
                for (int idx = 0; idx < cachePriceActionSwingRelation.Length; idx++)
                    if (cachePriceActionSwingRelation[idx].CalcMode == calcMode && cachePriceActionSwingRelation[idx].CalcSize == calcSize && cachePriceActionSwingRelation[idx].DtbStrength == dtbStrength && Math.Abs(cachePriceActionSwingRelation[idx].PsarAcceleration - psarAcceleration) <= double.Epsilon && Math.Abs(cachePriceActionSwingRelation[idx].PsarAccelerationMax - psarAccelerationMax) <= double.Epsilon && Math.Abs(cachePriceActionSwingRelation[idx].PsarAccelerationStep - psarAccelerationStep) <= double.Epsilon && cachePriceActionSwingRelation[idx].EqualsInput(input))
                        return cachePriceActionSwingRelation[idx];

            PriceActionSwingRelation indicator = new PriceActionSwingRelation();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.CalcMode = calcMode;
            indicator.CalcSize = calcSize;
            indicator.DtbStrength = dtbStrength;
            indicator.PsarAcceleration = psarAcceleration;
            indicator.PsarAccelerationMax = psarAccelerationMax;
            indicator.PsarAccelerationStep = psarAccelerationStep;
            indicator.SetUp();

            PriceActionSwingRelation[] tmp = new PriceActionSwingRelation[cachePriceActionSwingRelation == null ? 1 : cachePriceActionSwingRelation.Length + 1];
            if (cachePriceActionSwingRelation != null)
                cachePriceActionSwingRelation.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cachePriceActionSwingRelation = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Look for long entrys if the value is above 0 and for short vice versa. Shows the current price position in relation to the swings: -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceActionSwingRelation PriceActionSwingRelation(SwingMode calcMode, int calcSize, int dtbStrength, double psarAcceleration, double psarAccelerationMax, double psarAccelerationStep)
        {
            return _indicator.PriceActionSwingRelation(Input, calcMode, calcSize, dtbStrength, psarAcceleration, psarAccelerationMax, psarAccelerationStep);
        }

        /// <summary>
        /// Look for long entrys if the value is above 0 and for short vice versa. Shows the current price position in relation to the swings: -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom.
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceActionSwingRelation PriceActionSwingRelation(Data.IDataSeries input, SwingMode calcMode, int calcSize, int dtbStrength, double psarAcceleration, double psarAccelerationMax, double psarAccelerationStep)
        {
            return _indicator.PriceActionSwingRelation(input, calcMode, calcSize, dtbStrength, psarAcceleration, psarAccelerationMax, psarAccelerationStep);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Look for long entrys if the value is above 0 and for short vice versa. Shows the current price position in relation to the swings: -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceActionSwingRelation PriceActionSwingRelation(SwingMode calcMode, int calcSize, int dtbStrength, double psarAcceleration, double psarAccelerationMax, double psarAccelerationStep)
        {
            return _indicator.PriceActionSwingRelation(Input, calcMode, calcSize, dtbStrength, psarAcceleration, psarAccelerationMax, psarAccelerationStep);
        }

        /// <summary>
        /// Look for long entrys if the value is above 0 and for short vice versa. Shows the current price position in relation to the swings: -2 double top, -1 lower high/low, 0 price is nowhere, 1 higher high/low, 2 double bottom.
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceActionSwingRelation PriceActionSwingRelation(Data.IDataSeries input, SwingMode calcMode, int calcSize, int dtbStrength, double psarAcceleration, double psarAccelerationMax, double psarAccelerationStep)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PriceActionSwingRelation(input, calcMode, calcSize, dtbStrength, psarAcceleration, psarAccelerationMax, psarAccelerationStep);
        }

    }
}
#endregion
