#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class MACrossBuilder : Indicator
    {
        #region Variables
			//Setup Parameters Below
          	private CrossingMASelection		crossingMAType	= CrossingMASelection.SMA;
			private CrossedMASelection		crossedMAType	= CrossedMASelection.SMA;
			private int 					crossingPeriod 	= 7; // Default setting for CrossingPeriod
            private int 					crossedPeriod 	= 14; // Default setting for CrossedPeriod
			private int 					lookBackPeriod 	= 1;
			private bool 					crossesBelow 	= false; //Sets whether you want to evaluate Cross Below conditions
			private bool 					crossesAbove 	= true;	//Sets whether you want to evaluate Cross Above conditions. 
			
			//Action Choices Below
			private bool changeBarOutlineColor 	= false; // Default setting for ChangeBarOutlineColor
		 	private bool sendEmail 				= false; // Default setting for SendEmail
            private bool alertWithSound 		= false; // Default setting for AlertWithSound
            private bool draw 					= true; // Default setting for Draw
            private bool changeBarColor 		= false; // Default setting for ChangeBarColor
            private bool changeBackColor 		= false; // Default setting for ChangeBackColor
			
			//Action Parameters Below
			private DrawSelection	drawType			= DrawSelection.Diamond; //Chooses the Type of Drawing Object 
			private int				drawOffsetTicks		= 1; // Specifies how far (in # of ticks) from Highs and Lows the object is drawn at. 
			private bool			resetAlertNow		= false;
			private string 			emailFrom 			= @""; // Default setting for EmailFrom
			private string 			emailSubject		= @""; // Default setting for EmailFrom
            private string			emailTo				= @""; // Default setting for EmailTo
            private string 			messageText 		= @""; // Default setting for MessageText
            private string 			soundFile 			= @"Alert1.wav"; // Default setting for SoundFile
			private Color 			drawColor 			= Color.Blue;
			private Color 			candleColor 		= Color.Blue;
			private Color 			chartBackColor 		= Color.White;
			private Color 			candleOutline		= Color.Black; 
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "CrossingPlot"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Purple), PlotStyle.Line, "CrossedPlot"));
            Overlay				= true;
			DrawOnPricePanel 	= true;
			Plots[0].Pen.Width = 2;
			Plots[1].Pen.Width = 2;
        }
		
		public override string ToString()
		{
			return Name + "(" + CrossingPeriod + "-Period " + CrossingMAType.ToString() +  (CrossesAbove ? " Crosses Above " : " ") + (CrossesBelow ? " Crosses Below " : " ") + CrossedPeriod + "-Period "  + CrossedMAType.ToString() + ")";
		}

   
		private void runActions()
		{
     		   	if (AlertWithSound)
				{
					if (ResetAlertNow)
						ResetAlert("MyAlert0");
					
					Alert("MyAlert0", Priority.High, MessageText, SoundFile, 0, Color.White, Color.Black);
                }
				
				if (SendEmail)
					SendMail(EmailFrom, EmailTo, EmailSubject, MessageText);
			
				if (ChangeBarColor)
					BarColor = CandleColor; 
                
				if (ChangeBackColor)
					BackColor = ChartBackColor;
				
				if (ChangeBarOutlineColor)
					CandleOutlineColor = CandleOutline;
                
				if (Draw)
				{
					switch (DrawType)
					{
						case DrawSelection.ArrowDown:
						{
							DrawArrowDown("My down arrow" + CurrentBar, true, 0, High[0] + TickSize * DrawOffsetTicks, DrawColor);
							break;
						}
						
						case DrawSelection.TriangleDown:
						{
							DrawTriangleDown("My triangle down" + CurrentBar, true, 0, High[0] + TickSize * DrawOffsetTicks, DrawColor);
							break;
						}
						
						case DrawSelection.TriangleUp:
						{
							DrawTriangleUp("My triangle up" + CurrentBar, true, 0, Low[0] - TickSize * DrawOffsetTicks, DrawColor);
							break;
						}
						
						case DrawSelection.ArrowUp:
						{
							DrawArrowUp("My up arrow" + CurrentBar, true, 0, Low[0] - TickSize * DrawOffsetTicks, DrawColor);
							break;
						}
						
						case DrawSelection.Dot:
						{
							DrawDot("My dot" + CurrentBar, true, 0, High[0] + TickSize * DrawOffsetTicks, DrawColor);
							break;
						}
						
						case DrawSelection.Diamond:
						{
							DrawDiamond("My diamond" + CurrentBar, true, 0, High[0] + TickSize * DrawOffsetTicks, DrawColor);
							break;
						}
					}
				}
		}
		
        protected override void OnBarUpdate()
        {
            switch (CrossingMAType)
			{
				// If the matype is defined as an EMA then...
				case CrossingMASelection.EMA: //StartCrossingEMA Evaluation
				{
					switch (CrossedMAType)
					{
						case CrossedMASelection.EMA:
						{
							CrossingPlot.Set(EMA(CrossingPeriod)[0]);
							CrossedPlot.Set(EMA(CrossedPeriod)[0]);
							
						if (CrossesAbove)
						{
							if (CrossAbove(EMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
								
						if (CrossesBelow)
						{	
							if (CrossBelow(EMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
								
							break;		
						}
						
						case CrossedMASelection.HMA:
						{
							CrossingPlot.Set(EMA(CrossingPeriod)[0]);
							CrossedPlot.Set(HMA(CrossedPeriod)[0]);
							
						if (CrossesAbove)
						{
							if (CrossAbove(EMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
						
						if (CrossesBelow)
						{	
							if (CrossBelow(EMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
								
							break;
						}
						
						case CrossedMASelection.SMA:
						{
							CrossingPlot.Set(EMA(CrossingPeriod)[0]);
							CrossedPlot.Set(SMA(CrossedPeriod)[0]);
							
						if (CrossesAbove)
						{
							if (CrossAbove(EMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
						
						if (CrossesBelow)
						{	
							if (CrossBelow(EMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
								
							break;
						}
						
						case CrossedMASelection.WMA:
						{
							CrossingPlot.Set(EMA(CrossingPeriod)[0]);
							CrossedPlot.Set(WMA(CrossedPeriod)[0]);
							
						if (CrossesAbove)
						{
							if (CrossAbove(EMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
						
						if (CrossesBelow)
						{	
							if (CrossBelow(EMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
						}
								
							break;
						}
						
					} // EndCrossedEvaluation
					
					break;
				}
				
				// If the matype is defined as a HMA then...
				case CrossingMASelection.HMA:     //Start Evaluating Crossing HMA
				{
					switch (CrossedMAType)
					{
						case CrossedMASelection.EMA:
						{
							CrossingPlot.Set(HMA(CrossingPeriod)[0]);
							CrossedPlot.Set(EMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(HMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(HMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
							
						case CrossedMASelection.HMA:
						{
							CrossingPlot.Set(HMA(CrossingPeriod)[0]);
							CrossedPlot.Set(HMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(HMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(HMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
						case CrossedMASelection.SMA:
						{
							CrossingPlot.Set(HMA(CrossingPeriod)[0]);
							CrossedPlot.Set(SMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(HMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(HMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
							
						case CrossedMASelection.WMA:
						{
							CrossingPlot.Set(HMA(CrossingPeriod)[0]);
							CrossedPlot.Set(WMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(HMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(HMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
					} // EndCrossedEvaluation
					
					break;
				}
				
				// If the matype is defined as a SMA then...
				case CrossingMASelection.SMA: //Start evaluating SMA crossing
				{
					switch (CrossedMAType)
					{
						case CrossedMASelection.EMA:
						{
							CrossingPlot.Set(SMA(CrossingPeriod)[0]);
							CrossedPlot.Set(EMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(SMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(SMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
						case CrossedMASelection.HMA:
						{
							CrossingPlot.Set(SMA(CrossingPeriod)[0]);
							CrossedPlot.Set(HMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(SMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(SMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
						case CrossedMASelection.SMA:
						{
							CrossingPlot.Set(SMA(CrossingPeriod)[0]);
							CrossedPlot.Set(SMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(SMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(SMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
						case CrossedMASelection.WMA:
						{
							CrossingPlot.Set(SMA(CrossingPeriod)[0]);
							CrossedPlot.Set(WMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(SMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(SMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
					} // EndCrossedEvaluation
					break;
				}
				
				// If the matype is defined as a WMA then...
				case CrossingMASelection.WMA:    //Start evaluating WMA Crossing
				{
					switch (CrossedMAType)
					{
						case CrossedMASelection.EMA:
						{
							CrossingPlot.Set(WMA(CrossingPeriod)[0]);
							CrossedPlot.Set(EMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(WMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(WMA(CrossingPeriod), EMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
						case CrossedMASelection.HMA:
						{
							CrossingPlot.Set(WMA(CrossingPeriod)[0]);
							CrossedPlot.Set(HMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(WMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(WMA(CrossingPeriod), HMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
						case CrossedMASelection.SMA:
						{
							CrossingPlot.Set(WMA(CrossingPeriod)[0]);
							CrossedPlot.Set(SMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(WMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(WMA(CrossingPeriod), SMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
						case CrossedMASelection.WMA:
						{
							CrossingPlot.Set(WMA(CrossingPeriod)[0]);
							CrossedPlot.Set(WMA(CrossedPeriod)[0]);
							
							if (CrossesAbove)
							{
								if (CrossAbove(WMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
						
							if (CrossesBelow)
							{	
								if (CrossBelow(WMA(CrossingPeriod), WMA(CrossedPeriod), LookBackPeriod))
								runActions();
							}
								
							break;
						}
						
					} // EndCrossedEvaluation
					
					break;
				}
			}
        }
		
        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		[Gui.Design.DisplayName("\tCrossing Plot")]
        public DataSeries CrossingPlot
        {
            get { return Values[0]; }
        }
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		[Gui.Design.DisplayName("Crossed Plot")]
		public DataSeries CrossedPlot
        {
            get { return Values[1]; }
        }
		
		[Description("")]
		[GridCategory("1 - Setup")]
		[Gui.Design.DisplayName("\t\t\t\t\tCrossing MA Type")]
		public CrossingMASelection CrossingMAType
		{
			get { return crossingMAType; }
			set { crossingMAType = value; }
		}
		
		[Description("")]
        [GridCategory("1 - Setup")]
		[Gui.Design.DisplayName("\t\t\t\tCrossing MA Period")]
        public int CrossingPeriod
        {
            get { return crossingPeriod; }
            set { crossingPeriod = Math.Max(1, value); }
        }
		
		[Description("")]
        [GridCategory("1 - Setup")]
		[Gui.Design.DisplayName("\t\t\tCrossed MA Type")]
		public CrossedMASelection CrossedMAType
		{
			get { return crossedMAType; }
			set { crossedMAType = value; }
		}
		
		[Description("")]
        [GridCategory("1 - Setup")]
		[Gui.Design.DisplayName("\t\tCrossed MA Period")]
        public int CrossedPeriod
        {
            get { return crossedPeriod; }
            set { crossedPeriod = Math.Max(1, value); }
        }
		
		[Description("")]
        [GridCategory("1 - Setup")]
		[Gui.Design.DisplayName("\tCrossing lookback period")]
        public int LookBackPeriod
        {
            get { return lookBackPeriod; }
            set { lookBackPeriod = Math.Max(1, value); }
        }
		
		[Description("")]
        [GridCategory("1 - Setup")]
		[Gui.Design.DisplayName("Identify Cross Above")]
		public bool CrossesAbove
		{
			get { return crossesAbove; }
			set { crossesAbove = value; }
		}

		[Description("")]
        [GridCategory("1 - Setup")]
		[Gui.Design.DisplayName("Identify Cross Below")]
		public bool CrossesBelow
		{
			get { return crossesBelow; }
			set { crossesBelow = value; }
		}
		
		[Description("")]
        [GridCategory("2 - Actions")]
        public bool SendEmail
        {
            get { return sendEmail; }
            set { sendEmail = value; }
        }

        [Description("")]
        [GridCategory("2 - Actions")]
        public bool AlertWithSound
        {
            get { return alertWithSound; }
            set { alertWithSound = value; }
        }

        [Description("")]
        [GridCategory("2 - Actions")]
        public bool Draw
        {
            get { return draw; }
            set { draw = value; }
        }

        [Description("")]
        [GridCategory("2 - Actions")]
		[Gui.Design.DisplayName("Change Bar Color")]
        public bool ChangeBarColor
        {
            get { return changeBarColor; }
            set { changeBarColor = value; }
        }
		
		[Description("")]
        [GridCategory("2 - Actions")]
		[Gui.Design.DisplayName("Change CandleOutline Color")]
        public bool ChangeBarOutlineColor
        {
            get { return changeBarOutlineColor; }
            set { changeBarOutlineColor = value; }
        }

        [Description("")]
        [GridCategory("2 - Actions")]
		[Gui.Design.DisplayName("Change Chart Back Color")]
        public bool ChangeBackColor
        {
            get { return changeBackColor; }
            set { changeBackColor = value; }
        }
		
		[Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\t\t\t\t\t\t\tResetAlert")]
        public bool ResetAlertNow
        {
            get { return resetAlertNow; }
            set { resetAlertNow = value; }
        }
		
		
		[Description("")]
		[GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\t\t\t\t\t\tDrawType")]
		public DrawSelection DrawType
		{
			get { return drawType; }
			set { drawType = value; }
		}
		
		[Description("")]
		[GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\t\t\t\t\tDraw Tick Offset")]
		public int DrawOffsetTicks
		{
			get { return drawOffsetTicks; }
			set { drawOffsetTicks = Math.Max(1, value); }
		}
		
		[XmlIgnore()]
		[Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\t\t\t\t\tDraw Color")]
        public Color DrawColor
        {
            get { return drawColor; }
            set { drawColor = value; }
        }
		
		[XmlIgnore()]
		[Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\t\t\t\tBar Color")]
        public Color CandleColor
        {
            get { return candleColor; }
            set { candleColor = value; }
        }
		
				
		[XmlIgnore()]
		[Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\t\t\tCandle Outline Color")]
        public Color CandleOutline
        {
            get { return candleOutline; }
            set { candleOutline = value; }
        }
		
		[XmlIgnore()]
		[Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\t\tChart Back Color")]
        public Color ChartBackColor
        {
            get { return chartBackColor; }
            set { chartBackColor = value; }
        }
		
		[Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\t\tEmail From")]
        public string EmailFrom
        {
            get { return emailFrom; }
            set { emailFrom = value; }
        }

        [Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\t\tEmail To")]
        public string EmailTo
        {
            get { return emailTo; }
            set { emailTo = value; }
        }
		
		[Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\t\tEmail Subject")]
        public string EmailSubject
        {
            get { return emailSubject; }
            set { emailSubject = value; }
        }

        [Description("")]
        [GridCategory("3 - Action Parameters")]
		[Gui.Design.DisplayName("\t\tMessage Text")]
        public string MessageText
        {
            get { return messageText; }
            set { messageText = value; }
        }

        [Description("")]
        [GridCategory("3 - Action Parameters")]
        public string SoundFile
        {
            get { return soundFile; }
            set { soundFile = value; }
        }
		
		[Browsable(false)]
		public string drawColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(drawColor); }
			set { drawColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[Browsable(false)]
		public string CandleColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(candleColor); }
			set { candleColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[Browsable(false)]
		public string ChartBackColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(chartBackColor); }
			set { chartBackColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[Browsable(false)]
		public string CandleOutlineColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(candleOutline); }
			set { candleOutline = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
        #endregion
    }
}


public enum CrossingMASelection
{
	EMA,
	HMA,
	SMA,
	WMA,
}

public enum CrossedMASelection
{
	EMA,
	HMA,
	SMA,
	WMA,
}

public enum DrawSelection
{
	TriangleDown,
    TriangleUp,
    ArrowDown,
    Dot,
    ArrowUp,
	Diamond,
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private MACrossBuilder[] cacheMACrossBuilder = null;

        private static MACrossBuilder checkMACrossBuilder = new MACrossBuilder();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public MACrossBuilder MACrossBuilder(bool alertWithSound, Color candleColor, Color candleOutline, bool changeBackColor, bool changeBarColor, bool changeBarOutlineColor, Color chartBackColor, CrossedMASelection crossedMAType, int crossedPeriod, bool crossesAbove, bool crossesBelow, CrossingMASelection crossingMAType, int crossingPeriod, bool draw, Color drawColor, int drawOffsetTicks, DrawSelection drawType, string emailFrom, string emailSubject, string emailTo, int lookBackPeriod, string messageText, bool resetAlertNow, bool sendEmail, string soundFile)
        {
            return MACrossBuilder(Input, alertWithSound, candleColor, candleOutline, changeBackColor, changeBarColor, changeBarOutlineColor, chartBackColor, crossedMAType, crossedPeriod, crossesAbove, crossesBelow, crossingMAType, crossingPeriod, draw, drawColor, drawOffsetTicks, drawType, emailFrom, emailSubject, emailTo, lookBackPeriod, messageText, resetAlertNow, sendEmail, soundFile);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public MACrossBuilder MACrossBuilder(Data.IDataSeries input, bool alertWithSound, Color candleColor, Color candleOutline, bool changeBackColor, bool changeBarColor, bool changeBarOutlineColor, Color chartBackColor, CrossedMASelection crossedMAType, int crossedPeriod, bool crossesAbove, bool crossesBelow, CrossingMASelection crossingMAType, int crossingPeriod, bool draw, Color drawColor, int drawOffsetTicks, DrawSelection drawType, string emailFrom, string emailSubject, string emailTo, int lookBackPeriod, string messageText, bool resetAlertNow, bool sendEmail, string soundFile)
        {
            if (cacheMACrossBuilder != null)
                for (int idx = 0; idx < cacheMACrossBuilder.Length; idx++)
                    if (cacheMACrossBuilder[idx].AlertWithSound == alertWithSound && cacheMACrossBuilder[idx].CandleColor == candleColor && cacheMACrossBuilder[idx].CandleOutline == candleOutline && cacheMACrossBuilder[idx].ChangeBackColor == changeBackColor && cacheMACrossBuilder[idx].ChangeBarColor == changeBarColor && cacheMACrossBuilder[idx].ChangeBarOutlineColor == changeBarOutlineColor && cacheMACrossBuilder[idx].ChartBackColor == chartBackColor && cacheMACrossBuilder[idx].CrossedMAType == crossedMAType && cacheMACrossBuilder[idx].CrossedPeriod == crossedPeriod && cacheMACrossBuilder[idx].CrossesAbove == crossesAbove && cacheMACrossBuilder[idx].CrossesBelow == crossesBelow && cacheMACrossBuilder[idx].CrossingMAType == crossingMAType && cacheMACrossBuilder[idx].CrossingPeriod == crossingPeriod && cacheMACrossBuilder[idx].Draw == draw && cacheMACrossBuilder[idx].DrawColor == drawColor && cacheMACrossBuilder[idx].DrawOffsetTicks == drawOffsetTicks && cacheMACrossBuilder[idx].DrawType == drawType && cacheMACrossBuilder[idx].EmailFrom == emailFrom && cacheMACrossBuilder[idx].EmailSubject == emailSubject && cacheMACrossBuilder[idx].EmailTo == emailTo && cacheMACrossBuilder[idx].LookBackPeriod == lookBackPeriod && cacheMACrossBuilder[idx].MessageText == messageText && cacheMACrossBuilder[idx].ResetAlertNow == resetAlertNow && cacheMACrossBuilder[idx].SendEmail == sendEmail && cacheMACrossBuilder[idx].SoundFile == soundFile && cacheMACrossBuilder[idx].EqualsInput(input))
                        return cacheMACrossBuilder[idx];

            lock (checkMACrossBuilder)
            {
                checkMACrossBuilder.AlertWithSound = alertWithSound;
                alertWithSound = checkMACrossBuilder.AlertWithSound;
                checkMACrossBuilder.CandleColor = candleColor;
                candleColor = checkMACrossBuilder.CandleColor;
                checkMACrossBuilder.CandleOutline = candleOutline;
                candleOutline = checkMACrossBuilder.CandleOutline;
                checkMACrossBuilder.ChangeBackColor = changeBackColor;
                changeBackColor = checkMACrossBuilder.ChangeBackColor;
                checkMACrossBuilder.ChangeBarColor = changeBarColor;
                changeBarColor = checkMACrossBuilder.ChangeBarColor;
                checkMACrossBuilder.ChangeBarOutlineColor = changeBarOutlineColor;
                changeBarOutlineColor = checkMACrossBuilder.ChangeBarOutlineColor;
                checkMACrossBuilder.ChartBackColor = chartBackColor;
                chartBackColor = checkMACrossBuilder.ChartBackColor;
                checkMACrossBuilder.CrossedMAType = crossedMAType;
                crossedMAType = checkMACrossBuilder.CrossedMAType;
                checkMACrossBuilder.CrossedPeriod = crossedPeriod;
                crossedPeriod = checkMACrossBuilder.CrossedPeriod;
                checkMACrossBuilder.CrossesAbove = crossesAbove;
                crossesAbove = checkMACrossBuilder.CrossesAbove;
                checkMACrossBuilder.CrossesBelow = crossesBelow;
                crossesBelow = checkMACrossBuilder.CrossesBelow;
                checkMACrossBuilder.CrossingMAType = crossingMAType;
                crossingMAType = checkMACrossBuilder.CrossingMAType;
                checkMACrossBuilder.CrossingPeriod = crossingPeriod;
                crossingPeriod = checkMACrossBuilder.CrossingPeriod;
                checkMACrossBuilder.Draw = draw;
                draw = checkMACrossBuilder.Draw;
                checkMACrossBuilder.DrawColor = drawColor;
                drawColor = checkMACrossBuilder.DrawColor;
                checkMACrossBuilder.DrawOffsetTicks = drawOffsetTicks;
                drawOffsetTicks = checkMACrossBuilder.DrawOffsetTicks;
                checkMACrossBuilder.DrawType = drawType;
                drawType = checkMACrossBuilder.DrawType;
                checkMACrossBuilder.EmailFrom = emailFrom;
                emailFrom = checkMACrossBuilder.EmailFrom;
                checkMACrossBuilder.EmailSubject = emailSubject;
                emailSubject = checkMACrossBuilder.EmailSubject;
                checkMACrossBuilder.EmailTo = emailTo;
                emailTo = checkMACrossBuilder.EmailTo;
                checkMACrossBuilder.LookBackPeriod = lookBackPeriod;
                lookBackPeriod = checkMACrossBuilder.LookBackPeriod;
                checkMACrossBuilder.MessageText = messageText;
                messageText = checkMACrossBuilder.MessageText;
                checkMACrossBuilder.ResetAlertNow = resetAlertNow;
                resetAlertNow = checkMACrossBuilder.ResetAlertNow;
                checkMACrossBuilder.SendEmail = sendEmail;
                sendEmail = checkMACrossBuilder.SendEmail;
                checkMACrossBuilder.SoundFile = soundFile;
                soundFile = checkMACrossBuilder.SoundFile;

                if (cacheMACrossBuilder != null)
                    for (int idx = 0; idx < cacheMACrossBuilder.Length; idx++)
                        if (cacheMACrossBuilder[idx].AlertWithSound == alertWithSound && cacheMACrossBuilder[idx].CandleColor == candleColor && cacheMACrossBuilder[idx].CandleOutline == candleOutline && cacheMACrossBuilder[idx].ChangeBackColor == changeBackColor && cacheMACrossBuilder[idx].ChangeBarColor == changeBarColor && cacheMACrossBuilder[idx].ChangeBarOutlineColor == changeBarOutlineColor && cacheMACrossBuilder[idx].ChartBackColor == chartBackColor && cacheMACrossBuilder[idx].CrossedMAType == crossedMAType && cacheMACrossBuilder[idx].CrossedPeriod == crossedPeriod && cacheMACrossBuilder[idx].CrossesAbove == crossesAbove && cacheMACrossBuilder[idx].CrossesBelow == crossesBelow && cacheMACrossBuilder[idx].CrossingMAType == crossingMAType && cacheMACrossBuilder[idx].CrossingPeriod == crossingPeriod && cacheMACrossBuilder[idx].Draw == draw && cacheMACrossBuilder[idx].DrawColor == drawColor && cacheMACrossBuilder[idx].DrawOffsetTicks == drawOffsetTicks && cacheMACrossBuilder[idx].DrawType == drawType && cacheMACrossBuilder[idx].EmailFrom == emailFrom && cacheMACrossBuilder[idx].EmailSubject == emailSubject && cacheMACrossBuilder[idx].EmailTo == emailTo && cacheMACrossBuilder[idx].LookBackPeriod == lookBackPeriod && cacheMACrossBuilder[idx].MessageText == messageText && cacheMACrossBuilder[idx].ResetAlertNow == resetAlertNow && cacheMACrossBuilder[idx].SendEmail == sendEmail && cacheMACrossBuilder[idx].SoundFile == soundFile && cacheMACrossBuilder[idx].EqualsInput(input))
                            return cacheMACrossBuilder[idx];

                MACrossBuilder indicator = new MACrossBuilder();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AlertWithSound = alertWithSound;
                indicator.CandleColor = candleColor;
                indicator.CandleOutline = candleOutline;
                indicator.ChangeBackColor = changeBackColor;
                indicator.ChangeBarColor = changeBarColor;
                indicator.ChangeBarOutlineColor = changeBarOutlineColor;
                indicator.ChartBackColor = chartBackColor;
                indicator.CrossedMAType = crossedMAType;
                indicator.CrossedPeriod = crossedPeriod;
                indicator.CrossesAbove = crossesAbove;
                indicator.CrossesBelow = crossesBelow;
                indicator.CrossingMAType = crossingMAType;
                indicator.CrossingPeriod = crossingPeriod;
                indicator.Draw = draw;
                indicator.DrawColor = drawColor;
                indicator.DrawOffsetTicks = drawOffsetTicks;
                indicator.DrawType = drawType;
                indicator.EmailFrom = emailFrom;
                indicator.EmailSubject = emailSubject;
                indicator.EmailTo = emailTo;
                indicator.LookBackPeriod = lookBackPeriod;
                indicator.MessageText = messageText;
                indicator.ResetAlertNow = resetAlertNow;
                indicator.SendEmail = sendEmail;
                indicator.SoundFile = soundFile;
                Indicators.Add(indicator);
                indicator.SetUp();

                MACrossBuilder[] tmp = new MACrossBuilder[cacheMACrossBuilder == null ? 1 : cacheMACrossBuilder.Length + 1];
                if (cacheMACrossBuilder != null)
                    cacheMACrossBuilder.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheMACrossBuilder = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MACrossBuilder MACrossBuilder(bool alertWithSound, Color candleColor, Color candleOutline, bool changeBackColor, bool changeBarColor, bool changeBarOutlineColor, Color chartBackColor, CrossedMASelection crossedMAType, int crossedPeriod, bool crossesAbove, bool crossesBelow, CrossingMASelection crossingMAType, int crossingPeriod, bool draw, Color drawColor, int drawOffsetTicks, DrawSelection drawType, string emailFrom, string emailSubject, string emailTo, int lookBackPeriod, string messageText, bool resetAlertNow, bool sendEmail, string soundFile)
        {
            return _indicator.MACrossBuilder(Input, alertWithSound, candleColor, candleOutline, changeBackColor, changeBarColor, changeBarOutlineColor, chartBackColor, crossedMAType, crossedPeriod, crossesAbove, crossesBelow, crossingMAType, crossingPeriod, draw, drawColor, drawOffsetTicks, drawType, emailFrom, emailSubject, emailTo, lookBackPeriod, messageText, resetAlertNow, sendEmail, soundFile);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.MACrossBuilder MACrossBuilder(Data.IDataSeries input, bool alertWithSound, Color candleColor, Color candleOutline, bool changeBackColor, bool changeBarColor, bool changeBarOutlineColor, Color chartBackColor, CrossedMASelection crossedMAType, int crossedPeriod, bool crossesAbove, bool crossesBelow, CrossingMASelection crossingMAType, int crossingPeriod, bool draw, Color drawColor, int drawOffsetTicks, DrawSelection drawType, string emailFrom, string emailSubject, string emailTo, int lookBackPeriod, string messageText, bool resetAlertNow, bool sendEmail, string soundFile)
        {
            return _indicator.MACrossBuilder(input, alertWithSound, candleColor, candleOutline, changeBackColor, changeBarColor, changeBarOutlineColor, chartBackColor, crossedMAType, crossedPeriod, crossesAbove, crossesBelow, crossingMAType, crossingPeriod, draw, drawColor, drawOffsetTicks, drawType, emailFrom, emailSubject, emailTo, lookBackPeriod, messageText, resetAlertNow, sendEmail, soundFile);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MACrossBuilder MACrossBuilder(bool alertWithSound, Color candleColor, Color candleOutline, bool changeBackColor, bool changeBarColor, bool changeBarOutlineColor, Color chartBackColor, CrossedMASelection crossedMAType, int crossedPeriod, bool crossesAbove, bool crossesBelow, CrossingMASelection crossingMAType, int crossingPeriod, bool draw, Color drawColor, int drawOffsetTicks, DrawSelection drawType, string emailFrom, string emailSubject, string emailTo, int lookBackPeriod, string messageText, bool resetAlertNow, bool sendEmail, string soundFile)
        {
            return _indicator.MACrossBuilder(Input, alertWithSound, candleColor, candleOutline, changeBackColor, changeBarColor, changeBarOutlineColor, chartBackColor, crossedMAType, crossedPeriod, crossesAbove, crossesBelow, crossingMAType, crossingPeriod, draw, drawColor, drawOffsetTicks, drawType, emailFrom, emailSubject, emailTo, lookBackPeriod, messageText, resetAlertNow, sendEmail, soundFile);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.MACrossBuilder MACrossBuilder(Data.IDataSeries input, bool alertWithSound, Color candleColor, Color candleOutline, bool changeBackColor, bool changeBarColor, bool changeBarOutlineColor, Color chartBackColor, CrossedMASelection crossedMAType, int crossedPeriod, bool crossesAbove, bool crossesBelow, CrossingMASelection crossingMAType, int crossingPeriod, bool draw, Color drawColor, int drawOffsetTicks, DrawSelection drawType, string emailFrom, string emailSubject, string emailTo, int lookBackPeriod, string messageText, bool resetAlertNow, bool sendEmail, string soundFile)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.MACrossBuilder(input, alertWithSound, candleColor, candleOutline, changeBackColor, changeBarColor, changeBarOutlineColor, chartBackColor, crossedMAType, crossedPeriod, crossesAbove, crossesBelow, crossingMAType, crossingPeriod, draw, drawColor, drawOffsetTicks, drawType, emailFrom, emailSubject, emailTo, lookBackPeriod, messageText, resetAlertNow, sendEmail, soundFile);
        }
    }
}
#endregion
