	#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;              //NinjaTrader.Gui.Design.SerializableColor.ToString(lineColor
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Draws a Horizontal Line at Current Price by duck_CA")]
    public class PriceLine_Indicator_V_2 : Indicator
    {
        #region Variables
        // Wizard generated variables
        private Color lineColor = Color.Black;
		private int line_Size = 1;
		private DashStyle hlinestyle = DashStyle.Solid; 
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			 
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            //DrawHorizontalLine("Current_price",Close[0],LineColor,DashStyle.Dot,line_Size);
			//DrawHorizontalLine("Current_price",Close[0],LineColor,DashStyle.Solid,3);
			//DrawHorizontalLine("Current_price",Close[0],LineColor,DashStyle.Solid,line_Size);
			DrawHorizontalLine("Current_price",Close[0],Color.Black);
			
	    }

        #region Properties
		
		[Description("Horizontal line style")]
        [Category("Parameters")]
        public DashStyle HorizLineStyle
        {
            get { return hlinestyle; }
            set { hlinestyle = value; }
        }
		 
	    [XmlIgnore()]
        [Description("Current_Price_Line_ Color")]
        [Category("Parameters")]
		[Gui.Design.DisplayName ("\t\tColor LineColor")]
        public Color LineColor
        {
            get { return lineColor; }
            set { lineColor = value; }
        }
		
		[XmlIgnore()]
        [Description("PriceLine_Indicator_V_2_Test_Size")]
        [Category("Parameters")]
		[Gui.Design.DisplayName ("\t\tPriceLine_test_Size")]
        public int PriceLine_Indicator_V_2_Size
        {
            get { return line_Size; }
            set { line_Size = value; }
        }
		
		// Serialize our Color object
		[Browsable(false)]
		public string LineColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(lineColor); }//SerializableColor
			set { lineColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Now
        {
            get { return Values[0]; }
        }
      
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Current_Price
        {
            get { return Values[1]; }
        }
		 
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PriceLine_Indicator_V_2[] cachePriceLine_Indicator_V_2 = null;

        private static PriceLine_Indicator_V_2 checkPriceLine_Indicator_V_2 = new PriceLine_Indicator_V_2();

        /// <summary>
        /// Draws a Horizontal Line at Current Price by duck_CA
        /// </summary>
        /// <returns></returns>
        public PriceLine_Indicator_V_2 PriceLine_Indicator_V_2(DashStyle horizLineStyle, Color lineColor, int priceLine_Indicator_V_2_Size)
        {
            return PriceLine_Indicator_V_2(Input, horizLineStyle, lineColor, priceLine_Indicator_V_2_Size);
        }

        /// <summary>
        /// Draws a Horizontal Line at Current Price by duck_CA
        /// </summary>
        /// <returns></returns>
        public PriceLine_Indicator_V_2 PriceLine_Indicator_V_2(Data.IDataSeries input, DashStyle horizLineStyle, Color lineColor, int priceLine_Indicator_V_2_Size)
        {
            if (cachePriceLine_Indicator_V_2 != null)
                for (int idx = 0; idx < cachePriceLine_Indicator_V_2.Length; idx++)
                    if (cachePriceLine_Indicator_V_2[idx].HorizLineStyle == horizLineStyle && cachePriceLine_Indicator_V_2[idx].LineColor == lineColor && cachePriceLine_Indicator_V_2[idx].PriceLine_Indicator_V_2_Size == priceLine_Indicator_V_2_Size && cachePriceLine_Indicator_V_2[idx].EqualsInput(input))
                        return cachePriceLine_Indicator_V_2[idx];

            lock (checkPriceLine_Indicator_V_2)
            {
                checkPriceLine_Indicator_V_2.HorizLineStyle = horizLineStyle;
                horizLineStyle = checkPriceLine_Indicator_V_2.HorizLineStyle;
                checkPriceLine_Indicator_V_2.LineColor = lineColor;
                lineColor = checkPriceLine_Indicator_V_2.LineColor;
                checkPriceLine_Indicator_V_2.PriceLine_Indicator_V_2_Size = priceLine_Indicator_V_2_Size;
                priceLine_Indicator_V_2_Size = checkPriceLine_Indicator_V_2.PriceLine_Indicator_V_2_Size;

                if (cachePriceLine_Indicator_V_2 != null)
                    for (int idx = 0; idx < cachePriceLine_Indicator_V_2.Length; idx++)
                        if (cachePriceLine_Indicator_V_2[idx].HorizLineStyle == horizLineStyle && cachePriceLine_Indicator_V_2[idx].LineColor == lineColor && cachePriceLine_Indicator_V_2[idx].PriceLine_Indicator_V_2_Size == priceLine_Indicator_V_2_Size && cachePriceLine_Indicator_V_2[idx].EqualsInput(input))
                            return cachePriceLine_Indicator_V_2[idx];

                PriceLine_Indicator_V_2 indicator = new PriceLine_Indicator_V_2();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.HorizLineStyle = horizLineStyle;
                indicator.LineColor = lineColor;
                indicator.PriceLine_Indicator_V_2_Size = priceLine_Indicator_V_2_Size;
                Indicators.Add(indicator);
                indicator.SetUp();

                PriceLine_Indicator_V_2[] tmp = new PriceLine_Indicator_V_2[cachePriceLine_Indicator_V_2 == null ? 1 : cachePriceLine_Indicator_V_2.Length + 1];
                if (cachePriceLine_Indicator_V_2 != null)
                    cachePriceLine_Indicator_V_2.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachePriceLine_Indicator_V_2 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Draws a Horizontal Line at Current Price by duck_CA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceLine_Indicator_V_2 PriceLine_Indicator_V_2(DashStyle horizLineStyle, Color lineColor, int priceLine_Indicator_V_2_Size)
        {
            return _indicator.PriceLine_Indicator_V_2(Input, horizLineStyle, lineColor, priceLine_Indicator_V_2_Size);
        }

        /// <summary>
        /// Draws a Horizontal Line at Current Price by duck_CA
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceLine_Indicator_V_2 PriceLine_Indicator_V_2(Data.IDataSeries input, DashStyle horizLineStyle, Color lineColor, int priceLine_Indicator_V_2_Size)
        {
            return _indicator.PriceLine_Indicator_V_2(input, horizLineStyle, lineColor, priceLine_Indicator_V_2_Size);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Draws a Horizontal Line at Current Price by duck_CA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PriceLine_Indicator_V_2 PriceLine_Indicator_V_2(DashStyle horizLineStyle, Color lineColor, int priceLine_Indicator_V_2_Size)
        {
            return _indicator.PriceLine_Indicator_V_2(Input, horizLineStyle, lineColor, priceLine_Indicator_V_2_Size);
        }

        /// <summary>
        /// Draws a Horizontal Line at Current Price by duck_CA
        /// </summary>
        /// <returns></returns>
        public Indicator.PriceLine_Indicator_V_2 PriceLine_Indicator_V_2(Data.IDataSeries input, DashStyle horizLineStyle, Color lineColor, int priceLine_Indicator_V_2_Size)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PriceLine_Indicator_V_2(input, horizLineStyle, lineColor, priceLine_Indicator_V_2_Size);
        }
    }
}
#endregion
