//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private IGTDSequential[] cacheIGTDSequential = null;

        private static IGTDSequential checkIGTDSequential = new IGTDSequential();

        /// <summary>
        /// TD Sequential/Combo Countdown
        /// </summary>
        /// <returns></returns>
        public IGTDSequential IGTDSequential()
        {
            return IGTDSequential(Input);
        }

        /// <summary>
        /// TD Sequential/Combo Countdown
        /// </summary>
        /// <returns></returns>
        public IGTDSequential IGTDSequential(Data.IDataSeries input)
        {
            if (cacheIGTDSequential != null)
                for (int idx = 0; idx < cacheIGTDSequential.Length; idx++)
                    if (cacheIGTDSequential[idx].EqualsInput(input))
                        return cacheIGTDSequential[idx];

            lock (checkIGTDSequential)
            {
                if (cacheIGTDSequential != null)
                    for (int idx = 0; idx < cacheIGTDSequential.Length; idx++)
                        if (cacheIGTDSequential[idx].EqualsInput(input))
                            return cacheIGTDSequential[idx];

                IGTDSequential indicator = new IGTDSequential();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                IGTDSequential[] tmp = new IGTDSequential[cacheIGTDSequential == null ? 1 : cacheIGTDSequential.Length + 1];
                if (cacheIGTDSequential != null)
                    cacheIGTDSequential.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheIGTDSequential = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// TD Sequential/Combo Countdown
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.IGTDSequential IGTDSequential()
        {
            return _indicator.IGTDSequential(Input);
        }

        /// <summary>
        /// TD Sequential/Combo Countdown
        /// </summary>
        /// <returns></returns>
        public Indicator.IGTDSequential IGTDSequential(Data.IDataSeries input)
        {
            return _indicator.IGTDSequential(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// TD Sequential/Combo Countdown
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.IGTDSequential IGTDSequential()
        {
            return _indicator.IGTDSequential(Input);
        }

        /// <summary>
        /// TD Sequential/Combo Countdown
        /// </summary>
        /// <returns></returns>
        public Indicator.IGTDSequential IGTDSequential(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.IGTDSequential(input);
        }
    }
}
#endregion
