#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// 
    /// </summary>
    [Description("Plots vertical lines at specified intervals.")]
    public class VerticalLinesCustom : Indicator
    {
        #region Variables
		private int 		lineInterval 		= 10; 
		private int 		lineWidth 			= 1;
		private Color 		lineColor 			= Color.LightGray;
		private DashStyle 	lineStyle 			= DashStyle.Dash;
		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Overlay				= true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {		 
			if (LineInterval == 1)
				DrawVerticalLine(CurrentBar.ToString(), 0, LineColor, LineStyle, LineWidth);
		
			else if (CurrentBar % LineInterval == 1)    
				DrawVerticalLine(CurrentBar.ToString(), 0, LineColor, LineStyle, LineWidth);
        }
		
		public override string ToString() //formats chart label
		{
			return "VLines" + "(" + LineInterval + ")";
		}
		
        #region Properties
        [Description("Sets the bar interval that lines are drawn")]
        [GridCategory("Parameters")]
        public int LineInterval
        {
            get { return lineInterval; }
            set { lineInterval = Math.Max(1, value); }
        }
		
		[Description("Price Line Style")]
        [GridCategory("Parameters")]
        public DashStyle LineStyle
        {
            get { return lineStyle; }
            set { lineStyle = value; }
        }
		 
        [Description("Price Line Color")]
        [GridCategory("Parameters")]
        public Color LineColor
        {
            get { return lineColor; }
            set { lineColor = value; }
        }
		
		[Browsable(false)]
		public string LineColorSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableColor.ToString(lineColor); }//SerializableColor
			set { lineColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}		

    	[Description("Price Line Width")]
    	[GridCategory("Parameters")]
        public int LineWidth
        {
            get { return lineWidth; }
            set { lineWidth = value; }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private VerticalLinesCustom[] cacheVerticalLinesCustom = null;

        private static VerticalLinesCustom checkVerticalLinesCustom = new VerticalLinesCustom();

        /// <summary>
        /// Plots vertical lines at specified intervals.
        /// </summary>
        /// <returns></returns>
        public VerticalLinesCustom VerticalLinesCustom(Color lineColor, int lineInterval, DashStyle lineStyle, int lineWidth)
        {
            return VerticalLinesCustom(Input, lineColor, lineInterval, lineStyle, lineWidth);
        }

        /// <summary>
        /// Plots vertical lines at specified intervals.
        /// </summary>
        /// <returns></returns>
        public VerticalLinesCustom VerticalLinesCustom(Data.IDataSeries input, Color lineColor, int lineInterval, DashStyle lineStyle, int lineWidth)
        {
            if (cacheVerticalLinesCustom != null)
                for (int idx = 0; idx < cacheVerticalLinesCustom.Length; idx++)
                    if (cacheVerticalLinesCustom[idx].LineColor == lineColor && cacheVerticalLinesCustom[idx].LineInterval == lineInterval && cacheVerticalLinesCustom[idx].LineStyle == lineStyle && cacheVerticalLinesCustom[idx].LineWidth == lineWidth && cacheVerticalLinesCustom[idx].EqualsInput(input))
                        return cacheVerticalLinesCustom[idx];

            lock (checkVerticalLinesCustom)
            {
                checkVerticalLinesCustom.LineColor = lineColor;
                lineColor = checkVerticalLinesCustom.LineColor;
                checkVerticalLinesCustom.LineInterval = lineInterval;
                lineInterval = checkVerticalLinesCustom.LineInterval;
                checkVerticalLinesCustom.LineStyle = lineStyle;
                lineStyle = checkVerticalLinesCustom.LineStyle;
                checkVerticalLinesCustom.LineWidth = lineWidth;
                lineWidth = checkVerticalLinesCustom.LineWidth;

                if (cacheVerticalLinesCustom != null)
                    for (int idx = 0; idx < cacheVerticalLinesCustom.Length; idx++)
                        if (cacheVerticalLinesCustom[idx].LineColor == lineColor && cacheVerticalLinesCustom[idx].LineInterval == lineInterval && cacheVerticalLinesCustom[idx].LineStyle == lineStyle && cacheVerticalLinesCustom[idx].LineWidth == lineWidth && cacheVerticalLinesCustom[idx].EqualsInput(input))
                            return cacheVerticalLinesCustom[idx];

                VerticalLinesCustom indicator = new VerticalLinesCustom();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.LineColor = lineColor;
                indicator.LineInterval = lineInterval;
                indicator.LineStyle = lineStyle;
                indicator.LineWidth = lineWidth;
                Indicators.Add(indicator);
                indicator.SetUp();

                VerticalLinesCustom[] tmp = new VerticalLinesCustom[cacheVerticalLinesCustom == null ? 1 : cacheVerticalLinesCustom.Length + 1];
                if (cacheVerticalLinesCustom != null)
                    cacheVerticalLinesCustom.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheVerticalLinesCustom = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Plots vertical lines at specified intervals.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VerticalLinesCustom VerticalLinesCustom(Color lineColor, int lineInterval, DashStyle lineStyle, int lineWidth)
        {
            return _indicator.VerticalLinesCustom(Input, lineColor, lineInterval, lineStyle, lineWidth);
        }

        /// <summary>
        /// Plots vertical lines at specified intervals.
        /// </summary>
        /// <returns></returns>
        public Indicator.VerticalLinesCustom VerticalLinesCustom(Data.IDataSeries input, Color lineColor, int lineInterval, DashStyle lineStyle, int lineWidth)
        {
            return _indicator.VerticalLinesCustom(input, lineColor, lineInterval, lineStyle, lineWidth);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Plots vertical lines at specified intervals.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VerticalLinesCustom VerticalLinesCustom(Color lineColor, int lineInterval, DashStyle lineStyle, int lineWidth)
        {
            return _indicator.VerticalLinesCustom(Input, lineColor, lineInterval, lineStyle, lineWidth);
        }

        /// <summary>
        /// Plots vertical lines at specified intervals.
        /// </summary>
        /// <returns></returns>
        public Indicator.VerticalLinesCustom VerticalLinesCustom(Data.IDataSeries input, Color lineColor, int lineInterval, DashStyle lineStyle, int lineWidth)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.VerticalLinesCustom(input, lineColor, lineInterval, lineStyle, lineWidth);
        }
    }
}
#endregion
