#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Converted to NinjaScript by Elliott Wave 12/05/2008
    ///+------------------------------------------------------------------+
	///|                                                        Drive.mq4 |
	///|                                       Copyright © 2005, systrad5 |
	///|                                                         25/07/05 |
	///|               Feedback or comments welcome at systrad5@yahoo.com |
	///+------------------------------------------------------------------+
    [Description("Buy when the blue line is above the red line and sell when the red line is above the blue line.")]
    public class Drive : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int depth = 16; // Default setting for Period
			private int j = 0;
			private double UpCnt =0; 
			private double DnCnt =0;
			private int smooth = 2;
		
			private DataSeries					tempUp;
			private DataSeries					tempDown;
			private DataSeries					tempDiff;

        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Blue), PlotStyle.Line, "DriveUp"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Red), PlotStyle.Line, "DriveDn"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Transparent), PlotStyle.Bar, "Difference"));
			Plots[0].Pen.Width =2;
			Plots[1].Pen.Width =2;
			Plots[2].Pen.Width =2;

            CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= false;
			
			tempUp				= new DataSeries(this);
			tempDown			= new DataSeries(this);
			tempDiff			= new DataSeries(this);
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            if (CurrentBar ==0)
				DriveUp.Set(0);
				DriveDn.Set(0);
				Difference.Set(0);
			
			if (CurrentBar < depth + 10)
				return;
			// Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.

				UpCnt = 0;
				DnCnt = 0;
			
			for(j = 0; j < Depth; j++)
				{
				UpCnt = UpCnt + (High[j] - Open[j]) + (Close[j] - Low[j]);
				DnCnt = DnCnt + (Open[j] - Low[j]) + (High[j] - Close[j]);
				}
			
				tempUp.Set((UpCnt / (2 * Depth)) / Instrument.MasterInstrument.PointValue);
				tempDown.Set((DnCnt / (2 * Depth)) / Instrument.MasterInstrument.PointValue);
			
//			DriveUp.Set(T3(tempUp,0.618,smooth)[0]);
//			DriveDn.Set(T3(tempDown,0.618,smooth)[0]);
//				tempDiff.Set(DriveUp[0]-DriveDn[0]);
				         //input, period, count, amp
			DriveUp.Set(T3(tempUp, smooth, smooth, 0.7)[0]);
			DriveDn.Set(T3(tempDown, smooth, smooth, 0.7)[0]);
//			DriveUp.Set(T3(tempUp,0.7,smooth)[0]);
				         //input,amp,smooth
//			DriveDn.Set(T3(tempDown,0.7,smooth)[0]);
			Difference.Set(DriveUp[0]-DriveDn[0]);
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries DriveUp
        {
            get { return Values[0]; }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries DriveDn
        {
            get { return Values[1]; }
        }
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Difference
        {
            get { return Values[2]; }
        }
        [Description("Length of calculation")]
        [Category("Parameters")]
        public int Depth
        {
            get { return depth; }
            set { depth = Math.Max(1, value); }
        }
		
		[Description("Smoothing factor")]
        [Category("Parameters")]
        public int Smooth
        {
            get { return smooth; }
            set { smooth = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private Drive[] cacheDrive = null;

        private static Drive checkDrive = new Drive();

        /// <summary>
        /// Buy when the blue line is above the red line and sell when the red line is above the blue line.
        /// </summary>
        /// <returns></returns>
        public Drive Drive(int depth, int smooth)
        {
            return Drive(Input, depth, smooth);
        }

        /// <summary>
        /// Buy when the blue line is above the red line and sell when the red line is above the blue line.
        /// </summary>
        /// <returns></returns>
        public Drive Drive(Data.IDataSeries input, int depth, int smooth)
        {
            if (cacheDrive != null)
                for (int idx = 0; idx < cacheDrive.Length; idx++)
                    if (cacheDrive[idx].Depth == depth && cacheDrive[idx].Smooth == smooth && cacheDrive[idx].EqualsInput(input))
                        return cacheDrive[idx];

            lock (checkDrive)
            {
                checkDrive.Depth = depth;
                depth = checkDrive.Depth;
                checkDrive.Smooth = smooth;
                smooth = checkDrive.Smooth;

                if (cacheDrive != null)
                    for (int idx = 0; idx < cacheDrive.Length; idx++)
                        if (cacheDrive[idx].Depth == depth && cacheDrive[idx].Smooth == smooth && cacheDrive[idx].EqualsInput(input))
                            return cacheDrive[idx];

                Drive indicator = new Drive();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Depth = depth;
                indicator.Smooth = smooth;
                Indicators.Add(indicator);
                indicator.SetUp();

                Drive[] tmp = new Drive[cacheDrive == null ? 1 : cacheDrive.Length + 1];
                if (cacheDrive != null)
                    cacheDrive.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDrive = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Buy when the blue line is above the red line and sell when the red line is above the blue line.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Drive Drive(int depth, int smooth)
        {
            return _indicator.Drive(Input, depth, smooth);
        }

        /// <summary>
        /// Buy when the blue line is above the red line and sell when the red line is above the blue line.
        /// </summary>
        /// <returns></returns>
        public Indicator.Drive Drive(Data.IDataSeries input, int depth, int smooth)
        {
            return _indicator.Drive(input, depth, smooth);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Buy when the blue line is above the red line and sell when the red line is above the blue line.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Drive Drive(int depth, int smooth)
        {
            return _indicator.Drive(Input, depth, smooth);
        }

        /// <summary>
        /// Buy when the blue line is above the red line and sell when the red line is above the blue line.
        /// </summary>
        /// <returns></returns>
        public Indicator.Drive Drive(Data.IDataSeries input, int depth, int smooth)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.Drive(input, depth, smooth);
        }
    }
}
#endregion
