#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion


// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Draws color rectangles.....color,border,size are fully configurable
	///
    /// </summary>
    [Description("ColorZone3  (Ver 1.5 ... 02/11/11 by photog53) Draws rectangles around desired levels...enter Price and get a 3 tick 'zone'.   Allows changes to color, border, & size.")]
    public class ColorZone3 : Indicator
    {
        #region Variables
			//==========PARAMETERS  ==============
			private int opacity			= 3;
			private int zonesize		= 1;
		
		
			//=========== WK FIELDS ==================
			private double wk_zonesize	= .0001;
			
			private double zone1		= 1;
			private Color zone1Clr 		= Color.LightCoral;
			private Color zone1ClrBdr	= Color.Red;
			private string zone1text 	= @" ";
			private double zone2		= 1;
			private Color zone2Clr 		= Color.LightCoral;
			private Color zone2ClrBdr	= Color.Red;
			private string zone2text 	= @" ";
			private double zone3		= 1;
			private Color zone3Clr 		= Color.Orange;
			private Color zone3ClrBdr	= Color.DarkOrange;
			private string zone3text 	= @" ";
			private double zone4		= 1;
			private Color zone4Clr 		= Color.Yellow;
			private Color zone4ClrBdr	= Color.Gold;
			private string zone4text 	= @" ";
			private double zone5		= 1;
			private Color zone5Clr 		= Color.LawnGreen;
			private Color zone5ClrBdr	= Color.LimeGreen;	
			private string zone5text 	= @" ";
			private double zone6		= 1;
			private Color zone6Clr 		= Color.LawnGreen;
			private Color zone6ClrBdr	= Color.LimeGreen;	
			private string zone6text 	= @" ";
			private double zone7		= 1;
			private Color zone7Clr 		= Color.LawnGreen;
			private Color zone7ClrBdr	= Color.LimeGreen;	
			private string zone7text 	= @" ";
			private double zone8		= 1;
			private Color zone8Clr 		= Color.LawnGreen;
			private Color zone8ClrBdr	= Color.LimeGreen;	
			private string zone8text 	= @" ";
			private double zone9		= 1;
			private Color zone9Clr 		= Color.LawnGreen;
			private Color zone9ClrBdr	= Color.LimeGreen;	
			private string zone9text 	= @" ";
			private double zone10		= 1;
			private Color zone10Clr 	= Color.LawnGreen;
			private Color zone10ClrBdr	= Color.LimeGreen;	
			private string zone10text 	= @" ";
			private double zone11		= 1;
			private Color zone11Clr 	= Color.LawnGreen;
			private Color zone11ClrBdr	= Color.LimeGreen;	
			private string zone11text 	= @" ";
			private double zone12		= 1;
			private Color zone12Clr		= Color.LawnGreen;
			private Color zone12ClrBdr	= Color.LimeGreen;	
			private string zone12text 	= @" ";

		
			private int textShift		= 3;	// shift left right
			private int textOffset		= 10;	// offset up/down
			private Font textFont	= new Font("Courier", 10, FontStyle.Regular);
			private Color textColor = Color.White;
			private Color tr		= Color.Transparent;

		
			private double zone1a		= 1;
			private double zone1b		= 1;
			private double zone2a		= 1;
			private double zone2b		= 1;
			private double zone3a		= 1;
			private double zone3b		= 1;
			private double zone4a		= 1;
			private double zone4b		= 1;
			private double zone5a		= 1;
			private double zone5b		= 1;
			private double zone6a		= 1;
			private double zone6b		= 1;
			private double zone7a		= 1;
			private double zone7b		= 1;
			private double zone8a		= 1;
			private double zone8b		= 1;
			private double zone9a		= 1;
			private double zone9b		= 1;
			private double zone10a		= 1;
			private double zone10b		= 1;
			private double zone11a		= 1;
			private double zone11b		= 1;
			private double zone12a		= 1;
			private double zone12b		= 1;
		
		
		
		
			private DataSeries myDataSeries1a;
			private DataSeries myDataSeries1b;
			private DataSeries myDataSeries2a;
			private DataSeries myDataSeries2b;
			private DataSeries myDataSeries3a;
			private DataSeries myDataSeries3b;
			private DataSeries myDataSeries4a;
			private DataSeries myDataSeries4b;
			private DataSeries myDataSeries5a;
			private DataSeries myDataSeries5b;
			private DataSeries myDataSeries6a;
			private DataSeries myDataSeries6b;
			private DataSeries myDataSeries7a;
			private DataSeries myDataSeries7b;
			private DataSeries myDataSeries8a;
			private DataSeries myDataSeries8b;
			private DataSeries myDataSeries9a;
			private DataSeries myDataSeries9b;
			private DataSeries myDataSeries10a;
			private DataSeries myDataSeries10b;
			private DataSeries myDataSeries11a;
			private DataSeries myDataSeries11b;
			private DataSeries myDataSeries12a;
			private DataSeries myDataSeries12b;
		
		
		
		
		

		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
        			
			myDataSeries1a = new DataSeries(this);
			myDataSeries1b = new DataSeries(this);
			myDataSeries2a = new DataSeries(this);
			myDataSeries2b = new DataSeries(this);			
			myDataSeries3a = new DataSeries(this);
			myDataSeries3b = new DataSeries(this);
			myDataSeries4a = new DataSeries(this);
			myDataSeries4b = new DataSeries(this);
			myDataSeries5a = new DataSeries(this);
			myDataSeries5b = new DataSeries(this);			
			myDataSeries6a = new DataSeries(this);
			myDataSeries6b = new DataSeries(this);			
			myDataSeries7a = new DataSeries(this);
			myDataSeries7b = new DataSeries(this);			
			myDataSeries8a = new DataSeries(this);
			myDataSeries8b = new DataSeries(this);			
			myDataSeries9a = new DataSeries(this);
			myDataSeries9b = new DataSeries(this);			
			myDataSeries10a = new DataSeries(this);
			myDataSeries10b = new DataSeries(this);			
			myDataSeries11a = new DataSeries(this);
			myDataSeries11b = new DataSeries(this);			
			myDataSeries12a = new DataSeries(this);
			myDataSeries12b = new DataSeries(this);			
			
		
		    
			
            CalculateOnBarClose	= true;
            Overlay				= true;
            PriceTypeSupported	= false;
			AutoScale			= false;
			
						
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			wk_zonesize = zonesize * TickSize;
			
			if (CurrentBar < textShift)  return;
			
			zone1a = zone1 - wk_zonesize;
			zone1b = zone1 + wk_zonesize;
			myDataSeries1a.Set(zone1a);
			myDataSeries1b.Set(zone1b);
			DrawRegion("Zone1", CurrentBar, 0, myDataSeries1a, myDataSeries1b, zone1ClrBdr, zone1Clr, opacity );			
			DrawText("Zone1text", AutoScale, zone1text, textShift, zone1a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);

			zone2a = zone2 - wk_zonesize;
			zone2b = zone2 + wk_zonesize;
			myDataSeries2a.Set(zone2a);
			myDataSeries2b.Set(zone2b);
			DrawRegion("Zone2", CurrentBar, 0, myDataSeries2a, myDataSeries2b, zone2ClrBdr, zone2Clr, opacity);			
			DrawText("Zone2text", AutoScale, zone2text, textShift, zone2a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);

			zone3a = zone3 - wk_zonesize;
			zone3b = zone3 + wk_zonesize;
			myDataSeries3a.Set(zone3a);
			myDataSeries3b.Set(zone3b);
			DrawRegion("Zone3", CurrentBar, 0, myDataSeries3a, myDataSeries3b, zone3ClrBdr, zone3Clr, opacity);			
			DrawText("Zone3text", AutoScale, zone3text, textShift, zone3a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);

			zone4a = zone4 - wk_zonesize;
			zone4b = zone4 + wk_zonesize;
			myDataSeries4a.Set(zone4a);
			myDataSeries4b.Set(zone4b);
			DrawRegion("Zone4", CurrentBar, 0, myDataSeries4a, myDataSeries4b, zone4ClrBdr, zone4Clr, opacity);
			DrawText("Zone4text", AutoScale, zone4text, textShift, zone4a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);

			zone5a = zone5 - wk_zonesize;
			zone5b = zone5 + wk_zonesize;
			myDataSeries5a.Set(zone5a);
			myDataSeries5b.Set(zone5b);
			DrawRegion("Zone5", CurrentBar, 0, myDataSeries5a, myDataSeries5b, zone5ClrBdr, zone5Clr, opacity);
			DrawText("Zone5text", AutoScale, zone5text, textShift, zone5a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);

			zone6a = zone6 - wk_zonesize;
			zone6b = zone6 + wk_zonesize;
			myDataSeries6a.Set(zone6a);
			myDataSeries6b.Set(zone6b);
			DrawRegion("Zone6", CurrentBar, 0, myDataSeries6a, myDataSeries6b, zone6ClrBdr, zone6Clr, opacity);
			DrawText("Zone6text", AutoScale, zone6text, textShift, zone6a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);			
			
			zone7a = zone7 - wk_zonesize;
			zone7b = zone7 + wk_zonesize;
			myDataSeries7a.Set(zone7a);
			myDataSeries7b.Set(zone7b);
			DrawRegion("Zone7", CurrentBar, 0, myDataSeries7a, myDataSeries7b, zone7ClrBdr, zone7Clr, opacity);
			DrawText("Zone7text", AutoScale, zone7text, textShift, zone7a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);			

			zone8a = zone8 - wk_zonesize;
			zone8b = zone8 + wk_zonesize;
			myDataSeries8a.Set(zone8a);
			myDataSeries8b.Set(zone8b);
			DrawRegion("Zone8", CurrentBar, 0, myDataSeries8a, myDataSeries8b, zone8ClrBdr, zone8Clr, opacity);
			DrawText("Zone8text", AutoScale, zone8text, textShift, zone8a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);			

			zone9a = zone9 - wk_zonesize;
			zone9b = zone9 + wk_zonesize;
			myDataSeries9a.Set(zone9a);
			myDataSeries9b.Set(zone9b);
			DrawRegion("Zone9", CurrentBar, 0, myDataSeries9a, myDataSeries9b, zone9ClrBdr, zone9Clr, opacity);
			DrawText("Zone9text", AutoScale, zone9text, textShift, zone9a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);			
			
			zone10a = zone10 - wk_zonesize;
			zone10b = zone10 + wk_zonesize;
			myDataSeries10a.Set(zone10a);
			myDataSeries10b.Set(zone10b);
			DrawRegion("Zone10", CurrentBar, 0, myDataSeries10a, myDataSeries10b, zone10ClrBdr, zone10Clr, opacity);
			DrawText("Zone10text", AutoScale, zone10text, textShift, zone10a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);			

			zone11a = zone11 - wk_zonesize;
			zone11b = zone11 + wk_zonesize;
			myDataSeries11a.Set(zone11a);
			myDataSeries11b.Set(zone11b);
			DrawRegion("Zone11", CurrentBar, 0, myDataSeries11a, myDataSeries11b, zone11ClrBdr, zone11Clr, opacity);
			DrawText("Zone11text", AutoScale, zone11text, textShift, zone11a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);			
			
			zone12a = zone12 - wk_zonesize;
			zone12b = zone12 + wk_zonesize;
			myDataSeries12a.Set(zone12a);
			myDataSeries12b.Set(zone12b);
			DrawRegion("Zone12", CurrentBar, 0, myDataSeries12a, myDataSeries12b, zone12ClrBdr, zone12Clr, opacity);
			DrawText("Zone12text", AutoScale, zone12text, textShift, zone12a, textOffset, textColor, textFont, StringAlignment.Center, tr,tr, 0);			
			
			
			
        }

        #region Properties
		[Description("Opacity level for zones....1=light   10= dark")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Opacity")]
		public int Opacity
        {
            get { return opacity; }
            set { opacity = Math.Max(1, value); }
        }
		
		[Description("Zone size....in ticks.  # of Ticks up/down the region goes from the desired price")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone Size")]
		public int Zonesize
        {
            get { return zonesize; }
            set { zonesize = Math.Max(1, value); }
        }		
		
    //------------- Zone 1 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone1")]
		public double Zone1a
        {
            get { return zone1; }
            set { zone1 = Math.Max(-10, value); }
        }

        [XmlIgnore()]
		[Description("Color for Zone 1")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone1 Color")]
	    public Color Zone1Clr
        {
            get { return zone1Clr; }
            set { zone1Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone1ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone1Clr);}
				    set {zone1Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("Color for Zone 1 Border")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone1 Color Border")]
	    public Color Zone1ClrBdr
        {
            get { return zone1ClrBdr; }
            set { zone1ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone1ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone1ClrBdr);}
				    set {zone1ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone1 Text")]
		public string Zone1text
        {
            get { return zone1text; }
            set { zone1text = value; }
        }
		
			
    //------------- Zone 2 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone2")]
		public double Zone2
        {
            get { return zone2; }
            set { zone2 = Math.Max(-10, value); }
        }

        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone2 Color")]
	    public Color Zone2Clr
        {
            get { return zone2Clr; }
            set { zone2Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone2ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone2Clr);}
				    set {zone2Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone2 Color Border")]
	    public Color Zone2ClrBdr
        {
            get { return zone2ClrBdr; }
            set { zone2ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone2ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone2ClrBdr);}
				    set {zone2ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }    
			
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone2 Text")]
		public string Zone2text
        {
            get { return zone2text; }
            set { zone2text = value; }
        }
			
    //------------- Zone 3 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone3")]
		public double Zone3
        {
            get { return zone3; }
            set { zone3 = Math.Max(-10, value); }
        }

        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone3 Color")]
	    public Color Zone3Clr
        {
            get { return zone3Clr; }
            set { zone3Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone3ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone3Clr);}
				    set {zone3Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone3 Color Border")]
	    public Color Zone3ClrBdr
        {
            get { return zone3ClrBdr; }
            set { zone3ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone3ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone3ClrBdr);}
				    set {zone3ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }       	

		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone3 Text")]
		public string Zone3text
        {
            get { return zone3text; }
            set { zone3text = value; }
        }
			
			
    //------------- Zone 4 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone4")]
		public double Zone4
        {
            get { return zone4; }
            set { zone4 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone4 Color")]
	    public Color Zone4Clr
        {
            get { return zone4Clr; }
            set { zone4Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone4ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone4Clr);}
				    set {zone4Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone4 Color Border")]
	    public Color Zone4ClrBdr
        {
            get { return zone4ClrBdr; }
            set { zone4ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone4ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone4ClrBdr);}
				    set {zone4ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone4 Text")]
		public string Zone4text
        {
            get { return zone4text; }
            set { zone4text = value; }
        }
	
			
    //------------- Zone 5 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone5")]
		public double Zone5
        {
            get { return zone5; }
            set { zone5 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone5 Color")]
	    public Color Zone5Clr
        {
            get { return zone5Clr; }
            set { zone5Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone5ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone5Clr);}
				    set {zone5Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone5 Color Border")]
	    public Color Zone5ClrBdr
        {
            get { return zone5ClrBdr; }
            set { zone5ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone5ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone5ClrBdr);}
				    set {zone5ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }       	
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone5 Text")]
		public string Zone5text
        {
            get { return zone5text; }
            set { zone5text = value; }
        }
		
    //------------- Zone 6 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone6")]
		public double Zone6
        {
            get { return zone6; }
            set { zone6 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone6 Color")]
	    public Color Zone6Clr
        {
            get { return zone6Clr; }
            set { zone6Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone6ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone6Clr);}
				    set {zone6Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone6 Color Border")]
	    public Color Zone6ClrBdr
        {
            get { return zone6ClrBdr; }
            set { zone6ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone6ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone6ClrBdr);}
				    set {zone6ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone6 Text")]
		public string Zone6text
        {
            get { return zone6text; }
            set { zone6text = value; }
        }

    //------------- Zone 7 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone7")]
		public double Zone7
        {
            get { return zone7; }
            set { zone7 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone7 Color")]
	    public Color Zone7Clr
        {
            get { return zone7Clr; }
            set { zone7Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone7ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone7Clr);}
				    set {zone7Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone7 Color Border")]
	    public Color Zone7ClrBdr
        {
            get { return zone7ClrBdr; }
            set { zone7ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone7ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone7ClrBdr);}
				    set {zone7ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone7 Text")]
		public string Zone7text
        {
            get { return zone7text; }
            set { zone7text = value; }
        }
	
    //------------- Zone 8 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone8")]
		public double Zone8
        {
            get { return zone8; }
            set { zone8 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone8 Color")]
	    public Color Zone8Clr
        {
            get { return zone8Clr; }
            set { zone8Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone8ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone8Clr);}
				    set {zone8Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone8 Color Border")]
	    public Color Zone8ClrBdr
        {
            get { return zone8ClrBdr; }
            set { zone8ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone8ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone8ClrBdr);}
				    set {zone8ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone8 Text")]
		public string Zone8text
        {
            get { return zone8text; }
            set { zone8text = value; }
        }

    //------------- Zone 9 ------------------------------
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone9")]
		public double Zone9
        {
            get { return zone9; }
            set { zone9 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone9 Color")]
	    public Color Zone9Clr
        {
            get { return zone9Clr; }
            set { zone9Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone9ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone9Clr);}
				    set {zone9Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots")]
		[Gui.Design.DisplayName("Zone9 Color Border")]
	    public Color Zone9ClrBdr
        {
            get { return zone9ClrBdr; }
            set { zone9ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone9ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone9ClrBdr);}
				    set {zone9ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots")]
        [Gui.Design.DisplayName("Zone9 Text")]
		public string Zone9text
        {
            get { return zone9text; }
            set { zone9text = value; }
        }
		
    //------------- Zone 10 ------------------------------
		[Description("")]
        [Category("Plots2")]
        [Gui.Design.DisplayName("Zone10")]
		public double Zone10
        {
            get { return zone10; }
            set { zone10 = Math.Max(-10, value); }
        }

        [XmlIgnore()]
		[Description("")]
		[Category("Plots2")]
		[Gui.Design.DisplayName("Zone10 Color")]
	    public Color Zone10Clr
        {
            get { return zone10Clr; }
            set { zone10Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone10ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone10Clr);}
				    set {zone10Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots2")]
		[Gui.Design.DisplayName("Zone10 Color Border")]
	    public Color Zone10ClrBdr
        {
            get { return zone10ClrBdr; }
            set { zone10ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone10ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone10ClrBdr);}
				    set {zone10ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots2")]
        [Gui.Design.DisplayName("Zone10 Text")]
		public string Zone10text
        {
            get { return zone10text; }
            set { zone10text = value; }
        }
		
    //------------- Zone 11 ------------------------------
		[Description("")]
        [Category("Plots2")]
        [Gui.Design.DisplayName("Zone11")]
		public double Zone11
        {
            get { return zone11; }
            set { zone11 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots2")]
		[Gui.Design.DisplayName("Zone11 Color")]
	    public Color Zone11Clr
        {
            get { return zone11Clr; }
            set { zone11Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone11ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone11Clr);}
				    set {zone11Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots2")]
		[Gui.Design.DisplayName("Zone11 Color Border")]
	    public Color Zone11ClrBdr
        {
            get { return zone11ClrBdr; }
            set { zone11ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone11ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone11ClrBdr);}
				    set {zone11ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots2")]
        [Gui.Design.DisplayName("Zone11 Text")]
		public string Zone11text
        {
            get { return zone11text; }
            set { zone11text = value; }
        }

    //------------- Zone 12 ------------------------------
		[Description("")]
        [Category("Plots2")]
        [Gui.Design.DisplayName("Zone12")]
		public double Zone12
        {
            get { return zone12; }
            set { zone12 = Math.Max(-10, value); }
        }


        [XmlIgnore()]
		[Description("")]
		[Category("Plots2")]
		[Gui.Design.DisplayName("Zone12 Color")]
	    public Color Zone12Clr
        {
            get { return zone12Clr; }
            set { zone12Clr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone12ClrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone12Clr);}
				    set {zone12Clr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }
        [XmlIgnore()]
		[Description("")]
		[Category("Plots2")]
		[Gui.Design.DisplayName("Zone12 Color Border")]
	    public Color Zone12ClrBdr
        {
            get { return zone12ClrBdr; }
            set { zone12ClrBdr = value; }
        }
        // Serialize color object
			   [Browsable(false)]
			   public string Zone12ClrBdrSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zone12ClrBdr);}
				    set {zone12ClrBdr = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }  
			
		[Description("")]
        [Category("Plots2")]
        [Gui.Design.DisplayName("Zone12 Text")]
		public string Zone12text
        {
            get { return zone12text; }
            set { zone12text = value; }
        }
		
		
		
		
		
		
			
		//===========  TEXT  ================================
		[XmlIgnore()]
		[Description("")]
		[Category("Text Display")]
		[Gui.Design.DisplayName("Text Color")]
		public Color TextColor
		{
			get { return textColor; }
			set { textColor = value; }
		}
		// Serialize color object
			   [Browsable(false)]
			   public string TextColorSerialize
			   {
				    get { return NinjaTrader.Gui.Design.SerializableColor.ToString(textColor);}
				    set {textColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value);}
			   }	
			
		[XmlIgnore()]
		[Description("")]
        [Category("Text Display")]
		[Gui.Design.DisplayName("Text Font")]
		public Font TextFont
		{
			get { return textFont; }
			set { textFont = value; }
		}
		[Browsable(false)]
		public string textFontSerialize
		{
			get { return NinjaTrader.Gui.Design.SerializableFont.ToString(textFont); }
			set { textFont = NinjaTrader.Gui.Design.SerializableFont.FromString(value); }
		}
	  
		[Description("UP/Down Offset in ticks from top edge of zone1a, zone2a, zone3a, zone4a  ")]
		[Category("Text Display")]
		[Gui.Design.DisplayName("Text Offset")]			
		public int TextOffset
		{
			get { return textOffset; }
			set { textOffset = Math.Max(1, value); }
		}

		[Description("Left/Right (in bars)")]
		[Category("Text Display")]
		[Gui.Design.DisplayName("Text Shift")]			
		public int TextShift
		{
			get { return textShift; }
			set { textShift = Math.Max(1, value); }
		}
		
			
			
			
        #endregion
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ColorZone3[] cacheColorZone3 = null;

        private static ColorZone3 checkColorZone3 = new ColorZone3();

        /// <summary>
        /// ColorZone3  (Ver 1.5 ... 02/11/11 by photog53) Draws rectangles around desired levels...enter Price and get a 3 tick 'zone'.   Allows changes to color, border, & size.
        /// </summary>
        /// <returns></returns>
        public ColorZone3 ColorZone3()
        {
            return ColorZone3(Input);
        }

        /// <summary>
        /// ColorZone3  (Ver 1.5 ... 02/11/11 by photog53) Draws rectangles around desired levels...enter Price and get a 3 tick 'zone'.   Allows changes to color, border, & size.
        /// </summary>
        /// <returns></returns>
        public ColorZone3 ColorZone3(Data.IDataSeries input)
        {
            if (cacheColorZone3 != null)
                for (int idx = 0; idx < cacheColorZone3.Length; idx++)
                    if (cacheColorZone3[idx].EqualsInput(input))
                        return cacheColorZone3[idx];

            lock (checkColorZone3)
            {
                if (cacheColorZone3 != null)
                    for (int idx = 0; idx < cacheColorZone3.Length; idx++)
                        if (cacheColorZone3[idx].EqualsInput(input))
                            return cacheColorZone3[idx];

                ColorZone3 indicator = new ColorZone3();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                ColorZone3[] tmp = new ColorZone3[cacheColorZone3 == null ? 1 : cacheColorZone3.Length + 1];
                if (cacheColorZone3 != null)
                    cacheColorZone3.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheColorZone3 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// ColorZone3  (Ver 1.5 ... 02/11/11 by photog53) Draws rectangles around desired levels...enter Price and get a 3 tick 'zone'.   Allows changes to color, border, & size.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColorZone3 ColorZone3()
        {
            return _indicator.ColorZone3(Input);
        }

        /// <summary>
        /// ColorZone3  (Ver 1.5 ... 02/11/11 by photog53) Draws rectangles around desired levels...enter Price and get a 3 tick 'zone'.   Allows changes to color, border, & size.
        /// </summary>
        /// <returns></returns>
        public Indicator.ColorZone3 ColorZone3(Data.IDataSeries input)
        {
            return _indicator.ColorZone3(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// ColorZone3  (Ver 1.5 ... 02/11/11 by photog53) Draws rectangles around desired levels...enter Price and get a 3 tick 'zone'.   Allows changes to color, border, & size.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ColorZone3 ColorZone3()
        {
            return _indicator.ColorZone3(Input);
        }

        /// <summary>
        /// ColorZone3  (Ver 1.5 ... 02/11/11 by photog53) Draws rectangles around desired levels...enter Price and get a 3 tick 'zone'.   Allows changes to color, border, & size.
        /// </summary>
        /// <returns></returns>
        public Indicator.ColorZone3 ColorZone3(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ColorZone3(input);
        }
    }
}
#endregion
