#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

public enum COTmarket
{

	USDollarIndex_ICE,
	EuroFX_CME,
	JapaneseYen_CME,
	BritishPoundSterling_CME,
	CanadianDollar_CME,
	SwissFranc_CME,
	AustralianDollar_CME,
	NewZealandDollar_CME,
	MexicanPeso_CME,
	EMiniSP_CME,
	SP_CME,
	NASDAQ_CME,
	NaturalGas_NYME,
	Silver_CIE,
	Gold_CIE,
	Gold_CBE
	
	
	
}

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.
    /// </summary>
    [Description("This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.")]
    public class COTPlot : Indicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
		private COTmarket marketType = COTmarket.JapaneseYen_CME;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Red), PlotStyle.Line, "SmallSpecs"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Blue), PlotStyle.Line, "Commercials"));
            Add(new Plot(Color.FromKnownColor(KnownColor.LimeGreen), PlotStyle.Line, "LargeSpecs"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Pink), PlotStyle.Bar, "OpenInterest"));
            CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
            SmallSpecs.Set(Close[0]);
            Commercials.Set(Close[0]);
            LargeSpecs.Set(Close[0]);
			OpenInterest.Set(Volume[0]);
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SmallSpecs
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Commercials
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries LargeSpecs
        {
            get { return Values[2]; }
        }
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries OpenInterest
        {
            get { return Values[3]; }
        }
		
		[Description("Market")]
        [Category("Parameters")]
        public COTmarket MarketType
        {
            get { return marketType; }
            set { marketType = value; }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private COTPlot[] cacheCOTPlot = null;

        private static COTPlot checkCOTPlot = new COTPlot();

        /// <summary>
        /// This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.
        /// </summary>
        /// <returns></returns>
        public COTPlot COTPlot(COTmarket marketType)
        {
            return COTPlot(Input, marketType);
        }

        /// <summary>
        /// This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.
        /// </summary>
        /// <returns></returns>
        public COTPlot COTPlot(Data.IDataSeries input, COTmarket marketType)
        {
            checkCOTPlot.MarketType = marketType;
            marketType = checkCOTPlot.MarketType;

            if (cacheCOTPlot != null)
                for (int idx = 0; idx < cacheCOTPlot.Length; idx++)
                    if (cacheCOTPlot[idx].MarketType == marketType && cacheCOTPlot[idx].EqualsInput(input))
                        return cacheCOTPlot[idx];

            COTPlot indicator = new COTPlot();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.MarketType = marketType;
            indicator.SetUp();

            COTPlot[] tmp = new COTPlot[cacheCOTPlot == null ? 1 : cacheCOTPlot.Length + 1];
            if (cacheCOTPlot != null)
                cacheCOTPlot.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheCOTPlot = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.COTPlot COTPlot(COTmarket marketType)
        {
            return _indicator.COTPlot(Input, marketType);
        }

        /// <summary>
        /// This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.
        /// </summary>
        /// <returns></returns>
        public Indicator.COTPlot COTPlot(Data.IDataSeries input, COTmarket marketType)
        {
            return _indicator.COTPlot(input, marketType);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.COTPlot COTPlot(COTmarket marketType)
        {
            return _indicator.COTPlot(Input, marketType);
        }

        /// <summary>
        /// This indicator displays the net short/long positions of commercials, large speculators, and small speculators as reported in the CFTC Commitment of Traders report.
        /// </summary>
        /// <returns></returns>
        public Indicator.COTPlot COTPlot(Data.IDataSeries input, COTmarket marketType)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.COTPlot(input, marketType);
        }

    }
}
#endregion
