#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class GomVolumeLadderIndicators : Indicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
		GomVolumeLadder GVL;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			Add(new Plot(Color.FromKnownColor(KnownColor.Red), PlotStyle.Line, "MaxAsk"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Blue), PlotStyle.Line, "MaxBid"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Cyan), PlotStyle.Line, "SumAsk"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Magenta), PlotStyle.Line, "SumBid"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Black), PlotStyle.Line, "Volume"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Gray), PlotStyle.Line, "Delta"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "HighCOT"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Green), PlotStyle.Line, "LowCOT"));


            CalculateOnBarClose	= false;
            Overlay				= false;
			
			GVL=GomVolumeLadder();

        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.

			
				
			if (Historical)
			{
				MaxAsk.Set(GVL.MaxAsk[0]);
				MaxBid.Set(GVL.MaxBid[0]);
				
				SumAsk.Set(GVL.SumAsk[0]);
				SumBid.Set(GVL.SumBid[0]);
				
				Volume.Set(GVL.Volume[0]);
				Delta.Set(GVL.Delta[0]);
				
				HighCOT.Set(GVL.HighCOT[0]);
				LowCOT.Set(GVL.LowCOT[0]);
			}

        }
		
		protected override void OnMarketData(MarketDataEventArgs e)
		{
			MaxAsk.Set(GVL.MaxAsk[0]);
			MaxBid.Set(GVL.MaxBid[0]);
			
			SumAsk.Set(GVL.SumAsk[0]);
			SumBid.Set(GVL.SumBid[0]);
			
			Volume.Set(GVL.Volume[0]);
			Delta.Set(GVL.Delta[0]);
			
			HighCOT.Set(GVL.HighCOT[0]);
			LowCOT.Set(GVL.LowCOT[0]);
		}
		


        #region Properties

		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries MaxAsk
        {
            get { return Values[0]; }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries MaxBid
        {
            get { return Values[1]; }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SumAsk
        {
            get { return Values[2]; }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SumBid
        {
            get { return Values[3]; }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Volume
        {
            get { return Values[4]; }
        }

		        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Delta
        {
            get { return Values[5]; }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries HighCOT
        {
            get { return Values[6]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries LowCOT
        {
            get { return Values[7]; }
        }

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private GomVolumeLadderIndicators[] cacheGomVolumeLadderIndicators = null;

        private static GomVolumeLadderIndicators checkGomVolumeLadderIndicators = new GomVolumeLadderIndicators();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomVolumeLadderIndicators GomVolumeLadderIndicators()
        {
            return GomVolumeLadderIndicators(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public GomVolumeLadderIndicators GomVolumeLadderIndicators(Data.IDataSeries input)
        {
            if (cacheGomVolumeLadderIndicators != null)
                for (int idx = 0; idx < cacheGomVolumeLadderIndicators.Length; idx++)
                    if (cacheGomVolumeLadderIndicators[idx].EqualsInput(input))
                        return cacheGomVolumeLadderIndicators[idx];

            lock (checkGomVolumeLadderIndicators)
            {
                if (cacheGomVolumeLadderIndicators != null)
                    for (int idx = 0; idx < cacheGomVolumeLadderIndicators.Length; idx++)
                        if (cacheGomVolumeLadderIndicators[idx].EqualsInput(input))
                            return cacheGomVolumeLadderIndicators[idx];

                GomVolumeLadderIndicators indicator = new GomVolumeLadderIndicators();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                GomVolumeLadderIndicators[] tmp = new GomVolumeLadderIndicators[cacheGomVolumeLadderIndicators == null ? 1 : cacheGomVolumeLadderIndicators.Length + 1];
                if (cacheGomVolumeLadderIndicators != null)
                    cacheGomVolumeLadderIndicators.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheGomVolumeLadderIndicators = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomVolumeLadderIndicators GomVolumeLadderIndicators()
        {
            return _indicator.GomVolumeLadderIndicators(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomVolumeLadderIndicators GomVolumeLadderIndicators(Data.IDataSeries input)
        {
            return _indicator.GomVolumeLadderIndicators(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.GomVolumeLadderIndicators GomVolumeLadderIndicators()
        {
            return _indicator.GomVolumeLadderIndicators(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.GomVolumeLadderIndicators GomVolumeLadderIndicators(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.GomVolumeLadderIndicators(input);
        }
    }
}
#endregion
