// Range Bar High/Low Projections on the current bar by ccl-trading-systems.com 
// - with help from eDanny at http://www.ninjatrader-support2.com/vb/showthread.php?p=110218#post110218

#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Plots the possible high or low of a range bar as it is forming.
    /// </summary>
    [Description("For Range Bar charts: Plots the possible high and low of the current range bar as it is forming.")]
    public class RangeBarHighLow : Indicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
			private Color colorHigh = Color.Olive;
			private Color colorLow = Color.MediumBlue;
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			PaintPriceMarkers	= false;
		
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
           
        {	
			if (Bars.Period.Id == PeriodType.Range || Bars.Period.Id == PeriodType.Final1) 
		 {		
			if  (  High[0] != Low[0] + (Bars.Period.Value*TickSize))
			DrawText("PossHigh", true, "-", 0, Low[0]+ (Bars.Period.Value*TickSize), 4, ColorHigh, new Font("Franklin Gothic Heavy",21), StringAlignment.Center, Color.Empty, Color.Empty, 10);
			else
			RemoveDrawObject("PossHigh");
			
			if(Low[0] != High[0] - (Bars.Period.Value*TickSize))
			DrawText("PossLow", true, "-", 0, High[0]- (Bars.Period.Value*TickSize), 4, ColorLow, new Font("Franklin Gothic Heavy",21), StringAlignment.Center, Color.Empty, Color.Empty, 10);
			else
			RemoveDrawObject("PossLow");
		 } 
		else return;
		}	

        #region Properties

		[Description("Forming High Plot drawn on the currently forming Range Bar")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("High Plot")]
        public Color ColorHigh
        {
            get { return colorHigh; }
            set { colorHigh = value; }
        }
		// Ralph: colors are not serialised by default, you are on your own
		// Ralph: serialisation is important when you try to save current color with the workspace
		[Browsable(false)]
		public string ColorHighSerialise
		{
			get { return Gui.Design.SerializableColor.ToString(colorHigh); }
			set { colorHigh = Gui.Design.SerializableColor.FromString(value); }
		}
		[Description("Forming Low Plot drawn on the currently forming Range Bar")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("Low Plot")]
        public Color ColorLow
        {
            get { return colorLow; }
            set { colorLow = value; }
		}
		
		[Browsable(false)]
		public string ColorLowSerialise
		{
			get { return Gui.Design.SerializableColor.ToString(colorLow); }
			set { colorLow = Gui.Design.SerializableColor.FromString(value); }
		}
		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private RangeBarHighLow[] cacheRangeBarHighLow = null;

        private static RangeBarHighLow checkRangeBarHighLow = new RangeBarHighLow();

        /// <summary>
        /// For Range Bar charts: Plots the possible high and low of the current range bar as it is forming.
        /// </summary>
        /// <returns></returns>
        public RangeBarHighLow RangeBarHighLow()
        {
            return RangeBarHighLow(Input);
        }

        /// <summary>
        /// For Range Bar charts: Plots the possible high and low of the current range bar as it is forming.
        /// </summary>
        /// <returns></returns>
        public RangeBarHighLow RangeBarHighLow(Data.IDataSeries input)
        {

            if (cacheRangeBarHighLow != null)
                for (int idx = 0; idx < cacheRangeBarHighLow.Length; idx++)
                    if (cacheRangeBarHighLow[idx].EqualsInput(input))
                        return cacheRangeBarHighLow[idx];

            RangeBarHighLow indicator = new RangeBarHighLow();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.SetUp();

            RangeBarHighLow[] tmp = new RangeBarHighLow[cacheRangeBarHighLow == null ? 1 : cacheRangeBarHighLow.Length + 1];
            if (cacheRangeBarHighLow != null)
                cacheRangeBarHighLow.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheRangeBarHighLow = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// For Range Bar charts: Plots the possible high and low of the current range bar as it is forming.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.RangeBarHighLow RangeBarHighLow()
        {
            return _indicator.RangeBarHighLow(Input);
        }

        /// <summary>
        /// For Range Bar charts: Plots the possible high and low of the current range bar as it is forming.
        /// </summary>
        /// <returns></returns>
        public Indicator.RangeBarHighLow RangeBarHighLow(Data.IDataSeries input)
        {
            return _indicator.RangeBarHighLow(input);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// For Range Bar charts: Plots the possible high and low of the current range bar as it is forming.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.RangeBarHighLow RangeBarHighLow()
        {
            return _indicator.RangeBarHighLow(Input);
        }

        /// <summary>
        /// For Range Bar charts: Plots the possible high and low of the current range bar as it is forming.
        /// </summary>
        /// <returns></returns>
        public Indicator.RangeBarHighLow RangeBarHighLow(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.RangeBarHighLow(input);
        }

    }
}
#endregion
