//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private AlertBlock[] cacheAlertBlock = null;

        private static AlertBlock checkAlertBlock = new AlertBlock();

        /// <summary>
        /// Alert Block
        /// </summary>
        /// <returns></returns>
        public AlertBlock AlertBlock(double block, string fname)
        {
            return AlertBlock(Input, block, fname);
        }

        /// <summary>
        /// Alert Block
        /// </summary>
        /// <returns></returns>
        public AlertBlock AlertBlock(Data.IDataSeries input, double block, string fname)
        {
            if (cacheAlertBlock != null)
                for (int idx = 0; idx < cacheAlertBlock.Length; idx++)
                    if (Math.Abs(cacheAlertBlock[idx].Block - block) <= double.Epsilon && cacheAlertBlock[idx].Fname == fname && cacheAlertBlock[idx].EqualsInput(input))
                        return cacheAlertBlock[idx];

            lock (checkAlertBlock)
            {
                checkAlertBlock.Block = block;
                block = checkAlertBlock.Block;
                checkAlertBlock.Fname = fname;
                fname = checkAlertBlock.Fname;

                if (cacheAlertBlock != null)
                    for (int idx = 0; idx < cacheAlertBlock.Length; idx++)
                        if (Math.Abs(cacheAlertBlock[idx].Block - block) <= double.Epsilon && cacheAlertBlock[idx].Fname == fname && cacheAlertBlock[idx].EqualsInput(input))
                            return cacheAlertBlock[idx];

                AlertBlock indicator = new AlertBlock();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Block = block;
                indicator.Fname = fname;
                Indicators.Add(indicator);
                indicator.SetUp();

                AlertBlock[] tmp = new AlertBlock[cacheAlertBlock == null ? 1 : cacheAlertBlock.Length + 1];
                if (cacheAlertBlock != null)
                    cacheAlertBlock.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheAlertBlock = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Alert Block
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AlertBlock AlertBlock(double block, string fname)
        {
            return _indicator.AlertBlock(Input, block, fname);
        }

        /// <summary>
        /// Alert Block
        /// </summary>
        /// <returns></returns>
        public Indicator.AlertBlock AlertBlock(Data.IDataSeries input, double block, string fname)
        {
            return _indicator.AlertBlock(input, block, fname);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Alert Block
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.AlertBlock AlertBlock(double block, string fname)
        {
            return _indicator.AlertBlock(Input, block, fname);
        }

        /// <summary>
        /// Alert Block
        /// </summary>
        /// <returns></returns>
        public Indicator.AlertBlock AlertBlock(Data.IDataSeries input, double block, string fname)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.AlertBlock(input, block, fname);
        }
    }
}
#endregion
