#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. 
    /// </summary>
    [Description("Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. ")]
    public class BarNumber : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int barStart0 = 0; // Default setting for BarStart0
        // User defined variables (add any user defined variables below)
			private Color textColor = Color.Gray;
			int marker_counter;
			private Font 	textFont = new Font("Courier", 11, FontStyle.Bold);		
        
		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "Plot0"));
            Add(new Plot(Color.FromKnownColor(KnownColor.Orange), PlotStyle.Line, "Plot1"));

			Add(new Line(Color.FromKnownColor(KnownColor.DarkOliveGreen), 10, "Cen0"));
			
			DrawOnPricePanel = false;
            CalculateOnBarClose	= true;
            Overlay				= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.

			Plot0.Set(0.0);
			Plot1.Set(2.0);

			DrawText("bnum" + CurrentBar, Convert.ToString(Bars.BarsSinceSession+1-barStart0 ), 0, 1.0 , Color.Black);				
			
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries Plot1
        {
            get { return Values[1]; }
        }

		
		
        [Description("Chart Session's  Bar to be assigned the Bar number of 1")]
        [GridCategory("Parameters")]
        public int BarStart0
        {
            get { return barStart0; }
            set { barStart0 = Math.Max(0, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BarNumber[] cacheBarNumber = null;

        private static BarNumber checkBarNumber = new BarNumber();

        /// <summary>
        /// Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. 
        /// </summary>
        /// <returns></returns>
        public BarNumber BarNumber(int barStart0)
        {
            return BarNumber(Input, barStart0);
        }

        /// <summary>
        /// Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. 
        /// </summary>
        /// <returns></returns>
        public BarNumber BarNumber(Data.IDataSeries input, int barStart0)
        {
            if (cacheBarNumber != null)
                for (int idx = 0; idx < cacheBarNumber.Length; idx++)
                    if (cacheBarNumber[idx].BarStart0 == barStart0 && cacheBarNumber[idx].EqualsInput(input))
                        return cacheBarNumber[idx];

            lock (checkBarNumber)
            {
                checkBarNumber.BarStart0 = barStart0;
                barStart0 = checkBarNumber.BarStart0;

                if (cacheBarNumber != null)
                    for (int idx = 0; idx < cacheBarNumber.Length; idx++)
                        if (cacheBarNumber[idx].BarStart0 == barStart0 && cacheBarNumber[idx].EqualsInput(input))
                            return cacheBarNumber[idx];

                BarNumber indicator = new BarNumber();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BarStart0 = barStart0;
                Indicators.Add(indicator);
                indicator.SetUp();

                BarNumber[] tmp = new BarNumber[cacheBarNumber == null ? 1 : cacheBarNumber.Length + 1];
                if (cacheBarNumber != null)
                    cacheBarNumber.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheBarNumber = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BarNumber BarNumber(int barStart0)
        {
            return _indicator.BarNumber(Input, barStart0);
        }

        /// <summary>
        /// Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. 
        /// </summary>
        /// <returns></returns>
        public Indicator.BarNumber BarNumber(Data.IDataSeries input, int barStart0)
        {
            return _indicator.BarNumber(input, barStart0);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BarNumber BarNumber(int barStart0)
        {
            return _indicator.BarNumber(Input, barStart0);
        }

        /// <summary>
        /// Places the Bar Number in the indicator area based on the session start of your chart.  The indicator also allows you to control where the bar numbering begins.  For example,  if you are looking at a 7x24,  5 min chart,  the default bar number  (BARSTART=0)  for the RTH ( Regular Trading Hours) session will start on bar 90,   By setting the value of the BARSTART parameter to 90  will cause Bar 1 to be the first bar of the RTH session. 
        /// </summary>
        /// <returns></returns>
        public Indicator.BarNumber BarNumber(Data.IDataSeries input, int barStart0)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BarNumber(input, barStart0);
        }
    }
}
#endregion
