// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Exponential Moving Average. The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
	/// </summary>
	[Description("The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.")]
	public class EMA_Colors_V3_No_Repaint_Bars : Indicator
	{
		#region Variables
		private int			period		= 14;
		private int			slopeperiod	= 34;
		private int			ema34slope	= 0;
		private double		radToDegrees		= 180/Math.PI; // to convert Radians to Degrees for slope calc
		private int			angle1		= 30;
		private int			angle2		= 60;
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(Color.Green,  PlotStyle.Bar,"EMAup"));
			Add(new Plot(Color.Maroon,  PlotStyle.Bar,"EMAdown"));
			Add(new Plot(Color.Red, PlotStyle.Bar, "EMAslopedown"));
			Add(new Plot(Color.LimeGreen, PlotStyle.Bar, "EMAslopeup"));
			Add(new Plot(Color.Gray, PlotStyle.Bar, "EMAflat"));
			Plots[0].Pen.Width = 8;
			Plots[1].Pen.Width = 8;
			Plots[2].Pen.Width = 8;
			Plots[3].Pen.Width = 8;
			Plots[4].Pen.Width = 8;

			Overlay				= false;
			PriceTypeSupported	= true;
			CalculateOnBarClose	= true;
		}
		
		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if(CurrentBar<Period) return;
				ema34slope = (int)(radToDegrees*(Math.Atan((EMA(slopeperiod)[0]-(EMA(slopeperiod)[1]+EMA(slopeperiod)[2])/2)/1.5/TickSize)));
			if(Rising(EMA(Period)))
			{
				if(ema34slope>=angle2)
				{
				//	EMAslopeup.Set(1,EMA(Period)[1]);
					EMAslopeup.Set(EMA(Period)[0]);
				}
				else
				if (ema34slope>=angle1)
				{
				//	EMAup.Set(1,EMA(Period)[1]);
					EMAup.Set(EMA(Period)[0]);
				}
					else
					{	
				//		EMAflat.Set(1,EMA(Period)[1]);
						EMAflat.Set(EMA(Period)[0]);
					}
			}
			else
			{	if(ema34slope<=-angle2)
				{
				//	EMAslopedown.Set(1,EMA(Period)[1]);
					EMAslopedown.Set(EMA(Period)[0]);
				}
				else
				if (ema34slope<=-angle1)
				{
				//	EMAdown.Set(1,EMA(Period)[1]);
					EMAdown.Set(EMA(Period)[0]);
				}
					else
					{	
				//		EMAflat.Set(1,EMA(Period)[1]);
						EMAflat.Set(EMA(Period)[0]);
					}
			}
		}

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}

		[Description("EMA angle between Flat and Sloping zones.")]
		[Gui.Design.DisplayName("Angle 1")]
		[Category("Parameters")]
		public int Angle1
		{
			get { return angle1; }
			set { angle1 = Math.Max(1, value); }
		}

		[Description("EMA angle between Sloping and Steep zones.")]
		[Gui.Design.DisplayName("Angle 2")]
		[Category("Parameters")]
		public int Angle2
		{
			get { return angle2; }
			set { angle2 = Math.Max(1, value); }
		}
		
		
		[Description("EMA Slope Period.")]
		[Gui.Design.DisplayName("Slopeperiod")]
		[Category("Parameters")]
		public int Slopeperiod
		{
			get { return slopeperiod; }
			set { slopeperiod = Math.Max(1, value); }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries EMAup
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries EMAdown
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries EMAslopedown
        {
            get { return Values[2]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries EMAslopeup
        {
            get { return Values[3]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries EMAflat
        {
            get { return Values[4]; }
        }
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private EMA_Colors_V3_No_Repaint_Bars[] cacheEMA_Colors_V3_No_Repaint_Bars = null;

        private static EMA_Colors_V3_No_Repaint_Bars checkEMA_Colors_V3_No_Repaint_Bars = new EMA_Colors_V3_No_Repaint_Bars();

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public EMA_Colors_V3_No_Repaint_Bars EMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return EMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public EMA_Colors_V3_No_Repaint_Bars EMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            checkEMA_Colors_V3_No_Repaint_Bars.Angle1 = angle1;
            angle1 = checkEMA_Colors_V3_No_Repaint_Bars.Angle1;
            checkEMA_Colors_V3_No_Repaint_Bars.Angle2 = angle2;
            angle2 = checkEMA_Colors_V3_No_Repaint_Bars.Angle2;
            checkEMA_Colors_V3_No_Repaint_Bars.Period = period;
            period = checkEMA_Colors_V3_No_Repaint_Bars.Period;
            checkEMA_Colors_V3_No_Repaint_Bars.Slopeperiod = slopeperiod;
            slopeperiod = checkEMA_Colors_V3_No_Repaint_Bars.Slopeperiod;

            if (cacheEMA_Colors_V3_No_Repaint_Bars != null)
                for (int idx = 0; idx < cacheEMA_Colors_V3_No_Repaint_Bars.Length; idx++)
                    if (cacheEMA_Colors_V3_No_Repaint_Bars[idx].Angle1 == angle1 && cacheEMA_Colors_V3_No_Repaint_Bars[idx].Angle2 == angle2 && cacheEMA_Colors_V3_No_Repaint_Bars[idx].Period == period && cacheEMA_Colors_V3_No_Repaint_Bars[idx].Slopeperiod == slopeperiod && cacheEMA_Colors_V3_No_Repaint_Bars[idx].EqualsInput(input))
                        return cacheEMA_Colors_V3_No_Repaint_Bars[idx];

            EMA_Colors_V3_No_Repaint_Bars indicator = new EMA_Colors_V3_No_Repaint_Bars();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Angle1 = angle1;
            indicator.Angle2 = angle2;
            indicator.Period = period;
            indicator.Slopeperiod = slopeperiod;
            indicator.SetUp();

            EMA_Colors_V3_No_Repaint_Bars[] tmp = new EMA_Colors_V3_No_Repaint_Bars[cacheEMA_Colors_V3_No_Repaint_Bars == null ? 1 : cacheEMA_Colors_V3_No_Repaint_Bars.Length + 1];
            if (cacheEMA_Colors_V3_No_Repaint_Bars != null)
                cacheEMA_Colors_V3_No_Repaint_Bars.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheEMA_Colors_V3_No_Repaint_Bars = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Colors_V3_No_Repaint_Bars EMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.EMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Colors_V3_No_Repaint_Bars EMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.EMA_Colors_V3_No_Repaint_Bars(input, angle1, angle2, period, slopeperiod);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Colors_V3_No_Repaint_Bars EMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.EMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The EMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Colors_V3_No_Repaint_Bars EMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.EMA_Colors_V3_No_Repaint_Bars(input, angle1, angle2, period, slopeperiod);
        }

    }
}
#endregion
