// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.
	/// </summary>
	[Description("The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.")]
	public class SMA_Colors_V3_No_Repaint_Bars : Indicator
	{
		#region Variables
		private int			period		= 14;
		private int			slopeperiod	= 14;
		private int			sma34slope	= 0;
		private double		radToDegrees		= 180/Math.PI; // to convert Radians to Degrees for slope calc
		private int			angle1		= 30;
		private int			angle2		= 60;
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(Color.Green, PlotStyle.Bar, "SMAup"));
			Add(new Plot(Color.Maroon, PlotStyle.Bar, "SMAdown"));
			Add(new Plot(Color.Red, PlotStyle.Bar, "SMAslopedown"));
			Add(new Plot(Color.LimeGreen, PlotStyle.Bar, "SMAslopeup"));
			Add(new Plot(Color.Gray, PlotStyle.Bar, "SMAflat"));
			Plots[0].Pen.Width = 8;
			Plots[1].Pen.Width = 8;
			Plots[2].Pen.Width = 8;
			Plots[3].Pen.Width = 8;
			Plots[4].Pen.Width = 8;

			Overlay				= false;
			PriceTypeSupported	= true;
			CalculateOnBarClose	= true;
		}
		
		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if(CurrentBar<Period) return;
				sma34slope = (int)(radToDegrees*(Math.Atan((SMA(slopeperiod)[0]-(SMA(slopeperiod)[1]+SMA(slopeperiod)[2])/2)/1.5/TickSize)));
			if(Rising(SMA(Period)))
			{
				if(sma34slope>=angle2)
				{
			//		SMAslopeup.Set(1,SMA(Period)[1]);
					SMAslopeup.Set(SMA(Period)[0]);
				}
				else
				if (sma34slope>=angle1)
				{
			//		SMAup.Set(1,SMA(Period)[1]);
					SMAup.Set(SMA(Period)[0]);
				}
					else
					{
			//			SMAflat.Set(1,SMA(Period)[1]);
						SMAflat.Set(SMA(Period)[0]);
					}
			}
			else
			{	if(sma34slope<=-angle2)
				{
			//		SMAslopedown.Set(1,SMA(Period)[1]);
					SMAslopedown.Set(SMA(Period)[0]);
				}
				else
				if (sma34slope<=-angle1)
				{
			//		SMAdown.Set(1,SMA(Period)[1]);
					SMAdown.Set(SMA(Period)[0]);
				}
					else
					{
			//			SMAflat.Set(1,SMA(Period)[1]);
						SMAflat.Set(SMA(Period)[0]);
					}
			}
		}

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}

		[Description("SMA angle between Flat and Sloping zones.")]
		[Gui.Design.DisplayName("Angle 1")]
		[Category("Parameters")]
		public int Angle1
		{
			get { return angle1; }
			set { angle1 = Math.Max(1, value); }
		}

		[Description("SMA angle between Sloping and Steep zones.")]
		[Gui.Design.DisplayName("Angle 2")]
		[Category("Parameters")]
		public int Angle2
		{
			get { return angle2; }
			set { angle2 = Math.Max(1, value); }
		}
		
		[Description("SMA Slope Period.")]
		[Gui.Design.DisplayName("Slopeperiod")]
		[Category("Parameters")]
		public int Slopeperiod
		{
			get { return slopeperiod; }
			set { slopeperiod = Math.Max(1, value); }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SMAup
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SMAdown
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SMAslopedown
        {
            get { return Values[2]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SMAslopeup
        {
            get { return Values[3]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries SMAflat
        {
            get { return Values[4]; }
        }
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private SMA_Colors_V3_No_Repaint_Bars[] cacheSMA_Colors_V3_No_Repaint_Bars = null;

        private static SMA_Colors_V3_No_Repaint_Bars checkSMA_Colors_V3_No_Repaint_Bars = new SMA_Colors_V3_No_Repaint_Bars();

        /// <summary>
        /// The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.
        /// </summary>
        /// <returns></returns>
        public SMA_Colors_V3_No_Repaint_Bars SMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return SMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.
        /// </summary>
        /// <returns></returns>
        public SMA_Colors_V3_No_Repaint_Bars SMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            checkSMA_Colors_V3_No_Repaint_Bars.Angle1 = angle1;
            angle1 = checkSMA_Colors_V3_No_Repaint_Bars.Angle1;
            checkSMA_Colors_V3_No_Repaint_Bars.Angle2 = angle2;
            angle2 = checkSMA_Colors_V3_No_Repaint_Bars.Angle2;
            checkSMA_Colors_V3_No_Repaint_Bars.Period = period;
            period = checkSMA_Colors_V3_No_Repaint_Bars.Period;
            checkSMA_Colors_V3_No_Repaint_Bars.Slopeperiod = slopeperiod;
            slopeperiod = checkSMA_Colors_V3_No_Repaint_Bars.Slopeperiod;

            if (cacheSMA_Colors_V3_No_Repaint_Bars != null)
                for (int idx = 0; idx < cacheSMA_Colors_V3_No_Repaint_Bars.Length; idx++)
                    if (cacheSMA_Colors_V3_No_Repaint_Bars[idx].Angle1 == angle1 && cacheSMA_Colors_V3_No_Repaint_Bars[idx].Angle2 == angle2 && cacheSMA_Colors_V3_No_Repaint_Bars[idx].Period == period && cacheSMA_Colors_V3_No_Repaint_Bars[idx].Slopeperiod == slopeperiod && cacheSMA_Colors_V3_No_Repaint_Bars[idx].EqualsInput(input))
                        return cacheSMA_Colors_V3_No_Repaint_Bars[idx];

            SMA_Colors_V3_No_Repaint_Bars indicator = new SMA_Colors_V3_No_Repaint_Bars();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Angle1 = angle1;
            indicator.Angle2 = angle2;
            indicator.Period = period;
            indicator.Slopeperiod = slopeperiod;
            indicator.SetUp();

            SMA_Colors_V3_No_Repaint_Bars[] tmp = new SMA_Colors_V3_No_Repaint_Bars[cacheSMA_Colors_V3_No_Repaint_Bars == null ? 1 : cacheSMA_Colors_V3_No_Repaint_Bars.Length + 1];
            if (cacheSMA_Colors_V3_No_Repaint_Bars != null)
                cacheSMA_Colors_V3_No_Repaint_Bars.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheSMA_Colors_V3_No_Repaint_Bars = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SMA_Colors_V3_No_Repaint_Bars SMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.SMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.
        /// </summary>
        /// <returns></returns>
        public Indicator.SMA_Colors_V3_No_Repaint_Bars SMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.SMA_Colors_V3_No_Repaint_Bars(input, angle1, angle2, period, slopeperiod);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SMA_Colors_V3_No_Repaint_Bars SMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.SMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The SMA_Colors_V3_No_Repaint_Bars (Simple Moving Average) is an indicator that shows the average value of a security's price over a period of time.
        /// </summary>
        /// <returns></returns>
        public Indicator.SMA_Colors_V3_No_Repaint_Bars SMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.SMA_Colors_V3_No_Repaint_Bars(input, angle1, angle2, period, slopeperiod);
        }

    }
}
#endregion
