// 
// Copyright (C) 2006, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Exponential Moving Average. The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
	/// </summary>
	[Description("The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.")]
	public class WMA_Colors_V3_No_Repaint_Bars : Indicator
	{
		#region Variables
		private int			period		= 14;
		private int			slopeperiod	= 14;
		private int			wma34slope	= 0;
		private double		radToDegrees		= 180/Math.PI; // to convert Radians to Degrees for slope calc
		private int			angle1		= 30;
		private int			angle2		= 60;
		#endregion

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize()
		{
			Add(new Plot(Color.Green, PlotStyle.Bar, "WMAup"));
			Add(new Plot(Color.Maroon, PlotStyle.Bar, "WMAdown"));
			Add(new Plot(Color.Red,  PlotStyle.Bar,"WMAslopedown"));
			Add(new Plot(Color.LimeGreen, PlotStyle.Bar, "WMAslopeup"));
			Add(new Plot(Color.Gray,  PlotStyle.Bar,"WMAflat"));
			Plots[0].Pen.Width = 8;
			Plots[1].Pen.Width = 8;
			Plots[2].Pen.Width = 8;
			Plots[3].Pen.Width = 8;
			Plots[4].Pen.Width = 8;

			Overlay				= false;
			PriceTypeSupported	= true;
			CalculateOnBarClose	= true;
		}
		
		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate()
		{
			if(CurrentBar<Period) return;
				wma34slope = (int)(radToDegrees*(Math.Atan((WMA(slopeperiod)[0]-(WMA(slopeperiod)[1]+WMA(slopeperiod)[2])/2)/1.5/TickSize)));
			if(Rising(WMA(Period)))
			{
				if(wma34slope>=angle2)
				{
		//			WMAslopeup.Set(1,WMA(Period)[1]);
					WMAslopeup.Set(WMA(Period)[0]);
				}
				else
				if (wma34slope>=angle1)
				{
		//			WMAup.Set(1,WMA(Period)[1]);
					WMAup.Set(WMA(Period)[0]);
				}
					else
					{
		//				WMAflat.Set(1,WMA(Period)[1]);
						WMAflat.Set(WMA(Period)[0]);
					}
			}
			else
			{	if(wma34slope<=-angle2)
				{
		//			WMAslopedown.Set(1,WMA(Period)[1]);
					WMAslopedown.Set(WMA(Period)[0]);
				}
				else
				if (wma34slope<=-angle1)
				{
		//			WMAdown.Set(1,WMA(Period)[1]);
					WMAdown.Set(WMA(Period)[0]);
				}
					else
					{
		//				WMAflat.Set(1,WMA(Period)[1]);
						WMAflat.Set(WMA(Period)[0]);
					}
			}
		}

		#region Properties
		/// <summary>
		/// </summary>
		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		public int Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}

		[Description("WMA angle between Flat and Sloping zones.")]
		[Gui.Design.DisplayName("Angle 1")]
		[Category("Parameters")]
		public int Angle1
		{
			get { return angle1; }
			set { angle1 = Math.Max(1, value); }
		}

		[Description("WMA angle between Sloping and Steep zones.")]
		[Gui.Design.DisplayName("Angle 2")]
		[Category("Parameters")]
		public int Angle2
		{
			get { return angle2; }
			set { angle2 = Math.Max(1, value); }
		}
		
		[Description("WMA Slope Period.")]
		[Gui.Design.DisplayName("Slopeperiod")]
		[Category("Parameters")]
		public int Slopeperiod
		{
			get { return slopeperiod; }
			set { slopeperiod = Math.Max(1, value); }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries WMAup
        {
            get { return Values[0]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries WMAdown
        {
            get { return Values[1]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries WMAslopedown
        {
            get { return Values[2]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries WMAslopeup
        {
            get { return Values[3]; }
        }

        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries WMAflat
        {
            get { return Values[4]; }
        }
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private WMA_Colors_V3_No_Repaint_Bars[] cacheWMA_Colors_V3_No_Repaint_Bars = null;

        private static WMA_Colors_V3_No_Repaint_Bars checkWMA_Colors_V3_No_Repaint_Bars = new WMA_Colors_V3_No_Repaint_Bars();

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public WMA_Colors_V3_No_Repaint_Bars WMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return WMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public WMA_Colors_V3_No_Repaint_Bars WMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            checkWMA_Colors_V3_No_Repaint_Bars.Angle1 = angle1;
            angle1 = checkWMA_Colors_V3_No_Repaint_Bars.Angle1;
            checkWMA_Colors_V3_No_Repaint_Bars.Angle2 = angle2;
            angle2 = checkWMA_Colors_V3_No_Repaint_Bars.Angle2;
            checkWMA_Colors_V3_No_Repaint_Bars.Period = period;
            period = checkWMA_Colors_V3_No_Repaint_Bars.Period;
            checkWMA_Colors_V3_No_Repaint_Bars.Slopeperiod = slopeperiod;
            slopeperiod = checkWMA_Colors_V3_No_Repaint_Bars.Slopeperiod;

            if (cacheWMA_Colors_V3_No_Repaint_Bars != null)
                for (int idx = 0; idx < cacheWMA_Colors_V3_No_Repaint_Bars.Length; idx++)
                    if (cacheWMA_Colors_V3_No_Repaint_Bars[idx].Angle1 == angle1 && cacheWMA_Colors_V3_No_Repaint_Bars[idx].Angle2 == angle2 && cacheWMA_Colors_V3_No_Repaint_Bars[idx].Period == period && cacheWMA_Colors_V3_No_Repaint_Bars[idx].Slopeperiod == slopeperiod && cacheWMA_Colors_V3_No_Repaint_Bars[idx].EqualsInput(input))
                        return cacheWMA_Colors_V3_No_Repaint_Bars[idx];

            WMA_Colors_V3_No_Repaint_Bars indicator = new WMA_Colors_V3_No_Repaint_Bars();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Angle1 = angle1;
            indicator.Angle2 = angle2;
            indicator.Period = period;
            indicator.Slopeperiod = slopeperiod;
            indicator.SetUp();

            WMA_Colors_V3_No_Repaint_Bars[] tmp = new WMA_Colors_V3_No_Repaint_Bars[cacheWMA_Colors_V3_No_Repaint_Bars == null ? 1 : cacheWMA_Colors_V3_No_Repaint_Bars.Length + 1];
            if (cacheWMA_Colors_V3_No_Repaint_Bars != null)
                cacheWMA_Colors_V3_No_Repaint_Bars.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheWMA_Colors_V3_No_Repaint_Bars = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.WMA_Colors_V3_No_Repaint_Bars WMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.WMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.WMA_Colors_V3_No_Repaint_Bars WMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.WMA_Colors_V3_No_Repaint_Bars(input, angle1, angle2, period, slopeperiod);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.WMA_Colors_V3_No_Repaint_Bars WMA_Colors_V3_No_Repaint_Bars(int angle1, int angle2, int period, int slopeperiod)
        {
            return _indicator.WMA_Colors_V3_No_Repaint_Bars(Input, angle1, angle2, period, slopeperiod);
        }

        /// <summary>
        /// The Exponential Moving Average is an indicator that shows the average value of a security's price over a period of time. When calculating a moving average. The WMA_Colors_V3_No_Repaint_Bars applies more weight to recent prices than the SMA.
        /// </summary>
        /// <returns></returns>
        public Indicator.WMA_Colors_V3_No_Repaint_Bars WMA_Colors_V3_No_Repaint_Bars(Data.IDataSeries input, int angle1, int angle2, int period, int slopeperiod)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.WMA_Colors_V3_No_Repaint_Bars(input, angle1, angle2, period, slopeperiod);
        }

    }
}
#endregion
