
/// Changelog:
/// 
/// 1.09    FEB 1, 2010 ZONDOR®
/// </summary>
#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.Design;
using System.Collections.Generic;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{

    [Description("Plots the Total of Buy and Sell Orders shown in the rows of the order book of an instrument.")]
    //[Gui.Design.DisplayName("DOM_Bands7v109)]
	
    public class DOM_Bands7v109: Indicator
    {
        #region Variables
        // Wizard generated variables
		int maxrows=10;
		bool init =false;
		double totAVol;
		int idx1;
		int idx2;
		double totBVol;
		private DateTime lastRefresh;	
        // User defined variables (add any user defined variables below)
		private long 		activeBar = -1;
		private double		buy					= 0;
		private string      MM;
		private double		sell				= 0;
		private double		delta				= 0;
		
		private bool 		showBidAskVolume    = true;
		private				List<LadderRow>		askRows	= new List<LadderRow>();
		private				List<LadderRow>		bidRows	= new List<LadderRow>();	
		private double 		askTotY;
		private double 		bidTotY;
		private bool 		firstPaint = true;
		private System.Collections.ArrayList alBuy = new System.Collections.ArrayList();
		private System.Collections.ArrayList alSell = new System.Collections.ArrayList();
		private System.Collections.ArrayList alDelta = new System.Collections.ArrayList();
						
		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			
			Add(new Plot(Color.Red, "Total Sell"));
			Add(new Plot(Color.RoyalBlue,   "Total Buy"));
			Add(new Plot(Color.Yellow,   "Delta"));
			
			Add(new Line(Color.DimGray, 0, "zeroLine"));
            Lines[0].Pen.DashStyle = DashStyle.Dash;
			Lines[0].Pen.Width=2;

					
            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
			PaintPriceMarkers	= true;
			AutoScale			= true;			
		}
     
		
		protected override void OnBarUpdate()        
			
		{	
	       
			if(CurrentBar<3)return;
		}		
		
	
		protected override void OnMarketDepth(MarketDepthEventArgs e)
		{	
					// try, catch will handle any runtime errors, preventing the program from crashing
			try{	// this { is the start of the area that is being monitored for errors
				    // there may be runtime errors when this starts up in NT7
        {
			
				List<LadderRow> rows = null;
	
				// Checks to see if the event involves ask data
				if (e.MarketDataType == MarketDataType.Ask)
					rows = askRows;
				
				// Checks to see if the event involves bid data
				else if (e.MarketDataType == MarketDataType.Bid)
					rows = bidRows;
	
				if (rows == null) // event involves neither bid nor ask data
					return;
				
				#if NT7 // This switch will prevent the bracketed code from being compiled in NT6.5.
						// In NT7, MUST explcitly create list rows before inserting into them, to prevent runtime error
				{	    // Could also have used the Add method but this is more fun.
				if(rows.Count<4) //Create as many rows as you will need for your Level II data. I don't know if you can get more than 20.
					{ 	 idx1 =0;	
				  		for (idx1 = 0; idx1 < maxrows; idx1++)
						{   //insert placholder objects of type LadderRowrows into the list
							askRows.Insert(idx1, new LadderRow((int)0,(int) 0, "")); 
							bidRows.Insert(idx1, new LadderRow((int)0,(int) 0, ""));
						}
					}
				}
				#endif
				// In NT7, insertion will fail if there is not already an empty row to insert into	
					
	           
				// Checks to see if the action was an insertion into the ladder
				if (e.Operation == Operation.Insert)
				{			
					rows.Insert(e.Position, new LadderRow(0,(int) e.Volume, ""));
								}
				/* Checks to see if data were removed from the ladder
			
				-> check if e.Position is within valid range */
				else if (e.Operation == Operation.Remove && e.Position < rows.Count)
				{
					rows.RemoveAt(e.Position);
				}				
				/* Checks to see if the action was an update of data within the ladder
				-> check if e.Position is within valid range */
				else if (e.Operation == Operation.Update && e.Position < rows.Count)
				{
					rows[e.Position].Volume			=(int) e.Volume;  //VOLUME IS A DOUBLE IN NT7
				}
				
				
			
			try{				
			    if(CurrentBar<3)return;
				
					
				totAVol = 0;
				totBVol = 0;
				for (idx2 = 0; idx2 < maxrows; idx2++)
				{
				if(idx2<askRows.Count)totAVol += askRows[(int)idx2].Volume;
				if(idx2<bidRows.Count)totBVol -= bidRows[(int)idx2].Volume;
			
			 	Values[0].Set(totAVol);
				Values[1].Set(totBVol);
				Values[2].Set(totAVol+totBVol);
			
				}		
				} catch (Exception ex){
                    
				Print("Trapped exception in DOM Bands 7v109 OnMarketDepth Line 167 " + ex.Message);
                    return;				
				}
				
        }
	} //This is the end of the region that is being monitored for runtime errors
				catch (Exception ex){
                // Following is what we do if there is an error, sure beats crashing the indicator    
				Print("Trapped exception in DOM_Bands7v109.OnMarketDepth Line 176: " + ex.Message);
                return; //prevents the indicator from crashing
				}				
		}
		
#region ListRowsAndProperties	
		
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
		private class LadderRow   //for futures there is no Market Maker, but we can still use this to populate the lists
		{
			public	string	MarketMaker;			// relevant for stocks only
			public	double	Price;
			public	int		Volume;

			public LadderRow(double myPrice, int myVolume, string myMarketMaker)
			{
				MarketMaker	= myMarketMaker;
				Price		= myPrice;
				Volume		= myVolume;
			}
		}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++==		
		[Description("Number of DOM rows counted")]
		[GridCategory("Parameters")]
		public int MaxRows
		{
			get { return maxrows; }
			set { maxrows = Math.Min(10, value); }
		}
		
		
#endregion	
		
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DOM_Bands7v109[] cacheDOM_Bands7v109 = null;

        private static DOM_Bands7v109 checkDOM_Bands7v109 = new DOM_Bands7v109();

        /// <summary>
        /// Plots the Total of Buy and Sell Orders shown in the rows of the order book of an instrument.
        /// </summary>
        /// <returns></returns>
        public DOM_Bands7v109 DOM_Bands7v109(int maxRows)
        {
            return DOM_Bands7v109(Input, maxRows);
        }

        /// <summary>
        /// Plots the Total of Buy and Sell Orders shown in the rows of the order book of an instrument.
        /// </summary>
        /// <returns></returns>
        public DOM_Bands7v109 DOM_Bands7v109(Data.IDataSeries input, int maxRows)
        {
            if (cacheDOM_Bands7v109 != null)
                for (int idx = 0; idx < cacheDOM_Bands7v109.Length; idx++)
                    if (cacheDOM_Bands7v109[idx].MaxRows == maxRows && cacheDOM_Bands7v109[idx].EqualsInput(input))
                        return cacheDOM_Bands7v109[idx];

            lock (checkDOM_Bands7v109)
            {
                checkDOM_Bands7v109.MaxRows = maxRows;
                maxRows = checkDOM_Bands7v109.MaxRows;

                if (cacheDOM_Bands7v109 != null)
                    for (int idx = 0; idx < cacheDOM_Bands7v109.Length; idx++)
                        if (cacheDOM_Bands7v109[idx].MaxRows == maxRows && cacheDOM_Bands7v109[idx].EqualsInput(input))
                            return cacheDOM_Bands7v109[idx];

                DOM_Bands7v109 indicator = new DOM_Bands7v109();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.MaxRows = maxRows;
                Indicators.Add(indicator);
                indicator.SetUp();

                DOM_Bands7v109[] tmp = new DOM_Bands7v109[cacheDOM_Bands7v109 == null ? 1 : cacheDOM_Bands7v109.Length + 1];
                if (cacheDOM_Bands7v109 != null)
                    cacheDOM_Bands7v109.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDOM_Bands7v109 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Plots the Total of Buy and Sell Orders shown in the rows of the order book of an instrument.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DOM_Bands7v109 DOM_Bands7v109(int maxRows)
        {
            return _indicator.DOM_Bands7v109(Input, maxRows);
        }

        /// <summary>
        /// Plots the Total of Buy and Sell Orders shown in the rows of the order book of an instrument.
        /// </summary>
        /// <returns></returns>
        public Indicator.DOM_Bands7v109 DOM_Bands7v109(Data.IDataSeries input, int maxRows)
        {
            return _indicator.DOM_Bands7v109(input, maxRows);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Plots the Total of Buy and Sell Orders shown in the rows of the order book of an instrument.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DOM_Bands7v109 DOM_Bands7v109(int maxRows)
        {
            return _indicator.DOM_Bands7v109(Input, maxRows);
        }

        /// <summary>
        /// Plots the Total of Buy and Sell Orders shown in the rows of the order book of an instrument.
        /// </summary>
        /// <returns></returns>
        public Indicator.DOM_Bands7v109 DOM_Bands7v109(Data.IDataSeries input, int maxRows)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DOM_Bands7v109(input, maxRows);
        }
    }
}
#endregion
