#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
	/// Enter the description of your new custom indicator here
	/// </summary>
	[Description ("Enter the description of your new custom indicator here")]
	public class RubberBand : Indicator
	{
		#region Variables
		// Wizard generated variables
		private int longLeg = 35; // Default setting for LongLeg
		private int shortLeg = 1; // Default setting for ShortLeg
		private int multiLeg = 10; // Default setting for MultiLeg
		private int multiW = 1; // Default setting for MultiW
		// User defined variables (add any user defined variables below)
		#endregion

		double SyncShort, SyncLong, SyncMulti;
		double ShortWeight, LongWeight, MultiWeight;

		/// <summary>
		/// This method is used to configure the indicator and is called once before any bar data is loaded.
		/// </summary>
		protected override void Initialize ()
		{
			Add (new Line (Color.DarkGray, 0, "ZeroLine"));

			Add (new Plot (Color.FromKnownColor (KnownColor.Red), PlotStyle.Line, "MultiOsc"));
			Add (new Plot (Color.FromKnownColor (KnownColor.Purple), PlotStyle.Line, "MultiHigh"));
			Add (new Plot (Color.FromKnownColor (KnownColor.Purple), PlotStyle.Line, "MultiLow"));

			CalculateOnBarClose = true;
			Overlay = false;
			PriceTypeSupported = true;
			PriceType = PriceType.Close;

			ShortWeight = 2.0 / (ShortLeg + 1);
			LongWeight = 2.0 / (LongLeg + 1);
			MultiWeight = 2.0 / (MultiLeg + 1);
		}


		/// <summary>
		/// Called on each bar update event (incoming tick)
		/// </summary>
		protected override void OnBarUpdate ()
		{
			if (SyncShort == 0)
			{
				SyncShort = Close [0];
				SyncLong = Close [0];
			}
			else
			{
				SyncShort = SyncShort * (1 - ShortWeight) + (ShortWeight * Close [0]);
				SyncLong = SyncLong * (1 - LongWeight) + (LongWeight * Close [0]);
			}

			double multiOsc = 100 * ((SyncShort / SyncLong) - 1);
			if (SyncMulti == 0)
				SyncMulti = multiOsc;
			else
				SyncMulti = Math.Abs (SyncMulti) * (1 - MultiWeight) + (MultiWeight * multiOsc);

			MultiHigh.Set (SyncMulti * MultiW);
			MultiLow.Set (-SyncMulti * MultiW);
			MultiOsc.Set (multiOsc);
		}

		[Browsable (false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore ()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public DataSeries MultiOsc
		{
			get { return Values [0]; }
		}

		#region Properties
		[Browsable (false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore ()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public DataSeries MultiHigh
		{
			get { return Values [1]; }
		}

		[Browsable (false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore ()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public DataSeries MultiLow
		{
			get { return Values [2]; }
		}



		[Description ("")]
		[Category ("Parameters")]
		public int LongLeg
		{
			get { return longLeg; }
			set { longLeg = Math.Max (1, value); }
		}

		[Description ("")]
		[Category ("Parameters")]
		public int ShortLeg
		{
			get { return shortLeg; }
			set { shortLeg = Math.Max (1, value); }
		}

		[Description ("")]
		[Category ("Parameters")]
		public int MultiLeg
		{
			get { return multiLeg; }
			set { multiLeg = Math.Max (1, value); }
		}

		[Description ("")]
		[Category ("Parameters")]
		public int MultiW
		{
			get { return multiW; }
			set { multiW = Math.Max (1, value); }
		}
		#endregion
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	public partial class Indicator : IndicatorBase
	{
		private RubberBand [] cacheRubberBand = null;

		private static RubberBand checkRubberBand = new RubberBand ();

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public RubberBand RubberBand (int longLeg, int multiLeg, int multiW, int shortLeg)
		{
			return RubberBand (Input, longLeg, multiLeg, multiW, shortLeg);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public RubberBand RubberBand (Data.IDataSeries input, int longLeg, int multiLeg, int multiW, int shortLeg)
		{
			checkRubberBand.LongLeg = longLeg;
			longLeg = checkRubberBand.LongLeg;
			checkRubberBand.MultiLeg = multiLeg;
			multiLeg = checkRubberBand.MultiLeg;
			checkRubberBand.MultiW = multiW;
			multiW = checkRubberBand.MultiW;
			checkRubberBand.ShortLeg = shortLeg;
			shortLeg = checkRubberBand.ShortLeg;

			if (cacheRubberBand != null)
				for (int idx = 0; idx < cacheRubberBand.Length; idx++)
					if (cacheRubberBand [idx].LongLeg == longLeg && cacheRubberBand [idx].MultiLeg == multiLeg && cacheRubberBand [idx].MultiW == multiW && cacheRubberBand [idx].ShortLeg == shortLeg && cacheRubberBand [idx].EqualsInput (input))
						return cacheRubberBand [idx];

			RubberBand indicator = new RubberBand ();
			indicator.BarsRequired = BarsRequired;
			indicator.CalculateOnBarClose = CalculateOnBarClose;
			indicator.Input = input;
			indicator.LongLeg = longLeg;
			indicator.MultiLeg = multiLeg;
			indicator.MultiW = multiW;
			indicator.ShortLeg = shortLeg;
			indicator.SetUp ();

			RubberBand [] tmp = new RubberBand [cacheRubberBand == null ? 1 : cacheRubberBand.Length + 1];
			if (cacheRubberBand != null)
				cacheRubberBand.CopyTo (tmp, 0);
			tmp [tmp.Length - 1] = indicator;
			cacheRubberBand = tmp;
			Indicators.Add (indicator);

			return indicator;
		}

	}
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
	public partial class Column : ColumnBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.RubberBand RubberBand (int longLeg, int multiLeg, int multiW, int shortLeg)
		{
			return _indicator.RubberBand (Input, longLeg, multiLeg, multiW, shortLeg);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.RubberBand RubberBand (Data.IDataSeries input, int longLeg, int multiLeg, int multiW, int shortLeg)
		{
			return _indicator.RubberBand (input, longLeg, multiLeg, multiW, shortLeg);
		}

	}
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
	public partial class Strategy : StrategyBase
	{
		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		[Gui.Design.WizardCondition ("Indicator")]
		public Indicator.RubberBand RubberBand (int longLeg, int multiLeg, int multiW, int shortLeg)
		{
			return _indicator.RubberBand (Input, longLeg, multiLeg, multiW, shortLeg);
		}

		/// <summary>
		/// Enter the description of your new custom indicator here
		/// </summary>
		/// <returns></returns>
		public Indicator.RubberBand RubberBand (Data.IDataSeries input, int longLeg, int multiLeg, int multiW, int shortLeg)
		{
			if (InInitialize && input == null)
				throw new ArgumentException ("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

			return _indicator.RubberBand (input, longLeg, multiLeg, multiW, shortLeg);
		}

	}
}
#endregion
