#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    [Description("(ver 1.2  07/13/2011)   by photog53   Adjusts 'scaling' of chart adding whitespace above below price swings, when price narrows.   Leaves large price swing scaling alone")]
    public class ChartScale : Indicator
    {
        #region Variables
        
            private int lookBack 		= 150; 
            private int tickRange 		= 60; 
			private int barsBack		= 20;
			private bool extendRange		= false;
			private Color rangeColor	= Color.Transparent;
        	//--------------------------------
			private double _tickRange			= .0;
			private double rangeHigh			= 0;
			private double rangeLow				= 0;
			private double rangeDiff			= 0;
			private double scaleDiff			= 0;
			private double addon				= 0;
	
			//----TEXT ----------------
			private Font textFont	= new Font("Courier", 11, FontStyle.Regular);
			private Color textColor = Color.Gray;
			private Color tr		= Color.Transparent;
		
        #endregion

        protected override void Initialize()
        {
            AutoScale			= true;
			Overlay				= true;
        }

        protected override void OnBarUpdate()
        {
					
			_tickRange = (tickRange * TickSize);
			if (CurrentBar > lookBack +5)
			{
				rangeHigh =  MAX(High, lookBack) [1];
				rangeLow  =  MIN(Low, lookBack) [1];
				//rangeDiff = rangeHigh - rangeLow;
				rangeDiff = Math.Round(rangeHigh - rangeLow,4);
				scaleDiff = _tickRange - rangeDiff;
							
				if (scaleDiff > 0)
				{
					addon = (scaleDiff / 2);
					if (!extendRange)
					{
						DrawText("adjustTop",true,".",barsBack,rangeHigh + addon,0, rangeColor,textFont,StringAlignment.Near,tr,tr,0);
						DrawText("adjustBot",true,".",barsBack,rangeLow - addon,0, rangeColor,textFont,StringAlignment.Near,tr,tr,0);
					}
					else
					{
						DrawText("adjustTop"+CurrentBar,true,".",barsBack,rangeHigh + addon,0, rangeColor,textFont,StringAlignment.Near,tr,tr,0);
						DrawText("adjustBot"+CurrentBar,true,".",barsBack,rangeLow - addon,0, rangeColor,textFont,StringAlignment.Near,tr,tr,0);
					}
					//DrawText("rH"+CurrentBar,true,"High"+rangeHigh.ToString(),0,High[0],300, Color.Black,textFont,StringAlignment.Near,tr,tr,0);
					//DrawText("rL"+CurrentBar,true,"Low"+rangeLow.ToString(),0,High[0],250, Color.Black,textFont,StringAlignment.Near,tr,tr,0);
					//DrawText("rD"+CurrentBar,true,"Diff"+rangeDiff.ToString(),0,High[0],200, Color.Black,textFont,StringAlignment.Near,tr,tr,0);
					//DrawText("sD"+CurrentBar,true,"scale"+scaleDiff.ToString(),0,High[0],150, Color.Black,textFont,StringAlignment.Near,tr,tr,0);
				}
				else
				{
					if (!extendRange)
					{
						RemoveDrawObject("adjustTop");
						RemoveDrawObject("adjustBot");
					}
					int donothing;
					donothing = 1;
				}
            	DrawVerticalLine("vline",lookBack,Color.Black,DashStyle.Solid,1);
			}
        }

        #region Properties

        [Description("")]
        [GridCategory("Parameters")]
        public int LookBack
        {
            get { return lookBack; }
            set { lookBack = Math.Max(1, value); }
        }

        [Description("")]
        [GridCategory("Parameters")]
        public int TickRange
        {
            get { return tickRange; }
            set { tickRange = Math.Max(1, value); }
        }
		
		[Description("Bars back for the scale plot")]
        [GridCategory("Parameters")]
        public int BarsBack
        {
            get { return barsBack; }
            set { barsBack = Math.Max(1, value); }
        }
		
		[Description("Extend the 'range buffer' lines top and bottom back past current page ")]
        [Category("ChartControl")]
        public bool ExtendRange
        {
            get { return extendRange; }
            set { extendRange = value; }
        }
		
				
		[XmlIgnore()]
        [Description("NOTE: Use color other than transparent if you want to SEE the lines ")]
        [Category("ChartControl")]
		[Gui.Design.DisplayName ("Range Color")]
        public Color RangeColor
        {
            get { return rangeColor; }
            set { rangeColor = value; }
        }
			[Browsable(false)]
			public string RangeColorSerialize
			{
				get { return NinjaTrader.Gui.Design.SerializableColor.ToString(rangeColor); }
				set { rangeColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
			}  

        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private ChartScale[] cacheChartScale = null;

        private static ChartScale checkChartScale = new ChartScale();

        /// <summary>
        /// (ver 1.2  07/13/2011)   by photog53   Adjusts 'scaling' of chart adding whitespace above below price swings, when price narrows.   Leaves large price swing scaling alone
        /// </summary>
        /// <returns></returns>
        public ChartScale ChartScale(int barsBack, int lookBack, int tickRange)
        {
            return ChartScale(Input, barsBack, lookBack, tickRange);
        }

        /// <summary>
        /// (ver 1.2  07/13/2011)   by photog53   Adjusts 'scaling' of chart adding whitespace above below price swings, when price narrows.   Leaves large price swing scaling alone
        /// </summary>
        /// <returns></returns>
        public ChartScale ChartScale(Data.IDataSeries input, int barsBack, int lookBack, int tickRange)
        {
            if (cacheChartScale != null)
                for (int idx = 0; idx < cacheChartScale.Length; idx++)
                    if (cacheChartScale[idx].BarsBack == barsBack && cacheChartScale[idx].LookBack == lookBack && cacheChartScale[idx].TickRange == tickRange && cacheChartScale[idx].EqualsInput(input))
                        return cacheChartScale[idx];

            lock (checkChartScale)
            {
                checkChartScale.BarsBack = barsBack;
                barsBack = checkChartScale.BarsBack;
                checkChartScale.LookBack = lookBack;
                lookBack = checkChartScale.LookBack;
                checkChartScale.TickRange = tickRange;
                tickRange = checkChartScale.TickRange;

                if (cacheChartScale != null)
                    for (int idx = 0; idx < cacheChartScale.Length; idx++)
                        if (cacheChartScale[idx].BarsBack == barsBack && cacheChartScale[idx].LookBack == lookBack && cacheChartScale[idx].TickRange == tickRange && cacheChartScale[idx].EqualsInput(input))
                            return cacheChartScale[idx];

                ChartScale indicator = new ChartScale();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.BarsBack = barsBack;
                indicator.LookBack = lookBack;
                indicator.TickRange = tickRange;
                Indicators.Add(indicator);
                indicator.SetUp();

                ChartScale[] tmp = new ChartScale[cacheChartScale == null ? 1 : cacheChartScale.Length + 1];
                if (cacheChartScale != null)
                    cacheChartScale.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheChartScale = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// (ver 1.2  07/13/2011)   by photog53   Adjusts 'scaling' of chart adding whitespace above below price swings, when price narrows.   Leaves large price swing scaling alone
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ChartScale ChartScale(int barsBack, int lookBack, int tickRange)
        {
            return _indicator.ChartScale(Input, barsBack, lookBack, tickRange);
        }

        /// <summary>
        /// (ver 1.2  07/13/2011)   by photog53   Adjusts 'scaling' of chart adding whitespace above below price swings, when price narrows.   Leaves large price swing scaling alone
        /// </summary>
        /// <returns></returns>
        public Indicator.ChartScale ChartScale(Data.IDataSeries input, int barsBack, int lookBack, int tickRange)
        {
            return _indicator.ChartScale(input, barsBack, lookBack, tickRange);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// (ver 1.2  07/13/2011)   by photog53   Adjusts 'scaling' of chart adding whitespace above below price swings, when price narrows.   Leaves large price swing scaling alone
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.ChartScale ChartScale(int barsBack, int lookBack, int tickRange)
        {
            return _indicator.ChartScale(Input, barsBack, lookBack, tickRange);
        }

        /// <summary>
        /// (ver 1.2  07/13/2011)   by photog53   Adjusts 'scaling' of chart adding whitespace above below price swings, when price narrows.   Leaves large price swing scaling alone
        /// </summary>
        /// <returns></returns>
        public Indicator.ChartScale ChartScale(Data.IDataSeries input, int barsBack, int lookBack, int tickRange)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.ChartScale(input, barsBack, lookBack, tickRange);
        }
    }
}
#endregion
