//
// john thom @ johnthom.com - 11/7/2009  - please do not remove this line if you make copies of this code.  Thanks.
//
#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

namespace NinjaTrader.Indicator
{
	/// <summary>
	/// This indicator is intended to be used on range based charts only.
	/// It will draw a box around the current candle depicting the maximum range
	/// the current bar can grow before a new bar will be printed.
	/// It will color the box depending on how close to a new bar the current
	/// range has traveled.
	/// Optionally, it will print the high and low range prices at the top
	/// and bottom of the box.
	/// 
	/// Possible uses may be setting limit orders to the tick above or below a
	/// bar breakout.
	/// 
	/// Really it's just eye candy.
	/// 
	/// 
	/// 3/10 - Converted to NT7, added additional text, fixed double precision problem, formatting
	/// 
	/// </summary>
    [Description("Indicate where the range bar may close and a new bar will start.")]
    public class jtRangeMarker7 : Indicator
    {
		bool showPrices;
		bool isRangeChart;
		bool firstTime;
		private SolidBrush chartFontBrush;
		private Color defaultColor = Color.Black;
		private Color warningColor = Color.Blue;
		private Color lockedColor = Color.Red;
		private Color textColor = Color.Black;
		private const string noRangeMessage = "jtRangeMarker7 only works on range charts!";
		private int digits;
        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			PaintPriceMarkers	= false;
			
			firstTime = true;
			isRangeChart = false;
			showPrices = true;
			
        }

		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max)
		{
			try {
				base.Plot(graphics, bounds, min, max);
			
			
			if (Bars == null)
				return;

			if (isRangeChart)
			{
				int	actualRange	= (int) Math.Round(Math.Max(Close[0] - Low[0], High[0] - Close[0]) / Bars.Instrument.MasterInstrument.TickSize);
				int	rangeCount	= Bars.Period.Value - actualRange ;
				
				
				// determine wiggle room in ticks
				
				int barRange = (int) Math.Round( (High[0] - Low[0]) / Bars.Instrument.MasterInstrument.TickSize);
				
				int margin = (Bars.Period.Value - barRange);
				
				// calc our rectangle properties
				double highPrice = High[0] + (margin*TickSize);
				double lowPrice =  Low[0]  - (margin*TickSize);
				
				
				int rangeHighY = (bounds.Y + bounds.Height) - ((int) ((( highPrice - min ) / ChartControl.MaxMinusMin(max, min)) * bounds.Height))-1;
				int rangeLowY =  (bounds.Y + bounds.Height) - ((int) ((( lowPrice  - min ) / ChartControl.MaxMinusMin(max, min)) * bounds.Height))-1;
				int height = rangeLowY - rangeHighY;
				int rangeX = ChartControl.GetXByBarIdx(Bars, CurrentBar) -  (ChartControl.BarSpace/2) ;
				int width =  (ChartControl.BarSpace);
		
				int adj = 0;
				using (Pen tempPen = new Pen(defaultColor)){
					
					switch(margin){
						case 0:
							tempPen.Color = lockedColor;
							tempPen.Width = 2;
							adj = 1;
							break;
						case 1:
							tempPen.Color = warningColor;
							tempPen.Width = 2;
							adj = 1;
							break;
					}
					
					graphics.DrawRectangle(tempPen, rangeX, rangeHighY, width+adj, height);
				}	

				if(showPrices){
					
					
					int lineH = (int)graphics.MeasureString("X", ChartControl.Font).Height;
					
					graphics.DrawString(highPrice.ToString("F"+digits), ChartControl.Font, chartFontBrush, rangeX, rangeHighY - lineH);
					graphics.DrawString("R:" + rangeCount, ChartControl.Font, chartFontBrush, rangeX + width, rangeHighY );
					graphics.DrawString(lowPrice.ToString("F"+digits), ChartControl.Font, chartFontBrush, rangeX, rangeLowY);
					graphics.DrawString("C:" + barRange, ChartControl.Font, chartFontBrush, rangeX + width, rangeLowY - lineH  );
				}
					
			}
			else
			{
				graphics.DrawString(noRangeMessage, ChartControl.Font, chartFontBrush, 
					bounds.X + bounds.Width - graphics.MeasureString(noRangeMessage, ChartControl.Font).Width-10, 
					bounds.Y + bounds.Height - graphics.MeasureString(noRangeMessage, ChartControl.Font).Height-10);
			}
			} catch (Exception ex){
				Print(ex.ToString());
			}
		}		
		
		
        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			try {
			if (ChartControl == null || ChartControl.Bars == null || ChartControl.Bars.Length == 0 )
				return;
			
			if (firstTime){
				if (Bars.Period.Id == PeriodType.Range || (Data.BarsType.GetInstance(ChartControl.Bars[0].Period.Id).BuiltFrom == Data.PeriodType.Tick && ChartControl.Bars[0].Period.ToString().IndexOf("Range") >= 0))
				{
					isRangeChart = true;
					firstTime = false;

					// calc digits from TickSize
					digits = 0;
					string s = ((decimal)TickSize).ToString(System.Globalization.CultureInfo.InvariantCulture);
					if (s.Contains(".")){
						string ss = s.Substring(s.IndexOf("."));
						digits = ss.Length-1;
					}
					
					chartFontBrush =  new SolidBrush(textColor);
				}
			}
			} catch (Exception ex){
				Print(ex.ToString());
			}
        }

     	//======================== PROPERTIES ===================================================

		[Description("Default Box Color")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("Default Color")]
        public Color DefaultColor
        {
            get { return defaultColor; }
            set { defaultColor = value; }
        }
		
		[Browsable(false)]
		public string defaultColorSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(defaultColor); }
			set { defaultColor = Gui.Design.SerializableColor.FromString(value); }
		}
		
		[Description("Warning Box Color")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("Warning Color")]
        public Color WarningColor
        {
            get { return warningColor; }
            set { warningColor = value; }
        }
		
		[Browsable(false)]
		public string warningColorSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(warningColor); }
			set { warningColor = Gui.Design.SerializableColor.FromString(value); }
		}		
		
		[Description("Locked Box Color")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("Locked Color")]
        public Color LockedColor
        {
            get { return lockedColor; }
            set { lockedColor = value; }
        }
		
		[Browsable(false)]
		public string lockedColorSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(lockedColor); }
			set { lockedColor = Gui.Design.SerializableColor.FromString(value); }
		}	
		
		[Description("Text Color")]
        [Category("Visual")]
		[Gui.Design.DisplayName ("Text Color")]
        public Color TextColor
        {
            get { return textColor; }
            set { textColor = value; }
        }
		
		[Browsable(false)]
		public string textColorSerialize
		{
			get { return Gui.Design.SerializableColor.ToString(textColor); }
			set { textColor = Gui.Design.SerializableColor.FromString(value); }
		}	
		
		
		
		[Description("Show price at high and low of box.")]
		[Gui.Design.DisplayName ("Show Prices")]
        [Category("Parameters")]
        public bool ShowPrices
        {
            get { return showPrices; }
            set { showPrices = value; }
        }
		
        
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private jtRangeMarker7[] cachejtRangeMarker7 = null;

        private static jtRangeMarker7 checkjtRangeMarker7 = new jtRangeMarker7();

        /// <summary>
        /// Indicate where the range bar may close and a new bar will start.
        /// </summary>
        /// <returns></returns>
        public jtRangeMarker7 jtRangeMarker7(bool showPrices)
        {
            return jtRangeMarker7(Input, showPrices);
        }

        /// <summary>
        /// Indicate where the range bar may close and a new bar will start.
        /// </summary>
        /// <returns></returns>
        public jtRangeMarker7 jtRangeMarker7(Data.IDataSeries input, bool showPrices)
        {
            if (cachejtRangeMarker7 != null)
                for (int idx = 0; idx < cachejtRangeMarker7.Length; idx++)
                    if (cachejtRangeMarker7[idx].ShowPrices == showPrices && cachejtRangeMarker7[idx].EqualsInput(input))
                        return cachejtRangeMarker7[idx];

            lock (checkjtRangeMarker7)
            {
                checkjtRangeMarker7.ShowPrices = showPrices;
                showPrices = checkjtRangeMarker7.ShowPrices;

                if (cachejtRangeMarker7 != null)
                    for (int idx = 0; idx < cachejtRangeMarker7.Length; idx++)
                        if (cachejtRangeMarker7[idx].ShowPrices == showPrices && cachejtRangeMarker7[idx].EqualsInput(input))
                            return cachejtRangeMarker7[idx];

                jtRangeMarker7 indicator = new jtRangeMarker7();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.ShowPrices = showPrices;
                Indicators.Add(indicator);
                indicator.SetUp();

                jtRangeMarker7[] tmp = new jtRangeMarker7[cachejtRangeMarker7 == null ? 1 : cachejtRangeMarker7.Length + 1];
                if (cachejtRangeMarker7 != null)
                    cachejtRangeMarker7.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachejtRangeMarker7 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Indicate where the range bar may close and a new bar will start.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.jtRangeMarker7 jtRangeMarker7(bool showPrices)
        {
            return _indicator.jtRangeMarker7(Input, showPrices);
        }

        /// <summary>
        /// Indicate where the range bar may close and a new bar will start.
        /// </summary>
        /// <returns></returns>
        public Indicator.jtRangeMarker7 jtRangeMarker7(Data.IDataSeries input, bool showPrices)
        {
            return _indicator.jtRangeMarker7(input, showPrices);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Indicate where the range bar may close and a new bar will start.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.jtRangeMarker7 jtRangeMarker7(bool showPrices)
        {
            return _indicator.jtRangeMarker7(Input, showPrices);
        }

        /// <summary>
        /// Indicate where the range bar may close and a new bar will start.
        /// </summary>
        /// <returns></returns>
        public Indicator.jtRangeMarker7 jtRangeMarker7(Data.IDataSeries input, bool showPrices)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.jtRangeMarker7(input, showPrices);
        }
    }
}
#endregion
