//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BAVolCounterGtr[] cacheBAVolCounterGtr = null;
        private VolumeDirBins[] cacheVolumeDirBins = null;
        private VolumeFrequency[] cacheVolumeFrequency = null;

        private static BAVolCounterGtr checkBAVolCounterGtr = new BAVolCounterGtr();
        private static VolumeDirBins checkVolumeDirBins = new VolumeDirBins();
        private static VolumeFrequency checkVolumeFrequency = new VolumeFrequency();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public BAVolCounterGtr BAVolCounterGtr(int volGreaterThan)
        {
            return BAVolCounterGtr(Input, volGreaterThan);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public BAVolCounterGtr BAVolCounterGtr(Data.IDataSeries input, int volGreaterThan)
        {
            if (cacheBAVolCounterGtr != null)
                for (int idx = 0; idx < cacheBAVolCounterGtr.Length; idx++)
                    if (cacheBAVolCounterGtr[idx].VolGreaterThan == volGreaterThan && cacheBAVolCounterGtr[idx].EqualsInput(input))
                        return cacheBAVolCounterGtr[idx];

            lock (checkBAVolCounterGtr)
            {
                checkBAVolCounterGtr.VolGreaterThan = volGreaterThan;
                volGreaterThan = checkBAVolCounterGtr.VolGreaterThan;

                if (cacheBAVolCounterGtr != null)
                    for (int idx = 0; idx < cacheBAVolCounterGtr.Length; idx++)
                        if (cacheBAVolCounterGtr[idx].VolGreaterThan == volGreaterThan && cacheBAVolCounterGtr[idx].EqualsInput(input))
                            return cacheBAVolCounterGtr[idx];

                BAVolCounterGtr indicator = new BAVolCounterGtr();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.VolGreaterThan = volGreaterThan;
                Indicators.Add(indicator);
                indicator.SetUp();

                BAVolCounterGtr[] tmp = new BAVolCounterGtr[cacheBAVolCounterGtr == null ? 1 : cacheBAVolCounterGtr.Length + 1];
                if (cacheBAVolCounterGtr != null)
                    cacheBAVolCounterGtr.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheBAVolCounterGtr = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public VolumeDirBins VolumeDirBins(int input1, int input2, int input3, int input4)
        {
            return VolumeDirBins(Input, input1, input2, input3, input4);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public VolumeDirBins VolumeDirBins(Data.IDataSeries input, int input1, int input2, int input3, int input4)
        {
            if (cacheVolumeDirBins != null)
                for (int idx = 0; idx < cacheVolumeDirBins.Length; idx++)
                    if (cacheVolumeDirBins[idx].Input1 == input1 && cacheVolumeDirBins[idx].Input2 == input2 && cacheVolumeDirBins[idx].Input3 == input3 && cacheVolumeDirBins[idx].Input4 == input4 && cacheVolumeDirBins[idx].EqualsInput(input))
                        return cacheVolumeDirBins[idx];

            lock (checkVolumeDirBins)
            {
                checkVolumeDirBins.Input1 = input1;
                input1 = checkVolumeDirBins.Input1;
                checkVolumeDirBins.Input2 = input2;
                input2 = checkVolumeDirBins.Input2;
                checkVolumeDirBins.Input3 = input3;
                input3 = checkVolumeDirBins.Input3;
                checkVolumeDirBins.Input4 = input4;
                input4 = checkVolumeDirBins.Input4;

                if (cacheVolumeDirBins != null)
                    for (int idx = 0; idx < cacheVolumeDirBins.Length; idx++)
                        if (cacheVolumeDirBins[idx].Input1 == input1 && cacheVolumeDirBins[idx].Input2 == input2 && cacheVolumeDirBins[idx].Input3 == input3 && cacheVolumeDirBins[idx].Input4 == input4 && cacheVolumeDirBins[idx].EqualsInput(input))
                            return cacheVolumeDirBins[idx];

                VolumeDirBins indicator = new VolumeDirBins();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Input1 = input1;
                indicator.Input2 = input2;
                indicator.Input3 = input3;
                indicator.Input4 = input4;
                Indicators.Add(indicator);
                indicator.SetUp();

                VolumeDirBins[] tmp = new VolumeDirBins[cacheVolumeDirBins == null ? 1 : cacheVolumeDirBins.Length + 1];
                if (cacheVolumeDirBins != null)
                    cacheVolumeDirBins.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheVolumeDirBins = tmp;
                return indicator;
            }
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public VolumeFrequency VolumeFrequency(int emaLength, int minVol)
        {
            return VolumeFrequency(Input, emaLength, minVol);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public VolumeFrequency VolumeFrequency(Data.IDataSeries input, int emaLength, int minVol)
        {
            if (cacheVolumeFrequency != null)
                for (int idx = 0; idx < cacheVolumeFrequency.Length; idx++)
                    if (cacheVolumeFrequency[idx].EmaLength == emaLength && cacheVolumeFrequency[idx].MinVol == minVol && cacheVolumeFrequency[idx].EqualsInput(input))
                        return cacheVolumeFrequency[idx];

            lock (checkVolumeFrequency)
            {
                checkVolumeFrequency.EmaLength = emaLength;
                emaLength = checkVolumeFrequency.EmaLength;
                checkVolumeFrequency.MinVol = minVol;
                minVol = checkVolumeFrequency.MinVol;

                if (cacheVolumeFrequency != null)
                    for (int idx = 0; idx < cacheVolumeFrequency.Length; idx++)
                        if (cacheVolumeFrequency[idx].EmaLength == emaLength && cacheVolumeFrequency[idx].MinVol == minVol && cacheVolumeFrequency[idx].EqualsInput(input))
                            return cacheVolumeFrequency[idx];

                VolumeFrequency indicator = new VolumeFrequency();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.EmaLength = emaLength;
                indicator.MinVol = minVol;
                Indicators.Add(indicator);
                indicator.SetUp();

                VolumeFrequency[] tmp = new VolumeFrequency[cacheVolumeFrequency == null ? 1 : cacheVolumeFrequency.Length + 1];
                if (cacheVolumeFrequency != null)
                    cacheVolumeFrequency.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheVolumeFrequency = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BAVolCounterGtr BAVolCounterGtr(int volGreaterThan)
        {
            return _indicator.BAVolCounterGtr(Input, volGreaterThan);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.BAVolCounterGtr BAVolCounterGtr(Data.IDataSeries input, int volGreaterThan)
        {
            return _indicator.BAVolCounterGtr(input, volGreaterThan);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeDirBins VolumeDirBins(int input1, int input2, int input3, int input4)
        {
            return _indicator.VolumeDirBins(Input, input1, input2, input3, input4);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeDirBins VolumeDirBins(Data.IDataSeries input, int input1, int input2, int input3, int input4)
        {
            return _indicator.VolumeDirBins(input, input1, input2, input3, input4);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeFrequency VolumeFrequency(int emaLength, int minVol)
        {
            return _indicator.VolumeFrequency(Input, emaLength, minVol);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeFrequency VolumeFrequency(Data.IDataSeries input, int emaLength, int minVol)
        {
            return _indicator.VolumeFrequency(input, emaLength, minVol);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BAVolCounterGtr BAVolCounterGtr(int volGreaterThan)
        {
            return _indicator.BAVolCounterGtr(Input, volGreaterThan);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.BAVolCounterGtr BAVolCounterGtr(Data.IDataSeries input, int volGreaterThan)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BAVolCounterGtr(input, volGreaterThan);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeDirBins VolumeDirBins(int input1, int input2, int input3, int input4)
        {
            return _indicator.VolumeDirBins(Input, input1, input2, input3, input4);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeDirBins VolumeDirBins(Data.IDataSeries input, int input1, int input2, int input3, int input4)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.VolumeDirBins(input, input1, input2, input3, input4);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.VolumeFrequency VolumeFrequency(int emaLength, int minVol)
        {
            return _indicator.VolumeFrequency(Input, emaLength, minVol);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.VolumeFrequency VolumeFrequency(Data.IDataSeries input, int emaLength, int minVol)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.VolumeFrequency(input, emaLength, minVol);
        }
    }
}
#endregion
