//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private HolyGrail[] cacheHolyGrail = null;

        private static HolyGrail checkHolyGrail = new HolyGrail();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HolyGrail HolyGrail(bool drawHGRectangles, Color hGColorFlat, Color hGColorLong, Color hGColorShort, int hGOpacity, double level, int lookback, int period, bool plotHGSignal)
        {
            return HolyGrail(Input, drawHGRectangles, hGColorFlat, hGColorLong, hGColorShort, hGOpacity, level, lookback, period, plotHGSignal);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HolyGrail HolyGrail(Data.IDataSeries input, bool drawHGRectangles, Color hGColorFlat, Color hGColorLong, Color hGColorShort, int hGOpacity, double level, int lookback, int period, bool plotHGSignal)
        {
            if (cacheHolyGrail != null)
                for (int idx = 0; idx < cacheHolyGrail.Length; idx++)
                    if (cacheHolyGrail[idx].DrawHGRectangles == drawHGRectangles && cacheHolyGrail[idx].HGColorFlat == hGColorFlat && cacheHolyGrail[idx].HGColorLong == hGColorLong && cacheHolyGrail[idx].HGColorShort == hGColorShort && cacheHolyGrail[idx].HGOpacity == hGOpacity && Math.Abs(cacheHolyGrail[idx].Level - level) <= double.Epsilon && cacheHolyGrail[idx].Lookback == lookback && cacheHolyGrail[idx].Period == period && cacheHolyGrail[idx].PlotHGSignal == plotHGSignal && cacheHolyGrail[idx].EqualsInput(input))
                        return cacheHolyGrail[idx];

            lock (checkHolyGrail)
            {
                checkHolyGrail.DrawHGRectangles = drawHGRectangles;
                drawHGRectangles = checkHolyGrail.DrawHGRectangles;
                checkHolyGrail.HGColorFlat = hGColorFlat;
                hGColorFlat = checkHolyGrail.HGColorFlat;
                checkHolyGrail.HGColorLong = hGColorLong;
                hGColorLong = checkHolyGrail.HGColorLong;
                checkHolyGrail.HGColorShort = hGColorShort;
                hGColorShort = checkHolyGrail.HGColorShort;
                checkHolyGrail.HGOpacity = hGOpacity;
                hGOpacity = checkHolyGrail.HGOpacity;
                checkHolyGrail.Level = level;
                level = checkHolyGrail.Level;
                checkHolyGrail.Lookback = lookback;
                lookback = checkHolyGrail.Lookback;
                checkHolyGrail.Period = period;
                period = checkHolyGrail.Period;
                checkHolyGrail.PlotHGSignal = plotHGSignal;
                plotHGSignal = checkHolyGrail.PlotHGSignal;

                if (cacheHolyGrail != null)
                    for (int idx = 0; idx < cacheHolyGrail.Length; idx++)
                        if (cacheHolyGrail[idx].DrawHGRectangles == drawHGRectangles && cacheHolyGrail[idx].HGColorFlat == hGColorFlat && cacheHolyGrail[idx].HGColorLong == hGColorLong && cacheHolyGrail[idx].HGColorShort == hGColorShort && cacheHolyGrail[idx].HGOpacity == hGOpacity && Math.Abs(cacheHolyGrail[idx].Level - level) <= double.Epsilon && cacheHolyGrail[idx].Lookback == lookback && cacheHolyGrail[idx].Period == period && cacheHolyGrail[idx].PlotHGSignal == plotHGSignal && cacheHolyGrail[idx].EqualsInput(input))
                            return cacheHolyGrail[idx];

                HolyGrail indicator = new HolyGrail();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.DrawHGRectangles = drawHGRectangles;
                indicator.HGColorFlat = hGColorFlat;
                indicator.HGColorLong = hGColorLong;
                indicator.HGColorShort = hGColorShort;
                indicator.HGOpacity = hGOpacity;
                indicator.Level = level;
                indicator.Lookback = lookback;
                indicator.Period = period;
                indicator.PlotHGSignal = plotHGSignal;
                Indicators.Add(indicator);
                indicator.SetUp();

                HolyGrail[] tmp = new HolyGrail[cacheHolyGrail == null ? 1 : cacheHolyGrail.Length + 1];
                if (cacheHolyGrail != null)
                    cacheHolyGrail.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheHolyGrail = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HolyGrail HolyGrail(bool drawHGRectangles, Color hGColorFlat, Color hGColorLong, Color hGColorShort, int hGOpacity, double level, int lookback, int period, bool plotHGSignal)
        {
            return _indicator.HolyGrail(Input, drawHGRectangles, hGColorFlat, hGColorLong, hGColorShort, hGOpacity, level, lookback, period, plotHGSignal);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.HolyGrail HolyGrail(Data.IDataSeries input, bool drawHGRectangles, Color hGColorFlat, Color hGColorLong, Color hGColorShort, int hGOpacity, double level, int lookback, int period, bool plotHGSignal)
        {
            return _indicator.HolyGrail(input, drawHGRectangles, hGColorFlat, hGColorLong, hGColorShort, hGOpacity, level, lookback, period, plotHGSignal);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.HolyGrail HolyGrail(bool drawHGRectangles, Color hGColorFlat, Color hGColorLong, Color hGColorShort, int hGOpacity, double level, int lookback, int period, bool plotHGSignal)
        {
            return _indicator.HolyGrail(Input, drawHGRectangles, hGColorFlat, hGColorLong, hGColorShort, hGOpacity, level, lookback, period, plotHGSignal);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.HolyGrail HolyGrail(Data.IDataSeries input, bool drawHGRectangles, Color hGColorFlat, Color hGColorLong, Color hGColorShort, int hGOpacity, double level, int lookback, int period, bool plotHGSignal)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.HolyGrail(input, drawHGRectangles, hGColorFlat, hGColorLong, hGColorShort, hGOpacity, level, lookback, period, plotHGSignal);
        }
    }
}
#endregion
