/// Indicator: Bill Williams' Acceleration/Deceleration Oscillator
/// Author: cvax
/// Version: 0.1.0
/// 
/// Usage: http://www.metaquotes.net/techanalysis/indicators/accelerator_decelerator

#region Using declarations
using System;
//using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

namespace NinjaTrader.Indicator
{
    [Description("Acceleration/Deceleration Technical Indicator (bwAC) measures acceleration and deceleration of the current driving force. This indicator will change direction before any changes in the driving force, which, it its turn, will change its direction before the price. If you realize that Acceleration/Deceleration is a signal of an earlier warning, it gives you evident advantages.")]
    [Gui.Design.DisplayName("Profitunity: AC (Accelerator/Decelerator Oscillator by Bill Williams)")]
    public class bwAC : Indicator
    {
        #region Variables
		//private DataSeries acdata;
		private double ac = 0;
		private double ac1 = 0;
        #endregion

        protected override void Initialize()
        {
			Add(new Plot(new Pen(Color.Red, 9), PlotStyle.Bar, "bwAC (Negative)"));
			Add(new Plot(new Pen(Color.Green, 9), PlotStyle.Bar, "bwAC (Positive)"));
			Add(new Plot(Color.Transparent, PlotStyle.Line, "bwAC"));
			
			//acdata = new DataSeries(this);
			
			DrawOnPricePanel	= false;
            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

        protected override void OnBarUpdate()
        {
			if(CurrentBar == 0)
				DrawHorizontalLine("Zero Line",true, 0, Color.Black, DashStyle.Solid, 1);
			if(FirstTickOfBar)
				ac1=ac;
			ac = bwAO().AOValue[0]-SMA(bwAO().AOValue,5)[0];
			
//			//eSignal reference script used another average on the bwAC. It made it smoother, but I don't know if it is accurate.
//			if(CurrentBar < 5)
//				return;
//			acdata.Set(bwAO().AOValue[0]-SMA(bwAO().AOValue,5)[0]);
//			int x = 0;
//			while(x<5)
//			{
//				ac+=acdata[x];
//				x++;
//			}
//			ac/=5;
			
			if(ac>ac1)
				ACPos.Set(ac);
			else
				ACNeg.Set(ac);
			ACValue.Set(ac);
        }

        #region Properties
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ACNeg
        {
            get { return Values[0]; }
        }

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ACPos
        {
            get { return Values[1]; }
        }
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries ACValue
        {
            get { return Values[2]; }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private bwAC[] cachebwAC = null;

        private static bwAC checkbwAC = new bwAC();

        /// <summary>
        /// Acceleration/Deceleration Technical Indicator (bwAC) measures acceleration and deceleration of the current driving force. This indicator will change direction before any changes in the driving force, which, it its turn, will change its direction before the price. If you realize that Acceleration/Deceleration is a signal of an earlier warning, it gives you evident advantages.
        /// </summary>
        /// <returns></returns>
        public bwAC bwAC()
        {
            return bwAC(Input);
        }

        /// <summary>
        /// Acceleration/Deceleration Technical Indicator (bwAC) measures acceleration and deceleration of the current driving force. This indicator will change direction before any changes in the driving force, which, it its turn, will change its direction before the price. If you realize that Acceleration/Deceleration is a signal of an earlier warning, it gives you evident advantages.
        /// </summary>
        /// <returns></returns>
        public bwAC bwAC(Data.IDataSeries input)
        {
            if (cachebwAC != null)
                for (int idx = 0; idx < cachebwAC.Length; idx++)
                    if (cachebwAC[idx].EqualsInput(input))
                        return cachebwAC[idx];

            lock (checkbwAC)
            {
                if (cachebwAC != null)
                    for (int idx = 0; idx < cachebwAC.Length; idx++)
                        if (cachebwAC[idx].EqualsInput(input))
                            return cachebwAC[idx];

                bwAC indicator = new bwAC();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                bwAC[] tmp = new bwAC[cachebwAC == null ? 1 : cachebwAC.Length + 1];
                if (cachebwAC != null)
                    cachebwAC.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachebwAC = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Acceleration/Deceleration Technical Indicator (bwAC) measures acceleration and deceleration of the current driving force. This indicator will change direction before any changes in the driving force, which, it its turn, will change its direction before the price. If you realize that Acceleration/Deceleration is a signal of an earlier warning, it gives you evident advantages.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bwAC bwAC()
        {
            return _indicator.bwAC(Input);
        }

        /// <summary>
        /// Acceleration/Deceleration Technical Indicator (bwAC) measures acceleration and deceleration of the current driving force. This indicator will change direction before any changes in the driving force, which, it its turn, will change its direction before the price. If you realize that Acceleration/Deceleration is a signal of an earlier warning, it gives you evident advantages.
        /// </summary>
        /// <returns></returns>
        public Indicator.bwAC bwAC(Data.IDataSeries input)
        {
            return _indicator.bwAC(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Acceleration/Deceleration Technical Indicator (bwAC) measures acceleration and deceleration of the current driving force. This indicator will change direction before any changes in the driving force, which, it its turn, will change its direction before the price. If you realize that Acceleration/Deceleration is a signal of an earlier warning, it gives you evident advantages.
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.bwAC bwAC()
        {
            return _indicator.bwAC(Input);
        }

        /// <summary>
        /// Acceleration/Deceleration Technical Indicator (bwAC) measures acceleration and deceleration of the current driving force. This indicator will change direction before any changes in the driving force, which, it its turn, will change its direction before the price. If you realize that Acceleration/Deceleration is a signal of an earlier warning, it gives you evident advantages.
        /// </summary>
        /// <returns></returns>
        public Indicator.bwAC bwAC(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.bwAC(input);
        }
    }
}
#endregion
