//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private EMA_Color_Crossover[] cacheEMA_Color_Crossover = null;

        private static EMA_Color_Crossover checkEMA_Color_Crossover = new EMA_Color_Crossover();

        /// <summary>
        /// NT 7 Version of MA crossover indicator. Changes color when fast MA crossing slow MA
        /// </summary>
        /// <returns></returns>
        public EMA_Color_Crossover EMA_Color_Crossover(int period1, int period2)
        {
            return EMA_Color_Crossover(Input, period1, period2);
        }

        /// <summary>
        /// NT 7 Version of MA crossover indicator. Changes color when fast MA crossing slow MA
        /// </summary>
        /// <returns></returns>
        public EMA_Color_Crossover EMA_Color_Crossover(Data.IDataSeries input, int period1, int period2)
        {
            if (cacheEMA_Color_Crossover != null)
                for (int idx = 0; idx < cacheEMA_Color_Crossover.Length; idx++)
                    if (cacheEMA_Color_Crossover[idx].Period1 == period1 && cacheEMA_Color_Crossover[idx].Period2 == period2 && cacheEMA_Color_Crossover[idx].EqualsInput(input))
                        return cacheEMA_Color_Crossover[idx];

            lock (checkEMA_Color_Crossover)
            {
                checkEMA_Color_Crossover.Period1 = period1;
                period1 = checkEMA_Color_Crossover.Period1;
                checkEMA_Color_Crossover.Period2 = period2;
                period2 = checkEMA_Color_Crossover.Period2;

                if (cacheEMA_Color_Crossover != null)
                    for (int idx = 0; idx < cacheEMA_Color_Crossover.Length; idx++)
                        if (cacheEMA_Color_Crossover[idx].Period1 == period1 && cacheEMA_Color_Crossover[idx].Period2 == period2 && cacheEMA_Color_Crossover[idx].EqualsInput(input))
                            return cacheEMA_Color_Crossover[idx];

                EMA_Color_Crossover indicator = new EMA_Color_Crossover();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period1 = period1;
                indicator.Period2 = period2;
                Indicators.Add(indicator);
                indicator.SetUp();

                EMA_Color_Crossover[] tmp = new EMA_Color_Crossover[cacheEMA_Color_Crossover == null ? 1 : cacheEMA_Color_Crossover.Length + 1];
                if (cacheEMA_Color_Crossover != null)
                    cacheEMA_Color_Crossover.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheEMA_Color_Crossover = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// NT 7 Version of MA crossover indicator. Changes color when fast MA crossing slow MA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Color_Crossover EMA_Color_Crossover(int period1, int period2)
        {
            return _indicator.EMA_Color_Crossover(Input, period1, period2);
        }

        /// <summary>
        /// NT 7 Version of MA crossover indicator. Changes color when fast MA crossing slow MA
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Color_Crossover EMA_Color_Crossover(Data.IDataSeries input, int period1, int period2)
        {
            return _indicator.EMA_Color_Crossover(input, period1, period2);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// NT 7 Version of MA crossover indicator. Changes color when fast MA crossing slow MA
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EMA_Color_Crossover EMA_Color_Crossover(int period1, int period2)
        {
            return _indicator.EMA_Color_Crossover(Input, period1, period2);
        }

        /// <summary>
        /// NT 7 Version of MA crossover indicator. Changes color when fast MA crossing slow MA
        /// </summary>
        /// <returns></returns>
        public Indicator.EMA_Color_Crossover EMA_Color_Crossover(Data.IDataSeries input, int period1, int period2)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.EMA_Color_Crossover(input, period1, period2);
        }
    }
}
#endregion
