#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

using MySql.Data.MySqlClient;
using System.Data;
using System.Globalization;


// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// COT Index for NT
    /// </summary>
    [Description("COT Index for NT")]
    public class MTDcot : Indicator
    {
        #region Variables
        // Wizard generated variables
		    private string dbname = @"COT"; // Database Name
		    private string dbhost = @"shadow.standart.arh.ru"; // Host Name
		    private string dbuser = @"test"; // DB Username
		    private string dbpass = @"test1234"; // DB Password
		
            private int cOTmode = 1; // Default setting for COTmode
			private bool extended_view = false;
			private bool percent_view = false;

			private bool bbands = false; // Draw Bollinger Bands
			private	double numStdDev	= 2.0;
			private int period		= 14;
		
		// User defined variables (add any user defined variables below)				
			private MySqlConnection myConnection = null;
			private MySqlCommand myCommand = null;
			private MySqlDataReader myReader;
		
			private string contract_code;			
			private string subQuery = "open_interest_all";

			private double[] week_value = new double[3];
			private DateTime[] week_date = new DateTime[3];
			private int ball = 0;
			private int ball_up=0;
			private int ball_down=0;
			private Color ball_up_color=Color.White;
			private Color ball_down_color=Color.White;			
			private string signal = "";
			private int direction_up=0;
			private int direction_down=0;
			private int direction = 2;
			private int last_direction = -2;
			private bool lastCOTup=false;
			private bool lastCOTdown=false;		

			private DateTime rep_date;
			private DateTime week_begin, week_end; 
			private	DateTime cot_week = new DateTime(2099, 1, 1, 0, 0, 0);
			private int last_week=0;



		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(new Pen(Color.Green, 2), PlotStyle.Bar, "COTpercent"));			
			Add(new Plot(Color.FromKnownColor(KnownColor.Blue), PlotStyle.Line, "COT"));
			
			Add(new Plot(Color.FromKnownColor(KnownColor.Purple), PlotStyle.Line, "Upper band"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Red), PlotStyle.Line, "Middle band"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Purple), PlotStyle.Line, "Lower band"));
			
			Add(new Plot(Color.FromKnownColor(KnownColor.Black), PlotStyle.Dot, "COTdown"));
			Add(new Plot(Color.FromKnownColor(KnownColor.Black), PlotStyle.Dot, "COTup"));
            
			CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= false;
			
		    string myConnectionString = "Database="+dbname+";Data Source="+dbhost+";User Id="+dbuser+";Password="+dbpass;
		    myConnection = new MySqlConnection(myConnectionString);
		    myConnection.Open();
			
			string myQuery = "SELECT contract_code FROM cot_datafeed WHERE datafeed_code = '"+Instrument.MasterInstrument.Name +"'";

			myCommand = new MySqlCommand(myQuery);
			myCommand.Connection = myConnection; 
							
			myReader = myCommand.ExecuteReader();
			if (myReader.Read())
			{
				contract_code = myReader.GetString(0);
			}
			myReader.Close();
			
			switch(cOTmode)
			{
				case 1: subQuery = "comm_long_all-comm_short_all";
						ball_up=-1;
						ball_down=1;
						ball_up_color=Color.Pink;
						ball_down_color=Color.LightGreen;
						direction_up=-1;
						direction_down=1;					
					break;
				case 2: subQuery = "comm_long_all";
						ball_up=-1;
						ball_down=1;
						ball_up_color=Color.Pink;
						ball_down_color=Color.LightGreen;
						direction_up=-1;
						direction_down=1;					
					break;
				case 3: subQuery = "comm_short_all";
						ball_up=1;
						ball_down=-1;
						ball_up_color=Color.LightGreen;
						ball_down_color=Color.Pink;
						direction_up=1;
						direction_down=-1;					
					break;
				case 4: subQuery = "comm_long_all/open_interest_all";
						ball_up=-1;
						ball_down=1;
						ball_up_color=Color.Pink;
						ball_down_color=Color.LightGreen;
						direction_up=-1;
						direction_down=1;					
					break;
				case 5: subQuery = "comm_short_all/open_interest_all";
						ball_up=1;
						ball_down=-1;
						ball_up_color=Color.LightGreen;
						ball_down_color=Color.Pink;
						direction_up=1;
						direction_down=-1;
					break;
				case 6: subQuery = "large_long_all/open_interest_all";
						ball_up=1;
						ball_down=-1;
						ball_up_color=Color.LightGreen;
						ball_down_color=Color.Pink;
						direction_up=1;
						direction_down=-1;
					break;
				case 7: subQuery = "large_short_all/open_interest_all";
						ball_up=-1;
						ball_down=1;
						ball_up_color=Color.Pink;
						ball_down_color=Color.LightGreen;
						direction_up=-1;
						direction_down=1;					
						break;
			}
		}

		public override void Dispose()
        {
            base.Dispose(); 
			
            // close the db connection at the end
            if (myConnection != null)
			{
                myConnection.Close();
                myConnection = null;
            }			
        }
        
	    protected static int GetWeekNumber(DateTime dtPassed)
    	{
            CultureInfo ciCurr = CultureInfo.CurrentCulture;
            int weekNum = ciCurr.Calendar.GetWeekOfYear(dtPassed, CalendarWeekRule.FirstFourDayWeek, DayOfWeek.Monday);
            return weekNum;
      	}
		
		protected void NegativeDraw()
		{
			// BALLS 
			if (week_value[1]<week_value[0]) 
			{
				if (!percent_view) BackColor = ball_down_color; 
				ball = ball_down;
			}
			else if (week_value[1]>week_value[0]) 
			{
				if (!percent_view) BackColor = ball_up_color;
				ball = ball_up;
			}			
			
			// DIRECTION
			if (week_value[0]>week_value[1] && week_value[1]>week_value[2])
			{
				direction = direction_down;	
			} else if (week_value[0]<week_value[1] && week_value[1]<week_value[2])
			{
				direction = direction_up; 
			}
			else direction = 0;
			
			
			// SIGNAL
			if (week_value[0]<week_value[2] && week_date[0] == cot_week.Date) // last_direction!=direction_up && week_date[0] == cot_week.Date )
			{
				if (!lastCOTup && ball==ball_up)
				{
					lastCOTup = true;
					lastCOTdown = false;
					if (!percent_view) COTup.Set(COT[0]);				
				}
			}
			
			if (week_value[0]>week_value[2] && week_date[0] == cot_week.Date) // last_direction!=direction_down && week_date[0] == cot_week.Date)
			{
				if (!lastCOTdown && ball==ball_down)
				{
					lastCOTdown = true;
					lastCOTup=false;
					if (!percent_view) COTdown.Set(COT[0]);				
				}
			}
			
			if (direction==direction_up && last_direction!=direction)
			{
				if (!percent_view) BackColor = Color.LimeGreen;
				last_direction=direction_up;				
			}
			else if (direction==direction_down && last_direction!=direction)
			{
				if (!percent_view) BackColor = Color.Red;				
				last_direction=direction_down;
			}			
		}
		
		protected void PositiveDraw()
		{
			// BALLS 
			if (week_value[0]<week_value[1]) 
			{
				if (!percent_view) BackColor = ball_down_color; 
				ball = ball_down;
			}
			else if (week_value[0]>week_value[1]) 
			{
				if (!percent_view) BackColor = ball_up_color;
				ball = ball_up;
			}
			//Print("ball = "+Convert.ToString(ball));
			
			
			// DIRECTION
			if (week_value[0]<week_value[1] && week_value[1]<week_value[2])
			{
				direction = direction_down;	// графиr идет вниз				
			} else if (week_value[0]>week_value[1] && week_value[1]>week_value[2])
			{
				direction = direction_up; // график идет вверх
			}
			else direction = 0;
			
			
			// SIGNAL
			if (week_value[0]>week_value[2] && week_date[0] == cot_week.Date) // last_direction!=direction_up && week_date[0] == cot_week.Date )
			{
				if (!lastCOTup && ball==ball_up)
				{
					lastCOTup = true;
					lastCOTdown = false;
					if (!percent_view) COTup.Set(COT[0]);				
				}
			}
			
			if (week_value[0]<week_value[2] && week_date[0] == cot_week.Date) // last_direction!=direction_down && week_date[0] == cot_week.Date)
			{
				if (!lastCOTdown && ball==ball_down)
				{
					lastCOTdown = true;
					lastCOTup=false;
					if (!percent_view) COTdown.Set(COT[0]);				
				}
			}
			
			if (direction==direction_up && last_direction!=direction)
			{
				if (!percent_view) BackColor = Color.LimeGreen;
				last_direction=direction_up;				
			}
			else if (direction==direction_down && last_direction!=direction)
			{
				if (!percent_view) BackColor = Color.Red;				
				last_direction=direction_down;
			}
		}

		/// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {	
			string myQuery;			
			MySqlDataReader myReader;
			
			Print("====================================================");
			Print("Week of year is "+Convert.ToString(GetWeekNumber(Time[0]))+"/"+Convert.ToString(Time[0].Year));
			
			
			if (last_week != GetWeekNumber(Time[0])) // begin new week
			{
				last_week = GetWeekNumber(Time[0]);
				cot_week = Time[0].AddYears(1);
				week_begin = Time[0].Date;
				week_end = Time[0].AddDays(6);
				
				Print("====================================================");
				Print("week_begin is " + Convert.ToString(week_begin));
				Print("week_end is " + Convert.ToString(week_end));
				
				myQuery = "SELECT report_date FROM cot_report WHERE contract_code = '"+contract_code+"' AND report_date > '"+week_end.ToString("yyyy-MM-dd")+"' order by report_date ASC LIMIT 1";
				Print(myQuery);
				myCommand = new MySqlCommand(myQuery);
				myCommand.Connection = myConnection; 
				
				myReader = myCommand.ExecuteReader();

				if (myReader.Read())
				{
					cot_week = Convert.ToDateTime(myReader.GetString(0));
					Print("GetStrin0 is " + myReader.GetString(0));
				}
				
				myReader.Close();
				Print("cot_week is " + Convert.ToString(cot_week));
			
				myQuery = "SELECT "+subQuery+", report_date FROM cot_report WHERE contract_code = '"+contract_code+"' AND report_date <= '" +
					cot_week.ToString("yyyy-MM-dd")+"' ORDER BY report_date DESC LIMIT 4";				
			
				myCommand = new MySqlCommand(myQuery);
				myCommand.Connection = myConnection; 
							
				myReader = myCommand.ExecuteReader();
						
				for (int i=0; i<3; i++)
				{
					if (i==0)
					{
						if (myReader.Read())
						{
							Print("Query result is = "+myReader.GetString(0)+"on date - "+Time[0].ToString("yyyy-MM-dd"));					
							week_value[i] = Convert.ToDouble(myReader.GetString(0));
							Print("week_value[0] "+Convert.ToString(i)+" is "+Convert.ToString(week_value[i]));
							week_date[i] = Convert.ToDateTime(myReader.GetString(1));
							Print("week_date[0] "+Convert.ToString(i)+" is "+Convert.ToString(week_date[i]));
						}
					}
					else
					{
						if (myReader.Read())
						{
							week_value[i] = Convert.ToDouble(myReader.GetString(0));
							week_date[i] = Convert.ToDateTime(myReader.GetString(1));
						}
					}
				}
				myReader.Close();
			}
			
			// Usual View
			if (!percent_view) COT.Set(Convert.ToDouble(week_value[0]));
			
			// Percent View (histogramm)
			if (percent_view) 
				if (CurrentBar == 0) COTpercent.Set(0);
			else
			{
				if (week_value[0] > week_value[1])
					COTpercent.Set((week_value[0]/week_value[1]*100));
				else if (week_value[0] < week_value[1])
					COTpercent.Set(-(week_value[0]/week_value[1]*100));
			}

			// Extended View
			if (extended_view)
			{
				if (cOTmode==1 || cOTmode==2 || cOTmode==4 || cOTmode==7)
				{
					NegativeDraw();
				}
				else if (cOTmode==3 || cOTmode==5 || cOTmode==6)
				{
					PositiveDraw();
				}
			}
			
			if (bbands)
			{
				Upper.Set(SMA(COT,B_Period)[0] + B_NumStdDev * StdDev(COT,B_Period)[0]);
				Middle.Set(SMA(COT,B_Period)[0]);
				Lower.Set(SMA(COT,B_Period)[0] - B_NumStdDev * StdDev(COT,B_Period)[0]);
			}
		}

		public override string ToString()
		{
			/* We return a label consisting of only the parameters we want to include. If we did not
			override this method we would have a label with all four parameters. In this example we will
			be left with only the parameters "Period" and "Interval". */
			
			switch(cOTmode)
			{
				case 1: return Name + " ( NetPosition )";
				case 2: return Name + " ( Comm-Long (All)";
				case 3: return Name + " ( Comm-Short (All)";
				case 4: return Name + " ( Comm-Long (All)/Open-Interest )";
				case 5: return Name + " ( Comm-Short (All)/Open-Interest )";
				case 6: return Name + " ( Large-Long (All)/Open-Interest )";
				case 7: return Name + " ( Large-Short(All)/Open-Interest )";
			}
			return Name;
		}

        #region Properties
        
		
		
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries COTpercent
		{
			get { return Values[0]; }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove        		
		public DataSeries COT
        {
            get { return Values[1]; }
        }

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Upper
		{
			get { return Values[2]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Middle
		{
			get { return Values[3]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Lower
		{
			get { return Values[4]; }
		}
		
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries COTdown
		{
			get { return Values[5]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries COTup
		{
			get { return Values[6]; }
		}

		[Description("Database Name")]
        [Category("Parameters")]
		public string A_Database
        {
            get { return dbname; }
            set { dbname = value; }
        }

        [Description("Host Name")]
        [Category("Parameters")]
		public string A_Hostname
        {
            get { return dbhost; }
            set { dbhost = value; }
        }

        [Description("DB Username")]
        [Category("Parameters")]
		public string A_Username
        {
            get { return dbuser; }
            set { dbuser = value; }
        }

		[Description("DB Password")]
        [Category("Parameters")]
		public string A_Password
        {
            get { return dbpass; }
            set { dbpass = value; }
        }

		[Description("Indicator's Mode ")]
        [Category("Parameters")]        
		public int C_COTmode
        {
            get { return cOTmode; }
            set { cOTmode = Math.Max(1, value); }
        }

		[Description("COT Extended view")]
        [Category("Parameters")]        
		public bool C_ExtededView
        {
            get { return extended_view; }
            set { extended_view = value; }
        }
		
		[Description("COT Percent view")]
        [Category("Parameters")]        
		public bool C_PercentView
        {
            get { return percent_view; }
            set { percent_view = value; }
        }


		[Description("Draw Bollinger Bands ")]
        [Category("Parameters")]        
		public bool B_BollingerBands
        {
            get { return bbands; }
            set { bbands = value; }
        }

		[Description("Number of standard deviations")]
		[Category("Parameters")]
		public double B_NumStdDev
		{
			get { return numStdDev; }
			set { numStdDev = Math.Max(0, value); }
		}

		[Description("Numbers of bars used for calculations")]
		[Category("Parameters")]
		public int B_Period
		{
			get { return period; }
			set { period = Math.Max(1, value); }
		}


		#endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private MTDcot[] cacheMTDcot = null;

        private static MTDcot checkMTDcot = new MTDcot();

        /// <summary>
        /// COT Index for NT
        /// </summary>
        /// <returns></returns>
        public MTDcot MTDcot(string a_Database, string a_Hostname, string a_Password, string a_Username, bool b_BollingerBands, double b_NumStdDev, int b_Period, int c_COTmode, bool c_ExtededView, bool c_PercentView)
        {
            return MTDcot(Input, a_Database, a_Hostname, a_Password, a_Username, b_BollingerBands, b_NumStdDev, b_Period, c_COTmode, c_ExtededView, c_PercentView);
        }

        /// <summary>
        /// COT Index for NT
        /// </summary>
        /// <returns></returns>
        public MTDcot MTDcot(Data.IDataSeries input, string a_Database, string a_Hostname, string a_Password, string a_Username, bool b_BollingerBands, double b_NumStdDev, int b_Period, int c_COTmode, bool c_ExtededView, bool c_PercentView)
        {
            checkMTDcot.A_Database = a_Database;
            a_Database = checkMTDcot.A_Database;
            checkMTDcot.A_Hostname = a_Hostname;
            a_Hostname = checkMTDcot.A_Hostname;
            checkMTDcot.A_Password = a_Password;
            a_Password = checkMTDcot.A_Password;
            checkMTDcot.A_Username = a_Username;
            a_Username = checkMTDcot.A_Username;
            checkMTDcot.B_BollingerBands = b_BollingerBands;
            b_BollingerBands = checkMTDcot.B_BollingerBands;
            checkMTDcot.B_NumStdDev = b_NumStdDev;
            b_NumStdDev = checkMTDcot.B_NumStdDev;
            checkMTDcot.B_Period = b_Period;
            b_Period = checkMTDcot.B_Period;
            checkMTDcot.C_COTmode = c_COTmode;
            c_COTmode = checkMTDcot.C_COTmode;
            checkMTDcot.C_ExtededView = c_ExtededView;
            c_ExtededView = checkMTDcot.C_ExtededView;
            checkMTDcot.C_PercentView = c_PercentView;
            c_PercentView = checkMTDcot.C_PercentView;

            if (cacheMTDcot != null)
                for (int idx = 0; idx < cacheMTDcot.Length; idx++)
                    if (cacheMTDcot[idx].A_Database == a_Database && cacheMTDcot[idx].A_Hostname == a_Hostname && cacheMTDcot[idx].A_Password == a_Password && cacheMTDcot[idx].A_Username == a_Username && cacheMTDcot[idx].B_BollingerBands == b_BollingerBands && Math.Abs(cacheMTDcot[idx].B_NumStdDev - b_NumStdDev) <= double.Epsilon && cacheMTDcot[idx].B_Period == b_Period && cacheMTDcot[idx].C_COTmode == c_COTmode && cacheMTDcot[idx].C_ExtededView == c_ExtededView && cacheMTDcot[idx].C_PercentView == c_PercentView && cacheMTDcot[idx].EqualsInput(input))
                        return cacheMTDcot[idx];

            MTDcot indicator = new MTDcot();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.A_Database = a_Database;
            indicator.A_Hostname = a_Hostname;
            indicator.A_Password = a_Password;
            indicator.A_Username = a_Username;
            indicator.B_BollingerBands = b_BollingerBands;
            indicator.B_NumStdDev = b_NumStdDev;
            indicator.B_Period = b_Period;
            indicator.C_COTmode = c_COTmode;
            indicator.C_ExtededView = c_ExtededView;
            indicator.C_PercentView = c_PercentView;
            indicator.SetUp();

            MTDcot[] tmp = new MTDcot[cacheMTDcot == null ? 1 : cacheMTDcot.Length + 1];
            if (cacheMTDcot != null)
                cacheMTDcot.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheMTDcot = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// COT Index for NT
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MTDcot MTDcot(string a_Database, string a_Hostname, string a_Password, string a_Username, bool b_BollingerBands, double b_NumStdDev, int b_Period, int c_COTmode, bool c_ExtededView, bool c_PercentView)
        {
            return _indicator.MTDcot(Input, a_Database, a_Hostname, a_Password, a_Username, b_BollingerBands, b_NumStdDev, b_Period, c_COTmode, c_ExtededView, c_PercentView);
        }

        /// <summary>
        /// COT Index for NT
        /// </summary>
        /// <returns></returns>
        public Indicator.MTDcot MTDcot(Data.IDataSeries input, string a_Database, string a_Hostname, string a_Password, string a_Username, bool b_BollingerBands, double b_NumStdDev, int b_Period, int c_COTmode, bool c_ExtededView, bool c_PercentView)
        {
            return _indicator.MTDcot(input, a_Database, a_Hostname, a_Password, a_Username, b_BollingerBands, b_NumStdDev, b_Period, c_COTmode, c_ExtededView, c_PercentView);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// COT Index for NT
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.MTDcot MTDcot(string a_Database, string a_Hostname, string a_Password, string a_Username, bool b_BollingerBands, double b_NumStdDev, int b_Period, int c_COTmode, bool c_ExtededView, bool c_PercentView)
        {
            return _indicator.MTDcot(Input, a_Database, a_Hostname, a_Password, a_Username, b_BollingerBands, b_NumStdDev, b_Period, c_COTmode, c_ExtededView, c_PercentView);
        }

        /// <summary>
        /// COT Index for NT
        /// </summary>
        /// <returns></returns>
        public Indicator.MTDcot MTDcot(Data.IDataSeries input, string a_Database, string a_Hostname, string a_Password, string a_Username, bool b_BollingerBands, double b_NumStdDev, int b_Period, int c_COTmode, bool c_ExtededView, bool c_PercentView)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.MTDcot(input, a_Database, a_Hostname, a_Password, a_Username, b_BollingerBands, b_NumStdDev, b_Period, c_COTmode, c_ExtededView, c_PercentView);
        }

    }
}
#endregion
