//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private IntradayVP[] cacheIntradayVP = null;

        private static IntradayVP checkIntradayVP = new IntradayVP();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public IntradayVP IntradayVP(double base_v, Color clr_max_ray, Color clr_va_ray, Color clr_zone, Color g_base_volume, Color max_volume, Method04021979intra met, double mult, Color neg_delta, Color outline, bool overlay_draw, Color poz_delta, Color s_base_volume, bool show_max_ray, bool show_va_ray)
        {
            return IntradayVP(Input, base_v, clr_max_ray, clr_va_ray, clr_zone, g_base_volume, max_volume, met, mult, neg_delta, outline, overlay_draw, poz_delta, s_base_volume, show_max_ray, show_va_ray);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public IntradayVP IntradayVP(Data.IDataSeries input, double base_v, Color clr_max_ray, Color clr_va_ray, Color clr_zone, Color g_base_volume, Color max_volume, Method04021979intra met, double mult, Color neg_delta, Color outline, bool overlay_draw, Color poz_delta, Color s_base_volume, bool show_max_ray, bool show_va_ray)
        {
            if (cacheIntradayVP != null)
                for (int idx = 0; idx < cacheIntradayVP.Length; idx++)
                    if (Math.Abs(cacheIntradayVP[idx].Base_v - base_v) <= double.Epsilon && cacheIntradayVP[idx].Clr_max_ray == clr_max_ray && cacheIntradayVP[idx].Clr_va_ray == clr_va_ray && cacheIntradayVP[idx].Clr_zone == clr_zone && cacheIntradayVP[idx].G_base_volume == g_base_volume && cacheIntradayVP[idx].Max_volume == max_volume && cacheIntradayVP[idx].Met == met && Math.Abs(cacheIntradayVP[idx].Mult - mult) <= double.Epsilon && cacheIntradayVP[idx].Neg_delta == neg_delta && cacheIntradayVP[idx].Outline == outline && cacheIntradayVP[idx].Overlay_draw == overlay_draw && cacheIntradayVP[idx].Poz_delta == poz_delta && cacheIntradayVP[idx].S_base_volume == s_base_volume && cacheIntradayVP[idx].Show_max_ray == show_max_ray && cacheIntradayVP[idx].Show_va_ray == show_va_ray && cacheIntradayVP[idx].EqualsInput(input))
                        return cacheIntradayVP[idx];

            lock (checkIntradayVP)
            {
                checkIntradayVP.Base_v = base_v;
                base_v = checkIntradayVP.Base_v;
                checkIntradayVP.Clr_max_ray = clr_max_ray;
                clr_max_ray = checkIntradayVP.Clr_max_ray;
                checkIntradayVP.Clr_va_ray = clr_va_ray;
                clr_va_ray = checkIntradayVP.Clr_va_ray;
                checkIntradayVP.Clr_zone = clr_zone;
                clr_zone = checkIntradayVP.Clr_zone;
                checkIntradayVP.G_base_volume = g_base_volume;
                g_base_volume = checkIntradayVP.G_base_volume;
                checkIntradayVP.Max_volume = max_volume;
                max_volume = checkIntradayVP.Max_volume;
                checkIntradayVP.Met = met;
                met = checkIntradayVP.Met;
                checkIntradayVP.Mult = mult;
                mult = checkIntradayVP.Mult;
                checkIntradayVP.Neg_delta = neg_delta;
                neg_delta = checkIntradayVP.Neg_delta;
                checkIntradayVP.Outline = outline;
                outline = checkIntradayVP.Outline;
                checkIntradayVP.Overlay_draw = overlay_draw;
                overlay_draw = checkIntradayVP.Overlay_draw;
                checkIntradayVP.Poz_delta = poz_delta;
                poz_delta = checkIntradayVP.Poz_delta;
                checkIntradayVP.S_base_volume = s_base_volume;
                s_base_volume = checkIntradayVP.S_base_volume;
                checkIntradayVP.Show_max_ray = show_max_ray;
                show_max_ray = checkIntradayVP.Show_max_ray;
                checkIntradayVP.Show_va_ray = show_va_ray;
                show_va_ray = checkIntradayVP.Show_va_ray;

                if (cacheIntradayVP != null)
                    for (int idx = 0; idx < cacheIntradayVP.Length; idx++)
                        if (Math.Abs(cacheIntradayVP[idx].Base_v - base_v) <= double.Epsilon && cacheIntradayVP[idx].Clr_max_ray == clr_max_ray && cacheIntradayVP[idx].Clr_va_ray == clr_va_ray && cacheIntradayVP[idx].Clr_zone == clr_zone && cacheIntradayVP[idx].G_base_volume == g_base_volume && cacheIntradayVP[idx].Max_volume == max_volume && cacheIntradayVP[idx].Met == met && Math.Abs(cacheIntradayVP[idx].Mult - mult) <= double.Epsilon && cacheIntradayVP[idx].Neg_delta == neg_delta && cacheIntradayVP[idx].Outline == outline && cacheIntradayVP[idx].Overlay_draw == overlay_draw && cacheIntradayVP[idx].Poz_delta == poz_delta && cacheIntradayVP[idx].S_base_volume == s_base_volume && cacheIntradayVP[idx].Show_max_ray == show_max_ray && cacheIntradayVP[idx].Show_va_ray == show_va_ray && cacheIntradayVP[idx].EqualsInput(input))
                            return cacheIntradayVP[idx];

                IntradayVP indicator = new IntradayVP();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Base_v = base_v;
                indicator.Clr_max_ray = clr_max_ray;
                indicator.Clr_va_ray = clr_va_ray;
                indicator.Clr_zone = clr_zone;
                indicator.G_base_volume = g_base_volume;
                indicator.Max_volume = max_volume;
                indicator.Met = met;
                indicator.Mult = mult;
                indicator.Neg_delta = neg_delta;
                indicator.Outline = outline;
                indicator.Overlay_draw = overlay_draw;
                indicator.Poz_delta = poz_delta;
                indicator.S_base_volume = s_base_volume;
                indicator.Show_max_ray = show_max_ray;
                indicator.Show_va_ray = show_va_ray;
                Indicators.Add(indicator);
                indicator.SetUp();

                IntradayVP[] tmp = new IntradayVP[cacheIntradayVP == null ? 1 : cacheIntradayVP.Length + 1];
                if (cacheIntradayVP != null)
                    cacheIntradayVP.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheIntradayVP = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.IntradayVP IntradayVP(double base_v, Color clr_max_ray, Color clr_va_ray, Color clr_zone, Color g_base_volume, Color max_volume, Method04021979intra met, double mult, Color neg_delta, Color outline, bool overlay_draw, Color poz_delta, Color s_base_volume, bool show_max_ray, bool show_va_ray)
        {
            return _indicator.IntradayVP(Input, base_v, clr_max_ray, clr_va_ray, clr_zone, g_base_volume, max_volume, met, mult, neg_delta, outline, overlay_draw, poz_delta, s_base_volume, show_max_ray, show_va_ray);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.IntradayVP IntradayVP(Data.IDataSeries input, double base_v, Color clr_max_ray, Color clr_va_ray, Color clr_zone, Color g_base_volume, Color max_volume, Method04021979intra met, double mult, Color neg_delta, Color outline, bool overlay_draw, Color poz_delta, Color s_base_volume, bool show_max_ray, bool show_va_ray)
        {
            return _indicator.IntradayVP(input, base_v, clr_max_ray, clr_va_ray, clr_zone, g_base_volume, max_volume, met, mult, neg_delta, outline, overlay_draw, poz_delta, s_base_volume, show_max_ray, show_va_ray);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.IntradayVP IntradayVP(double base_v, Color clr_max_ray, Color clr_va_ray, Color clr_zone, Color g_base_volume, Color max_volume, Method04021979intra met, double mult, Color neg_delta, Color outline, bool overlay_draw, Color poz_delta, Color s_base_volume, bool show_max_ray, bool show_va_ray)
        {
            return _indicator.IntradayVP(Input, base_v, clr_max_ray, clr_va_ray, clr_zone, g_base_volume, max_volume, met, mult, neg_delta, outline, overlay_draw, poz_delta, s_base_volume, show_max_ray, show_va_ray);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.IntradayVP IntradayVP(Data.IDataSeries input, double base_v, Color clr_max_ray, Color clr_va_ray, Color clr_zone, Color g_base_volume, Color max_volume, Method04021979intra met, double mult, Color neg_delta, Color outline, bool overlay_draw, Color poz_delta, Color s_base_volume, bool show_max_ray, bool show_va_ray)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.IntradayVP(input, base_v, clr_max_ray, clr_va_ray, clr_zone, g_base_volume, max_volume, met, mult, neg_delta, outline, overlay_draw, poz_delta, s_base_volume, show_max_ray, show_va_ray);
        }
    }
}
#endregion
