#region Using declarations
using System;
using System.ComponentModel;
using System.Collections.Generic;
#endregion

// This namespace holds all bars types. Do not change it.
namespace NinjaTrader.Data
{

	public class f02BarsType : BarsType
	{
		private static bool registered = Register(new f02BarsType());
		
		private double currentPrice = 0, ticksPerPriceChange = 0;
		private List<int> ticks = new List<int>();
		
		public override void Add(Bars bars, double open, double high, double low, double close, DateTime time, long volume, bool isRealtime)
		{
			
			if (currentPrice != close) {
				int moveLevels = (int)Math.Round(Math.Abs(close - currentPrice) / bars.Instrument.MasterInstrument.TickSize);
				for (int i = 0; i < moveLevels; i++)
					ticks.Add(0);
				if (ticks.Count > bars.Period.Value)
					ticks.RemoveRange(0, ticks.Count - bars.Period.Value);
				currentPrice = close;
			}

			if (ticks.Count > 0) {
				ticks[ticks.Count - 1]++;
				if (ticksPerPriceChange == 0) {
					double sum = 0;
					for (int i = 0; i < ticks.Count; i++)
						sum += ticks[i];
					ticksPerPriceChange = sum / ticks.Count;
				}
			}
			
			if (bars.Count == 0 || bars.IsNewSession(time, isRealtime))
				AddBar(bars, open, high, low, close, time, volume, isRealtime);
			else {
				if (bars.TickCount < Math.Round(ticksPerPriceChange))
					UpdateBar(bars, open, high, low, close, time, volume, isRealtime);
				else {
					ticksPerPriceChange = 0;
					AddBar(bars, open, high, low, close, time, volume, isRealtime);
				}
			}
			
		}

		public override void ApplyDefaults(Gui.Chart.BarsData barsData)
		{
			barsData.DaysBack		= 3;
			barsData.Period.Value	= 50;
		}


		public override PeriodType BuiltFrom
		{
			get { return PeriodType.Tick; }
		}

		public override string ChartDataBoxDate(DateTime time)
		{
			return time.ToString(Cbi.Globals.CurrentCulture.DateTimeFormat.ShortDatePattern);
		}

		public override string ChartLabel(Gui.Chart.ChartControl chartControl, DateTime time)
		{
			return time.ToString(chartControl.LabelFormatTick, Cbi.Globals.CurrentCulture);
		}

		public override Gui.Chart.ChartStyleType[] ChartStyleTypesSupported
		{
			get { return new[] { Gui.Chart.ChartStyleType.Box, Gui.Chart.ChartStyleType.CandleStick, Gui.Chart.ChartStyleType.HiLoBars, Gui.Chart.ChartStyleType.LineOnClose, 
				Gui.Chart.ChartStyleType.OHLC, Gui.Chart.ChartStyleType.Custom0, Gui.Chart.ChartStyleType.Custom1, Gui.Chart.ChartStyleType.Custom2, Gui.Chart.ChartStyleType.Custom3,
				Gui.Chart.ChartStyleType.Custom4, Gui.Chart.ChartStyleType.Custom5, Gui.Chart.ChartStyleType.Custom6, Gui.Chart.ChartStyleType.Custom7, Gui.Chart.ChartStyleType.Custom8,
				Gui.Chart.ChartStyleType.Custom9, Gui.Chart.ChartStyleType.Final0, Gui.Chart.ChartStyleType.Final1, Gui.Chart.ChartStyleType.Final2, Gui.Chart.ChartStyleType.Final3,
				Gui.Chart.ChartStyleType.Final4 }; }
		}

		public override object Clone()
		{
			return new f02BarsType();
		}

		public override int DefaultValue
		{ 
			get { return 50; }
		}

		public override string DisplayName
		{
			get { return "f02"; }
		}

		public override int GetInitialLookBackDays(Period period, int barsBack)
		{ 
			return 1;
		}	
			
		public override double GetPercentComplete(Bars bars, DateTime now)
		{
			throw new ApplicationException("GetPercentComplete not supported in " + DisplayName);
		}

		public override PropertyDescriptorCollection GetProperties(PropertyDescriptor propertyDescriptor, Period period, Attribute[] attributes)
		{
			PropertyDescriptorCollection properties = base.GetProperties(propertyDescriptor, period, attributes);

			// here is how you remove properties not needed for that particular bars type
			properties.Remove(properties.Find("BasePeriodType", true));
			properties.Remove(properties.Find("BasePeriodValue", true));
			properties.Remove(properties.Find("PointAndFigurePriceType", true));
			properties.Remove(properties.Find("ReversalType", true));
			properties.Remove(properties.Find("Value2", true));

			// here is how you change the display name of the property on the properties grid
			Gui.Design.DisplayNameAttribute.SetDisplayName(properties, "Value", "Price changes");

			return properties;
		}

		public override bool IsIntraday
		{
			get { return true; }
		}

		public f02BarsType() : base(PeriodType.Custom1)
		{
		}

		public override string ToString(Period period)
		{
			return string.Format("{0} f02{1}", period.Value, (period.MarketDataType != MarketDataType.Last ? " - " + period.MarketDataType : string.Empty));
		}
	}
	
}