
// Derived rom jtRealstats v1.5 by John Thom 
// credits to the NinjaTrader team member who posted the MarketDepth routine below.
//
//======================================================================================================================
// this version has been updated for Ninjatrader 7 by ZONDOR®
// JT and RJay did all the hard stuff, I merely got it to work in NT7. Thanks, guys.
// As of 21:JAN:2010 Log of ZONDOR® changes to date
// 2011 alert changes added by LostTrader
///======================================================================================================================
    //      Some datatypes from the OnMarketDepth method were changed from double to int in NT7.
	//      To fix they are locally cast as integers by preceding them with (int), allowing the indicator
	///     to compile in NT7. 
	/// ------------------------------------------------------------------------------------------------
	/// 	To improve efficiency, most of the variables that had been ad hoc locally declared are
	///     now declared in the variables region.
	/// ---------------------------------------------------------------------------------------------------
	///     Indicator would not run at all in NT7, so added  try catch error trapping to diagnose and handle
    ////    runtime errors. Do not remove the error trapping. It uses minimal resources. 
	/// 	Under certain conditions during initiation of Market Replay runtime errors still happen but the
	///     error trapping prevents crashing. For now the diagnostic Print statements have been left in the error traps.
	/// 	The error trapping was discussed with (NinjaTrader) Bertrand W., who approves.
	/// -------------------------------------------------------------------------------------------------------------
	/// 	Added code to create empty bidRows and askRows in lists of DOM rows. There were runtime errors when
	///     the indicator was trying to work with rows that did not already exist. Apparently
	///     the rows would have been created implicitly in NT6.5, but this does not work in NT7.
	///     The number of rows in the lists must be capped. If the rowcount inflates it will eventually
	///     reach the maximum allowable number of rows for a list object, and indicator wil hard freeze.
	///     For now there is still a diagnostic Print statement that reports the rowcount to the Output Window.
	///     The rowcount should hold at around 22.
	/// --------------------------------------------------------------------------------------------------------------
	///     The index of the iterator that reads data from the DOM list rows had a max vslue of < 5, so
	///  	only five of the zero-based bid and five of the ask rows were showing. Changed it to 10. Now, all 10 rows
	///     of both the bid book and the offer book are displayed.
	/// --------------------------------------------------------------------------------------------------------------
	//      Moved the creation of the listrows to Plot() to get rid of last remaining runtime errors, because the
	///     rows were being accessed in the Plot method before having been created by the OnMarketDepth method.
	/// --------------------------------------------------------------------------------------------------------------
	//      Changed list of current bar statistics to save space, fourth row clarifed INSIDE Asks and Bids, 
	///     Added new row of Total Asks, Total Bids, and ratio of TA/TB
	/// ---------------------------------------------------------------------------------------------------------------
	/// 01/18 removed the casting of e.price as an integer in OnMarketDepth which was not necessary and a mistake.
	/// 01/18 added user parameter HistogramWidthFactor and eliminated logic that was trying to keep the bars from
	/// 	being wider than the window, which did not work anyway.
	/// 01/18 added Level II user parameter to limit the number of rows displayed and calculated.
	/// 01/19 width of histogram bars now autoscales correctly with changes in width of chart window.
	/// 01/21 corrected autoacaling problems on right side of y axis. However still does not work right for 6E E-mini.
	/// 03/01 removed list row creation from Plot method, cleaned up OnMarketDepth code.
	/// ---------------------------------------------------------------------------------------------------------------
	/// 2011/07/05  inserted DOM Alerts (and renamed from jtRealStat7v301/JT_Realstats_RJ7v301)
	/// 2011/07/11  placed triangles & text relative to measured font size
	/// ===================THIS SHOULD STILL BE CONSIDERED A BETA VERSION!!!!!!!!!!!!==================================
	/// Remaining Agenda: Display lags too much during slow to medium paced markets. Need a more sophisticated 
	/// way to control the refresh rate. If the market is not too fast, we can
	/// refresh the Plot method every time there ia a MarketDepth event.
	/// ================================================================================================================
#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.Design;
using System.Collections.Generic;


#endregion

// This namespace holds all indicators and is required. Do not change it unless you are looking for trouble.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("jtRealtime Stats version 1.5 (aka 7.301) for NT7 with Alerts")]
    public class DOMAlert : Indicator
    {
		#region Internal Variables
		// user settings
		private int x1;  // changed from locally declared
		private int x2;
		int X3;
		private int idx;  // changed from locally declared
		private int idx1;
		private int idx2;
		private int idx3;
		private int idx4;
		
		private SolidBrush higherVolBrush;
		private SolidBrush lowerVolBrush;
		private SolidBrush sameVolBrush;
		private Pen outlinePen;
		private Brush textBrush;
		private SolidBrush levelIILevel1Brush;
		private SolidBrush levelIILevel2Brush;
		private SolidBrush levelIILevel3Brush;
		private SolidBrush levelIILevel4Brush;
		private SolidBrush levelIILevel5Brush;
		private SolidBrush levelIILevel6Brush;
		private SolidBrush levelIILevel7Brush;
		private SolidBrush levelIILevel8Brush;
		private SolidBrush levelIILevel9Brush;
		private SolidBrush levelIILevel10Brush;
		private SolidBrush askBrush;
		private SolidBrush bidBrush;
		private Pen priceLinePen;

		
		private int SumOfAllAsks;
		private int SumOfAllBids;	
		private int askTotY;
		private int bidTotY;
		private int lineStrength;
		private StringFormat stringFormat;
		private StringFormat stringCFormat;
		private Font stringFont;
		private Font stringBFont;
		private int tickVolHigherThanClose;
		private int tickVolLowerThanClose;
		private int tickVolEqualClose;
		private int lastBar;		
		private int lastTickVol;
		private int tickCnt;
		private DateTime lastRefresh;		
		private Brush[] brushes;
//		private const int arrowWidth = 14;
//		private const int arrowHight = 12;
		double barWidthScaler;
		private const int arrowWidth = 21;
		private const int arrowHight = 12;
		private int barWidth2;
		private	List<LadderRow>		askRows	= new List<LadderRow>();
		private	List<LadderRow>		bidRows	= new List<LadderRow>();
		private double maxvol, largestVolA, largestVolB, delta;
		#endregion
		
		// ------------- Stats Inputs ------------------------------
		#region StatsProperties
		
		private bool showStats = false;
		[Description("Show Volume/Tick statistics on chart.")]	
		[Category("Stats Settings")]
		[NinjaTrader.Gui.Design.DisplayName("1. Show")]		
		public bool ShowStats {
			get{ return showStats;}
			set{ showStats = value;}
		}
		
		private TextPosition statsPosition = TextPosition.TopLeft;
		[Description("Position on Price panel where statics will be displayed.")]	
		[Category("Stats Settings")]
		[NinjaTrader.Gui.Design.DisplayName("2. Display Position")]		
		public TextPosition StatsPosition {
			get{ return statsPosition;}
			set{ statsPosition = value;}
		}
		#endregion	
		// ------------- Volume Inputs -----------------------------
		#region VolumeProperties	
		
		private bool showVolume=false;
		[Description("Show Tick volume indicator.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("1. Show")]		
		public bool ShowTickVolume {
			get{ return showVolume;}
			set{ showVolume = value;}
		}		
		
		private bool showHighLowSameVolume = true;
		[Description("Show volume higher, lower and same as last bar close price.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("2. Show High/Low/Same ")]		
		public bool ShowHighLowSameVolume {
			get{ return showHighLowSameVolume;}
			set{ showHighLowSameVolume = value;}
		}		
		
		private bool showBidAskVolume = true;
		[Description("Show current bid/ask volume.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("3. Show Bid/Ask")]		
		public bool ShowBidAskVolume {
			get{ return showBidAskVolume;}
			set{ showBidAskVolume = value;}
		}		
		
		private Color higherVolColor = Color.Blue;
		[Description("Color for the volume higher.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("4. Volume-Higher Color")]		
		public Color HigherVolColor {
			get{ return higherVolColor;}
			set{ higherVolColor = value;}
		}	
		[Browsable(false)]
    	public string _HigherVolColor
    	{
        		get { return SerializableColor.ToString(this.HigherVolColor); }
        		set { this.HigherVolColor = SerializableColor.FromString(value); }
    	}		
		
		private Color sameVolColor = Color.DimGray;
		[Description("Color for volume same.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("5. Neutral-Volume Color")]		
		public Color SameVolColor {
			get{ return sameVolColor;}
			set{ sameVolColor = value;}
		}	
		[Browsable(false)]
    	public string _SameVolColor
    	{
        		get { return SerializableColor.ToString(this.SameVolColor); }
        		set { this.SameVolColor = SerializableColor.FromString(value); }
    	}
		
		private Color lowerVolColor = Color.Fuchsia;
		[Description("Color for volume lower.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("6. Volume-Lower Color")]		
		public Color LowerVolColor {
			get{ return lowerVolColor;}
			set{ lowerVolColor = value;}
		}			
		[Browsable(false)]
    	public string _LowerVolColor
    	{
        		get { return SerializableColor.ToString(this.LowerVolColor); }
        		set { this.LowerVolColor = SerializableColor.FromString(value); }
    	}
		
		private Color askColor = Color.DarkRed;
		[Description("Color for Ask Volume.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("7. Ask Volume Color")]		
		public Color AskColor {
			get{ return askColor;}
			set{ askColor = value;}
		}			
		[Browsable(false)]
    	public string AskColorSerialized
    	{
        		get { return SerializableColor.ToString(this.AskColor); }
        		set { this.AskColor = SerializableColor.FromString(value); }
    	}

		private Color bidColor = Color.LimeGreen;
		[Description("Color for Bid Volume.")]	
		[Category("Volume Settings")]
		[NinjaTrader.Gui.Design.DisplayName("8. Bid Volume Color")]		
		public Color BidColor {
			get{ return bidColor;}
			set{ bidColor = value;}
		}			
		[Browsable(false)]
    	public string BidColorSerialized
    	{
        		get { return SerializableColor.ToString(this.BidColor); }
        		set { this.BidColor = SerializableColor.FromString(value); }
    	}

		#endregion
		// ------------- Level II Inputs ---------------------------	
		#region LevelISettings
			
		private int maxrows=10;	
		[Description("MaxRows")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("000. MaxRows")]		
		public int MaxRowsShown {
			get{ return maxrows;}
			set{ maxrows =Math.Min(10,value);}
		}

		private bool showMarketData = true;
		[Description("Show Level II indicator.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("00. Show")]		
		public bool ShowLevelII {
			get{ return showMarketData;}
			set{ showMarketData = value;}
		}
	
		private bool showLevelIIHistogram = true;
		[Description("Show Level II histogram.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("01. Show Histogram")]		
		public bool ShowLevelIIHistogram {
			get{ return showLevelIIHistogram;}
			set{ showLevelIIHistogram = value;}
		}
		
		private bool showBidAskVolumeEachLine=true;
		[Description("Show Level II histogram bid/ask volume numbers.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("02. Show Histogram Volumes")]		
		public bool ShowBidAskVolumeEachLine {
			get{ return showBidAskVolumeEachLine;}
			set{ showBidAskVolumeEachLine = value;}
		}

		private int histogramOpacity = 50;
		[Description("Histogram opacity.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("03. Histogram Bar Opacity")]		
		public int HistogramOpacity {
			get{ return histogramOpacity;}
			set{ histogramOpacity = Math.Max(Math.Min(value, 255),0);}
		}
		
		private double histogramwidthfactor=1.5;
		[Description("Histogram Width Factor.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("03. Histogram Width Factor")]		
		public double HistoWidthFactor {
			get{ return histogramwidthfactor;}
			set{ histogramwidthfactor =Math.Abs(value);}
		}

		private int levelIIRefreshDelayMillis = 300;
		[Description("Level II refresh delay in milliseconds. NOTE: This will be the number of milliseconds that the Level II data will lag real-time.  This may be necessary if your CPU utilization increases too much.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("04. Refresh Delay")]		
		public int LevelIIRefreshDelay {
			get{ return levelIIRefreshDelayMillis;}
			set{ levelIIRefreshDelayMillis = value;}
		}

		private bool outlineHistBars = false;
		[Description("Outline histogram bars for visibility.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("05. Outline bars")]		
		public bool OutlineHistBars {
			get{ return outlineHistBars;}
			set{ outlineHistBars = value;}
		}
		
		private Color levelIILevel1Color = Color.Red;  
		[Description("Level 1 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("08. Level 1 Color")]		
		public Color LevelIILevel1Color {
			get{ return  levelIILevel1Color;}
			set{ levelIILevel1Color = value;}
		}	
		[Browsable(false)]
    	public string LevelIILevel1ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel1Color); }
    		set { this.LevelIILevel1Color = SerializableColor.FromString(value); }
    	}			
		
		private Color levelIILevel2Color = Color.DarkOrange;
		[Description("Level 2 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("09. Level 2 Color")]		
		public Color LevelIILevel2Color {
			get{ return levelIILevel2Color;}
			set{ levelIILevel2Color = value;}
		}	
		[Browsable(false)]
    	public string LevelIILevel2ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel2Color); }
    		set { this.LevelIILevel2Color = SerializableColor.FromString(value); }
    	}			
	
		private Color levelIILevel3Color = Color.DarkRed;
		[Description("Level 3 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("10. Level 3 Color")]		
		public Color LevelIILevel3Color {
			get{ return levelIILevel3Color;}
			set{ levelIILevel3Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel3ColorColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel3Color); }
    		set { this.LevelIILevel3Color = SerializableColor.FromString(value); }
    	}	
		
		private Color levelIILevel4Color = Color.Green;
		[Description("Level 4 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("11. Level 4 Color")]		
		public Color LevelIILevel4Color {
			get{ return levelIILevel4Color;}
			set{ levelIILevel4Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel4ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel4Color); }
    		set { this.LevelIILevel4Color = SerializableColor.FromString(value); }
    	}	
		
		private Color levelIILevel5Color = Color.Blue;
		[Description("Level 5 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("12. Level 5 Color")]		
		public Color LevelIILevel5Color {
			get{ return levelIILevel5Color;}
			set{ levelIILevel5Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel5ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel5Color); }
    		set { this.LevelIILevel5Color = SerializableColor.FromString(value); }
    	}			
		
		private Color levelIILevel6Color = Color.Cyan;
		[Description("Level 6 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("13. Level 6 Color")]		
		public Color LevelIILevel6Color {
			get{ return levelIILevel6Color;}
			set{ levelIILevel6Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel6ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel6Color); }
    		set { this.LevelIILevel6Color = SerializableColor.FromString(value); }
    	}	
		
		private Color levelIILevel7Color = Color.Fuchsia;
		[Description("Level 7 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("14. Level 7 Color")]		
		public Color LevelIILevel7Color {
			get{ return levelIILevel7Color;}
			set{ levelIILevel7Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel7ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel7Color); }
    		set { this.LevelIILevel7Color = SerializableColor.FromString(value); }
    	}	
		
		private Color levelIILevel8Color = Color.DarkMagenta;	
		[Description("Level 8 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("15. Level 8 Color")]		
		public Color LevelIILevel8Color {
			get{ return levelIILevel8Color;}
			set{ levelIILevel8Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel8ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel8Color); }
    		set { this.LevelIILevel8Color = SerializableColor.FromString(value); }
    	}	
		
		private Color levelIILevel9Color = Color.DarkGoldenrod;
		[Description("Level 9 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("16. Level 9 Color")]		
		public Color LevelIILevel9Color {
			get{ return levelIILevel9Color;}
			set{ levelIILevel9Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel9ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel9Color); }
    		set { this.LevelIILevel9Color = SerializableColor.FromString(value); }
    	}			
		
		private Color levelIILevel10Color = Color.DarkTurquoise;	
		[Description("Level 10 Color.")]	
		[Category("Level II Settings")]
		[NinjaTrader.Gui.Design.DisplayName("17. Level 10 Color")]		
		public Color LevelIILevel10Color {
			get{ return levelIILevel10Color;}
			set{ levelIILevel10Color = value;}
		}			
		[Browsable(false)]
    	public string LevelIILevel10ColorSerialize
    	{
    		get { return SerializableColor.ToString(LevelIILevel10Color); }
    		set { this.LevelIILevel10Color = SerializableColor.FromString(value); }
    	}	
		
		#endregion		
		// ------------- Price Line --------------------------------	
		#region PriceLine	
		
		private bool drawPriceLine = true;
		[Description("Draw a line at the current price level. Makes it easier to see price movement when you have a larger right margin.")]	
		[Category("Price Line Settings")]
		[NinjaTrader.Gui.Design.DisplayName("06. Draw price line")]		
		public bool DrawPriceLine {
			get{ return drawPriceLine;}
			set{ drawPriceLine = value;}
		}

		private Color priceLineColor = Color.Silver;	
		[Description("Price line color.")]	
		[Category("Price Line Settings")]
		[NinjaTrader.Gui.Design.DisplayName("18. Price line color")]		
		public Color PriceLineColor {
			get{ return priceLineColor;}
			set{ priceLineColor = value;}
		}			
		[Browsable(false)]
    	public string _PriceLineColor
    	{
    		get { return SerializableColor.ToString(PriceLineColor); }
    		set { this.PriceLineColor = SerializableColor.FromString(value); }
    	}	
		#endregion
	    // ------------- Misc Color Inputs -------------------------
    	#region MiscSettings
		
		private Color outlineColor = Color.Gray;
		[Description("Color used to outline bars when outlining is enable.")]	
		[Category("Misc")]
		[NinjaTrader.Gui.Design.DisplayName("1. Outline Color")]		
		public Color OutlineColor {
			get{ return outlineColor;}
			set{ outlineColor = value;}
		}	
		[Browsable(false)]
    	public string outlineColorSerialize
    	{
    		get { return SerializableColor.ToString(OutlineColor); }
    		set { this.OutlineColor = SerializableColor.FromString(value); }
    	}	
		
		private Color textColor = Color.Black;
		[Description("Color used for all text.")]	
		[Category("Misc")]
		[NinjaTrader.Gui.Design.DisplayName("2. Text Color")]		
		public Color TextColor {
			get{ return textColor;}
			set{ textColor = value;}
		}	
		[Browsable(false)]
    	public string textColorSerialize
    	{
    		get { return SerializableColor.ToString(TextColor); }
    		set { this.TextColor = SerializableColor.FromString(value); }
    	}	
		
	#endregion	
	    // ------------- Alerts Inputs -----------------------------
		#region AlertsProperties
			
		private bool 	enDAlert = false;  
		[Description("Sound Alert when Total Ask or Bid volume exceeds the other by the trigger percent")]	
		[Category("Alert Settings")]	
		public bool DeltaAlert_Enable {
			get{ return enDAlert;}
			set{ enDAlert = value; }
		}
		
		private bool 	enVAlert = false;  	
		[Description("Sound Alert when Ask or Bid volume exceeds threshold")]	
		[Category("Alert Settings")]	
		public bool VolumeAlert_Enable {
			get{ return enVAlert;}
			set{ enVAlert = value; }
		}
		
		private string 	soundVA = "Alert1.wav";
		[Description("wave file to use for Low Priority DOM Volume Alerts, must be in NT sounds directory")]
        [Category("Alert Settings")]
        public string VolumeAlert_Sound
        {
            get { return soundVA; }
            set { soundVA = value; }
        }	
				
		private string 	soundDA = "Alert1.wav";
		[Description("wave file to use for Low Priority DOM Delta Alerts, must be in NT sounds directory")]
        [Category("Alert Settings")]
        public string DeltaAlert_Sound
        {
            get { return soundDA; }
            set { soundDA = value; }
        }	
		
		private double triggerPct = 200;
		[Description("Percent increase to trigger Delta Alerts. 100% = 2x")]	
		[Category("Alert Settings")]
		public double Delta_Percent_Trigger {
			get{ return triggerPct;}
			set{ triggerPct = Math.Max(value,1); }
		}
		
		private double alertMinVol = 0;
		[Description("Minimum Volume to permit a Delta Alert. Disabled if 0")]	
		[Category("Alert Settings")]
		public double Delta_MinVolume {
			get{ return alertMinVol;}
			set{ alertMinVol = Math.Max(value,0); }
		}
		
		private double thresholdA = 300;
		[Description("Volume threshold to trigger Alerts")]	
		[Category("Alert Settings")]
		public double Volume_Alert_Threshold {
			get{ return thresholdA;}
			set{ thresholdA = Math.Max(value,0); }
		}
		
		#endregion
		
		#region Initialize & OnStartUp
        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			higherVolBrush = new SolidBrush(higherVolColor);
			lowerVolBrush = new SolidBrush(lowerVolColor);
			sameVolBrush = new SolidBrush(sameVolColor);
			outlinePen = new Pen(outlineColor);
			textBrush = new SolidBrush(textColor);
			levelIILevel1Brush = new SolidBrush(LevelIILevel1Color);
			levelIILevel2Brush = new SolidBrush(LevelIILevel2Color);
			levelIILevel3Brush = new SolidBrush(LevelIILevel3Color);
			levelIILevel4Brush = new SolidBrush(LevelIILevel4Color);
			levelIILevel5Brush = new SolidBrush(LevelIILevel5Color);
			levelIILevel6Brush = new SolidBrush(LevelIILevel6Color);
			levelIILevel7Brush = new SolidBrush(LevelIILevel7Color);
			levelIILevel8Brush = new SolidBrush(LevelIILevel8Color);
			levelIILevel9Brush = new SolidBrush(LevelIILevel9Color);
			levelIILevel10Brush = new SolidBrush(LevelIILevel10Color);
			askBrush = new SolidBrush(AskColor);
			bidBrush = new SolidBrush(BidColor);		
			
			PlotsConfigurable 	= false;
			CalculateOnBarClose = false;		
			DrawOnPricePanel = true;
			
            Overlay				= true;
			PaintPriceMarkers 	= false;
            PriceTypeSupported	= false;
			
			stringFormat = new StringFormat();
			stringFormat.Alignment = StringAlignment.Far;
			stringCFormat = new StringFormat();
			stringCFormat.Alignment = StringAlignment.Center;
			stringFont = new Font(FontFamily.GenericSansSerif, 8, FontStyle.Regular, GraphicsUnit.Pixel);
		//	stringBFont = new Font(FontFamily.GenericSansSerif, 9, FontStyle.Bold, GraphicsUnit.Pixel);
			stringBFont = new Font(FontFamily.GenericSansSerif, 12, FontStyle.Bold, GraphicsUnit.Pixel);
		
			lastBar = -1;
						
			brushes = new Brush[] {
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel1Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel2Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel3Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel4Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel5Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel6Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel7Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel8Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel9Color)),
    		new SolidBrush(Color.FromArgb(HistogramOpacity,levelIILevel10Color))
			};
			
			priceLinePen = new Pen(PriceLineColor);	
			priceLinePen.DashStyle = DashStyle.Dot;
		}
		 protected override void OnStartUp()
        {
			
		}
		#endregion
		
		#region OnEvent()  Methods
		protected override void OnBarUpdate()
        {
			
			try {
				// -----  accumulate the volume by tick for this bar.
				if (!Historical && CurrentBar > 0)
				{
					if (lastBar == CurrentBar){
						UpdateTickVolume();
						tickCnt++;
					} else {
						// new bar, reset counters.
						lastBar = CurrentBar;
						tickVolHigherThanClose = 0;
						tickVolLowerThanClose = 0;
						tickVolEqualClose = 0;
						lastTickVol = 0;
						tickCnt = 1;
						UpdateTickVolume();
					}
         			if(bidRows.Count>30 || askRows.Count>30)  
						Print("Realstat 7 list has "+askRows.Count+" ask rows "+bidRows.Count + "bid rows.");
					
					int ticksRemaining = 0;
					if (Bars.Period.Id == PeriodType.Tick){
						ticksRemaining = Bars.Period.Value - Bars.TickCount;
					}
					
					if (ShowStats){
						string text = string.Format("For "+maxrows+ " DOM Levels:\r\n Tick Count:{0} /{1}; {2}%\r\n Vol: {3}   Up {4}  Neut  {5}   Dn {6}\r\n  InsAsk: {7}   InsBid: {8}\r\n TotA: {9}  TotB: {10}  TA / TB {11}",Bars.TickCount,ticksRemaining+Bars.TickCount , (int)(Bars.PercentComplete*100), Volume[0],tickVolHigherThanClose, tickVolEqualClose, tickVolLowerThanClose, GetCurrentAskVolume(), GetCurrentBidVolume(),SumOfAllAsks,SumOfAllBids,Math.Round(SumOfAllAsks/(SumOfAllBids+.001),2) );
						DrawTextFixed("DOMAlert", text,  StatsPosition); 	
					}
				}
			} catch (Exception ex){
			Print("Trapped exception in DOMAlert.OnBarUpdate(): " + ex.Message);
				return;
			}
        }
		
		
		protected override void OnMarketDepth(MarketDepthEventArgs e)
		{	
					// try, catch will handle any runtime errors, preventing the program from crashing
			try		// this { is the start of the area that is being monitored for errors
				    // there may be runtime errors when this starts up in NT7
        	{
			if (ShowLevelII){
				List<LadderRow> rows = null;
	
				// Create the list rows before trying to update them			
				 
				{	    
				rows=bidRows;
				if(rows.Count<5) //Create the rows for the list of bids
					{ 	idx =0;	
				  		for (idx = 0; idx <12; idx++)
						{   //insert empty placholder objects of type LadderRowrows into the bidRows list
							bidRows.Insert(idx, new LadderRow((int)0,(int) 0, ""));
						}
					}
				rows=askRows;
				if(rows.Count<5) //Create the rows for the list of offers
					{ 	idx =0;	
				  		for (idx = 0; idx <12; idx++)
						{   //insert empty placholder objects of type LadderRowrows into the askRows list
							askRows.Insert(idx, new LadderRow((int)0,(int) 0, ""));
						}
					}
				}
				
				
				// decide which list to update based on the MarketDataType
				if (e.MarketDataType == MarketDataType.Ask)
					rows = askRows;
			    else if (e.MarketDataType == MarketDataType.Bid)
					rows = bidRows;
				
				//update the appropriate list
				
				if (e.Operation == Operation.Update && e.Position < 11)
				{
					rows[e.Position].MarketMaker	= e.MarketMaker;
					rows[e.Position].Price			= e.Price;
					rows[e.Position].Volume			=(int) e.Volume;
					
				}
				
				// Throtte back calls to Graphics method to reduce CPU usaage
				
				if (lastRefresh.AddMilliseconds(LevelIIRefreshDelay) < DateTime.Now)
				{					
					lastRefresh = DateTime.Now;
				}
				
			 }  // end if
       		}   //end of try = error trapped region
				catch (Exception ex){
                // Following is what we do if there is an error, sure beats crashing the indicator    
				Print("Trapped exception in DOMAlert.OnMarketDepth(): " + ex.Message);
                return; //prevents the indicator from crashing
				}	
		}
		
		#endregion
		
		/*
		*	Accumulate the volume for each tick by vol higher, lower or same as prior bar close price
		*/
		private void UpdateTickVolume(){
			int  vol =  (int)Volume[0]-lastTickVol;
			if (Input[0] > Close[1]){
				tickVolHigherThanClose += vol;
			} else 	if (Input[0] < Close[1]) {
				tickVolLowerThanClose += vol;
			} else {
				tickVolEqualClose += vol;
			}
			lastTickVol = (int)Volume[0];	
		}
		
		private Brush GetLadderBrush(int idx1){
			Brush brush = null;
			if (idx < brushes.Length){
				brush = brushes[idx1];
			} else {
				brush = textBrush;
			}
			return brush;
		}
	
		public override void Plot(Graphics graphics, Rectangle bounds, double min, double max){
	
			try {
				  
					int priceY = (bounds.Y + bounds.Height) - ((int) ((( Close[0] - min) / ChartControl.MaxMinusMin(max, min)) * bounds.Height))-1;
					int heightBFont = (int) graphics.MeasureString("ABC", stringBFont).Height;
					
					int heightAFont = (int) graphics.MeasureString("ABC", stringFont).Height;
					
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//=============================================================================================================================		
					if (ShowTickVolume){
						
				//		int X3 = bounds.X+bounds.Width-13;
						 X3 = bounds.X+bounds.Width-18;
				
						if (showHighLowSameVolume){
							// Draw the high/low/same volume bars
		
							Rectangle rect = new Rectangle(X3, bounds.Y, 18, bounds.Height);
							graphics.FillRectangle(Brushes.White, rect);
	
							double heightPerTick = bounds.Height / Volume[0];
							
							if (heightPerTick > 0){
								
								int volHigherHeight = (int)(heightPerTick * tickVolHigherThanClose);
								int volLowerHeight = (int)(heightPerTick * tickVolLowerThanClose);
								int volSameHeight = (int)(heightPerTick * tickVolEqualClose);
								int offset = (bounds.Height - volLowerHeight - volHigherHeight - volSameHeight)/2;
								
								Rectangle higherRect = new Rectangle(X3, offset, 22, volHigherHeight);
								Rectangle sameRect = new Rectangle(X3, offset+volHigherHeight, 22, volSameHeight);
								Rectangle lowerRect = new Rectangle(X3, offset + volHigherHeight + volSameHeight, 22, volLowerHeight);
			
								graphics.FillRectangle(higherVolBrush, higherRect);
								graphics.FillRectangle(sameVolBrush, sameRect);
								graphics.FillRectangle(lowerVolBrush, lowerRect);
//!!								
					//			graphics.DrawString(tickVolHigherThanClose.ToString(), stringBFont, textBrush, bounds.X3-12 + bounds.Width , bounds.Y, stringFormat);
					//			graphics.DrawString(tickVolLowerThanClose.ToString(), stringBFont, textBrush, bounds.X3-12 + bounds.Width , bounds.Y+bounds.Height-12, stringFormat);
								
								graphics.DrawString(tickVolHigherThanClose.ToString(), stringBFont, textBrush, bounds.X-40 + bounds.Width , bounds.Y, stringFormat);
								graphics.DrawString(tickVolLowerThanClose.ToString(), stringBFont, textBrush, bounds.X-40 + bounds.Width , bounds.Y+bounds.Height-20, stringFormat);
								
							}
						}
						
						if (showBidAskVolume){
							// draw the bid/ask volume bars
							int askVol = (int)GetCurrentAskVolume();
							int bidVol = (int)GetCurrentBidVolume();
							
							graphics.DrawRectangle(outlinePen, X3,priceY-(askVol/5), 9, (askVol/5)); 
							graphics.DrawRectangle(outlinePen, X3, priceY, 9, (bidVol/5)); 
							graphics.FillRectangle(askBrush, X3,priceY-(askVol/5)+1, 9, (askVol/5)-1); 
							graphics.FillRectangle(bidBrush, X3, priceY+1, 9, (bidVol/5)-1); 
							
						}
					}
//=============================================================================================================================	
					// Draw the level II histogram 
					
					int totAVol = 0;
					int totBVol = 0;
				
					if (ShowLevelII){
						 x1 = base.ChartControl.CanvasRight-1;

						if (ShowTickVolume){ x1 -= 14; 	}
						
						int priceOffset = 7;						
						
//----------------------------------------------------------------------------------------------------------------------------
						// find longest bar 
						// Find the largest volume and use it to autoscale the histogram to keep it from 
						//	overrunning the left edge of the screen.
						maxvol = 0; largestVolA = 0; largestVolB = 0;
						for (idx = 0; idx < maxrows; idx++)
						{							
							//Print("askrow[" +idx+ "]  "+askRows[idx].Volume);			
							if ((double)askRows[idx].Volume>maxvol) largestVolA =(double)askRows[idx].Volume;					
							if ((double)bidRows[idx].Volume>maxvol) largestVolB =(double)bidRows[idx].Volume;				
						}
						maxvol = Math.Max(largestVolA,largestVolB);
						barWidthScaler = Math.Min(histogramwidthfactor,Math.Abs((bounds.Width-100)/(maxvol+1)));
						
						//  Volume threshold Alerts ------------------------------------------------------------------
						if (largestVolA >= thresholdA && enVAlert)
							Alert("DOM1", NinjaTrader.Cbi.Priority.Low, "ASK Vol exceeded threshold "+thresholdA, soundVA, 10, Color.Yellow, Color.Black );
						if (largestVolB >= thresholdA && enVAlert)
							Alert("DOM1", NinjaTrader.Cbi.Priority.Low, "BID Vol exceeded threshold "+thresholdA, soundVA, 10, Color.Yellow, Color.Black );
						
//==========================================================================================================================	
						
						//  Level II Ask individual levels
						for (idx = 0; idx < maxrows; idx++){
							int y1 = (bounds.Y + bounds.Height) - ((int) ((( askRows[idx].Price - min) / ChartControl.MaxMinusMin(max, min)) * bounds.Height)) - priceOffset;
							if (ShowLevelIIHistogram && askRows.Count>idx) 
							{
								// do not try to read rows that do not exist
						    	barWidth2 = askRows[idx].Volume/barWidthScaler > 0 ? (int)Math.Round(askRows[idx].Volume*barWidthScaler,0) : 1;									
								Rectangle rect = new Rectangle(x1-25-(int)Math.Round(askRows[idx].Volume*barWidthScaler,0), y1+3, barWidth2, 6);
								graphics.FillRectangle(GetLadderBrush(idx), rect);
								if (outlineHistBars){ graphics.DrawRectangle(outlinePen, rect); }		
								
								if (showBidAskVolumeEachLine == true) 
									graphics.DrawString(askRows[idx].Volume.ToString(), stringFont, textBrush, x1, y1+2, stringFormat);														
							}								
							totAVol += askRows[idx].Volume;   		askTotY = y1+2;
							SumOfAllAsks = totAVol;
						}
						
						//  Print Ask Total Volume #
						askTotY -= heightBFont+2;													
						graphics.DrawString(totAVol.ToString(), stringBFont, textBrush, x1-5, askTotY, stringFormat);  // bounds.X-20 + bounds.Width
						
						
						//  Level II Bid individual levels
						for (idx = 0; idx < maxrows; idx++){
							int y1 = (bounds.Y + bounds.Height) - ((int) ((( bidRows[idx].Price - min) / ChartControl.MaxMinusMin(max, min)) * bounds.Height)) - priceOffset;
							if (ShowLevelIIHistogram && bidRows.Count>idx) 
							{ // test added that the row exsits, for NT7
								int barWidth = bidRows[idx].Volume*barWidthScaler > 0 ? (int)Math.Round(bidRows[idx].Volume*barWidthScaler,0) : 1;
								Rectangle rect = new Rectangle(x1-25-(int)Math.Round(bidRows[idx].Volume*barWidthScaler,0), y1+3, barWidth, 6);
								graphics.FillRectangle(GetLadderBrush(idx), rect);
								if (outlineHistBars) { graphics.DrawRectangle(outlinePen, rect); }
								
								if (showBidAskVolumeEachLine == true)							 
									graphics.DrawString(bidRows[idx].Volume.ToString(), stringFont, textBrush, x1, y1+2, stringFormat);
							}
							totBVol += bidRows[idx].Volume; 	bidTotY = y1+2;
							SumOfAllBids= totBVol;
						}
						
						//  Print Bid Total Volume #
						bidTotY += heightAFont;  // x,y = upper left corner
						graphics.DrawString(totBVol.ToString(), stringBFont, textBrush, x1-5, bidTotY, stringFormat);					
						
						// -----------------------------------------------------------------------------------------------------------------
						// draw arrows (Triangles) to indicate price trend based on supply/demand and up/down volume
						
						{ 
							SmoothingMode oldMode = graphics.SmoothingMode;
							try {
									graphics.SmoothingMode = SmoothingMode.AntiAlias;
									int x = (bounds.X-26 + bounds.Width) - arrowWidth-2;  // distance from right chart edge
								
									// Ask polygon and text
									int y1 = askTotY - 3;  // place above last text
									Point[] lines1 = new Point[]{new Point(x, y1), new Point(x + arrowWidth/2 , y1 - arrowHight), new Point(x + arrowWidth, y1),new Point(x, y1)};
									graphics.DrawPolygon(outlinePen, lines1);
									
									graphics.DrawString(string.Format("{0:F2}", (double)totAVol/(double)totBVol), stringBFont, textBrush, x+12, y1-arrowHight-heightBFont,stringCFormat); // ??
									
									// Bid polygon and text
									int y2 = bidTotY + heightBFont +3;  // place below last text
									Point[] lines2 = new Point[]{new Point(x, y2), new Point(x + arrowWidth/2 , y2 + arrowHight), new Point(x + arrowWidth, y2),new Point(x, y2)};
									graphics.DrawPolygon(outlinePen, lines2);
	// !!								
									graphics.DrawString(string.Format("{0:F2}", (double)totBVol/(double)totAVol), stringBFont, textBrush, x+12, y2+arrowHight,stringCFormat);  // ??
			
								if (totAVol > totBVol)
								{
									int y = y1;
									Point[] lines = new Point[]{new Point(x, y), new Point(x + arrowWidth/2 , y - arrowHight), new Point(x + arrowWidth, y),new Point(x, y)};
									graphics.DrawPolygon(outlinePen, lines);
									if (tickVolHigherThanClose > tickVolLowerThanClose) 
									{
										graphics.FillPolygon(higherVolBrush, lines);
										graphics.DrawPolygon(outlinePen, lines);
									} else {
										graphics.DrawPolygon(outlinePen, lines);
									}
				
									//graphics.DrawString(string.Format("{0:F2}", (double)totAVol/(double)totBVol), stringBFont, textBrush, x+12, y-arrowHight-24,stringCFormat); // ??
									
								} 
								else if (totAVol < totBVol)
								{
									int y = y2;
									Point[] lines = new Point[]{new Point(x, y), new Point(x + arrowWidth/2 , y + arrowHight), new Point(x + arrowWidth, y),new Point(x, y)};
									graphics.DrawPolygon(outlinePen, lines);
									if (tickVolHigherThanClose < tickVolLowerThanClose) {
										graphics.FillPolygon(lowerVolBrush, lines);
										graphics.DrawPolygon(outlinePen, lines);
									} else {
										graphics.DrawPolygon(outlinePen, lines);
									}
									
									//graphics.DrawString(string.Format("{0:F2}", (double)totBVol/(double)totAVol), stringBFont, textBrush, x+12, y+arrowHight-36,stringCFormat); // ??
								}
							} finally {
								graphics.SmoothingMode = oldMode;
							}
						}
						
//==========================================================================================================================	
						
						//  ---------   Percent Delta Alert --------------------------------------------------------
						if (enDAlert && totBVol>alertMinVol && totAVol>alertMinVol)
						{
							//DrawTextFixed("DOM1", "\n ASK "+totAVol+ " & BID "+totBVol, TextPosition.BottomRight);	
							delta = (totBVol>0) ? (totAVol-totBVol)/totBVol : 0;
							//Print("DELTA ask  " + Time[0] +" is "+delta.ToString("P2") );
							if (delta !=0 && totAVol > totBVol*(triggerPct+100)/100)
								Alert("DOM1", NinjaTrader.Cbi.Priority.Low, "Total ASK Vol "+totAVol+" exceeded BID "+totBVol+" by "+delta.ToString("P2"), soundDA, 10, Color.Yellow, Color.Black );
							delta = (totAVol>0) ? (totBVol-totAVol)/totAVol : 0;
							//Print("DELTA bid  " + Time[0] +" is "+delta.ToString("P2") );
							if (delta !=0 && totBVol > totAVol*(triggerPct+100)/100)
								Alert("DOM1", NinjaTrader.Cbi.Priority.Low, "Total BID "+totBVol+" Vol exceeded ASK "+totAVol+" by "+delta.ToString("P2"), soundDA, 10, Color.Yellow, Color.Black );
						}
						
						//  ---------   PRICE LINE   ----------------------------------------------------------------
						//  draw a price line

						if (drawPriceLine){
							graphics.DrawLine(priceLinePen, bounds.X, priceY, bounds.X+bounds.Width, priceY);
						}

					}
				
				} catch (Exception ex){
                    
				Print("Trapped exception in DOMAlert.Plot(): " + ex.Message);
                    return;
				}
		}
		
//====================================================================================================================		
		
//====================================================================================================================		
		
		private class LadderRow   //for futures there is no Market Maker, but we can still use this to populate the lists
		{
			public	string	MarketMaker;			// relevant for stocks only
			public	double	Price;
			public	int		Volume;

			public LadderRow(double myPrice, int myVolume, string myMarketMaker)
			{
				MarketMaker	= myMarketMaker;
				Price		= myPrice;
				Volume		= myVolume;
			}
		}
	//=====================================================================================================================	
	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DOMAlert[] cacheDOMAlert = null;

        private static DOMAlert checkDOMAlert = new DOMAlert();

        /// <summary>
        /// jtRealtime Stats version 1.5 (aka 7.301) for NT7 with Alerts
        /// </summary>
        /// <returns></returns>
        public DOMAlert DOMAlert()
        {
            return DOMAlert(Input);
        }

        /// <summary>
        /// jtRealtime Stats version 1.5 (aka 7.301) for NT7 with Alerts
        /// </summary>
        /// <returns></returns>
        public DOMAlert DOMAlert(Data.IDataSeries input)
        {
            if (cacheDOMAlert != null)
                for (int idx = 0; idx < cacheDOMAlert.Length; idx++)
                    if (cacheDOMAlert[idx].EqualsInput(input))
                        return cacheDOMAlert[idx];

            lock (checkDOMAlert)
            {
                if (cacheDOMAlert != null)
                    for (int idx = 0; idx < cacheDOMAlert.Length; idx++)
                        if (cacheDOMAlert[idx].EqualsInput(input))
                            return cacheDOMAlert[idx];

                DOMAlert indicator = new DOMAlert();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                DOMAlert[] tmp = new DOMAlert[cacheDOMAlert == null ? 1 : cacheDOMAlert.Length + 1];
                if (cacheDOMAlert != null)
                    cacheDOMAlert.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDOMAlert = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// jtRealtime Stats version 1.5 (aka 7.301) for NT7 with Alerts
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DOMAlert DOMAlert()
        {
            return _indicator.DOMAlert(Input);
        }

        /// <summary>
        /// jtRealtime Stats version 1.5 (aka 7.301) for NT7 with Alerts
        /// </summary>
        /// <returns></returns>
        public Indicator.DOMAlert DOMAlert(Data.IDataSeries input)
        {
            return _indicator.DOMAlert(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// jtRealtime Stats version 1.5 (aka 7.301) for NT7 with Alerts
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DOMAlert DOMAlert()
        {
            return _indicator.DOMAlert(Input);
        }

        /// <summary>
        /// jtRealtime Stats version 1.5 (aka 7.301) for NT7 with Alerts
        /// </summary>
        /// <returns></returns>
        public Indicator.DOMAlert DOMAlert(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DOMAlert(input);
        }
    }
}
#endregion
