using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;

namespace NinjaTrader.Indicator
{		
    public class i12m03: Indicator
    {
		enum BarType {
			Bid, Ask, UnderBid, AboveAsk, Unknown
		}
		
		int lastBar = 0;
		double currentMax = 0, lastAsk = 0, lastBid = Double.MaxValue;
		Queue<MarketDataEventArgs> eventBuffer = new Queue<MarketDataEventArgs>();
		DataSeries price;
		
		protected override void Initialize()
		{
			Add(new Plot(new Pen(Color.Red, 2), PlotStyle.Bar, "Объёмы на цене Bid"));
			Add(new Plot(new Pen(Color.Green, 2), PlotStyle.Bar, "Объёмы на цене Ask"));
			Add(new Plot(new Pen(Color.Orange, 2), PlotStyle.Bar, "Объёмы на цене ниже Bid"));
			Add(new Plot(new Pen(Color.LightGreen, 2), PlotStyle.Bar, "Объёмы на цене выше Ask"));
			Add(new Plot(new Pen(Color.Blue, 2), PlotStyle.Bar, "Объёмы без типа цены"));
			
			Add(PeriodType.Tick, 1);
			
			price = new DataSeries(this);

			CalculateOnBarClose = false;
		}

        protected override void OnBarUpdate()
		{
			if (Historical)
				return;
			
			if (BarsInProgress == 1) {
				if (currentMax < Volume[0]) {
					MarketDataEventArgs e;
					BarType barType = BarType.Unknown;
					
					while (eventBuffer.Count > 0) {
						e = eventBuffer.Dequeue();
						if (e.MarketDataType == MarketDataType.Ask) {
							lastAsk = e.Price;
							continue;
						}
						else if (e.MarketDataType == MarketDataType.Bid) {
							lastBid = e.Price;
							continue;
						}
						
						if (e.Volume == Volume[0] && e.Price == Close[0]) {
							if (Close[0] > lastAsk)
								barType = BarType.AboveAsk;
							else if (Close[0] == lastAsk)
								barType = BarType.Ask;
							else if (Close[0] == lastBid)
								barType = BarType.Bid;
							else if (Close[0] < lastBid)
								barType = BarType.UnderBid;

							break;
						}
						
					}
				
					currentMax = Volume[0];
					foreach (BarType t in Enum.GetValues(typeof(BarType)))
						Values[(int)t].Reset();
					Values[(int)barType].Set(currentMax);
					price.Set(Close[0]);
				}
			}
			else if (lastBar < CurrentBar) {
				lastBar = CurrentBar;
				currentMax = 0;
			}
			
		}
		
		protected override void OnMarketData(MarketDataEventArgs e)
		{
			if (e.MarketDataType == MarketDataType.Ask
					|| e.MarketDataType == MarketDataType.Bid
					|| e.MarketDataType == MarketDataType.Last)
				eventBuffer.Enqueue(e);
		}
		
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries BidVolume
        {
			get { return Values[0]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries AskVolume
        {
			get { return Values[1]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries UnderBidVolume
        {
			get { return Values[2]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries AboveAskVolume
        {
			get { return Values[3]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries UnknownVolume
        {
			get { return Values[4]; }
		}

		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries Price
        {
			get { return price; }
		}

	}
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private i12m03[] cachei12m03 = null;

        private static i12m03 checki12m03 = new i12m03();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i12m03 i12m03()
        {
            return i12m03(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public i12m03 i12m03(Data.IDataSeries input)
        {
            if (cachei12m03 != null)
                for (int idx = 0; idx < cachei12m03.Length; idx++)
                    if (cachei12m03[idx].EqualsInput(input))
                        return cachei12m03[idx];

            lock (checki12m03)
            {
                if (cachei12m03 != null)
                    for (int idx = 0; idx < cachei12m03.Length; idx++)
                        if (cachei12m03[idx].EqualsInput(input))
                            return cachei12m03[idx];

                i12m03 indicator = new i12m03();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                i12m03[] tmp = new i12m03[cachei12m03 == null ? 1 : cachei12m03.Length + 1];
                if (cachei12m03 != null)
                    cachei12m03.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachei12m03 = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i12m03 i12m03()
        {
            return _indicator.i12m03(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i12m03 i12m03(Data.IDataSeries input)
        {
            return _indicator.i12m03(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.i12m03 i12m03()
        {
            return _indicator.i12m03(Input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.i12m03 i12m03(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.i12m03(input);
        }
    }
}
#endregion
